/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.linux.XVisualInfo;

public class GLXSGIXFBConfig {
    public static final int GLX_DRAWABLE_TYPE_SGIX = 32784;
    public static final int GLX_RENDER_TYPE_SGIX = 32785;
    public static final int GLX_X_RENDERABLE_SGIX = 32786;
    public static final int GLX_FBCONFIG_ID_SGIX = 32787;
    public static final int GLX_SCREEN_EXT = 32780;
    public static final int GLX_WINDOW_BIT_SGIX = 1;
    public static final int GLX_PIXMAP_BIT_SGIX = 2;
    public static final int GLX_RGBA_BIT_SGIX = 1;
    public static final int GLX_COLOR_INDEX_BIT_SGIX = 2;
    public static final int GLX_RGBA_TYPE_SGIX = 32788;
    public static final int GLX_COLOR_INDEX_TYPE_SGIX = 32789;
    public final long GetFBConfigAttribSGIX;
    public final long ChooseFBConfigSGIX;
    public final long CreateGLXPixmapWithConfigSGIX;
    public final long CreateContextWithConfigSGIX;
    public final long GetVisualFromFBConfigSGIX;
    public final long GetFBConfigFromVisualSGIX;

    protected GLXSGIXFBConfig() {
        throw new UnsupportedOperationException();
    }

    public GLXSGIXFBConfig(FunctionProvider provider) {
        this.GetFBConfigAttribSGIX = provider.getFunctionAddress("glXGetFBConfigAttribSGIX");
        this.ChooseFBConfigSGIX = provider.getFunctionAddress("glXChooseFBConfigSGIX");
        this.CreateGLXPixmapWithConfigSGIX = provider.getFunctionAddress("glXCreateGLXPixmapWithConfigSGIX");
        this.CreateContextWithConfigSGIX = provider.getFunctionAddress("glXCreateContextWithConfigSGIX");
        this.GetVisualFromFBConfigSGIX = provider.getFunctionAddress("glXGetVisualFromFBConfigSGIX");
        this.GetFBConfigFromVisualSGIX = provider.getFunctionAddress("glXGetFBConfigFromVisualSGIX");
    }

    public static GLXSGIXFBConfig getInstance() {
        return GLXSGIXFBConfig.getInstance(GL.getCapabilities());
    }

    public static GLXSGIXFBConfig getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__GLXSGIXFBConfig);
    }

    static GLXSGIXFBConfig create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GLX_SGIX_fbconfig")) {
            return null;
        }
        GLXSGIXFBConfig funcs = new GLXSGIXFBConfig(provider);
        boolean supported = Checks.checkFunctions(funcs.GetFBConfigAttribSGIX, funcs.ChooseFBConfigSGIX, funcs.CreateGLXPixmapWithConfigSGIX, funcs.CreateContextWithConfigSGIX, funcs.GetVisualFromFBConfigSGIX, funcs.GetFBConfigFromVisualSGIX);
        return GL.checkExtension("GLX_SGIX_fbconfig", funcs, supported);
    }

    public static int nglXGetFBConfigAttribSGIX(long display, long config, int attribute, long value) {
        long __functionAddress = GLXSGIXFBConfig.getInstance().GetFBConfigAttribSGIX;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkPointer(config);
        }
        return JNI.callPPIPI(__functionAddress, display, config, attribute, value);
    }

    public static int glXGetFBConfigAttribSGIX(long display, long config, int attribute, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        return GLXSGIXFBConfig.nglXGetFBConfigAttribSGIX(display, config, attribute, MemoryUtil.memAddress(value));
    }

    public static int glXGetFBConfigAttribSGIX(long display, long config, int attribute, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        return GLXSGIXFBConfig.nglXGetFBConfigAttribSGIX(display, config, attribute, MemoryUtil.memAddress(value));
    }

    public static long nglXChooseFBConfigSGIX(long display, int screen, long attrib_list, long nelements) {
        long __functionAddress = GLXSGIXFBConfig.getInstance().ChooseFBConfigSGIX;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
        }
        return JNI.callPIPPP(__functionAddress, display, screen, attrib_list, nelements);
    }

    public static PointerBuffer glXChooseFBConfigSGIX(long display, int screen, ByteBuffer attrib_list) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nelements = __buffer.intParam();
        long __result = GLXSGIXFBConfig.nglXChooseFBConfigSGIX(display, screen, MemoryUtil.memAddressSafe(attrib_list), __buffer.address(nelements));
        return MemoryUtil.memPointerBuffer(__result, __buffer.intValue(nelements));
    }

    public static PointerBuffer glXChooseFBConfigSGIX(long display, int screen, IntBuffer attrib_list) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nelements = __buffer.intParam();
        long __result = GLXSGIXFBConfig.nglXChooseFBConfigSGIX(display, screen, MemoryUtil.memAddressSafe(attrib_list), __buffer.address(nelements));
        return MemoryUtil.memPointerBuffer(__result, __buffer.intValue(nelements));
    }

    public static long glXCreateGLXPixmapWithConfigSGIX(long display, long config, long pixmap) {
        long __functionAddress = GLXSGIXFBConfig.getInstance().CreateGLXPixmapWithConfigSGIX;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkPointer(config);
        }
        return JNI.callPPPP(__functionAddress, display, config, pixmap);
    }

    public static long glXCreateContextWithConfigSGIX(long display, long config, int render_type, long share_list, int direct) {
        long __functionAddress = GLXSGIXFBConfig.getInstance().CreateContextWithConfigSGIX;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkPointer(config);
            Checks.checkPointer(share_list);
        }
        return JNI.callPPIPIP(__functionAddress, display, config, render_type, share_list, direct);
    }

    public static long nglXGetVisualFromFBConfigSGIX(long display, long config) {
        long __functionAddress = GLXSGIXFBConfig.getInstance().GetVisualFromFBConfigSGIX;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkPointer(config);
        }
        return JNI.callPPP(__functionAddress, display, config);
    }

    public static XVisualInfo glXGetVisualFromFBConfigSGIX(long display, long config) {
        long __result = GLXSGIXFBConfig.nglXGetVisualFromFBConfigSGIX(display, config);
        return new XVisualInfo(__result);
    }

    public static long nglXGetFBConfigFromVisualSGIX(long display, long vis) {
        long __functionAddress = GLXSGIXFBConfig.getInstance().GetFBConfigFromVisualSGIX;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
        }
        return JNI.callPPP(__functionAddress, display, vis);
    }

    public static long glXGetFBConfigFromVisualSGIX(long display, XVisualInfo vis) {
        return GLXSGIXFBConfig.nglXGetFBConfigFromVisualSGIX(display, vis.address());
    }
}

