/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class GLXSGIXPbuffer {
    public static final int GLX_MAX_PBUFFER_WIDTH_SGIX = 32790;
    public static final int GLX_MAX_PBUFFER_HEIGHT_SGIX = 32791;
    public static final int GLX_MAX_PBUFFER_PIXELS_SGIX = 32792;
    public static final int GLX_OPTIMAL_PBUFFER_WIDTH_SGIX = 32793;
    public static final int GLX_OPTIMAL_PBUFFER_HEIGHT_SGIX = 32794;
    public static final int GLX_PBUFFER_BIT_SGIX = 4;
    public static final int GLX_PRESERVED_CONTENTS_SGIX = 32795;
    public static final int GLX_LARGEST_PBUFFER_SGIX = 32796;
    public static final int GLX_WIDTH_SGIX = 32797;
    public static final int GLX_HEIGHT_SGIX = 32798;
    public static final int GLX_EVENT_MASK_SGIX = 32799;
    public static final int GLX_BUFFER_CLOBBER_MASK_SGIX = 0x8000000;
    public static final int GLX_DAMAGED_SGIX = 32800;
    public static final int GLX_SAVED_SGIX = 32801;
    public static final int GLX_WINDOW_SGIX = 32802;
    public static final int GLX_PBUFFER_SGIX = 32803;
    public static final int GLX_FRONT_LEFT_BUFFER_BIT_SGIX = 1;
    public static final int GLX_FRONT_RIGHT_BUFFER_BIT_SGIX = 2;
    public static final int GLX_BACK_LEFT_BUFFER_BIT_SGIX = 4;
    public static final int GLX_BACK_RIGHT_BUFFER_BIT_SGIX = 8;
    public static final int GLX_AUX_BUFFERS_BIT_SGIX = 16;
    public static final int GLX_DEPTH_BUFFER_BIT_SGIX = 32;
    public static final int GLX_STENCIL_BUFFER_BIT_SGIX = 64;
    public static final int GLX_ACCUM_BUFFER_BIT_SGIX = 128;
    public static final int GLX_SAMPLE_BUFFERS_BIT_SGIX = 256;
    public final long CreateGLXPbufferSGIX;
    public final long DestroyGLXPbufferSGIX;
    public final long QueryGLXPbufferSGIX;
    public final long SelectEventSGIX;
    public final long GetSelectedEventSGIX;

    protected GLXSGIXPbuffer() {
        throw new UnsupportedOperationException();
    }

    public GLXSGIXPbuffer(FunctionProvider provider) {
        this.CreateGLXPbufferSGIX = provider.getFunctionAddress("glXCreateGLXPbufferSGIX");
        this.DestroyGLXPbufferSGIX = provider.getFunctionAddress("glXDestroyGLXPbufferSGIX");
        this.QueryGLXPbufferSGIX = provider.getFunctionAddress("glXQueryGLXPbufferSGIX");
        this.SelectEventSGIX = provider.getFunctionAddress("glXSelectEventSGIX");
        this.GetSelectedEventSGIX = provider.getFunctionAddress("glXGetSelectedEventSGIX");
    }

    public static GLXSGIXPbuffer getInstance() {
        return GLXSGIXPbuffer.getInstance(GL.getCapabilities());
    }

    public static GLXSGIXPbuffer getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__GLXSGIXPbuffer);
    }

    static GLXSGIXPbuffer create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GLX_SGIX_pbuffer")) {
            return null;
        }
        GLXSGIXPbuffer funcs = new GLXSGIXPbuffer(provider);
        boolean supported = Checks.checkFunctions(funcs.CreateGLXPbufferSGIX, funcs.DestroyGLXPbufferSGIX, funcs.QueryGLXPbufferSGIX, funcs.SelectEventSGIX, funcs.GetSelectedEventSGIX);
        return GL.checkExtension("GLX_SGIX_pbuffer", funcs, supported);
    }

    public static long nglXCreateGLXPbufferSGIX(long display, long config, int width, int height, long attrib_list) {
        long __functionAddress = GLXSGIXPbuffer.getInstance().CreateGLXPbufferSGIX;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkPointer(config);
        }
        return JNI.callPPIIPP(__functionAddress, display, config, width, height, attrib_list);
    }

    public static long glXCreateGLXPbufferSGIX(long display, long config, int width, int height, ByteBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT4(attrib_list);
        }
        return GLXSGIXPbuffer.nglXCreateGLXPbufferSGIX(display, config, width, height, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long glXCreateGLXPbufferSGIX(long display, long config, int width, int height, IntBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list);
        }
        return GLXSGIXPbuffer.nglXCreateGLXPbufferSGIX(display, config, width, height, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static void glXDestroyGLXPbufferSGIX(long display, long pbuf) {
        long __functionAddress = GLXSGIXPbuffer.getInstance().DestroyGLXPbufferSGIX;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkPointer(pbuf);
        }
        JNI.callPPV(__functionAddress, display, pbuf);
    }

    public static void nglXQueryGLXPbufferSGIX(long display, long pbuf, int attribute, long value) {
        long __functionAddress = GLXSGIXPbuffer.getInstance().QueryGLXPbufferSGIX;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkPointer(pbuf);
        }
        JNI.callPPIPV(__functionAddress, display, pbuf, attribute, value);
    }

    public static void glXQueryGLXPbufferSGIX(long display, long pbuf, int attribute, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        GLXSGIXPbuffer.nglXQueryGLXPbufferSGIX(display, pbuf, attribute, MemoryUtil.memAddress(value));
    }

    public static void glXQueryGLXPbufferSGIX(long display, long pbuf, int attribute, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        GLXSGIXPbuffer.nglXQueryGLXPbufferSGIX(display, pbuf, attribute, MemoryUtil.memAddress(value));
    }

    public static void glXSelectEventSGIX(long display, long drawable, long mask) {
        long __functionAddress = GLXSGIXPbuffer.getInstance().SelectEventSGIX;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkPointer(drawable);
        }
        JNI.callPPPV(__functionAddress, display, drawable, mask);
    }

    public static void nglXGetSelectedEventSGIX(long display, long drawable, long mask) {
        long __functionAddress = GLXSGIXPbuffer.getInstance().GetSelectedEventSGIX;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkPointer(drawable);
        }
        JNI.callPPPV(__functionAddress, display, drawable, mask);
    }

    public static void glXGetSelectedEventSGIX(long display, long drawable, ByteBuffer mask) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)mask, 1 << Pointer.POINTER_SHIFT);
        }
        GLXSGIXPbuffer.nglXGetSelectedEventSGIX(display, drawable, MemoryUtil.memAddress(mask));
    }

    public static void glXGetSelectedEventSGIX(long display, long drawable, PointerBuffer mask) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(mask, 1);
        }
        GLXSGIXPbuffer.nglXGetSelectedEventSGIX(display, drawable, MemoryUtil.memAddress(mask));
    }
}

