/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class NVExplicitMultisample {
    public static final int GL_SAMPLE_POSITION_NV = 36432;
    public static final int GL_SAMPLE_MASK_NV = 36433;
    public static final int GL_SAMPLE_MASK_VALUE_NV = 36434;
    public static final int GL_TEXTURE_BINDING_RENDERBUFFER_NV = 36435;
    public static final int GL_TEXTURE_RENDERBUFFER_DATA_STORE_BINDING_NV = 36436;
    public static final int GL_MAX_SAMPLE_MASK_WORDS_NV = 36441;
    public static final int GL_TEXTURE_RENDERBUFFER_NV = 36437;
    public static final int GL_SAMPLER_RENDERBUFFER_NV = 36438;
    public static final int GL_INT_SAMPLER_RENDERBUFFER_NV = 36439;
    public static final int GL_UNSIGNED_INT_SAMPLER_RENDERBUFFER_NV = 36440;
    public final long GetMultisamplefvNV;
    public final long SampleMaskIndexedNV;
    public final long TexRenderbufferNV;

    protected NVExplicitMultisample() {
        throw new UnsupportedOperationException();
    }

    public NVExplicitMultisample(FunctionProvider provider) {
        this.GetMultisamplefvNV = provider.getFunctionAddress("glGetMultisamplefvNV");
        this.SampleMaskIndexedNV = provider.getFunctionAddress("glSampleMaskIndexedNV");
        this.TexRenderbufferNV = provider.getFunctionAddress("glTexRenderbufferNV");
    }

    public static NVExplicitMultisample getInstance() {
        return NVExplicitMultisample.getInstance(GL.getCapabilities());
    }

    public static NVExplicitMultisample getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__NVExplicitMultisample);
    }

    static NVExplicitMultisample create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_NV_explicit_multisample")) {
            return null;
        }
        NVExplicitMultisample funcs = new NVExplicitMultisample(provider);
        boolean supported = Checks.checkFunctions(funcs.GetMultisamplefvNV, funcs.SampleMaskIndexedNV, funcs.TexRenderbufferNV);
        return GL.checkExtension("GL_NV_explicit_multisample", funcs, supported);
    }

    public static void nglGetMultisamplefvNV(int pname, int index, long val) {
        long __functionAddress = NVExplicitMultisample.getInstance().GetMultisamplefvNV;
        JNI.callIIPV(__functionAddress, pname, index, val);
    }

    public static void glGetMultisamplefvNV(int pname, int index, ByteBuffer val) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)val, 8);
        }
        NVExplicitMultisample.nglGetMultisamplefvNV(pname, index, MemoryUtil.memAddress(val));
    }

    public static void glGetMultisamplefvNV(int pname, int index, FloatBuffer val) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)val, 2);
        }
        NVExplicitMultisample.nglGetMultisamplefvNV(pname, index, MemoryUtil.memAddress(val));
    }

    public static void glSampleMaskIndexedNV(int index, int mask) {
        long __functionAddress = NVExplicitMultisample.getInstance().SampleMaskIndexedNV;
        JNI.callIIV(__functionAddress, index, mask);
    }

    public static void glTexRenderbufferNV(int target, int renderbuffer) {
        long __functionAddress = NVExplicitMultisample.getInstance().TexRenderbufferNV;
        JNI.callIIV(__functionAddress, target, renderbuffer);
    }
}

