/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class NVTransformFeedback {
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_NV = 35982;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_START_NV = 35972;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_NV = 35973;
    public static final int GL_TRANSFORM_FEEDBACK_RECORD_NV = 35974;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_NV = 35983;
    public static final int GL_INTERLEAVED_ATTRIBS_NV = 35980;
    public static final int GL_SEPARATE_ATTRIBS_NV = 35981;
    public static final int GL_PRIMITIVES_GENERATED_NV = 35975;
    public static final int GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_NV = 35976;
    public static final int GL_RASTERIZER_DISCARD_NV = 35977;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_NV = 35978;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_NV = 35979;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_NV = 35968;
    public static final int GL_TRANSFORM_FEEDBACK_ATTRIBS_NV = 35966;
    public static final int GL_ACTIVE_VARYINGS_NV = 35969;
    public static final int GL_ACTIVE_VARYING_MAX_LENGTH_NV = 35970;
    public static final int GL_TRANSFORM_FEEDBACK_VARYINGS_NV = 35971;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_MODE_NV = 35967;
    public static final int GL_BACK_PRIMARY_COLOR_NV = 35959;
    public static final int GL_BACK_SECONDARY_COLOR_NV = 35960;
    public static final int GL_TEXTURE_COORD_NV = 35961;
    public static final int GL_CLIP_DISTANCE_NV = 35962;
    public static final int GL_VERTEX_ID_NV = 35963;
    public static final int GL_PRIMITIVE_ID_NV = 35964;
    public static final int GL_GENERIC_ATTRIB_NV = 35965;
    public static final int GL_SECONDARY_COLOR_NV = 34093;
    public static final int GL_LAYER_NV = 36266;
    public final long BeginTransformFeedbackNV;
    public final long EndTransformFeedbackNV;
    public final long TransformFeedbackAttribsNV;
    public final long BindBufferRangeNV;
    public final long BindBufferOffsetNV;
    public final long BindBufferBaseNV;
    public final long TransformFeedbackVaryingsNV;
    public final long ActiveVaryingNV;
    public final long GetVaryingLocationNV;
    public final long GetActiveVaryingNV;
    public final long GetTransformFeedbackVaryingNV;
    public final long TransformFeedbackStreamAttribsNV;

    protected NVTransformFeedback() {
        throw new UnsupportedOperationException();
    }

    public NVTransformFeedback(FunctionProvider provider) {
        this.BeginTransformFeedbackNV = provider.getFunctionAddress("glBeginTransformFeedbackNV");
        this.EndTransformFeedbackNV = provider.getFunctionAddress("glEndTransformFeedbackNV");
        this.TransformFeedbackAttribsNV = provider.getFunctionAddress("glTransformFeedbackAttribsNV");
        this.BindBufferRangeNV = provider.getFunctionAddress("glBindBufferRangeNV");
        this.BindBufferOffsetNV = provider.getFunctionAddress("glBindBufferOffsetNV");
        this.BindBufferBaseNV = provider.getFunctionAddress("glBindBufferBaseNV");
        this.TransformFeedbackVaryingsNV = provider.getFunctionAddress("glTransformFeedbackVaryingsNV");
        this.ActiveVaryingNV = provider.getFunctionAddress("glActiveVaryingNV");
        this.GetVaryingLocationNV = provider.getFunctionAddress("glGetVaryingLocationNV");
        this.GetActiveVaryingNV = provider.getFunctionAddress("glGetActiveVaryingNV");
        this.GetTransformFeedbackVaryingNV = provider.getFunctionAddress("glGetTransformFeedbackVaryingNV");
        this.TransformFeedbackStreamAttribsNV = provider.getFunctionAddress("glTransformFeedbackStreamAttribsNV");
    }

    public static NVTransformFeedback getInstance() {
        return NVTransformFeedback.getInstance(GL.getCapabilities());
    }

    public static NVTransformFeedback getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__NVTransformFeedback);
    }

    static NVTransformFeedback create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_NV_transform_feedback")) {
            return null;
        }
        NVTransformFeedback funcs = new NVTransformFeedback(provider);
        boolean supported = Checks.checkFunctions(funcs.BeginTransformFeedbackNV, funcs.EndTransformFeedbackNV, funcs.TransformFeedbackAttribsNV, funcs.BindBufferRangeNV, funcs.BindBufferOffsetNV, funcs.BindBufferBaseNV, funcs.TransformFeedbackVaryingsNV, funcs.ActiveVaryingNV, funcs.GetVaryingLocationNV, funcs.GetActiveVaryingNV, funcs.GetTransformFeedbackVaryingNV, funcs.TransformFeedbackStreamAttribsNV);
        return GL.checkExtension("GL_NV_transform_feedback", funcs, supported);
    }

    public static void glBeginTransformFeedbackNV(int primitiveMode) {
        long __functionAddress = NVTransformFeedback.getInstance().BeginTransformFeedbackNV;
        JNI.callIV(__functionAddress, primitiveMode);
    }

    public static void glEndTransformFeedbackNV() {
        long __functionAddress = NVTransformFeedback.getInstance().EndTransformFeedbackNV;
        JNI.callV(__functionAddress);
    }

    public static void nglTransformFeedbackAttribsNV(int count, long attribs, int bufferMode) {
        long __functionAddress = NVTransformFeedback.getInstance().TransformFeedbackAttribsNV;
        JNI.callIPIV(__functionAddress, count, attribs, bufferMode);
    }

    public static void glTransformFeedbackAttribsNV(int count, ByteBuffer attribs, int bufferMode) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)attribs, count << 2);
        }
        NVTransformFeedback.nglTransformFeedbackAttribsNV(count, MemoryUtil.memAddress(attribs), bufferMode);
    }

    public static void glTransformFeedbackAttribsNV(IntBuffer attribs, int bufferMode) {
        NVTransformFeedback.nglTransformFeedbackAttribsNV(attribs.remaining(), MemoryUtil.memAddress(attribs), bufferMode);
    }

    public static void glBindBufferRangeNV(int target, int index, int buffer, long offset, long size) {
        long __functionAddress = NVTransformFeedback.getInstance().BindBufferRangeNV;
        JNI.callIIIPPV(__functionAddress, target, index, buffer, offset, size);
    }

    public static void glBindBufferOffsetNV(int target, int index, int buffer, long offset) {
        long __functionAddress = NVTransformFeedback.getInstance().BindBufferOffsetNV;
        JNI.callIIIPV(__functionAddress, target, index, buffer, offset);
    }

    public static void glBindBufferBaseNV(int target, int index, int buffer) {
        long __functionAddress = NVTransformFeedback.getInstance().BindBufferBaseNV;
        JNI.callIIIV(__functionAddress, target, index, buffer);
    }

    public static void nglTransformFeedbackVaryingsNV(int program, int count, long locations, int bufferMode) {
        long __functionAddress = NVTransformFeedback.getInstance().TransformFeedbackVaryingsNV;
        JNI.callIIPIV(__functionAddress, program, count, locations, bufferMode);
    }

    public static void glTransformFeedbackVaryingsNV(int program, int count, ByteBuffer locations, int bufferMode) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)locations, count << 2);
        }
        NVTransformFeedback.nglTransformFeedbackVaryingsNV(program, count, MemoryUtil.memAddress(locations), bufferMode);
    }

    public static void glTransformFeedbackVaryingsNV(int program, IntBuffer locations, int bufferMode) {
        NVTransformFeedback.nglTransformFeedbackVaryingsNV(program, locations.remaining(), MemoryUtil.memAddress(locations), bufferMode);
    }

    public static void nglActiveVaryingNV(int program, long name) {
        long __functionAddress = NVTransformFeedback.getInstance().ActiveVaryingNV;
        JNI.callIPV(__functionAddress, program, name);
    }

    public static void glActiveVaryingNV(int program, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        NVTransformFeedback.nglActiveVaryingNV(program, MemoryUtil.memAddress(name));
    }

    public static void glActiveVaryingNV(int program, CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, true);
        NVTransformFeedback.nglActiveVaryingNV(program, __buffer.address(nameEncoded));
    }

    public static int nglGetVaryingLocationNV(int program, long name) {
        long __functionAddress = NVTransformFeedback.getInstance().GetVaryingLocationNV;
        return JNI.callIPI(__functionAddress, program, name);
    }

    public static int glGetVaryingLocationNV(int program, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return NVTransformFeedback.nglGetVaryingLocationNV(program, MemoryUtil.memAddress(name));
    }

    public static int glGetVaryingLocationNV(int program, CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, true);
        return NVTransformFeedback.nglGetVaryingLocationNV(program, __buffer.address(nameEncoded));
    }

    public static void nglGetActiveVaryingNV(int program, int index, int bufSize, long length, long size, long type, long name) {
        long __functionAddress = NVTransformFeedback.getInstance().GetActiveVaryingNV;
        JNI.callIIIPPPPV(__functionAddress, program, index, bufSize, length, size, type, name);
    }

    public static void glGetActiveVaryingNV(int program, int index, int bufSize, ByteBuffer length, ByteBuffer size, ByteBuffer type, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)name, bufSize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
            Checks.checkBuffer((Buffer)size, 4);
            Checks.checkBuffer((Buffer)type, 4);
        }
        NVTransformFeedback.nglGetActiveVaryingNV(program, index, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
    }

    public static void glGetActiveVaryingNV(int program, int index, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        if (Checks.CHECKS) {
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 1);
            }
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        NVTransformFeedback.nglGetActiveVaryingNV(program, index, name.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
    }

    public static void nglGetTransformFeedbackVaryingNV(int program, int index, long location) {
        long __functionAddress = NVTransformFeedback.getInstance().GetTransformFeedbackVaryingNV;
        JNI.callIIPV(__functionAddress, program, index, location);
    }

    public static void glGetTransformFeedbackVaryingNV(int program, int index, ByteBuffer location) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)location, 4);
        }
        NVTransformFeedback.nglGetTransformFeedbackVaryingNV(program, index, MemoryUtil.memAddress(location));
    }

    public static void glGetTransformFeedbackVaryingNV(int program, int index, IntBuffer location) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)location, 1);
        }
        NVTransformFeedback.nglGetTransformFeedbackVaryingNV(program, index, MemoryUtil.memAddress(location));
    }

    public static int glGetTransformFeedbackVaryingNV(int program, int index) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int location = __buffer.intParam();
        NVTransformFeedback.nglGetTransformFeedbackVaryingNV(program, index, __buffer.address(location));
        return __buffer.intValue(location);
    }

    public static void nglTransformFeedbackStreamAttribsNV(int count, long attribs, int nbuffers, long bufstreams, int bufferMode) {
        long __functionAddress = NVTransformFeedback.getInstance().TransformFeedbackStreamAttribsNV;
        JNI.callIPIPIV(__functionAddress, count, attribs, nbuffers, bufstreams, bufferMode);
    }

    public static void glTransformFeedbackStreamAttribsNV(int count, ByteBuffer attribs, int nbuffers, ByteBuffer bufstreams, int bufferMode) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)attribs, count << 2);
            Checks.checkBuffer((Buffer)bufstreams, nbuffers << 2);
        }
        NVTransformFeedback.nglTransformFeedbackStreamAttribsNV(count, MemoryUtil.memAddress(attribs), nbuffers, MemoryUtil.memAddress(bufstreams), bufferMode);
    }

    public static void glTransformFeedbackStreamAttribsNV(IntBuffer attribs, IntBuffer bufstreams, int bufferMode) {
        NVTransformFeedback.nglTransformFeedbackStreamAttribsNV(attribs.remaining(), MemoryUtil.memAddress(attribs), bufstreams.remaining(), MemoryUtil.memAddress(bufstreams), bufferMode);
    }
}

