/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class NVVertexArrayRange {
    public static final int GL_VERTEX_ARRAY_RANGE_NV = 34077;
    public static final int GL_VERTEX_ARRAY_RANGE_LENGTH_NV = 34078;
    public static final int GL_VERTEX_ARRAY_RANGE_VALID_NV = 34079;
    public static final int GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV = 34080;
    public static final int GL_VERTEX_ARRAY_RANGE_POINTER_NV = 34081;
    public final long VertexArrayRangeNV;
    public final long FlushVertexArrayRangeNV;

    protected NVVertexArrayRange() {
        throw new UnsupportedOperationException();
    }

    public NVVertexArrayRange(FunctionProvider provider) {
        this.VertexArrayRangeNV = provider.getFunctionAddress("glVertexArrayRangeNV");
        this.FlushVertexArrayRangeNV = provider.getFunctionAddress("glFlushVertexArrayRangeNV");
    }

    public static NVVertexArrayRange getInstance() {
        return NVVertexArrayRange.getInstance(GL.getCapabilities());
    }

    public static NVVertexArrayRange getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__NVVertexArrayRange);
    }

    static NVVertexArrayRange create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_NV_vertex_array_range")) {
            return null;
        }
        NVVertexArrayRange funcs = new NVVertexArrayRange(provider);
        boolean supported = Checks.checkFunctions(funcs.VertexArrayRangeNV, funcs.FlushVertexArrayRangeNV);
        return GL.checkExtension("GL_NV_vertex_array_range", funcs, supported);
    }

    public static void nglVertexArrayRangeNV(int length, long pointer) {
        long __functionAddress = NVVertexArrayRange.getInstance().VertexArrayRangeNV;
        JNI.callIPV(__functionAddress, length, pointer);
    }

    public static void glVertexArrayRangeNV(int length, ByteBuffer pointer) {
        NVVertexArrayRange.nglVertexArrayRangeNV(length, MemoryUtil.memAddress(pointer));
    }

    public static void glFlushVertexArrayRangeNV() {
        long __functionAddress = NVVertexArrayRange.getInstance().FlushVertexArrayRangeNV;
        JNI.callV(__functionAddress);
    }
}

