/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.windows.GLYPHMETRICSFLOAT;

public class WGL {
    public static final int WGL_FONT_LINES = 0;
    public static final int WGL_FONT_POLYGONS = 1;
    public static final int WGL_SWAP_MAIN_PLANE = 1;
    public static final int WGL_SWAP_OVERLAY1 = 2;
    public static final int WGL_SWAP_OVERLAY2 = 4;
    public static final int WGL_SWAP_OVERLAY3 = 8;
    public static final int WGL_SWAP_OVERLAY4 = 16;
    public static final int WGL_SWAP_OVERLAY5 = 32;
    public static final int WGL_SWAP_OVERLAY6 = 64;
    public static final int WGL_SWAP_OVERLAY7 = 128;
    public static final int WGL_SWAP_OVERLAY8 = 256;
    public static final int WGL_SWAP_OVERLAY9 = 512;
    public static final int WGL_SWAP_OVERLAY10 = 1024;
    public static final int WGL_SWAP_OVERLAY11 = 2048;
    public static final int WGL_SWAP_OVERLAY12 = 4096;
    public static final int WGL_SWAP_OVERLAY13 = 8192;
    public static final int WGL_SWAP_OVERLAY14 = 16384;
    public static final int WGL_SWAP_OVERLAY15 = 32768;
    public static final int WGL_SWAP_UNDERLAY1 = 65536;
    public static final int WGL_SWAP_UNDERLAY2 = 131072;
    public static final int WGL_SWAP_UNDERLAY3 = 262144;
    public static final int WGL_SWAP_UNDERLAY4 = 524288;
    public static final int WGL_SWAP_UNDERLAY5 = 0x100000;
    public static final int WGL_SWAP_UNDERLAY6 = 0x200000;
    public static final int WGL_SWAP_UNDERLAY7 = 0x400000;
    public static final int WGL_SWAP_UNDERLAY8 = 0x800000;
    public static final int WGL_SWAP_UNDERLAY9 = 0x1000000;
    public static final int WGL_SWAP_UNDERLAY10 = 0x2000000;
    public static final int WGL_SWAP_UNDERLAY11 = 0x4000000;
    public static final int WGL_SWAP_UNDERLAY12 = 0x8000000;
    public static final int WGL_SWAP_UNDERLAY13 = 0x10000000;
    public static final int WGL_SWAP_UNDERLAY14 = 0x20000000;
    public static final int WGL_SWAP_UNDERLAY15 = 0x40000000;
    public final long CreateContext;
    public final long CreateLayerContext;
    public final long CopyContext;
    public final long DeleteContext;
    public final long GetCurrentContext;
    public final long GetCurrentDC;
    public final long GetProcAddress;
    public final long MakeCurrent;
    public final long ShareLists;
    public final long UseFontBitmaps;
    public final long UseFontOutlines;

    protected WGL() {
        throw new UnsupportedOperationException();
    }

    public WGL(FunctionProvider provider) {
        this.CreateContext = provider.getFunctionAddress("wglCreateContext");
        this.CreateLayerContext = provider.getFunctionAddress("wglCreateLayerContext");
        this.CopyContext = provider.getFunctionAddress("wglCopyContext");
        this.DeleteContext = provider.getFunctionAddress("wglDeleteContext");
        this.GetCurrentContext = provider.getFunctionAddress("wglGetCurrentContext");
        this.GetCurrentDC = provider.getFunctionAddress("wglGetCurrentDC");
        this.GetProcAddress = provider.getFunctionAddress("wglGetProcAddress");
        this.MakeCurrent = provider.getFunctionAddress("wglMakeCurrent");
        this.ShareLists = provider.getFunctionAddress("wglShareLists");
        this.UseFontBitmaps = provider.getFunctionAddress("wglUseFontBitmapsW");
        this.UseFontOutlines = provider.getFunctionAddress("wglUseFontOutlinesW");
    }

    public static WGL getInstance() {
        return WGL.getInstance(GL.getCapabilities());
    }

    public static WGL getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__WGL);
    }

    static WGL create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("WGL")) {
            return null;
        }
        WGL funcs = new WGL(provider);
        boolean supported = Checks.checkFunctions(funcs.CreateContext, funcs.CreateLayerContext, funcs.CopyContext, funcs.DeleteContext, funcs.GetCurrentContext, funcs.GetCurrentDC, funcs.GetProcAddress, funcs.MakeCurrent, funcs.ShareLists, funcs.UseFontBitmaps, funcs.UseFontOutlines);
        return GL.checkExtension("WGL", funcs, supported);
    }

    public static long wglCreateContext(long hdc) {
        long __functionAddress = WGL.getInstance().CreateContext;
        if (Checks.CHECKS) {
            Checks.checkPointer(hdc);
        }
        return JNI.callPP(__functionAddress, hdc);
    }

    public static long wglCreateLayerContext(long hdc, int layerPlane) {
        long __functionAddress = WGL.getInstance().CreateLayerContext;
        if (Checks.CHECKS) {
            Checks.checkPointer(hdc);
        }
        return JNI.callPIP(__functionAddress, hdc, layerPlane);
    }

    public static int wglCopyContext(long src, long dst, int mask) {
        long __functionAddress = WGL.getInstance().CopyContext;
        if (Checks.CHECKS) {
            Checks.checkPointer(src);
            Checks.checkPointer(dst);
        }
        return JNI.callPPII(__functionAddress, src, dst, mask);
    }

    public static int wglDeleteContext(long context) {
        long __functionAddress = WGL.getInstance().DeleteContext;
        if (Checks.CHECKS) {
            Checks.checkPointer(context);
        }
        return JNI.callPI(__functionAddress, context);
    }

    public static long wglGetCurrentContext() {
        long __functionAddress = WGL.getInstance().GetCurrentContext;
        return JNI.callP(__functionAddress);
    }

    public static long wglGetCurrentDC() {
        long __functionAddress = WGL.getInstance().GetCurrentDC;
        return JNI.callP(__functionAddress);
    }

    public static long nwglGetProcAddress(long proc) {
        long __functionAddress = WGL.getInstance().GetProcAddress;
        return JNI.callPP(__functionAddress, proc);
    }

    public static long wglGetProcAddress(ByteBuffer proc) {
        if (Checks.CHECKS) {
            Checks.checkNT1(proc);
        }
        return WGL.nwglGetProcAddress(MemoryUtil.memAddress(proc));
    }

    public static long wglGetProcAddress(CharSequence proc) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int procEncoded = __buffer.stringParamASCII(proc, true);
        return WGL.nwglGetProcAddress(__buffer.address(procEncoded));
    }

    public static int wglMakeCurrent(long hdc, long context) {
        long __functionAddress = WGL.getInstance().MakeCurrent;
        return JNI.callPPI(__functionAddress, hdc, context);
    }

    public static int wglShareLists(long context1, long context2) {
        long __functionAddress = WGL.getInstance().ShareLists;
        if (Checks.CHECKS) {
            Checks.checkPointer(context1);
            Checks.checkPointer(context2);
        }
        return JNI.callPPI(__functionAddress, context1, context2);
    }

    public static int wglUseFontBitmaps(long hdc, int first, int count, int listBase) {
        long __functionAddress = WGL.getInstance().UseFontBitmaps;
        if (Checks.CHECKS) {
            Checks.checkPointer(hdc);
        }
        return JNI.callPIIII(__functionAddress, hdc, first, count, listBase);
    }

    public static int nwglUseFontOutlines(long hdc, int first, int count, int listBase, float deviation, float extrusion, int format, long glyphMetrics) {
        long __functionAddress = WGL.getInstance().UseFontOutlines;
        if (Checks.CHECKS) {
            Checks.checkPointer(hdc);
        }
        return JNI.callPIIIFFIPI(__functionAddress, hdc, first, count, listBase, deviation, extrusion, format, glyphMetrics);
    }

    public static int wglUseFontOutlines(long hdc, int first, int count, int listBase, float deviation, float extrusion, int format, GLYPHMETRICSFLOAT.Buffer glyphMetrics) {
        if (Checks.CHECKS && glyphMetrics != null) {
            Checks.checkBuffer(glyphMetrics, count);
        }
        return WGL.nwglUseFontOutlines(hdc, first, count, listBase, deviation, extrusion, format, glyphMetrics == null ? 0L : glyphMetrics.address());
    }

    public static int wglUseFontOutlines(long hdc, int first, int listBase, float deviation, float extrusion, int format, GLYPHMETRICSFLOAT.Buffer glyphMetrics) {
        return WGL.nwglUseFontOutlines(hdc, first, glyphMetrics == null ? 0 : glyphMetrics.remaining(), listBase, deviation, extrusion, format, glyphMetrics == null ? 0L : glyphMetrics.address());
    }
}

