/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class WGLARBCreateContext {
    public static final int WGL_CONTEXT_MAJOR_VERSION_ARB = 8337;
    public static final int WGL_CONTEXT_MINOR_VERSION_ARB = 8338;
    public static final int WGL_CONTEXT_LAYER_PLANE_ARB = 8339;
    public static final int WGL_CONTEXT_FLAGS_ARB = 8340;
    public static final int WGL_CONTEXT_DEBUG_BIT_ARB = 1;
    public static final int WGL_CONTEXT_FORWARD_COMPATIBLE_BIT_ARB = 2;
    public static final int ERROR_INVALID_VERSION_ARB = 8341;
    public final long CreateContextAttribsARB;

    protected WGLARBCreateContext() {
        throw new UnsupportedOperationException();
    }

    public WGLARBCreateContext(FunctionProvider provider) {
        this.CreateContextAttribsARB = provider.getFunctionAddress("wglCreateContextAttribsARB");
    }

    public static WGLARBCreateContext getInstance() {
        return WGLARBCreateContext.getInstance(GL.getCapabilities());
    }

    public static WGLARBCreateContext getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__WGLARBCreateContext);
    }

    static WGLARBCreateContext create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("WGL_ARB_create_context")) {
            return null;
        }
        WGLARBCreateContext funcs = new WGLARBCreateContext(provider);
        boolean supported = Checks.checkFunctions(funcs.CreateContextAttribsARB);
        return GL.checkExtension("WGL_ARB_create_context", funcs, supported);
    }

    public static long nwglCreateContextAttribsARB(long hdc, long shareContext, long attribList) {
        long __functionAddress = WGLARBCreateContext.getInstance().CreateContextAttribsARB;
        if (Checks.CHECKS) {
            Checks.checkPointer(hdc);
        }
        return JNI.callPPPP(__functionAddress, hdc, shareContext, attribList);
    }

    public static long wglCreateContextAttribsARB(long hdc, long shareContext, ByteBuffer attribList) {
        if (Checks.CHECKS && attribList != null) {
            Checks.checkNT4(attribList);
        }
        return WGLARBCreateContext.nwglCreateContextAttribsARB(hdc, shareContext, MemoryUtil.memAddressSafe(attribList));
    }

    public static long wglCreateContextAttribsARB(long hdc, long shareContext, IntBuffer attribList) {
        if (Checks.CHECKS && attribList != null) {
            Checks.checkNT(attribList);
        }
        return WGLARBCreateContext.nwglCreateContextAttribsARB(hdc, shareContext, MemoryUtil.memAddressSafe(attribList));
    }
}

