/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class WGLNVSwapGroup {
    public final long JoinSwapGroupNV;
    public final long BindSwapBarrierNV;
    public final long QuerySwapGroupNV;
    public final long QueryMaxSwapGroupsNV;
    public final long QueryFrameCountNV;
    public final long ResetFrameCountNV;

    protected WGLNVSwapGroup() {
        throw new UnsupportedOperationException();
    }

    public WGLNVSwapGroup(FunctionProvider provider) {
        this.JoinSwapGroupNV = provider.getFunctionAddress("wglJoinSwapGroupNV");
        this.BindSwapBarrierNV = provider.getFunctionAddress("wglBindSwapBarrierNV");
        this.QuerySwapGroupNV = provider.getFunctionAddress("wglQuerySwapGroupNV");
        this.QueryMaxSwapGroupsNV = provider.getFunctionAddress("wglQueryMaxSwapGroupsNV");
        this.QueryFrameCountNV = provider.getFunctionAddress("wglQueryFrameCountNV");
        this.ResetFrameCountNV = provider.getFunctionAddress("wglResetFrameCountNV");
    }

    public static WGLNVSwapGroup getInstance() {
        return WGLNVSwapGroup.getInstance(GL.getCapabilities());
    }

    public static WGLNVSwapGroup getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__WGLNVSwapGroup);
    }

    static WGLNVSwapGroup create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("WGL_NV_swap_group")) {
            return null;
        }
        WGLNVSwapGroup funcs = new WGLNVSwapGroup(provider);
        boolean supported = Checks.checkFunctions(funcs.JoinSwapGroupNV, funcs.BindSwapBarrierNV, funcs.QuerySwapGroupNV, funcs.QueryMaxSwapGroupsNV, funcs.QueryFrameCountNV, funcs.ResetFrameCountNV);
        return GL.checkExtension("WGL_NV_swap_group", funcs, supported);
    }

    public static int wglJoinSwapGroupNV(long hDC, int group) {
        long __functionAddress = WGLNVSwapGroup.getInstance().JoinSwapGroupNV;
        if (Checks.CHECKS) {
            Checks.checkPointer(hDC);
        }
        return JNI.callPII(__functionAddress, hDC, group);
    }

    public static int wglBindSwapBarrierNV(int group, int barrier) {
        long __functionAddress = WGLNVSwapGroup.getInstance().BindSwapBarrierNV;
        return JNI.callIII(__functionAddress, group, barrier);
    }

    public static int nwglQuerySwapGroupNV(long hDC, long group, long barrier) {
        long __functionAddress = WGLNVSwapGroup.getInstance().QuerySwapGroupNV;
        if (Checks.CHECKS) {
            Checks.checkPointer(hDC);
        }
        return JNI.callPPPI(__functionAddress, hDC, group, barrier);
    }

    public static int wglQuerySwapGroupNV(long hDC, ByteBuffer group, ByteBuffer barrier) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)group, 4);
            Checks.checkBuffer((Buffer)barrier, 4);
        }
        return WGLNVSwapGroup.nwglQuerySwapGroupNV(hDC, MemoryUtil.memAddress(group), MemoryUtil.memAddress(barrier));
    }

    public static int wglQuerySwapGroupNV(long hDC, IntBuffer group, IntBuffer barrier) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)group, 1);
            Checks.checkBuffer((Buffer)barrier, 1);
        }
        return WGLNVSwapGroup.nwglQuerySwapGroupNV(hDC, MemoryUtil.memAddress(group), MemoryUtil.memAddress(barrier));
    }

    public static int nwglQueryMaxSwapGroupsNV(long hDC, long maxGroups, long maxBarriers) {
        long __functionAddress = WGLNVSwapGroup.getInstance().QueryMaxSwapGroupsNV;
        if (Checks.CHECKS) {
            Checks.checkPointer(hDC);
        }
        return JNI.callPPPI(__functionAddress, hDC, maxGroups, maxBarriers);
    }

    public static int wglQueryMaxSwapGroupsNV(long hDC, ByteBuffer maxGroups, ByteBuffer maxBarriers) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)maxGroups, 4);
            Checks.checkBuffer((Buffer)maxBarriers, 4);
        }
        return WGLNVSwapGroup.nwglQueryMaxSwapGroupsNV(hDC, MemoryUtil.memAddress(maxGroups), MemoryUtil.memAddress(maxBarriers));
    }

    public static int wglQueryMaxSwapGroupsNV(long hDC, IntBuffer maxGroups, IntBuffer maxBarriers) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)maxGroups, 1);
            Checks.checkBuffer((Buffer)maxBarriers, 1);
        }
        return WGLNVSwapGroup.nwglQueryMaxSwapGroupsNV(hDC, MemoryUtil.memAddress(maxGroups), MemoryUtil.memAddress(maxBarriers));
    }

    public static int nwglQueryFrameCountNV(long hDC, long count) {
        long __functionAddress = WGLNVSwapGroup.getInstance().QueryFrameCountNV;
        if (Checks.CHECKS) {
            Checks.checkPointer(hDC);
        }
        return JNI.callPPI(__functionAddress, hDC, count);
    }

    public static int wglQueryFrameCountNV(long hDC, ByteBuffer count) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)count, 4);
        }
        return WGLNVSwapGroup.nwglQueryFrameCountNV(hDC, MemoryUtil.memAddress(count));
    }

    public static int wglQueryFrameCountNV(long hDC, IntBuffer count) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)count, 1);
        }
        return WGLNVSwapGroup.nwglQueryFrameCountNV(hDC, MemoryUtil.memAddress(count));
    }

    public static int wglResetFrameCountNV(long hDC) {
        long __functionAddress = WGLNVSwapGroup.getInstance().ResetFrameCountNV;
        if (Checks.CHECKS) {
            Checks.checkPointer(hDC);
        }
        return JNI.callPI(__functionAddress, hDC);
    }
}

