/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.Set;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class APPLESync {
    public static final int GL_MAX_SERVER_WAIT_TIMEOUT_APPLE = 37137;
    public static final int GL_OBJECT_TYPE_APPLE = 37138;
    public static final int GL_SYNC_CONDITION_APPLE = 37139;
    public static final int GL_SYNC_STATUS_APPLE = 37140;
    public static final int GL_SYNC_FLAGS_APPLE = 37141;
    public static final int GL_SYNC_FENCE_APPLE = 37142;
    public static final int GL_SYNC_GPU_COMMANDS_COMPLETE_APPLE = 37143;
    public static final int GL_UNSIGNALED_APPLE = 37144;
    public static final int GL_SIGNALED_APPLE = 37145;
    public static final int GL_SYNC_FLUSH_COMMANDS_BIT_APPLE = 1;
    public static final long GL_TIMEOUT_IGNORED_APPLE = -1L;
    public static final int GL_ALREADY_SIGNALED_APPLE = 37146;
    public static final int GL_TIMEOUT_EXPIRED_APPLE = 37147;
    public static final int GL_CONDITION_SATISFIED_APPLE = 37148;
    public static final int GL_WAIT_FAILED_APPLE = 37149;
    public static final int GL_SYNC_OBJECT_APPLE = 35411;
    public final long FenceSyncAPPLE;
    public final long IsSyncAPPLE;
    public final long DeleteSyncAPPLE;
    public final long ClientWaitSyncAPPLE;
    public final long WaitSyncAPPLE;
    public final long GetInteger64vAPPLE;
    public final long GetSyncivAPPLE;

    protected APPLESync() {
        throw new UnsupportedOperationException();
    }

    public APPLESync(FunctionProvider provider) {
        this.FenceSyncAPPLE = provider.getFunctionAddress("glFenceSyncAPPLE");
        this.IsSyncAPPLE = provider.getFunctionAddress("glIsSyncAPPLE");
        this.DeleteSyncAPPLE = provider.getFunctionAddress("glDeleteSyncAPPLE");
        this.ClientWaitSyncAPPLE = provider.getFunctionAddress("glClientWaitSyncAPPLE");
        this.WaitSyncAPPLE = provider.getFunctionAddress("glWaitSyncAPPLE");
        this.GetInteger64vAPPLE = provider.getFunctionAddress("glGetInteger64vAPPLE");
        this.GetSyncivAPPLE = provider.getFunctionAddress("glGetSyncivAPPLE");
    }

    public static APPLESync getInstance() {
        return APPLESync.getInstance(GLES.getCapabilities());
    }

    public static APPLESync getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__APPLESync);
    }

    static APPLESync create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_APPLE_sync")) {
            return null;
        }
        APPLESync funcs = new APPLESync(provider);
        boolean supported = Checks.checkFunctions(funcs.FenceSyncAPPLE, funcs.IsSyncAPPLE, funcs.DeleteSyncAPPLE, funcs.ClientWaitSyncAPPLE, funcs.WaitSyncAPPLE, funcs.GetInteger64vAPPLE, funcs.GetSyncivAPPLE);
        return GLES.checkExtension("GL_APPLE_sync", funcs, supported);
    }

    public static long glFenceSyncAPPLE(int condition, int flags) {
        long __functionAddress = APPLESync.getInstance().FenceSyncAPPLE;
        return JNI.callIIP(__functionAddress, condition, flags);
    }

    public static boolean glIsSyncAPPLE(long sync) {
        long __functionAddress = APPLESync.getInstance().IsSyncAPPLE;
        if (Checks.CHECKS) {
            Checks.checkPointer(sync);
        }
        return JNI.callPZ(__functionAddress, sync);
    }

    public static void glDeleteSyncAPPLE(long sync) {
        long __functionAddress = APPLESync.getInstance().DeleteSyncAPPLE;
        if (Checks.CHECKS) {
            Checks.checkPointer(sync);
        }
        JNI.callPV(__functionAddress, sync);
    }

    public static int glClientWaitSyncAPPLE(long sync, int flags, long timeout) {
        long __functionAddress = APPLESync.getInstance().ClientWaitSyncAPPLE;
        if (Checks.CHECKS) {
            Checks.checkPointer(sync);
        }
        return JNI.callPIJI(__functionAddress, sync, flags, timeout);
    }

    public static void glWaitSyncAPPLE(long sync, int flags, long timeout) {
        long __functionAddress = APPLESync.getInstance().WaitSyncAPPLE;
        if (Checks.CHECKS) {
            Checks.checkPointer(sync);
        }
        JNI.callPIJV(__functionAddress, sync, flags, timeout);
    }

    public static void nglGetInteger64vAPPLE(int pname, long params) {
        long __functionAddress = APPLESync.getInstance().GetInteger64vAPPLE;
        JNI.callIPV(__functionAddress, pname, params);
    }

    public static void glGetInteger64vAPPLE(int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 8);
        }
        APPLESync.nglGetInteger64vAPPLE(pname, MemoryUtil.memAddress(params));
    }

    public static void glGetInteger64vAPPLE(int pname, LongBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        APPLESync.nglGetInteger64vAPPLE(pname, MemoryUtil.memAddress(params));
    }

    public static long glGetInteger64APPLE(int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.longParam();
        APPLESync.nglGetInteger64vAPPLE(pname, __buffer.address(params));
        return __buffer.longValue(params);
    }

    public static void nglGetSyncivAPPLE(long sync, int pname, int bufSize, long length, long values) {
        long __functionAddress = APPLESync.getInstance().GetSyncivAPPLE;
        if (Checks.CHECKS) {
            Checks.checkPointer(sync);
        }
        JNI.callPIIPPV(__functionAddress, sync, pname, bufSize, length, values);
    }

    public static void glGetSyncivAPPLE(long sync, int pname, int bufSize, ByteBuffer length, ByteBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)values, bufSize << 2);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        APPLESync.nglGetSyncivAPPLE(sync, pname, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(values));
    }

    public static void glGetSyncivAPPLE(long sync, int pname, IntBuffer length, IntBuffer values) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        APPLESync.nglGetSyncivAPPLE(sync, pname, values.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(values));
    }

    public static int glGetSynciAPPLE(long sync, int pname, IntBuffer length) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int values = __buffer.intParam();
        APPLESync.nglGetSyncivAPPLE(sync, pname, 1, MemoryUtil.memAddressSafe(length), __buffer.address(values));
        return __buffer.intValue(values);
    }
}

