/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTBufferStorage {
    public static final int GL_MAP_PERSISTENT_BIT_EXT = 64;
    public static final int GL_MAP_COHERENT_BIT_EXT = 128;
    public static final int GL_DYNAMIC_STORAGE_BIT_EXT = 256;
    public static final int GL_CLIENT_STORAGE_BIT_EXT = 512;
    public static final int GL_BUFFER_IMMUTABLE_STORAGE_EXT = 33311;
    public static final int GL_BUFFER_STORAGE_FLAGS_EXT = 33312;
    public static final int GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT_EXT = 16384;
    public final long BufferStorageEXT;

    protected EXTBufferStorage() {
        throw new UnsupportedOperationException();
    }

    public EXTBufferStorage(FunctionProvider provider) {
        this.BufferStorageEXT = provider.getFunctionAddress("glBufferStorageEXT");
    }

    public static EXTBufferStorage getInstance() {
        return EXTBufferStorage.getInstance(GLES.getCapabilities());
    }

    public static EXTBufferStorage getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__EXTBufferStorage);
    }

    static EXTBufferStorage create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_EXT_buffer_storage")) {
            return null;
        }
        EXTBufferStorage funcs = new EXTBufferStorage(provider);
        boolean supported = Checks.checkFunctions(funcs.BufferStorageEXT);
        return GLES.checkExtension("GL_EXT_buffer_storage", funcs, supported);
    }

    public static void nglBufferStorageEXT(int target, long size, long data, int flags) {
        long __functionAddress = EXTBufferStorage.getInstance().BufferStorageEXT;
        JNI.callIPPIV(__functionAddress, target, size, data, flags);
    }

    public static void glBufferStorageEXT(int target, long size, ByteBuffer data, int flags) {
        if (Checks.CHECKS && data != null) {
            Checks.checkBuffer((Buffer)data, size);
        }
        EXTBufferStorage.nglBufferStorageEXT(target, size, MemoryUtil.memAddressSafe(data), flags);
    }

    public static void glBufferStorageEXT(int target, long size, int flags) {
        EXTBufferStorage.nglBufferStorageEXT(target, size, 0L, flags);
    }

    public static void glBufferStorageEXT(int target, ByteBuffer data, int flags) {
        EXTBufferStorage.nglBufferStorageEXT(target, data.remaining(), MemoryUtil.memAddress(data), flags);
    }

    public static void glBufferStorageEXT(int target, ShortBuffer data, int flags) {
        EXTBufferStorage.nglBufferStorageEXT(target, data.remaining() << 1, MemoryUtil.memAddress(data), flags);
    }

    public static void glBufferStorageEXT(int target, IntBuffer data, int flags) {
        EXTBufferStorage.nglBufferStorageEXT(target, data.remaining() << 2, MemoryUtil.memAddress(data), flags);
    }

    public static void glBufferStorageEXT(int target, FloatBuffer data, int flags) {
        EXTBufferStorage.nglBufferStorageEXT(target, data.remaining() << 2, MemoryUtil.memAddress(data), flags);
    }
}

