/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.opengles.GLESChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTMultiDrawIndirect {
    public final long MultiDrawArraysIndirectEXT;
    public final long MultiDrawElementsIndirectEXT;

    protected EXTMultiDrawIndirect() {
        throw new UnsupportedOperationException();
    }

    public EXTMultiDrawIndirect(FunctionProvider provider) {
        this.MultiDrawArraysIndirectEXT = provider.getFunctionAddress("glMultiDrawArraysIndirectEXT");
        this.MultiDrawElementsIndirectEXT = provider.getFunctionAddress("glMultiDrawElementsIndirectEXT");
    }

    public static EXTMultiDrawIndirect getInstance() {
        return EXTMultiDrawIndirect.getInstance(GLES.getCapabilities());
    }

    public static EXTMultiDrawIndirect getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__EXTMultiDrawIndirect);
    }

    static EXTMultiDrawIndirect create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_EXT_multi_draw_indirect")) {
            return null;
        }
        EXTMultiDrawIndirect funcs = new EXTMultiDrawIndirect(provider);
        boolean supported = Checks.checkFunctions(funcs.MultiDrawArraysIndirectEXT, funcs.MultiDrawElementsIndirectEXT);
        return GLES.checkExtension("GL_EXT_multi_draw_indirect", funcs, supported);
    }

    public static void nglMultiDrawArraysIndirectEXT(int mode, long indirect, int drawcount, int stride) {
        long __functionAddress = EXTMultiDrawIndirect.getInstance().MultiDrawArraysIndirectEXT;
        JNI.callIPIIV(__functionAddress, mode, indirect, drawcount, stride);
    }

    public static void glMultiDrawArraysIndirectEXT(int mode, ByteBuffer indirect, int drawcount, int stride) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, drawcount * (stride == 0 ? 16 : stride));
            GLESChecks.ensureBufferObject(36675, false);
        }
        EXTMultiDrawIndirect.nglMultiDrawArraysIndirectEXT(mode, MemoryUtil.memAddress(indirect), drawcount, stride);
    }

    public static void glMultiDrawArraysIndirectEXT(int mode, long indirectOffset, int drawcount, int stride) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(36675, true);
        }
        EXTMultiDrawIndirect.nglMultiDrawArraysIndirectEXT(mode, indirectOffset, drawcount, stride);
    }

    public static void glMultiDrawArraysIndirectEXT(int mode, IntBuffer indirect, int drawcount, int stride) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, drawcount * (stride == 0 ? 16 : stride) >> 2);
            GLESChecks.ensureBufferObject(36675, false);
        }
        EXTMultiDrawIndirect.nglMultiDrawArraysIndirectEXT(mode, MemoryUtil.memAddress(indirect), drawcount, stride);
    }

    public static void nglMultiDrawElementsIndirectEXT(int mode, int type, long indirect, int drawcount, int stride) {
        long __functionAddress = EXTMultiDrawIndirect.getInstance().MultiDrawElementsIndirectEXT;
        JNI.callIIPIIV(__functionAddress, mode, type, indirect, drawcount, stride);
    }

    public static void glMultiDrawElementsIndirectEXT(int mode, int type, ByteBuffer indirect, int drawcount, int stride) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, drawcount * (stride == 0 ? 20 : stride));
            GLESChecks.ensureBufferObject(36675, false);
        }
        EXTMultiDrawIndirect.nglMultiDrawElementsIndirectEXT(mode, type, MemoryUtil.memAddress(indirect), drawcount, stride);
    }

    public static void glMultiDrawElementsIndirectEXT(int mode, int type, long indirectOffset, int drawcount, int stride) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(36675, true);
        }
        EXTMultiDrawIndirect.nglMultiDrawElementsIndirectEXT(mode, type, indirectOffset, drawcount, stride);
    }

    public static void glMultiDrawElementsIndirectEXT(int mode, int type, IntBuffer indirect, int drawcount, int stride) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, drawcount * (stride == 0 ? 20 : stride) >> 2);
            GLESChecks.ensureBufferObject(36675, false);
        }
        EXTMultiDrawIndirect.nglMultiDrawElementsIndirectEXT(mode, type, MemoryUtil.memAddress(indirect), drawcount, stride);
    }
}

