/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTMultiviewDrawBuffers {
    public static final int GL_COLOR_ATTACHMENT_EXT = 37104;
    public static final int GL_MULTIVIEW_EXT = 37105;
    public static final int GL_DRAW_BUFFER_EXT = 3073;
    public static final int GL_READ_BUFFER_EXT = 3074;
    public static final int GL_MAX_MULTIVIEW_BUFFERS_EXT = 37106;
    public final long ReadBufferIndexedEXT;
    public final long DrawBuffersIndexedEXT;
    public final long GetIntegeri_vEXT;

    protected EXTMultiviewDrawBuffers() {
        throw new UnsupportedOperationException();
    }

    public EXTMultiviewDrawBuffers(FunctionProvider provider) {
        this.ReadBufferIndexedEXT = provider.getFunctionAddress("glReadBufferIndexedEXT");
        this.DrawBuffersIndexedEXT = provider.getFunctionAddress("glDrawBuffersIndexedEXT");
        this.GetIntegeri_vEXT = provider.getFunctionAddress("glGetIntegeri_vEXT");
    }

    public static EXTMultiviewDrawBuffers getInstance() {
        return EXTMultiviewDrawBuffers.getInstance(GLES.getCapabilities());
    }

    public static EXTMultiviewDrawBuffers getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__EXTMultiviewDrawBuffers);
    }

    static EXTMultiviewDrawBuffers create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_EXT_multiview_draw_buffers")) {
            return null;
        }
        EXTMultiviewDrawBuffers funcs = new EXTMultiviewDrawBuffers(provider);
        boolean supported = Checks.checkFunctions(funcs.ReadBufferIndexedEXT, funcs.DrawBuffersIndexedEXT, funcs.GetIntegeri_vEXT);
        return GLES.checkExtension("GL_EXT_multiview_draw_buffers", funcs, supported);
    }

    public static void glReadBufferIndexedEXT(int src, int index) {
        long __functionAddress = EXTMultiviewDrawBuffers.getInstance().ReadBufferIndexedEXT;
        JNI.callIIV(__functionAddress, src, index);
    }

    public static void nglDrawBuffersIndexedEXT(int n, long location, long indices) {
        long __functionAddress = EXTMultiviewDrawBuffers.getInstance().DrawBuffersIndexedEXT;
        JNI.callIPPV(__functionAddress, n, location, indices);
    }

    public static void glDrawBuffersIndexedEXT(int n, ByteBuffer location, ByteBuffer indices) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)location, n << 2);
            Checks.checkBuffer((Buffer)indices, n << 2);
        }
        EXTMultiviewDrawBuffers.nglDrawBuffersIndexedEXT(n, MemoryUtil.memAddress(location), MemoryUtil.memAddress(indices));
    }

    public static void glDrawBuffersIndexedEXT(IntBuffer location, IntBuffer indices) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indices, location.remaining());
        }
        EXTMultiviewDrawBuffers.nglDrawBuffersIndexedEXT(location.remaining(), MemoryUtil.memAddress(location), MemoryUtil.memAddress(indices));
    }

    public static void nglGetIntegeri_vEXT(int target, int index, long data) {
        long __functionAddress = EXTMultiviewDrawBuffers.getInstance().GetIntegeri_vEXT;
        JNI.callIIPV(__functionAddress, target, index, data);
    }

    public static void glGetIntegeri_vEXT(int target, int index, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 4);
        }
        EXTMultiviewDrawBuffers.nglGetIntegeri_vEXT(target, index, MemoryUtil.memAddress(data));
    }

    public static void glGetIntegeri_vEXT(int target, int index, IntBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 1);
        }
        EXTMultiviewDrawBuffers.nglGetIntegeri_vEXT(target, index, MemoryUtil.memAddress(data));
    }

    public static int glGetIntegeriEXT(int target, int index) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int data = __buffer.intParam();
        EXTMultiviewDrawBuffers.nglGetIntegeri_vEXT(target, index, __buffer.address(data));
        return __buffer.intValue(data);
    }
}

