/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTOcclusionQueryBoolean {
    public static final int GL_ANY_SAMPLES_PASSED_EXT = 35887;
    public static final int GL_ANY_SAMPLES_PASSED_CONSERVATIVE_EXT = 36202;
    public static final int GL_CURRENT_QUERY_EXT = 34917;
    public static final int GL_QUERY_RESULT_EXT = 34918;
    public static final int GL_QUERY_RESULT_AVAILABLE_EXT = 34919;
    public final long GenQueriesEXT;
    public final long DeleteQueriesEXT;
    public final long IsQueryEXT;
    public final long BeginQueryEXT;
    public final long EndQueryEXT;
    public final long GetQueryivEXT;
    public final long GetQueryObjectuivEXT;

    protected EXTOcclusionQueryBoolean() {
        throw new UnsupportedOperationException();
    }

    public EXTOcclusionQueryBoolean(FunctionProvider provider) {
        this.GenQueriesEXT = provider.getFunctionAddress("glGenQueriesEXT");
        this.DeleteQueriesEXT = provider.getFunctionAddress("glDeleteQueriesEXT");
        this.IsQueryEXT = provider.getFunctionAddress("glIsQueryEXT");
        this.BeginQueryEXT = provider.getFunctionAddress("glBeginQueryEXT");
        this.EndQueryEXT = provider.getFunctionAddress("glEndQueryEXT");
        this.GetQueryivEXT = provider.getFunctionAddress("glGetQueryivEXT");
        this.GetQueryObjectuivEXT = provider.getFunctionAddress("glGetQueryObjectuivEXT");
    }

    public static EXTOcclusionQueryBoolean getInstance() {
        return EXTOcclusionQueryBoolean.getInstance(GLES.getCapabilities());
    }

    public static EXTOcclusionQueryBoolean getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__EXTOcclusionQueryBoolean);
    }

    static EXTOcclusionQueryBoolean create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_EXT_occlusion_query_boolean")) {
            return null;
        }
        EXTOcclusionQueryBoolean funcs = new EXTOcclusionQueryBoolean(provider);
        boolean supported = Checks.checkFunctions(funcs.GenQueriesEXT, funcs.DeleteQueriesEXT, funcs.IsQueryEXT, funcs.BeginQueryEXT, funcs.EndQueryEXT, funcs.GetQueryivEXT, funcs.GetQueryObjectuivEXT);
        return GLES.checkExtension("GL_EXT_occlusion_query_boolean", funcs, supported);
    }

    public static void nglGenQueriesEXT(int n, long ids) {
        long __functionAddress = EXTOcclusionQueryBoolean.getInstance().GenQueriesEXT;
        JNI.callIPV(__functionAddress, n, ids);
    }

    public static void glGenQueriesEXT(int n, ByteBuffer ids) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)ids, n << 2);
        }
        EXTOcclusionQueryBoolean.nglGenQueriesEXT(n, MemoryUtil.memAddress(ids));
    }

    public static void glGenQueriesEXT(IntBuffer ids) {
        EXTOcclusionQueryBoolean.nglGenQueriesEXT(ids.remaining(), MemoryUtil.memAddress(ids));
    }

    public static int glGenQueriesEXT() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int ids = __buffer.intParam();
        EXTOcclusionQueryBoolean.nglGenQueriesEXT(1, __buffer.address(ids));
        return __buffer.intValue(ids);
    }

    public static void nglDeleteQueriesEXT(int n, long ids) {
        long __functionAddress = EXTOcclusionQueryBoolean.getInstance().DeleteQueriesEXT;
        JNI.callIPV(__functionAddress, n, ids);
    }

    public static void glDeleteQueriesEXT(int n, ByteBuffer ids) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)ids, n << 2);
        }
        EXTOcclusionQueryBoolean.nglDeleteQueriesEXT(n, MemoryUtil.memAddress(ids));
    }

    public static void glDeleteQueriesEXT(IntBuffer ids) {
        EXTOcclusionQueryBoolean.nglDeleteQueriesEXT(ids.remaining(), MemoryUtil.memAddress(ids));
    }

    public static void glDeleteQueriesEXT(int id) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int ids = __buffer.intParam(id);
        EXTOcclusionQueryBoolean.nglDeleteQueriesEXT(1, __buffer.address(ids));
    }

    public static boolean glIsQueryEXT(int id) {
        long __functionAddress = EXTOcclusionQueryBoolean.getInstance().IsQueryEXT;
        return JNI.callIZ(__functionAddress, id);
    }

    public static void glBeginQueryEXT(int target, int id) {
        long __functionAddress = EXTOcclusionQueryBoolean.getInstance().BeginQueryEXT;
        JNI.callIIV(__functionAddress, target, id);
    }

    public static void glEndQueryEXT(int target) {
        long __functionAddress = EXTOcclusionQueryBoolean.getInstance().EndQueryEXT;
        JNI.callIV(__functionAddress, target);
    }

    public static void nglGetQueryivEXT(int target, int pname, long params) {
        long __functionAddress = EXTOcclusionQueryBoolean.getInstance().GetQueryivEXT;
        JNI.callIIPV(__functionAddress, target, pname, params);
    }

    public static void glGetQueryivEXT(int target, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        EXTOcclusionQueryBoolean.nglGetQueryivEXT(target, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetQueryivEXT(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTOcclusionQueryBoolean.nglGetQueryivEXT(target, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetQueryiEXT(int target, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        EXTOcclusionQueryBoolean.nglGetQueryivEXT(target, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetQueryObjectuivEXT(int id, int pname, long params) {
        long __functionAddress = EXTOcclusionQueryBoolean.getInstance().GetQueryObjectuivEXT;
        JNI.callIIPV(__functionAddress, id, pname, params);
    }

    public static void glGetQueryObjectuivEXT(int id, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        EXTOcclusionQueryBoolean.nglGetQueryObjectuivEXT(id, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetQueryObjectuivEXT(int id, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTOcclusionQueryBoolean.nglGetQueryObjectuivEXT(id, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetQueryObjectuiEXT(int id, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        EXTOcclusionQueryBoolean.nglGetQueryObjectuivEXT(id, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }
}

