/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.opengles.GLESChecks;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTRobustness {
    public static final int GL_GUILTY_CONTEXT_RESET_EXT = 33363;
    public static final int GL_INNOCENT_CONTEXT_RESET_EXT = 33364;
    public static final int GL_UNKNOWN_CONTEXT_RESET_EXT = 33365;
    public static final int GL_CONTEXT_ROBUST_ACCESS_EXT = 37107;
    public static final int GL_RESET_NOTIFICATION_STRATEGY_EXT = 33366;
    public static final int GL_LOSE_CONTEXT_ON_RESET_EXT = 33362;
    public static final int GL_NO_RESET_NOTIFICATION_EXT = 33377;
    public final long GetGraphicsResetStatusEXT;
    public final long ReadnPixelsEXT;
    public final long GetnUniformfvEXT;
    public final long GetnUniformivEXT;

    protected EXTRobustness() {
        throw new UnsupportedOperationException();
    }

    public EXTRobustness(FunctionProvider provider) {
        this.GetGraphicsResetStatusEXT = provider.getFunctionAddress("glGetGraphicsResetStatusEXT");
        this.ReadnPixelsEXT = provider.getFunctionAddress("glReadnPixelsEXT");
        this.GetnUniformfvEXT = provider.getFunctionAddress("glGetnUniformfvEXT");
        this.GetnUniformivEXT = provider.getFunctionAddress("glGetnUniformivEXT");
    }

    public static EXTRobustness getInstance() {
        return EXTRobustness.getInstance(GLES.getCapabilities());
    }

    public static EXTRobustness getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__EXTRobustness);
    }

    static EXTRobustness create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_EXT_robustness")) {
            return null;
        }
        EXTRobustness funcs = new EXTRobustness(provider);
        boolean supported = Checks.checkFunctions(funcs.GetGraphicsResetStatusEXT, funcs.ReadnPixelsEXT, funcs.GetnUniformfvEXT, funcs.GetnUniformivEXT);
        return GLES.checkExtension("GL_EXT_robustness", funcs, supported);
    }

    public static int glGetGraphicsResetStatusEXT() {
        long __functionAddress = EXTRobustness.getInstance().GetGraphicsResetStatusEXT;
        return JNI.callI(__functionAddress);
    }

    public static void nglReadnPixelsEXT(int x, int y, int width, int height, int format, int type, int bufSize, long data) {
        long __functionAddress = EXTRobustness.getInstance().ReadnPixelsEXT;
        JNI.callIIIIIIIPV(__functionAddress, x, y, width, height, format, type, bufSize, data);
    }

    public static void glReadnPixelsEXT(int x, int y, int width, int height, int format, int type, int bufSize, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, bufSize);
            GLESChecks.ensureBufferObject(35053, false);
        }
        EXTRobustness.nglReadnPixelsEXT(x, y, width, height, format, type, bufSize, MemoryUtil.memAddress(data));
    }

    public static void glReadnPixelsEXT(int x, int y, int width, int height, int format, int type, int bufSize, long dataOffset) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35053, true);
        }
        EXTRobustness.nglReadnPixelsEXT(x, y, width, height, format, type, bufSize, dataOffset);
    }

    public static void glReadnPixelsEXT(int x, int y, int width, int height, int format, int type, ByteBuffer data) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35053, false);
        }
        EXTRobustness.nglReadnPixelsEXT(x, y, width, height, format, type, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void glReadnPixelsEXT(int x, int y, int width, int height, int format, int type, ShortBuffer data) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35053, false);
        }
        EXTRobustness.nglReadnPixelsEXT(x, y, width, height, format, type, data.remaining() << 1, MemoryUtil.memAddress(data));
    }

    public static void glReadnPixelsEXT(int x, int y, int width, int height, int format, int type, IntBuffer data) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35053, false);
        }
        EXTRobustness.nglReadnPixelsEXT(x, y, width, height, format, type, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static void glReadnPixelsEXT(int x, int y, int width, int height, int format, int type, FloatBuffer data) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35053, false);
        }
        EXTRobustness.nglReadnPixelsEXT(x, y, width, height, format, type, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static void nglGetnUniformfvEXT(int program, int location, int bufSize, long params) {
        long __functionAddress = EXTRobustness.getInstance().GetnUniformfvEXT;
        JNI.callIIIPV(__functionAddress, program, location, bufSize, params);
    }

    public static void glGetnUniformfvEXT(int program, int location, int bufSize, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, bufSize << 2);
        }
        EXTRobustness.nglGetnUniformfvEXT(program, location, bufSize, MemoryUtil.memAddress(params));
    }

    public static void glGetnUniformfvEXT(int program, int location, FloatBuffer params) {
        EXTRobustness.nglGetnUniformfvEXT(program, location, params.remaining(), MemoryUtil.memAddress(params));
    }

    public static float glGetnUniformfEXT(int program, int location) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.floatParam();
        EXTRobustness.nglGetnUniformfvEXT(program, location, 1, __buffer.address(params));
        return __buffer.floatValue(params);
    }

    public static void nglGetnUniformivEXT(int program, int location, int bufSize, long params) {
        long __functionAddress = EXTRobustness.getInstance().GetnUniformivEXT;
        JNI.callIIIPV(__functionAddress, program, location, bufSize, params);
    }

    public static void glGetnUniformivEXT(int program, int location, int bufSize, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, bufSize << 2);
        }
        EXTRobustness.nglGetnUniformivEXT(program, location, bufSize, MemoryUtil.memAddress(params));
    }

    public static void glGetnUniformivEXT(int program, int location, IntBuffer params) {
        EXTRobustness.nglGetnUniformivEXT(program, location, params.remaining(), MemoryUtil.memAddress(params));
    }

    public static int glGetnUniformiEXT(int program, int location) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        EXTRobustness.nglGetnUniformivEXT(program, location, 1, __buffer.address(params));
        return __buffer.intValue(params);
    }
}

