/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class EXTSeparateShaderObjects {
    public static final int GL_VERTEX_SHADER_BIT_EXT = 1;
    public static final int GL_FRAGMENT_SHADER_BIT_EXT = 2;
    public static final int GL_ALL_SHADER_BITS_EXT = -1;
    public static final int GL_PROGRAM_SEPARABLE_EXT = 33368;
    public static final int GL_ACTIVE_PROGRAM_EXT = 33369;
    public static final int GL_PROGRAM_PIPELINE_BINDING_EXT = 33370;
    public final long ActiveShaderProgramEXT;
    public final long BindProgramPipelineEXT;
    public final long CreateShaderProgramvEXT;
    public final long DeleteProgramPipelinesEXT;
    public final long GenProgramPipelinesEXT;
    public final long GetProgramPipelineInfoLogEXT;
    public final long GetProgramPipelineivEXT;
    public final long IsProgramPipelineEXT;
    public final long ProgramParameteriEXT;
    public final long ProgramUniform1fEXT;
    public final long ProgramUniform1fvEXT;
    public final long ProgramUniform1iEXT;
    public final long ProgramUniform1ivEXT;
    public final long ProgramUniform2fEXT;
    public final long ProgramUniform2fvEXT;
    public final long ProgramUniform2iEXT;
    public final long ProgramUniform2ivEXT;
    public final long ProgramUniform3fEXT;
    public final long ProgramUniform3fvEXT;
    public final long ProgramUniform3iEXT;
    public final long ProgramUniform3ivEXT;
    public final long ProgramUniform4fEXT;
    public final long ProgramUniform4fvEXT;
    public final long ProgramUniform4iEXT;
    public final long ProgramUniform4ivEXT;
    public final long ProgramUniformMatrix2fvEXT;
    public final long ProgramUniformMatrix3fvEXT;
    public final long ProgramUniformMatrix4fvEXT;
    public final long UseProgramStagesEXT;
    public final long ValidateProgramPipelineEXT;
    public final long ProgramUniform1uiEXT;
    public final long ProgramUniform2uiEXT;
    public final long ProgramUniform3uiEXT;
    public final long ProgramUniform4uiEXT;
    public final long ProgramUniform1uivEXT;
    public final long ProgramUniform2uivEXT;
    public final long ProgramUniform3uivEXT;
    public final long ProgramUniform4uivEXT;
    public final long ProgramUniformMatrix2x3fvEXT;
    public final long ProgramUniformMatrix3x2fvEXT;
    public final long ProgramUniformMatrix2x4fvEXT;
    public final long ProgramUniformMatrix4x2fvEXT;
    public final long ProgramUniformMatrix3x4fvEXT;
    public final long ProgramUniformMatrix4x3fvEXT;

    protected EXTSeparateShaderObjects() {
        throw new UnsupportedOperationException();
    }

    public EXTSeparateShaderObjects(FunctionProvider provider) {
        this.ActiveShaderProgramEXT = provider.getFunctionAddress("glActiveShaderProgramEXT");
        this.BindProgramPipelineEXT = provider.getFunctionAddress("glBindProgramPipelineEXT");
        this.CreateShaderProgramvEXT = provider.getFunctionAddress("glCreateShaderProgramvEXT");
        this.DeleteProgramPipelinesEXT = provider.getFunctionAddress("glDeleteProgramPipelinesEXT");
        this.GenProgramPipelinesEXT = provider.getFunctionAddress("glGenProgramPipelinesEXT");
        this.GetProgramPipelineInfoLogEXT = provider.getFunctionAddress("glGetProgramPipelineInfoLogEXT");
        this.GetProgramPipelineivEXT = provider.getFunctionAddress("glGetProgramPipelineivEXT");
        this.IsProgramPipelineEXT = provider.getFunctionAddress("glIsProgramPipelineEXT");
        this.ProgramParameteriEXT = provider.getFunctionAddress("glProgramParameteriEXT");
        this.ProgramUniform1fEXT = provider.getFunctionAddress("glProgramUniform1fEXT");
        this.ProgramUniform1fvEXT = provider.getFunctionAddress("glProgramUniform1fvEXT");
        this.ProgramUniform1iEXT = provider.getFunctionAddress("glProgramUniform1iEXT");
        this.ProgramUniform1ivEXT = provider.getFunctionAddress("glProgramUniform1ivEXT");
        this.ProgramUniform2fEXT = provider.getFunctionAddress("glProgramUniform2fEXT");
        this.ProgramUniform2fvEXT = provider.getFunctionAddress("glProgramUniform2fvEXT");
        this.ProgramUniform2iEXT = provider.getFunctionAddress("glProgramUniform2iEXT");
        this.ProgramUniform2ivEXT = provider.getFunctionAddress("glProgramUniform2ivEXT");
        this.ProgramUniform3fEXT = provider.getFunctionAddress("glProgramUniform3fEXT");
        this.ProgramUniform3fvEXT = provider.getFunctionAddress("glProgramUniform3fvEXT");
        this.ProgramUniform3iEXT = provider.getFunctionAddress("glProgramUniform3iEXT");
        this.ProgramUniform3ivEXT = provider.getFunctionAddress("glProgramUniform3ivEXT");
        this.ProgramUniform4fEXT = provider.getFunctionAddress("glProgramUniform4fEXT");
        this.ProgramUniform4fvEXT = provider.getFunctionAddress("glProgramUniform4fvEXT");
        this.ProgramUniform4iEXT = provider.getFunctionAddress("glProgramUniform4iEXT");
        this.ProgramUniform4ivEXT = provider.getFunctionAddress("glProgramUniform4ivEXT");
        this.ProgramUniformMatrix2fvEXT = provider.getFunctionAddress("glProgramUniformMatrix2fvEXT");
        this.ProgramUniformMatrix3fvEXT = provider.getFunctionAddress("glProgramUniformMatrix3fvEXT");
        this.ProgramUniformMatrix4fvEXT = provider.getFunctionAddress("glProgramUniformMatrix4fvEXT");
        this.UseProgramStagesEXT = provider.getFunctionAddress("glUseProgramStagesEXT");
        this.ValidateProgramPipelineEXT = provider.getFunctionAddress("glValidateProgramPipelineEXT");
        this.ProgramUniform1uiEXT = provider.getFunctionAddress("glProgramUniform1uiEXT");
        this.ProgramUniform2uiEXT = provider.getFunctionAddress("glProgramUniform2uiEXT");
        this.ProgramUniform3uiEXT = provider.getFunctionAddress("glProgramUniform3uiEXT");
        this.ProgramUniform4uiEXT = provider.getFunctionAddress("glProgramUniform4uiEXT");
        this.ProgramUniform1uivEXT = provider.getFunctionAddress("glProgramUniform1uivEXT");
        this.ProgramUniform2uivEXT = provider.getFunctionAddress("glProgramUniform2uivEXT");
        this.ProgramUniform3uivEXT = provider.getFunctionAddress("glProgramUniform3uivEXT");
        this.ProgramUniform4uivEXT = provider.getFunctionAddress("glProgramUniform4uivEXT");
        this.ProgramUniformMatrix2x3fvEXT = provider.getFunctionAddress("glProgramUniformMatrix2x3fvEXT");
        this.ProgramUniformMatrix3x2fvEXT = provider.getFunctionAddress("glProgramUniformMatrix3x2fvEXT");
        this.ProgramUniformMatrix2x4fvEXT = provider.getFunctionAddress("glProgramUniformMatrix2x4fvEXT");
        this.ProgramUniformMatrix4x2fvEXT = provider.getFunctionAddress("glProgramUniformMatrix4x2fvEXT");
        this.ProgramUniformMatrix3x4fvEXT = provider.getFunctionAddress("glProgramUniformMatrix3x4fvEXT");
        this.ProgramUniformMatrix4x3fvEXT = provider.getFunctionAddress("glProgramUniformMatrix4x3fvEXT");
    }

    public static EXTSeparateShaderObjects getInstance() {
        return EXTSeparateShaderObjects.getInstance(GLES.getCapabilities());
    }

    public static EXTSeparateShaderObjects getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__EXTSeparateShaderObjects);
    }

    static EXTSeparateShaderObjects create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_EXT_separate_shader_objects")) {
            return null;
        }
        EXTSeparateShaderObjects funcs = new EXTSeparateShaderObjects(provider);
        boolean supported = Checks.checkFunctions(funcs.ActiveShaderProgramEXT, funcs.BindProgramPipelineEXT, funcs.CreateShaderProgramvEXT, funcs.DeleteProgramPipelinesEXT, funcs.GenProgramPipelinesEXT, funcs.GetProgramPipelineInfoLogEXT, funcs.GetProgramPipelineivEXT, funcs.IsProgramPipelineEXT, funcs.ProgramParameteriEXT, funcs.ProgramUniform1fEXT, funcs.ProgramUniform1fvEXT, funcs.ProgramUniform1iEXT, funcs.ProgramUniform1ivEXT, funcs.ProgramUniform2fEXT, funcs.ProgramUniform2fvEXT, funcs.ProgramUniform2iEXT, funcs.ProgramUniform2ivEXT, funcs.ProgramUniform3fEXT, funcs.ProgramUniform3fvEXT, funcs.ProgramUniform3iEXT, funcs.ProgramUniform3ivEXT, funcs.ProgramUniform4fEXT, funcs.ProgramUniform4fvEXT, funcs.ProgramUniform4iEXT, funcs.ProgramUniform4ivEXT, funcs.ProgramUniformMatrix2fvEXT, funcs.ProgramUniformMatrix3fvEXT, funcs.ProgramUniformMatrix4fvEXT, funcs.UseProgramStagesEXT, funcs.ValidateProgramPipelineEXT, funcs.ProgramUniform1uiEXT, funcs.ProgramUniform2uiEXT, funcs.ProgramUniform3uiEXT, funcs.ProgramUniform4uiEXT, funcs.ProgramUniform1uivEXT, funcs.ProgramUniform2uivEXT, funcs.ProgramUniform3uivEXT, funcs.ProgramUniform4uivEXT, funcs.ProgramUniformMatrix2x3fvEXT, funcs.ProgramUniformMatrix3x2fvEXT, funcs.ProgramUniformMatrix2x4fvEXT, funcs.ProgramUniformMatrix4x2fvEXT, funcs.ProgramUniformMatrix3x4fvEXT, funcs.ProgramUniformMatrix4x3fvEXT);
        return GLES.checkExtension("GL_EXT_separate_shader_objects", funcs, supported);
    }

    public static void glActiveShaderProgramEXT(int pipeline, int program) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ActiveShaderProgramEXT;
        JNI.callIIV(__functionAddress, pipeline, program);
    }

    public static void glBindProgramPipelineEXT(int pipeline) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().BindProgramPipelineEXT;
        JNI.callIV(__functionAddress, pipeline);
    }

    public static int nglCreateShaderProgramvEXT(int type, int count, long strings) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().CreateShaderProgramvEXT;
        return JNI.callIIPI(__functionAddress, type, count, strings);
    }

    public static int glCreateShaderProgramvEXT(int type, int count, ByteBuffer strings) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)strings, count << Pointer.POINTER_SHIFT);
        }
        return EXTSeparateShaderObjects.nglCreateShaderProgramvEXT(type, count, MemoryUtil.memAddress(strings));
    }

    public static int glCreateShaderProgramvEXT(int type, PointerBuffer strings) {
        return EXTSeparateShaderObjects.nglCreateShaderProgramvEXT(type, strings.remaining(), MemoryUtil.memAddress(strings));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glCreateShaderProgramvEXT(int type, CharSequence ... strings) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int stringsAddress = __buffer.pointerArrayParamUTF8(strings);
        try {
            int n = EXTSeparateShaderObjects.nglCreateShaderProgramvEXT(type, strings.length, __buffer.address(stringsAddress));
            return n;
        }
        finally {
            __buffer.pointerArrayFree(stringsAddress, strings.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glCreateShaderProgramvEXT(int type, CharSequence string) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int stringsAddress = __buffer.pointerArrayParamUTF8(string);
        try {
            int n = EXTSeparateShaderObjects.nglCreateShaderProgramvEXT(type, 1, __buffer.address(stringsAddress));
            return n;
        }
        finally {
            __buffer.pointerArrayFree(stringsAddress, 1);
        }
    }

    public static void nglDeleteProgramPipelinesEXT(int n, long pipelines) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().DeleteProgramPipelinesEXT;
        JNI.callIPV(__functionAddress, n, pipelines);
    }

    public static void glDeleteProgramPipelinesEXT(int n, ByteBuffer pipelines) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)pipelines, n << 2);
        }
        EXTSeparateShaderObjects.nglDeleteProgramPipelinesEXT(n, MemoryUtil.memAddress(pipelines));
    }

    public static void glDeleteProgramPipelinesEXT(IntBuffer pipelines) {
        EXTSeparateShaderObjects.nglDeleteProgramPipelinesEXT(pipelines.remaining(), MemoryUtil.memAddress(pipelines));
    }

    public static void glDeleteProgramPipelinesEXT(int pipeline) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int pipelines = __buffer.intParam(pipeline);
        EXTSeparateShaderObjects.nglDeleteProgramPipelinesEXT(1, __buffer.address(pipelines));
    }

    public static void nglGenProgramPipelinesEXT(int n, long pipelines) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().GenProgramPipelinesEXT;
        JNI.callIPV(__functionAddress, n, pipelines);
    }

    public static void glGenProgramPipelinesEXT(int n, ByteBuffer pipelines) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)pipelines, n << 2);
        }
        EXTSeparateShaderObjects.nglGenProgramPipelinesEXT(n, MemoryUtil.memAddress(pipelines));
    }

    public static void glGenProgramPipelinesEXT(IntBuffer pipelines) {
        EXTSeparateShaderObjects.nglGenProgramPipelinesEXT(pipelines.remaining(), MemoryUtil.memAddress(pipelines));
    }

    public static int glGenProgramPipelinesEXT() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int pipelines = __buffer.intParam();
        EXTSeparateShaderObjects.nglGenProgramPipelinesEXT(1, __buffer.address(pipelines));
        return __buffer.intValue(pipelines);
    }

    public static void nglGetProgramPipelineInfoLogEXT(int pipeline, int bufSize, long length, long infoLog) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().GetProgramPipelineInfoLogEXT;
        JNI.callIIPPV(__functionAddress, pipeline, bufSize, length, infoLog);
    }

    public static void glGetProgramPipelineInfoLogEXT(int pipeline, int bufSize, ByteBuffer length, ByteBuffer infoLog) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)infoLog, bufSize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        EXTSeparateShaderObjects.nglGetProgramPipelineInfoLogEXT(pipeline, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(infoLog));
    }

    public static void glGetProgramPipelineInfoLogEXT(int pipeline, IntBuffer length, ByteBuffer infoLog) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        EXTSeparateShaderObjects.nglGetProgramPipelineInfoLogEXT(pipeline, infoLog.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(infoLog));
    }

    public static String glGetProgramPipelineInfoLogEXT(int pipeline, int bufSize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int infoLog = __buffer.bufferParam(bufSize);
        EXTSeparateShaderObjects.nglGetProgramPipelineInfoLogEXT(pipeline, bufSize, __buffer.address(length), __buffer.address(infoLog));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), infoLog);
    }

    public static String glGetProgramPipelineInfoLogEXT(int pipeline) {
        int bufSize = EXTSeparateShaderObjects.glGetProgramPipelineiEXT(pipeline, 35716);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int infoLog = __buffer.bufferParam(bufSize);
        EXTSeparateShaderObjects.nglGetProgramPipelineInfoLogEXT(pipeline, bufSize, __buffer.address(length), __buffer.address(infoLog));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), infoLog);
    }

    public static void nglGetProgramPipelineivEXT(int pipeline, int pname, long params) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().GetProgramPipelineivEXT;
        JNI.callIIPV(__functionAddress, pipeline, pname, params);
    }

    public static void glGetProgramPipelineivEXT(int pipeline, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        EXTSeparateShaderObjects.nglGetProgramPipelineivEXT(pipeline, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetProgramPipelineivEXT(int pipeline, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTSeparateShaderObjects.nglGetProgramPipelineivEXT(pipeline, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetProgramPipelineiEXT(int pipeline, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        EXTSeparateShaderObjects.nglGetProgramPipelineivEXT(pipeline, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static boolean glIsProgramPipelineEXT(int pipeline) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().IsProgramPipelineEXT;
        return JNI.callIZ(__functionAddress, pipeline);
    }

    public static void glProgramParameteriEXT(int program, int pname, int value) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ProgramParameteriEXT;
        JNI.callIIIV(__functionAddress, program, pname, value);
    }

    public static void glProgramUniform1fEXT(int program, int location, float v0) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ProgramUniform1fEXT;
        JNI.callIIFV(__functionAddress, program, location, v0);
    }

    public static void nglProgramUniform1fvEXT(int program, int location, int count, long value) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ProgramUniform1fvEXT;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform1fvEXT(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2);
        }
        EXTSeparateShaderObjects.nglProgramUniform1fvEXT(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform1fvEXT(int program, int location, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniform1fvEXT(program, location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform1iEXT(int program, int location, int v0) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ProgramUniform1iEXT;
        JNI.callIIIV(__functionAddress, program, location, v0);
    }

    public static void nglProgramUniform1ivEXT(int program, int location, int count, long value) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ProgramUniform1ivEXT;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform1ivEXT(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2);
        }
        EXTSeparateShaderObjects.nglProgramUniform1ivEXT(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform1ivEXT(int program, int location, IntBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniform1ivEXT(program, location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform2fEXT(int program, int location, float v0, float v1) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ProgramUniform2fEXT;
        JNI.callIIFFV(__functionAddress, program, location, v0, v1);
    }

    public static void nglProgramUniform2fvEXT(int program, int location, int count, long value) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ProgramUniform2fvEXT;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform2fvEXT(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 1 << 2);
        }
        EXTSeparateShaderObjects.nglProgramUniform2fvEXT(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform2fvEXT(int program, int location, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniform2fvEXT(program, location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform2iEXT(int program, int location, int v0, int v1) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ProgramUniform2iEXT;
        JNI.callIIIIV(__functionAddress, program, location, v0, v1);
    }

    public static void nglProgramUniform2ivEXT(int program, int location, int count, long value) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ProgramUniform2ivEXT;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform2ivEXT(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 1 << 2);
        }
        EXTSeparateShaderObjects.nglProgramUniform2ivEXT(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform2ivEXT(int program, int location, IntBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniform2ivEXT(program, location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform3fEXT(int program, int location, float v0, float v1, float v2) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ProgramUniform3fEXT;
        JNI.callIIFFFV(__functionAddress, program, location, v0, v1, v2);
    }

    public static void nglProgramUniform3fvEXT(int program, int location, int count, long value) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ProgramUniform3fvEXT;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform3fvEXT(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 3 << 2);
        }
        EXTSeparateShaderObjects.nglProgramUniform3fvEXT(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform3fvEXT(int program, int location, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniform3fvEXT(program, location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform3iEXT(int program, int location, int v0, int v1, int v2) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ProgramUniform3iEXT;
        JNI.callIIIIIV(__functionAddress, program, location, v0, v1, v2);
    }

    public static void nglProgramUniform3ivEXT(int program, int location, int count, long value) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ProgramUniform3ivEXT;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform3ivEXT(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 3 << 2);
        }
        EXTSeparateShaderObjects.nglProgramUniform3ivEXT(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform3ivEXT(int program, int location, IntBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniform3ivEXT(program, location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform4fEXT(int program, int location, float v0, float v1, float v2, float v3) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ProgramUniform4fEXT;
        JNI.callIIFFFFV(__functionAddress, program, location, v0, v1, v2, v3);
    }

    public static void nglProgramUniform4fvEXT(int program, int location, int count, long value) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ProgramUniform4fvEXT;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform4fvEXT(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 2);
        }
        EXTSeparateShaderObjects.nglProgramUniform4fvEXT(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform4fvEXT(int program, int location, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniform4fvEXT(program, location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform4iEXT(int program, int location, int v0, int v1, int v2, int v3) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ProgramUniform4iEXT;
        JNI.callIIIIIIV(__functionAddress, program, location, v0, v1, v2, v3);
    }

    public static void nglProgramUniform4ivEXT(int program, int location, int count, long value) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ProgramUniform4ivEXT;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform4ivEXT(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 2);
        }
        EXTSeparateShaderObjects.nglProgramUniform4ivEXT(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform4ivEXT(int program, int location, IntBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniform4ivEXT(program, location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix2fvEXT(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ProgramUniformMatrix2fvEXT;
        JNI.callIIIZPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix2fvEXT(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 2);
        }
        EXTSeparateShaderObjects.nglProgramUniformMatrix2fvEXT(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix2fvEXT(int program, int location, boolean transpose, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniformMatrix2fvEXT(program, location, value.remaining() >> 2, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix3fvEXT(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ProgramUniformMatrix3fvEXT;
        JNI.callIIIZPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix3fvEXT(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 9 << 2);
        }
        EXTSeparateShaderObjects.nglProgramUniformMatrix3fvEXT(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix3fvEXT(int program, int location, boolean transpose, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniformMatrix3fvEXT(program, location, value.remaining() / 9, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix4fvEXT(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ProgramUniformMatrix4fvEXT;
        JNI.callIIIZPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix4fvEXT(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 4 << 2);
        }
        EXTSeparateShaderObjects.nglProgramUniformMatrix4fvEXT(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix4fvEXT(int program, int location, boolean transpose, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniformMatrix4fvEXT(program, location, value.remaining() >> 4, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUseProgramStagesEXT(int pipeline, int stages, int program) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().UseProgramStagesEXT;
        JNI.callIIIV(__functionAddress, pipeline, stages, program);
    }

    public static void glValidateProgramPipelineEXT(int pipeline) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ValidateProgramPipelineEXT;
        JNI.callIV(__functionAddress, pipeline);
    }

    public static void glProgramUniform1uiEXT(int program, int location, int v0) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ProgramUniform1uiEXT;
        JNI.callIIIV(__functionAddress, program, location, v0);
    }

    public static void glProgramUniform2uiEXT(int program, int location, int v0, int v1) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ProgramUniform2uiEXT;
        JNI.callIIIIV(__functionAddress, program, location, v0, v1);
    }

    public static void glProgramUniform3uiEXT(int program, int location, int v0, int v1, int v2) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ProgramUniform3uiEXT;
        JNI.callIIIIIV(__functionAddress, program, location, v0, v1, v2);
    }

    public static void glProgramUniform4uiEXT(int program, int location, int v0, int v1, int v2, int v3) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ProgramUniform4uiEXT;
        JNI.callIIIIIIV(__functionAddress, program, location, v0, v1, v2, v3);
    }

    public static void nglProgramUniform1uivEXT(int program, int location, int count, long value) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ProgramUniform1uivEXT;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform1uivEXT(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2);
        }
        EXTSeparateShaderObjects.nglProgramUniform1uivEXT(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform1uivEXT(int program, int location, IntBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniform1uivEXT(program, location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform2uivEXT(int program, int location, int count, long value) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ProgramUniform2uivEXT;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform2uivEXT(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 1 << 2);
        }
        EXTSeparateShaderObjects.nglProgramUniform2uivEXT(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform2uivEXT(int program, int location, IntBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniform2uivEXT(program, location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform3uivEXT(int program, int location, int count, long value) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ProgramUniform3uivEXT;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform3uivEXT(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 3 << 2);
        }
        EXTSeparateShaderObjects.nglProgramUniform3uivEXT(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform3uivEXT(int program, int location, IntBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniform3uivEXT(program, location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform4uivEXT(int program, int location, int count, long value) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ProgramUniform4uivEXT;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform4uivEXT(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 2);
        }
        EXTSeparateShaderObjects.nglProgramUniform4uivEXT(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform4uivEXT(int program, int location, IntBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniform4uivEXT(program, location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix2x3fvEXT(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ProgramUniformMatrix2x3fvEXT;
        JNI.callIIIZPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix2x3fvEXT(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 6 << 2);
        }
        EXTSeparateShaderObjects.nglProgramUniformMatrix2x3fvEXT(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix2x3fvEXT(int program, int location, boolean transpose, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniformMatrix2x3fvEXT(program, location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix3x2fvEXT(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ProgramUniformMatrix3x2fvEXT;
        JNI.callIIIZPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix3x2fvEXT(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 6 << 2);
        }
        EXTSeparateShaderObjects.nglProgramUniformMatrix3x2fvEXT(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix3x2fvEXT(int program, int location, boolean transpose, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniformMatrix3x2fvEXT(program, location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix2x4fvEXT(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ProgramUniformMatrix2x4fvEXT;
        JNI.callIIIZPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix2x4fvEXT(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 3 << 2);
        }
        EXTSeparateShaderObjects.nglProgramUniformMatrix2x4fvEXT(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix2x4fvEXT(int program, int location, boolean transpose, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniformMatrix2x4fvEXT(program, location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix4x2fvEXT(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ProgramUniformMatrix4x2fvEXT;
        JNI.callIIIZPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix4x2fvEXT(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 3 << 2);
        }
        EXTSeparateShaderObjects.nglProgramUniformMatrix4x2fvEXT(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix4x2fvEXT(int program, int location, boolean transpose, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniformMatrix4x2fvEXT(program, location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix3x4fvEXT(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ProgramUniformMatrix3x4fvEXT;
        JNI.callIIIZPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix3x4fvEXT(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 12 << 2);
        }
        EXTSeparateShaderObjects.nglProgramUniformMatrix3x4fvEXT(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix3x4fvEXT(int program, int location, boolean transpose, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniformMatrix3x4fvEXT(program, location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix4x3fvEXT(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ProgramUniformMatrix4x3fvEXT;
        JNI.callIIIZPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix4x3fvEXT(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 12 << 2);
        }
        EXTSeparateShaderObjects.nglProgramUniformMatrix4x3fvEXT(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix4x3fvEXT(int program, int location, boolean transpose, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniformMatrix4x3fvEXT(program, location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }
}

