/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.opengles.GLESChecks;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class GLES20 {
    public static final int GL_DEPTH_BUFFER_BIT = 256;
    public static final int GL_STENCIL_BUFFER_BIT = 1024;
    public static final int GL_COLOR_BUFFER_BIT = 16384;
    public static final int GL_FALSE = 0;
    public static final int GL_TRUE = 1;
    public static final int GL_POINTS = 0;
    public static final int GL_LINES = 1;
    public static final int GL_LINE_LOOP = 2;
    public static final int GL_LINE_STRIP = 3;
    public static final int GL_TRIANGLES = 4;
    public static final int GL_TRIANGLE_STRIP = 5;
    public static final int GL_TRIANGLE_FAN = 6;
    public static final int GL_ZERO = 0;
    public static final int GL_ONE = 1;
    public static final int GL_SRC_COLOR = 768;
    public static final int GL_ONE_MINUS_SRC_COLOR = 769;
    public static final int GL_SRC_ALPHA = 770;
    public static final int GL_ONE_MINUS_SRC_ALPHA = 771;
    public static final int GL_DST_ALPHA = 772;
    public static final int GL_ONE_MINUS_DST_ALPHA = 773;
    public static final int GL_DST_COLOR = 774;
    public static final int GL_ONE_MINUS_DST_COLOR = 775;
    public static final int GL_SRC_ALPHA_SATURATE = 776;
    public static final int GL_FUNC_ADD = 32774;
    public static final int GL_BLEND_EQUATION = 32777;
    public static final int GL_BLEND_EQUATION_RGB = 32777;
    public static final int GL_BLEND_EQUATION_ALPHA = 34877;
    public static final int GL_FUNC_SUBTRACT = 32778;
    public static final int GL_FUNC_REVERSE_SUBTRACT = 32779;
    public static final int GL_BLEND_DST_RGB = 32968;
    public static final int GL_BLEND_SRC_RGB = 32969;
    public static final int GL_BLEND_DST_ALPHA = 32970;
    public static final int GL_BLEND_SRC_ALPHA = 32971;
    public static final int GL_CONSTANT_COLOR = 32769;
    public static final int GL_ONE_MINUS_CONSTANT_COLOR = 32770;
    public static final int GL_CONSTANT_ALPHA = 32771;
    public static final int GL_ONE_MINUS_CONSTANT_ALPHA = 32772;
    public static final int GL_BLEND_COLOR = 32773;
    public static final int GL_ARRAY_BUFFER = 34962;
    public static final int GL_ELEMENT_ARRAY_BUFFER = 34963;
    public static final int GL_ARRAY_BUFFER_BINDING = 34964;
    public static final int GL_ELEMENT_ARRAY_BUFFER_BINDING = 34965;
    public static final int GL_STREAM_DRAW = 35040;
    public static final int GL_STATIC_DRAW = 35044;
    public static final int GL_DYNAMIC_DRAW = 35048;
    public static final int GL_BUFFER_SIZE = 34660;
    public static final int GL_BUFFER_USAGE = 34661;
    public static final int GL_CURRENT_VERTEX_ATTRIB = 34342;
    public static final int GL_FRONT = 1028;
    public static final int GL_BACK = 1029;
    public static final int GL_FRONT_AND_BACK = 1032;
    public static final int GL_TEXTURE_2D = 3553;
    public static final int GL_CULL_FACE = 2884;
    public static final int GL_BLEND = 3042;
    public static final int GL_DITHER = 3024;
    public static final int GL_STENCIL_TEST = 2960;
    public static final int GL_DEPTH_TEST = 2929;
    public static final int GL_SCISSOR_TEST = 3089;
    public static final int GL_POLYGON_OFFSET_FILL = 32823;
    public static final int GL_SAMPLE_ALPHA_TO_COVERAGE = 32926;
    public static final int GL_SAMPLE_COVERAGE = 32928;
    public static final int GL_NO_ERROR = 0;
    public static final int GL_INVALID_ENUM = 1280;
    public static final int GL_INVALID_VALUE = 1281;
    public static final int GL_INVALID_OPERATION = 1282;
    public static final int GL_OUT_OF_MEMORY = 1285;
    public static final int GL_CW = 2304;
    public static final int GL_CCW = 2305;
    public static final int GL_LINE_WIDTH = 2849;
    public static final int GL_ALIASED_POINT_SIZE_RANGE = 33901;
    public static final int GL_ALIASED_LINE_WIDTH_RANGE = 33902;
    public static final int GL_CULL_FACE_MODE = 2885;
    public static final int GL_FRONT_FACE = 2886;
    public static final int GL_DEPTH_RANGE = 2928;
    public static final int GL_DEPTH_WRITEMASK = 2930;
    public static final int GL_DEPTH_CLEAR_VALUE = 2931;
    public static final int GL_DEPTH_FUNC = 2932;
    public static final int GL_STENCIL_CLEAR_VALUE = 2961;
    public static final int GL_STENCIL_FUNC = 2962;
    public static final int GL_STENCIL_FAIL = 2964;
    public static final int GL_STENCIL_PASS_DEPTH_FAIL = 2965;
    public static final int GL_STENCIL_PASS_DEPTH_PASS = 2966;
    public static final int GL_STENCIL_REF = 2967;
    public static final int GL_STENCIL_VALUE_MASK = 2963;
    public static final int GL_STENCIL_WRITEMASK = 2968;
    public static final int GL_STENCIL_BACK_FUNC = 34816;
    public static final int GL_STENCIL_BACK_FAIL = 34817;
    public static final int GL_STENCIL_BACK_PASS_DEPTH_FAIL = 34818;
    public static final int GL_STENCIL_BACK_PASS_DEPTH_PASS = 34819;
    public static final int GL_STENCIL_BACK_REF = 36003;
    public static final int GL_STENCIL_BACK_VALUE_MASK = 36004;
    public static final int GL_STENCIL_BACK_WRITEMASK = 36005;
    public static final int GL_VIEWPORT = 2978;
    public static final int GL_SCISSOR_BOX = 3088;
    public static final int GL_COLOR_CLEAR_VALUE = 3106;
    public static final int GL_COLOR_WRITEMASK = 3107;
    public static final int GL_UNPACK_ALIGNMENT = 3317;
    public static final int GL_PACK_ALIGNMENT = 3333;
    public static final int GL_MAX_TEXTURE_SIZE = 3379;
    public static final int GL_MAX_VIEWPORT_DIMS = 3386;
    public static final int GL_SUBPIXEL_BITS = 3408;
    public static final int GL_RED_BITS = 3410;
    public static final int GL_GREEN_BITS = 3411;
    public static final int GL_BLUE_BITS = 3412;
    public static final int GL_ALPHA_BITS = 3413;
    public static final int GL_DEPTH_BITS = 3414;
    public static final int GL_STENCIL_BITS = 3415;
    public static final int GL_POLYGON_OFFSET_UNITS = 10752;
    public static final int GL_POLYGON_OFFSET_FACTOR = 32824;
    public static final int GL_TEXTURE_BINDING_2D = 32873;
    public static final int GL_SAMPLE_BUFFERS = 32936;
    public static final int GL_SAMPLES = 32937;
    public static final int GL_SAMPLE_COVERAGE_VALUE = 32938;
    public static final int GL_SAMPLE_COVERAGE_INVERT = 32939;
    public static final int GL_NUM_COMPRESSED_TEXTURE_FORMATS = 34466;
    public static final int GL_COMPRESSED_TEXTURE_FORMATS = 34467;
    public static final int GL_DONT_CARE = 4352;
    public static final int GL_FASTEST = 4353;
    public static final int GL_NICEST = 4354;
    public static final int GL_GENERATE_MIPMAP_HINT = 33170;
    public static final int GL_BYTE = 5120;
    public static final int GL_UNSIGNED_BYTE = 5121;
    public static final int GL_SHORT = 5122;
    public static final int GL_UNSIGNED_SHORT = 5123;
    public static final int GL_INT = 5124;
    public static final int GL_UNSIGNED_INT = 5125;
    public static final int GL_FLOAT = 5126;
    public static final int GL_FIXED = 5132;
    public static final int GL_DEPTH_COMPONENT = 6402;
    public static final int GL_ALPHA = 6406;
    public static final int GL_RGB = 6407;
    public static final int GL_RGBA = 6408;
    public static final int GL_LUMINANCE = 6409;
    public static final int GL_LUMINANCE_ALPHA = 6410;
    public static final int GL_UNSIGNED_SHORT_4_4_4_4 = 32819;
    public static final int GL_UNSIGNED_SHORT_5_5_5_1 = 32820;
    public static final int GL_UNSIGNED_SHORT_5_6_5 = 33635;
    public static final int GL_FRAGMENT_SHADER = 35632;
    public static final int GL_VERTEX_SHADER = 35633;
    public static final int GL_MAX_VERTEX_ATTRIBS = 34921;
    public static final int GL_MAX_VERTEX_UNIFORM_VECTORS = 36347;
    public static final int GL_MAX_VARYING_VECTORS = 36348;
    public static final int GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS = 35661;
    public static final int GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS = 35660;
    public static final int GL_MAX_TEXTURE_IMAGE_UNITS = 34930;
    public static final int GL_MAX_FRAGMENT_UNIFORM_VECTORS = 36349;
    public static final int GL_SHADER_TYPE = 35663;
    public static final int GL_DELETE_STATUS = 35712;
    public static final int GL_LINK_STATUS = 35714;
    public static final int GL_VALIDATE_STATUS = 35715;
    public static final int GL_ATTACHED_SHADERS = 35717;
    public static final int GL_ACTIVE_UNIFORMS = 35718;
    public static final int GL_ACTIVE_UNIFORM_MAX_LENGTH = 35719;
    public static final int GL_ACTIVE_ATTRIBUTES = 35721;
    public static final int GL_ACTIVE_ATTRIBUTE_MAX_LENGTH = 35722;
    public static final int GL_SHADING_LANGUAGE_VERSION = 35724;
    public static final int GL_CURRENT_PROGRAM = 35725;
    public static final int GL_NEVER = 512;
    public static final int GL_LESS = 513;
    public static final int GL_EQUAL = 514;
    public static final int GL_LEQUAL = 515;
    public static final int GL_GREATER = 516;
    public static final int GL_NOTEQUAL = 517;
    public static final int GL_GEQUAL = 518;
    public static final int GL_ALWAYS = 519;
    public static final int GL_KEEP = 7680;
    public static final int GL_REPLACE = 7681;
    public static final int GL_INCR = 7682;
    public static final int GL_DECR = 7683;
    public static final int GL_INVERT = 5386;
    public static final int GL_INCR_WRAP = 34055;
    public static final int GL_DECR_WRAP = 34056;
    public static final int GL_VENDOR = 7936;
    public static final int GL_RENDERER = 7937;
    public static final int GL_VERSION = 7938;
    public static final int GL_EXTENSIONS = 7939;
    public static final int GL_NEAREST = 9728;
    public static final int GL_LINEAR = 9729;
    public static final int GL_NEAREST_MIPMAP_NEAREST = 9984;
    public static final int GL_LINEAR_MIPMAP_NEAREST = 9985;
    public static final int GL_NEAREST_MIPMAP_LINEAR = 9986;
    public static final int GL_LINEAR_MIPMAP_LINEAR = 9987;
    public static final int GL_TEXTURE_MAG_FILTER = 10240;
    public static final int GL_TEXTURE_MIN_FILTER = 10241;
    public static final int GL_TEXTURE_WRAP_S = 10242;
    public static final int GL_TEXTURE_WRAP_T = 10243;
    public static final int GL_TEXTURE = 5890;
    public static final int GL_TEXTURE_CUBE_MAP = 34067;
    public static final int GL_TEXTURE_BINDING_CUBE_MAP = 34068;
    public static final int GL_TEXTURE_CUBE_MAP_POSITIVE_X = 34069;
    public static final int GL_TEXTURE_CUBE_MAP_NEGATIVE_X = 34070;
    public static final int GL_TEXTURE_CUBE_MAP_POSITIVE_Y = 34071;
    public static final int GL_TEXTURE_CUBE_MAP_NEGATIVE_Y = 34072;
    public static final int GL_TEXTURE_CUBE_MAP_POSITIVE_Z = 34073;
    public static final int GL_TEXTURE_CUBE_MAP_NEGATIVE_Z = 34074;
    public static final int GL_MAX_CUBE_MAP_TEXTURE_SIZE = 34076;
    public static final int GL_TEXTURE0 = 33984;
    public static final int GL_TEXTURE1 = 33985;
    public static final int GL_TEXTURE2 = 33986;
    public static final int GL_TEXTURE3 = 33987;
    public static final int GL_TEXTURE4 = 33988;
    public static final int GL_TEXTURE5 = 33989;
    public static final int GL_TEXTURE6 = 33990;
    public static final int GL_TEXTURE7 = 33991;
    public static final int GL_TEXTURE8 = 33992;
    public static final int GL_TEXTURE9 = 33993;
    public static final int GL_TEXTURE10 = 33994;
    public static final int GL_TEXTURE11 = 33995;
    public static final int GL_TEXTURE12 = 33996;
    public static final int GL_TEXTURE13 = 33997;
    public static final int GL_TEXTURE14 = 33998;
    public static final int GL_TEXTURE15 = 33999;
    public static final int GL_TEXTURE16 = 34000;
    public static final int GL_TEXTURE17 = 34001;
    public static final int GL_TEXTURE18 = 34002;
    public static final int GL_TEXTURE19 = 34003;
    public static final int GL_TEXTURE20 = 34004;
    public static final int GL_TEXTURE21 = 34005;
    public static final int GL_TEXTURE22 = 34006;
    public static final int GL_TEXTURE23 = 34007;
    public static final int GL_TEXTURE24 = 34008;
    public static final int GL_TEXTURE25 = 34009;
    public static final int GL_TEXTURE26 = 34010;
    public static final int GL_TEXTURE27 = 34011;
    public static final int GL_TEXTURE28 = 34012;
    public static final int GL_TEXTURE29 = 34013;
    public static final int GL_TEXTURE30 = 34014;
    public static final int GL_TEXTURE31 = 34015;
    public static final int GL_ACTIVE_TEXTURE = 34016;
    public static final int GL_REPEAT = 10497;
    public static final int GL_CLAMP_TO_EDGE = 33071;
    public static final int GL_MIRRORED_REPEAT = 33648;
    public static final int GL_FLOAT_VEC2 = 35664;
    public static final int GL_FLOAT_VEC3 = 35665;
    public static final int GL_FLOAT_VEC4 = 35666;
    public static final int GL_INT_VEC2 = 35667;
    public static final int GL_INT_VEC3 = 35668;
    public static final int GL_INT_VEC4 = 35669;
    public static final int GL_BOOL = 35670;
    public static final int GL_BOOL_VEC2 = 35671;
    public static final int GL_BOOL_VEC3 = 35672;
    public static final int GL_BOOL_VEC4 = 35673;
    public static final int GL_FLOAT_MAT2 = 35674;
    public static final int GL_FLOAT_MAT3 = 35675;
    public static final int GL_FLOAT_MAT4 = 35676;
    public static final int GL_SAMPLER_2D = 35678;
    public static final int GL_SAMPLER_CUBE = 35680;
    public static final int GL_VERTEX_ATTRIB_ARRAY_ENABLED = 34338;
    public static final int GL_VERTEX_ATTRIB_ARRAY_SIZE = 34339;
    public static final int GL_VERTEX_ATTRIB_ARRAY_STRIDE = 34340;
    public static final int GL_VERTEX_ATTRIB_ARRAY_TYPE = 34341;
    public static final int GL_VERTEX_ATTRIB_ARRAY_NORMALIZED = 34922;
    public static final int GL_VERTEX_ATTRIB_ARRAY_POINTER = 34373;
    public static final int GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING = 34975;
    public static final int GL_IMPLEMENTATION_COLOR_READ_TYPE = 35738;
    public static final int GL_IMPLEMENTATION_COLOR_READ_FORMAT = 35739;
    public static final int GL_COMPILE_STATUS = 35713;
    public static final int GL_INFO_LOG_LENGTH = 35716;
    public static final int GL_SHADER_SOURCE_LENGTH = 35720;
    public static final int GL_SHADER_COMPILER = 36346;
    public static final int GL_SHADER_BINARY_FORMATS = 36344;
    public static final int GL_NUM_SHADER_BINARY_FORMATS = 36345;
    public static final int GL_LOW_FLOAT = 36336;
    public static final int GL_MEDIUM_FLOAT = 36337;
    public static final int GL_HIGH_FLOAT = 36338;
    public static final int GL_LOW_INT = 36339;
    public static final int GL_MEDIUM_INT = 36340;
    public static final int GL_HIGH_INT = 36341;
    public static final int GL_FRAMEBUFFER = 36160;
    public static final int GL_RENDERBUFFER = 36161;
    public static final int GL_RGBA4 = 32854;
    public static final int GL_RGB5_A1 = 32855;
    public static final int GL_RGB565 = 36194;
    public static final int GL_DEPTH_COMPONENT16 = 33189;
    public static final int GL_STENCIL_INDEX8 = 36168;
    public static final int GL_RENDERBUFFER_WIDTH = 36162;
    public static final int GL_RENDERBUFFER_HEIGHT = 36163;
    public static final int GL_RENDERBUFFER_INTERNAL_FORMAT = 36164;
    public static final int GL_RENDERBUFFER_RED_SIZE = 36176;
    public static final int GL_RENDERBUFFER_GREEN_SIZE = 36177;
    public static final int GL_RENDERBUFFER_BLUE_SIZE = 36178;
    public static final int GL_RENDERBUFFER_ALPHA_SIZE = 36179;
    public static final int GL_RENDERBUFFER_DEPTH_SIZE = 36180;
    public static final int GL_RENDERBUFFER_STENCIL_SIZE = 36181;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE = 36048;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME = 36049;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL = 36050;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE = 36051;
    public static final int GL_COLOR_ATTACHMENT0 = 36064;
    public static final int GL_DEPTH_ATTACHMENT = 36096;
    public static final int GL_STENCIL_ATTACHMENT = 36128;
    public static final int GL_NONE = 0;
    public static final int GL_FRAMEBUFFER_COMPLETE = 36053;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 36054;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 36055;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS = 36057;
    public static final int GL_FRAMEBUFFER_UNSUPPORTED = 36061;
    public static final int GL_FRAMEBUFFER_BINDING = 36006;
    public static final int GL_RENDERBUFFER_BINDING = 36007;
    public static final int GL_MAX_RENDERBUFFER_SIZE = 34024;
    public static final int GL_INVALID_FRAMEBUFFER_OPERATION = 1286;
    public final long ActiveTexture;
    public final long AttachShader;
    public final long BindAttribLocation;
    public final long BindBuffer;
    public final long BindFramebuffer;
    public final long BindRenderbuffer;
    public final long BindTexture;
    public final long BlendColor;
    public final long BlendEquation;
    public final long BlendEquationSeparate;
    public final long BlendFunc;
    public final long BlendFuncSeparate;
    public final long BufferData;
    public final long BufferSubData;
    public final long CheckFramebufferStatus;
    public final long Clear;
    public final long ClearColor;
    public final long ClearDepthf;
    public final long ClearStencil;
    public final long ColorMask;
    public final long CompileShader;
    public final long CompressedTexImage2D;
    public final long CompressedTexSubImage2D;
    public final long CopyTexImage2D;
    public final long CopyTexSubImage2D;
    public final long CreateProgram;
    public final long CreateShader;
    public final long CullFace;
    public final long DeleteBuffers;
    public final long DeleteFramebuffers;
    public final long DeleteProgram;
    public final long DeleteRenderbuffers;
    public final long DeleteShader;
    public final long DeleteTextures;
    public final long DepthFunc;
    public final long DepthMask;
    public final long DepthRangef;
    public final long DetachShader;
    public final long Disable;
    public final long DisableVertexAttribArray;
    public final long DrawArrays;
    public final long DrawElements;
    public final long Enable;
    public final long EnableVertexAttribArray;
    public final long Finish;
    public final long Flush;
    public final long FramebufferRenderbuffer;
    public final long FramebufferTexture2D;
    public final long FrontFace;
    public final long GenBuffers;
    public final long GenerateMipmap;
    public final long GenFramebuffers;
    public final long GenRenderbuffers;
    public final long GenTextures;
    public final long GetActiveAttrib;
    public final long GetActiveUniform;
    public final long GetAttachedShaders;
    public final long GetAttribLocation;
    public final long GetBooleanv;
    public final long GetBufferParameteriv;
    public final long GetError;
    public final long GetFloatv;
    public final long GetFramebufferAttachmentParameteriv;
    public final long GetIntegerv;
    public final long GetProgramiv;
    public final long GetProgramInfoLog;
    public final long GetRenderbufferParameteriv;
    public final long GetShaderiv;
    public final long GetShaderInfoLog;
    public final long GetShaderPrecisionFormat;
    public final long GetShaderSource;
    public final long GetString;
    public final long GetTexParameterfv;
    public final long GetTexParameteriv;
    public final long GetUniformfv;
    public final long GetUniformiv;
    public final long GetUniformLocation;
    public final long GetVertexAttribfv;
    public final long GetVertexAttribiv;
    public final long GetVertexAttribPointerv;
    public final long Hint;
    public final long IsBuffer;
    public final long IsEnabled;
    public final long IsFramebuffer;
    public final long IsProgram;
    public final long IsRenderbuffer;
    public final long IsShader;
    public final long IsTexture;
    public final long LineWidth;
    public final long LinkProgram;
    public final long PixelStorei;
    public final long PolygonOffset;
    public final long ReadPixels;
    public final long ReleaseShaderCompiler;
    public final long RenderbufferStorage;
    public final long SampleCoverage;
    public final long Scissor;
    public final long ShaderBinary;
    public final long ShaderSource;
    public final long StencilFunc;
    public final long StencilFuncSeparate;
    public final long StencilMask;
    public final long StencilMaskSeparate;
    public final long StencilOp;
    public final long StencilOpSeparate;
    public final long TexImage2D;
    public final long TexParameterf;
    public final long TexParameterfv;
    public final long TexParameteri;
    public final long TexParameteriv;
    public final long TexSubImage2D;
    public final long Uniform1f;
    public final long Uniform1fv;
    public final long Uniform1i;
    public final long Uniform1iv;
    public final long Uniform2f;
    public final long Uniform2fv;
    public final long Uniform2i;
    public final long Uniform2iv;
    public final long Uniform3f;
    public final long Uniform3fv;
    public final long Uniform3i;
    public final long Uniform3iv;
    public final long Uniform4f;
    public final long Uniform4fv;
    public final long Uniform4i;
    public final long Uniform4iv;
    public final long UniformMatrix2fv;
    public final long UniformMatrix3fv;
    public final long UniformMatrix4fv;
    public final long UseProgram;
    public final long ValidateProgram;
    public final long VertexAttrib1f;
    public final long VertexAttrib1fv;
    public final long VertexAttrib2f;
    public final long VertexAttrib2fv;
    public final long VertexAttrib3f;
    public final long VertexAttrib3fv;
    public final long VertexAttrib4f;
    public final long VertexAttrib4fv;
    public final long VertexAttribPointer;
    public final long Viewport;

    protected GLES20() {
        throw new UnsupportedOperationException();
    }

    public GLES20(FunctionProvider provider) {
        this.ActiveTexture = provider.getFunctionAddress("glActiveTexture");
        this.AttachShader = provider.getFunctionAddress("glAttachShader");
        this.BindAttribLocation = provider.getFunctionAddress("glBindAttribLocation");
        this.BindBuffer = provider.getFunctionAddress("glBindBuffer");
        this.BindFramebuffer = provider.getFunctionAddress("glBindFramebuffer");
        this.BindRenderbuffer = provider.getFunctionAddress("glBindRenderbuffer");
        this.BindTexture = provider.getFunctionAddress("glBindTexture");
        this.BlendColor = provider.getFunctionAddress("glBlendColor");
        this.BlendEquation = provider.getFunctionAddress("glBlendEquation");
        this.BlendEquationSeparate = provider.getFunctionAddress("glBlendEquationSeparate");
        this.BlendFunc = provider.getFunctionAddress("glBlendFunc");
        this.BlendFuncSeparate = provider.getFunctionAddress("glBlendFuncSeparate");
        this.BufferData = provider.getFunctionAddress("glBufferData");
        this.BufferSubData = provider.getFunctionAddress("glBufferSubData");
        this.CheckFramebufferStatus = provider.getFunctionAddress("glCheckFramebufferStatus");
        this.Clear = provider.getFunctionAddress("glClear");
        this.ClearColor = provider.getFunctionAddress("glClearColor");
        this.ClearDepthf = provider.getFunctionAddress("glClearDepthf");
        this.ClearStencil = provider.getFunctionAddress("glClearStencil");
        this.ColorMask = provider.getFunctionAddress("glColorMask");
        this.CompileShader = provider.getFunctionAddress("glCompileShader");
        this.CompressedTexImage2D = provider.getFunctionAddress("glCompressedTexImage2D");
        this.CompressedTexSubImage2D = provider.getFunctionAddress("glCompressedTexSubImage2D");
        this.CopyTexImage2D = provider.getFunctionAddress("glCopyTexImage2D");
        this.CopyTexSubImage2D = provider.getFunctionAddress("glCopyTexSubImage2D");
        this.CreateProgram = provider.getFunctionAddress("glCreateProgram");
        this.CreateShader = provider.getFunctionAddress("glCreateShader");
        this.CullFace = provider.getFunctionAddress("glCullFace");
        this.DeleteBuffers = provider.getFunctionAddress("glDeleteBuffers");
        this.DeleteFramebuffers = provider.getFunctionAddress("glDeleteFramebuffers");
        this.DeleteProgram = provider.getFunctionAddress("glDeleteProgram");
        this.DeleteRenderbuffers = provider.getFunctionAddress("glDeleteRenderbuffers");
        this.DeleteShader = provider.getFunctionAddress("glDeleteShader");
        this.DeleteTextures = provider.getFunctionAddress("glDeleteTextures");
        this.DepthFunc = provider.getFunctionAddress("glDepthFunc");
        this.DepthMask = provider.getFunctionAddress("glDepthMask");
        this.DepthRangef = provider.getFunctionAddress("glDepthRangef");
        this.DetachShader = provider.getFunctionAddress("glDetachShader");
        this.Disable = provider.getFunctionAddress("glDisable");
        this.DisableVertexAttribArray = provider.getFunctionAddress("glDisableVertexAttribArray");
        this.DrawArrays = provider.getFunctionAddress("glDrawArrays");
        this.DrawElements = provider.getFunctionAddress("glDrawElements");
        this.Enable = provider.getFunctionAddress("glEnable");
        this.EnableVertexAttribArray = provider.getFunctionAddress("glEnableVertexAttribArray");
        this.Finish = provider.getFunctionAddress("glFinish");
        this.Flush = provider.getFunctionAddress("glFlush");
        this.FramebufferRenderbuffer = provider.getFunctionAddress("glFramebufferRenderbuffer");
        this.FramebufferTexture2D = provider.getFunctionAddress("glFramebufferTexture2D");
        this.FrontFace = provider.getFunctionAddress("glFrontFace");
        this.GenBuffers = provider.getFunctionAddress("glGenBuffers");
        this.GenerateMipmap = provider.getFunctionAddress("glGenerateMipmap");
        this.GenFramebuffers = provider.getFunctionAddress("glGenFramebuffers");
        this.GenRenderbuffers = provider.getFunctionAddress("glGenRenderbuffers");
        this.GenTextures = provider.getFunctionAddress("glGenTextures");
        this.GetActiveAttrib = provider.getFunctionAddress("glGetActiveAttrib");
        this.GetActiveUniform = provider.getFunctionAddress("glGetActiveUniform");
        this.GetAttachedShaders = provider.getFunctionAddress("glGetAttachedShaders");
        this.GetAttribLocation = provider.getFunctionAddress("glGetAttribLocation");
        this.GetBooleanv = provider.getFunctionAddress("glGetBooleanv");
        this.GetBufferParameteriv = provider.getFunctionAddress("glGetBufferParameteriv");
        this.GetError = provider.getFunctionAddress("glGetError");
        this.GetFloatv = provider.getFunctionAddress("glGetFloatv");
        this.GetFramebufferAttachmentParameteriv = provider.getFunctionAddress("glGetFramebufferAttachmentParameteriv");
        this.GetIntegerv = provider.getFunctionAddress("glGetIntegerv");
        this.GetProgramiv = provider.getFunctionAddress("glGetProgramiv");
        this.GetProgramInfoLog = provider.getFunctionAddress("glGetProgramInfoLog");
        this.GetRenderbufferParameteriv = provider.getFunctionAddress("glGetRenderbufferParameteriv");
        this.GetShaderiv = provider.getFunctionAddress("glGetShaderiv");
        this.GetShaderInfoLog = provider.getFunctionAddress("glGetShaderInfoLog");
        this.GetShaderPrecisionFormat = provider.getFunctionAddress("glGetShaderPrecisionFormat");
        this.GetShaderSource = provider.getFunctionAddress("glGetShaderSource");
        this.GetString = provider.getFunctionAddress("glGetString");
        this.GetTexParameterfv = provider.getFunctionAddress("glGetTexParameterfv");
        this.GetTexParameteriv = provider.getFunctionAddress("glGetTexParameteriv");
        this.GetUniformfv = provider.getFunctionAddress("glGetUniformfv");
        this.GetUniformiv = provider.getFunctionAddress("glGetUniformiv");
        this.GetUniformLocation = provider.getFunctionAddress("glGetUniformLocation");
        this.GetVertexAttribfv = provider.getFunctionAddress("glGetVertexAttribfv");
        this.GetVertexAttribiv = provider.getFunctionAddress("glGetVertexAttribiv");
        this.GetVertexAttribPointerv = provider.getFunctionAddress("glGetVertexAttribPointerv");
        this.Hint = provider.getFunctionAddress("glHint");
        this.IsBuffer = provider.getFunctionAddress("glIsBuffer");
        this.IsEnabled = provider.getFunctionAddress("glIsEnabled");
        this.IsFramebuffer = provider.getFunctionAddress("glIsFramebuffer");
        this.IsProgram = provider.getFunctionAddress("glIsProgram");
        this.IsRenderbuffer = provider.getFunctionAddress("glIsRenderbuffer");
        this.IsShader = provider.getFunctionAddress("glIsShader");
        this.IsTexture = provider.getFunctionAddress("glIsTexture");
        this.LineWidth = provider.getFunctionAddress("glLineWidth");
        this.LinkProgram = provider.getFunctionAddress("glLinkProgram");
        this.PixelStorei = provider.getFunctionAddress("glPixelStorei");
        this.PolygonOffset = provider.getFunctionAddress("glPolygonOffset");
        this.ReadPixels = provider.getFunctionAddress("glReadPixels");
        this.ReleaseShaderCompiler = provider.getFunctionAddress("glReleaseShaderCompiler");
        this.RenderbufferStorage = provider.getFunctionAddress("glRenderbufferStorage");
        this.SampleCoverage = provider.getFunctionAddress("glSampleCoverage");
        this.Scissor = provider.getFunctionAddress("glScissor");
        this.ShaderBinary = provider.getFunctionAddress("glShaderBinary");
        this.ShaderSource = provider.getFunctionAddress("glShaderSource");
        this.StencilFunc = provider.getFunctionAddress("glStencilFunc");
        this.StencilFuncSeparate = provider.getFunctionAddress("glStencilFuncSeparate");
        this.StencilMask = provider.getFunctionAddress("glStencilMask");
        this.StencilMaskSeparate = provider.getFunctionAddress("glStencilMaskSeparate");
        this.StencilOp = provider.getFunctionAddress("glStencilOp");
        this.StencilOpSeparate = provider.getFunctionAddress("glStencilOpSeparate");
        this.TexImage2D = provider.getFunctionAddress("glTexImage2D");
        this.TexParameterf = provider.getFunctionAddress("glTexParameterf");
        this.TexParameterfv = provider.getFunctionAddress("glTexParameterfv");
        this.TexParameteri = provider.getFunctionAddress("glTexParameteri");
        this.TexParameteriv = provider.getFunctionAddress("glTexParameteriv");
        this.TexSubImage2D = provider.getFunctionAddress("glTexSubImage2D");
        this.Uniform1f = provider.getFunctionAddress("glUniform1f");
        this.Uniform1fv = provider.getFunctionAddress("glUniform1fv");
        this.Uniform1i = provider.getFunctionAddress("glUniform1i");
        this.Uniform1iv = provider.getFunctionAddress("glUniform1iv");
        this.Uniform2f = provider.getFunctionAddress("glUniform2f");
        this.Uniform2fv = provider.getFunctionAddress("glUniform2fv");
        this.Uniform2i = provider.getFunctionAddress("glUniform2i");
        this.Uniform2iv = provider.getFunctionAddress("glUniform2iv");
        this.Uniform3f = provider.getFunctionAddress("glUniform3f");
        this.Uniform3fv = provider.getFunctionAddress("glUniform3fv");
        this.Uniform3i = provider.getFunctionAddress("glUniform3i");
        this.Uniform3iv = provider.getFunctionAddress("glUniform3iv");
        this.Uniform4f = provider.getFunctionAddress("glUniform4f");
        this.Uniform4fv = provider.getFunctionAddress("glUniform4fv");
        this.Uniform4i = provider.getFunctionAddress("glUniform4i");
        this.Uniform4iv = provider.getFunctionAddress("glUniform4iv");
        this.UniformMatrix2fv = provider.getFunctionAddress("glUniformMatrix2fv");
        this.UniformMatrix3fv = provider.getFunctionAddress("glUniformMatrix3fv");
        this.UniformMatrix4fv = provider.getFunctionAddress("glUniformMatrix4fv");
        this.UseProgram = provider.getFunctionAddress("glUseProgram");
        this.ValidateProgram = provider.getFunctionAddress("glValidateProgram");
        this.VertexAttrib1f = provider.getFunctionAddress("glVertexAttrib1f");
        this.VertexAttrib1fv = provider.getFunctionAddress("glVertexAttrib1fv");
        this.VertexAttrib2f = provider.getFunctionAddress("glVertexAttrib2f");
        this.VertexAttrib2fv = provider.getFunctionAddress("glVertexAttrib2fv");
        this.VertexAttrib3f = provider.getFunctionAddress("glVertexAttrib3f");
        this.VertexAttrib3fv = provider.getFunctionAddress("glVertexAttrib3fv");
        this.VertexAttrib4f = provider.getFunctionAddress("glVertexAttrib4f");
        this.VertexAttrib4fv = provider.getFunctionAddress("glVertexAttrib4fv");
        this.VertexAttribPointer = provider.getFunctionAddress("glVertexAttribPointer");
        this.Viewport = provider.getFunctionAddress("glViewport");
    }

    public static GLES20 getInstance() {
        return GLES20.getInstance(GLES.getCapabilities());
    }

    public static GLES20 getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__GLES20);
    }

    static GLES20 create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GLES20")) {
            return null;
        }
        GLES20 funcs = new GLES20(provider);
        boolean supported = Checks.checkFunctions(funcs.ActiveTexture, funcs.AttachShader, funcs.BindAttribLocation, funcs.BindBuffer, funcs.BindFramebuffer, funcs.BindRenderbuffer, funcs.BindTexture, funcs.BlendColor, funcs.BlendEquation, funcs.BlendEquationSeparate, funcs.BlendFunc, funcs.BlendFuncSeparate, funcs.BufferData, funcs.BufferSubData, funcs.CheckFramebufferStatus, funcs.Clear, funcs.ClearColor, funcs.ClearDepthf, funcs.ClearStencil, funcs.ColorMask, funcs.CompileShader, funcs.CompressedTexImage2D, funcs.CompressedTexSubImage2D, funcs.CopyTexImage2D, funcs.CopyTexSubImage2D, funcs.CreateProgram, funcs.CreateShader, funcs.CullFace, funcs.DeleteBuffers, funcs.DeleteFramebuffers, funcs.DeleteProgram, funcs.DeleteRenderbuffers, funcs.DeleteShader, funcs.DeleteTextures, funcs.DepthFunc, funcs.DepthMask, funcs.DepthRangef, funcs.DetachShader, funcs.Disable, funcs.DisableVertexAttribArray, funcs.DrawArrays, funcs.DrawElements, funcs.Enable, funcs.EnableVertexAttribArray, funcs.Finish, funcs.Flush, funcs.FramebufferRenderbuffer, funcs.FramebufferTexture2D, funcs.FrontFace, funcs.GenBuffers, funcs.GenerateMipmap, funcs.GenFramebuffers, funcs.GenRenderbuffers, funcs.GenTextures, funcs.GetActiveAttrib, funcs.GetActiveUniform, funcs.GetAttachedShaders, funcs.GetAttribLocation, funcs.GetBooleanv, funcs.GetBufferParameteriv, funcs.GetError, funcs.GetFloatv, funcs.GetFramebufferAttachmentParameteriv, funcs.GetIntegerv, funcs.GetProgramiv, funcs.GetProgramInfoLog, funcs.GetRenderbufferParameteriv, funcs.GetShaderiv, funcs.GetShaderInfoLog, funcs.GetShaderPrecisionFormat, funcs.GetShaderSource, funcs.GetString, funcs.GetTexParameterfv, funcs.GetTexParameteriv, funcs.GetUniformfv, funcs.GetUniformiv, funcs.GetUniformLocation, funcs.GetVertexAttribfv, funcs.GetVertexAttribiv, funcs.GetVertexAttribPointerv, funcs.Hint, funcs.IsBuffer, funcs.IsEnabled, funcs.IsFramebuffer, funcs.IsProgram, funcs.IsRenderbuffer, funcs.IsShader, funcs.IsTexture, funcs.LineWidth, funcs.LinkProgram, funcs.PixelStorei, funcs.PolygonOffset, funcs.ReadPixels, funcs.ReleaseShaderCompiler, funcs.RenderbufferStorage, funcs.SampleCoverage, funcs.Scissor, funcs.ShaderBinary, funcs.ShaderSource, funcs.StencilFunc, funcs.StencilFuncSeparate, funcs.StencilMask, funcs.StencilMaskSeparate, funcs.StencilOp, funcs.StencilOpSeparate, funcs.TexImage2D, funcs.TexParameterf, funcs.TexParameterfv, funcs.TexParameteri, funcs.TexParameteriv, funcs.TexSubImage2D, funcs.Uniform1f, funcs.Uniform1fv, funcs.Uniform1i, funcs.Uniform1iv, funcs.Uniform2f, funcs.Uniform2fv, funcs.Uniform2i, funcs.Uniform2iv, funcs.Uniform3f, funcs.Uniform3fv, funcs.Uniform3i, funcs.Uniform3iv, funcs.Uniform4f, funcs.Uniform4fv, funcs.Uniform4i, funcs.Uniform4iv, funcs.UniformMatrix2fv, funcs.UniformMatrix3fv, funcs.UniformMatrix4fv, funcs.UseProgram, funcs.ValidateProgram, funcs.VertexAttrib1f, funcs.VertexAttrib1fv, funcs.VertexAttrib2f, funcs.VertexAttrib2fv, funcs.VertexAttrib3f, funcs.VertexAttrib3fv, funcs.VertexAttrib4f, funcs.VertexAttrib4fv, funcs.VertexAttribPointer, funcs.Viewport);
        return GLES.checkExtension("GLES20", funcs, supported);
    }

    public static void glActiveTexture(int texture) {
        long __functionAddress = GLES20.getInstance().ActiveTexture;
        JNI.callIV(__functionAddress, texture);
    }

    public static void glAttachShader(int program, int shader) {
        long __functionAddress = GLES20.getInstance().AttachShader;
        JNI.callIIV(__functionAddress, program, shader);
    }

    public static void nglBindAttribLocation(int program, int index, long name) {
        long __functionAddress = GLES20.getInstance().BindAttribLocation;
        JNI.callIIPV(__functionAddress, program, index, name);
    }

    public static void glBindAttribLocation(int program, int index, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        GLES20.nglBindAttribLocation(program, index, MemoryUtil.memAddress(name));
    }

    public static void glBindAttribLocation(int program, int index, CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, true);
        GLES20.nglBindAttribLocation(program, index, __buffer.address(nameEncoded));
    }

    public static void glBindBuffer(int target, int buffer) {
        long __functionAddress = GLES20.getInstance().BindBuffer;
        JNI.callIIV(__functionAddress, target, buffer);
    }

    public static void glBindFramebuffer(int target, int framebuffer) {
        long __functionAddress = GLES20.getInstance().BindFramebuffer;
        JNI.callIIV(__functionAddress, target, framebuffer);
    }

    public static void glBindRenderbuffer(int target, int renderbuffer) {
        long __functionAddress = GLES20.getInstance().BindRenderbuffer;
        JNI.callIIV(__functionAddress, target, renderbuffer);
    }

    public static void glBindTexture(int target, int texture) {
        long __functionAddress = GLES20.getInstance().BindTexture;
        JNI.callIIV(__functionAddress, target, texture);
    }

    public static void glBlendColor(float red, float green, float blue, float alpha) {
        long __functionAddress = GLES20.getInstance().BlendColor;
        JNI.callFFFFV(__functionAddress, red, green, blue, alpha);
    }

    public static void glBlendEquation(int mode) {
        long __functionAddress = GLES20.getInstance().BlendEquation;
        JNI.callIV(__functionAddress, mode);
    }

    public static void glBlendEquationSeparate(int modeRGB, int modeAlpha) {
        long __functionAddress = GLES20.getInstance().BlendEquationSeparate;
        JNI.callIIV(__functionAddress, modeRGB, modeAlpha);
    }

    public static void glBlendFunc(int sfactor, int dfactor) {
        long __functionAddress = GLES20.getInstance().BlendFunc;
        JNI.callIIV(__functionAddress, sfactor, dfactor);
    }

    public static void glBlendFuncSeparate(int sfactorRGB, int dfactorRGB, int sfactorAlpha, int dfactorAlpha) {
        long __functionAddress = GLES20.getInstance().BlendFuncSeparate;
        JNI.callIIIIV(__functionAddress, sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);
    }

    public static void nglBufferData(int target, long size, long data, int usage) {
        long __functionAddress = GLES20.getInstance().BufferData;
        JNI.callIPPIV(__functionAddress, target, size, data, usage);
    }

    public static void glBufferData(int target, long size, ByteBuffer data, int usage) {
        if (Checks.CHECKS && data != null) {
            Checks.checkBuffer((Buffer)data, size);
        }
        GLES20.nglBufferData(target, size, MemoryUtil.memAddressSafe(data), usage);
    }

    public static void glBufferData(int target, long size, int usage) {
        GLES20.nglBufferData(target, size, 0L, usage);
    }

    public static void glBufferData(int target, ByteBuffer data, int usage) {
        GLES20.nglBufferData(target, data.remaining(), MemoryUtil.memAddress(data), usage);
    }

    public static void glBufferData(int target, ShortBuffer data, int usage) {
        GLES20.nglBufferData(target, data.remaining() << 1, MemoryUtil.memAddress(data), usage);
    }

    public static void glBufferData(int target, IntBuffer data, int usage) {
        GLES20.nglBufferData(target, data.remaining() << 2, MemoryUtil.memAddress(data), usage);
    }

    public static void glBufferData(int target, FloatBuffer data, int usage) {
        GLES20.nglBufferData(target, data.remaining() << 2, MemoryUtil.memAddress(data), usage);
    }

    public static void nglBufferSubData(int target, long offset, long size, long data) {
        long __functionAddress = GLES20.getInstance().BufferSubData;
        JNI.callIPPPV(__functionAddress, target, offset, size, data);
    }

    public static void glBufferSubData(int target, long offset, long size, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, size);
        }
        GLES20.nglBufferSubData(target, offset, size, MemoryUtil.memAddress(data));
    }

    public static void glBufferSubData(int target, long offset, ByteBuffer data) {
        GLES20.nglBufferSubData(target, offset, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void glBufferSubData(int target, long offset, ShortBuffer data) {
        GLES20.nglBufferSubData(target, offset, data.remaining() << 1, MemoryUtil.memAddress(data));
    }

    public static void glBufferSubData(int target, long offset, IntBuffer data) {
        GLES20.nglBufferSubData(target, offset, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static void glBufferSubData(int target, long offset, FloatBuffer data) {
        GLES20.nglBufferSubData(target, offset, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static int glCheckFramebufferStatus(int target) {
        long __functionAddress = GLES20.getInstance().CheckFramebufferStatus;
        return JNI.callII(__functionAddress, target);
    }

    public static void glClear(int mask) {
        long __functionAddress = GLES20.getInstance().Clear;
        JNI.callIV(__functionAddress, mask);
    }

    public static void glClearColor(float red, float green, float blue, float alpha) {
        long __functionAddress = GLES20.getInstance().ClearColor;
        JNI.callFFFFV(__functionAddress, red, green, blue, alpha);
    }

    public static void glClearDepthf(float d) {
        long __functionAddress = GLES20.getInstance().ClearDepthf;
        JNI.callFV(__functionAddress, d);
    }

    public static void glClearStencil(int s) {
        long __functionAddress = GLES20.getInstance().ClearStencil;
        JNI.callIV(__functionAddress, s);
    }

    public static void glColorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        long __functionAddress = GLES20.getInstance().ColorMask;
        JNI.callZZZZV(__functionAddress, red, green, blue, alpha);
    }

    public static void glCompileShader(int shader) {
        long __functionAddress = GLES20.getInstance().CompileShader;
        JNI.callIV(__functionAddress, shader);
    }

    public static void nglCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, int imageSize, long data) {
        long __functionAddress = GLES20.getInstance().CompressedTexImage2D;
        JNI.callIIIIIIIPV(__functionAddress, target, level, internalformat, width, height, border, imageSize, data);
    }

    public static void glCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, int imageSize, ByteBuffer data) {
        if (Checks.CHECKS) {
            if (data != null) {
                Checks.checkBuffer((Buffer)data, imageSize);
            }
            GLESChecks.ensureBufferObject(35055, false);
        }
        GLES20.nglCompressedTexImage2D(target, level, internalformat, width, height, border, imageSize, MemoryUtil.memAddressSafe(data));
    }

    public static void glCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, int imageSize, long dataOffset) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, true);
        }
        GLES20.nglCompressedTexImage2D(target, level, internalformat, width, height, border, imageSize, dataOffset);
    }

    public static void glCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, ByteBuffer data) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        GLES20.nglCompressedTexImage2D(target, level, internalformat, width, height, border, data == null ? 0 : data.remaining(), MemoryUtil.memAddressSafe(data));
    }

    public static void nglCompressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, long data) {
        long __functionAddress = GLES20.getInstance().CompressedTexSubImage2D;
        JNI.callIIIIIIIIPV(__functionAddress, target, level, xoffset, yoffset, width, height, format, imageSize, data);
    }

    public static void glCompressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, imageSize);
            GLESChecks.ensureBufferObject(35055, false);
        }
        GLES20.nglCompressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format, imageSize, MemoryUtil.memAddress(data));
    }

    public static void glCompressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, long dataOffset) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, true);
        }
        GLES20.nglCompressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format, imageSize, dataOffset);
    }

    public static void glCompressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, ByteBuffer data) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        GLES20.nglCompressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void glCopyTexImage2D(int target, int level, int internalformat, int x, int y, int width, int height, int border) {
        long __functionAddress = GLES20.getInstance().CopyTexImage2D;
        JNI.callIIIIIIIIV(__functionAddress, target, level, internalformat, x, y, width, height, border);
    }

    public static void glCopyTexSubImage2D(int target, int level, int xoffset, int yoffset, int x, int y, int width, int height) {
        long __functionAddress = GLES20.getInstance().CopyTexSubImage2D;
        JNI.callIIIIIIIIV(__functionAddress, target, level, xoffset, yoffset, x, y, width, height);
    }

    public static int glCreateProgram() {
        long __functionAddress = GLES20.getInstance().CreateProgram;
        return JNI.callI(__functionAddress);
    }

    public static int glCreateShader(int type) {
        long __functionAddress = GLES20.getInstance().CreateShader;
        return JNI.callII(__functionAddress, type);
    }

    public static void glCullFace(int mode) {
        long __functionAddress = GLES20.getInstance().CullFace;
        JNI.callIV(__functionAddress, mode);
    }

    public static void nglDeleteBuffers(int n, long buffers) {
        long __functionAddress = GLES20.getInstance().DeleteBuffers;
        JNI.callIPV(__functionAddress, n, buffers);
    }

    public static void glDeleteBuffers(int n, ByteBuffer buffers) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)buffers, n << 2);
        }
        GLES20.nglDeleteBuffers(n, MemoryUtil.memAddress(buffers));
    }

    public static void glDeleteBuffers(IntBuffer buffers) {
        GLES20.nglDeleteBuffers(buffers.remaining(), MemoryUtil.memAddress(buffers));
    }

    public static void glDeleteBuffers(int buffer) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int buffers = __buffer.intParam(buffer);
        GLES20.nglDeleteBuffers(1, __buffer.address(buffers));
    }

    public static void nglDeleteFramebuffers(int n, long framebuffers) {
        long __functionAddress = GLES20.getInstance().DeleteFramebuffers;
        JNI.callIPV(__functionAddress, n, framebuffers);
    }

    public static void glDeleteFramebuffers(int n, ByteBuffer framebuffers) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)framebuffers, n << 2);
        }
        GLES20.nglDeleteFramebuffers(n, MemoryUtil.memAddress(framebuffers));
    }

    public static void glDeleteFramebuffers(IntBuffer framebuffers) {
        GLES20.nglDeleteFramebuffers(framebuffers.remaining(), MemoryUtil.memAddress(framebuffers));
    }

    public static void glDeleteFramebuffers(int framebuffer) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int framebuffers = __buffer.intParam(framebuffer);
        GLES20.nglDeleteFramebuffers(1, __buffer.address(framebuffers));
    }

    public static void glDeleteProgram(int program) {
        long __functionAddress = GLES20.getInstance().DeleteProgram;
        JNI.callIV(__functionAddress, program);
    }

    public static void nglDeleteRenderbuffers(int n, long renderbuffers) {
        long __functionAddress = GLES20.getInstance().DeleteRenderbuffers;
        JNI.callIPV(__functionAddress, n, renderbuffers);
    }

    public static void glDeleteRenderbuffers(int n, ByteBuffer renderbuffers) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)renderbuffers, n << 2);
        }
        GLES20.nglDeleteRenderbuffers(n, MemoryUtil.memAddress(renderbuffers));
    }

    public static void glDeleteRenderbuffers(IntBuffer renderbuffers) {
        GLES20.nglDeleteRenderbuffers(renderbuffers.remaining(), MemoryUtil.memAddress(renderbuffers));
    }

    public static void glDeleteRenderbuffers(int renderbuffer) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int renderbuffers = __buffer.intParam(renderbuffer);
        GLES20.nglDeleteRenderbuffers(1, __buffer.address(renderbuffers));
    }

    public static void glDeleteShader(int shader) {
        long __functionAddress = GLES20.getInstance().DeleteShader;
        JNI.callIV(__functionAddress, shader);
    }

    public static void nglDeleteTextures(int n, long textures) {
        long __functionAddress = GLES20.getInstance().DeleteTextures;
        JNI.callIPV(__functionAddress, n, textures);
    }

    public static void glDeleteTextures(int n, ByteBuffer textures) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)textures, n << 2);
        }
        GLES20.nglDeleteTextures(n, MemoryUtil.memAddress(textures));
    }

    public static void glDeleteTextures(IntBuffer textures) {
        GLES20.nglDeleteTextures(textures.remaining(), MemoryUtil.memAddress(textures));
    }

    public static void glDeleteTextures(int texture) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int textures = __buffer.intParam(texture);
        GLES20.nglDeleteTextures(1, __buffer.address(textures));
    }

    public static void glDepthFunc(int func) {
        long __functionAddress = GLES20.getInstance().DepthFunc;
        JNI.callIV(__functionAddress, func);
    }

    public static void glDepthMask(boolean flag) {
        long __functionAddress = GLES20.getInstance().DepthMask;
        JNI.callZV(__functionAddress, flag);
    }

    public static void glDepthRangef(float n, float f) {
        long __functionAddress = GLES20.getInstance().DepthRangef;
        JNI.callFFV(__functionAddress, n, f);
    }

    public static void glDetachShader(int program, int shader) {
        long __functionAddress = GLES20.getInstance().DetachShader;
        JNI.callIIV(__functionAddress, program, shader);
    }

    public static void glDisable(int cap) {
        long __functionAddress = GLES20.getInstance().Disable;
        JNI.callIV(__functionAddress, cap);
    }

    public static void glDisableVertexAttribArray(int index) {
        long __functionAddress = GLES20.getInstance().DisableVertexAttribArray;
        JNI.callIV(__functionAddress, index);
    }

    public static void glDrawArrays(int mode, int first, int count) {
        long __functionAddress = GLES20.getInstance().DrawArrays;
        JNI.callIIIV(__functionAddress, mode, first, count);
    }

    public static void nglDrawElements(int mode, int count, int type, long indices) {
        long __functionAddress = GLES20.getInstance().DrawElements;
        JNI.callIIIPV(__functionAddress, mode, count, type, indices);
    }

    public static void glDrawElements(int mode, int count, int type, ByteBuffer indices) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indices, count << GLESChecks.typeToByteShift(type));
            GLESChecks.ensureBufferObject(34965, false);
        }
        GLES20.nglDrawElements(mode, count, type, MemoryUtil.memAddress(indices));
    }

    public static void glDrawElements(int mode, int count, int type, long indicesOffset) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, true);
        }
        GLES20.nglDrawElements(mode, count, type, indicesOffset);
    }

    public static void glDrawElements(int mode, int type, ByteBuffer indices) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        GLES20.nglDrawElements(mode, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices));
    }

    public static void glDrawElements(int mode, ByteBuffer indices) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        GLES20.nglDrawElements(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices));
    }

    public static void glDrawElements(int mode, ShortBuffer indices) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        GLES20.nglDrawElements(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices));
    }

    public static void glDrawElements(int mode, IntBuffer indices) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        GLES20.nglDrawElements(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices));
    }

    public static void glEnable(int cap) {
        long __functionAddress = GLES20.getInstance().Enable;
        JNI.callIV(__functionAddress, cap);
    }

    public static void glEnableVertexAttribArray(int index) {
        long __functionAddress = GLES20.getInstance().EnableVertexAttribArray;
        JNI.callIV(__functionAddress, index);
    }

    public static void glFinish() {
        long __functionAddress = GLES20.getInstance().Finish;
        JNI.callV(__functionAddress);
    }

    public static void glFlush() {
        long __functionAddress = GLES20.getInstance().Flush;
        JNI.callV(__functionAddress);
    }

    public static void glFramebufferRenderbuffer(int target, int attachment, int renderbuffertarget, int renderbuffer) {
        long __functionAddress = GLES20.getInstance().FramebufferRenderbuffer;
        JNI.callIIIIV(__functionAddress, target, attachment, renderbuffertarget, renderbuffer);
    }

    public static void glFramebufferTexture2D(int target, int attachment, int textarget, int texture, int level) {
        long __functionAddress = GLES20.getInstance().FramebufferTexture2D;
        JNI.callIIIIIV(__functionAddress, target, attachment, textarget, texture, level);
    }

    public static void glFrontFace(int mode) {
        long __functionAddress = GLES20.getInstance().FrontFace;
        JNI.callIV(__functionAddress, mode);
    }

    public static void nglGenBuffers(int n, long buffers) {
        long __functionAddress = GLES20.getInstance().GenBuffers;
        JNI.callIPV(__functionAddress, n, buffers);
    }

    public static void glGenBuffers(int n, ByteBuffer buffers) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)buffers, n << 2);
        }
        GLES20.nglGenBuffers(n, MemoryUtil.memAddress(buffers));
    }

    public static void glGenBuffers(IntBuffer buffers) {
        GLES20.nglGenBuffers(buffers.remaining(), MemoryUtil.memAddress(buffers));
    }

    public static int glGenBuffers() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int buffers = __buffer.intParam();
        GLES20.nglGenBuffers(1, __buffer.address(buffers));
        return __buffer.intValue(buffers);
    }

    public static void glGenerateMipmap(int target) {
        long __functionAddress = GLES20.getInstance().GenerateMipmap;
        JNI.callIV(__functionAddress, target);
    }

    public static void nglGenFramebuffers(int n, long framebuffers) {
        long __functionAddress = GLES20.getInstance().GenFramebuffers;
        JNI.callIPV(__functionAddress, n, framebuffers);
    }

    public static void glGenFramebuffers(int n, ByteBuffer framebuffers) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)framebuffers, n << 2);
        }
        GLES20.nglGenFramebuffers(n, MemoryUtil.memAddress(framebuffers));
    }

    public static void glGenFramebuffers(IntBuffer framebuffers) {
        GLES20.nglGenFramebuffers(framebuffers.remaining(), MemoryUtil.memAddress(framebuffers));
    }

    public static int glGenFramebuffers() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int framebuffers = __buffer.intParam();
        GLES20.nglGenFramebuffers(1, __buffer.address(framebuffers));
        return __buffer.intValue(framebuffers);
    }

    public static void nglGenRenderbuffers(int n, long renderbuffers) {
        long __functionAddress = GLES20.getInstance().GenRenderbuffers;
        JNI.callIPV(__functionAddress, n, renderbuffers);
    }

    public static void glGenRenderbuffers(int n, ByteBuffer renderbuffers) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)renderbuffers, n << 2);
        }
        GLES20.nglGenRenderbuffers(n, MemoryUtil.memAddress(renderbuffers));
    }

    public static void glGenRenderbuffers(IntBuffer renderbuffers) {
        GLES20.nglGenRenderbuffers(renderbuffers.remaining(), MemoryUtil.memAddress(renderbuffers));
    }

    public static int glGenRenderbuffers() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int renderbuffers = __buffer.intParam();
        GLES20.nglGenRenderbuffers(1, __buffer.address(renderbuffers));
        return __buffer.intValue(renderbuffers);
    }

    public static void nglGenTextures(int n, long textures) {
        long __functionAddress = GLES20.getInstance().GenTextures;
        JNI.callIPV(__functionAddress, n, textures);
    }

    public static void glGenTextures(int n, ByteBuffer textures) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)textures, n << 2);
        }
        GLES20.nglGenTextures(n, MemoryUtil.memAddress(textures));
    }

    public static void glGenTextures(IntBuffer textures) {
        GLES20.nglGenTextures(textures.remaining(), MemoryUtil.memAddress(textures));
    }

    public static int glGenTextures() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int textures = __buffer.intParam();
        GLES20.nglGenTextures(1, __buffer.address(textures));
        return __buffer.intValue(textures);
    }

    public static void nglGetActiveAttrib(int program, int index, int bufSize, long length, long size, long type, long name) {
        long __functionAddress = GLES20.getInstance().GetActiveAttrib;
        JNI.callIIIPPPPV(__functionAddress, program, index, bufSize, length, size, type, name);
    }

    public static void glGetActiveAttrib(int program, int index, int bufSize, ByteBuffer length, ByteBuffer size, ByteBuffer type, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)name, bufSize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
            Checks.checkBuffer((Buffer)size, 4);
            Checks.checkBuffer((Buffer)type, 4);
        }
        GLES20.nglGetActiveAttrib(program, index, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
    }

    public static void glGetActiveAttrib(int program, int index, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        if (Checks.CHECKS) {
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 1);
            }
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        GLES20.nglGetActiveAttrib(program, index, name.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
    }

    public static String glGetActiveAttrib(int program, int index, int bufSize, IntBuffer size, IntBuffer type) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int name = __buffer.bufferParam(bufSize);
        GLES20.nglGetActiveAttrib(program, index, bufSize, __buffer.address(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), __buffer.address(name));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), name);
    }

    public static String glGetActiveAttrib(int program, int index, IntBuffer size, IntBuffer type) {
        int bufSize = GLES20.glGetProgrami(program, 35722);
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int name = __buffer.bufferParam(bufSize);
        GLES20.nglGetActiveAttrib(program, index, bufSize, __buffer.address(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), __buffer.address(name));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), name);
    }

    public static void nglGetActiveUniform(int program, int index, int bufSize, long length, long size, long type, long name) {
        long __functionAddress = GLES20.getInstance().GetActiveUniform;
        JNI.callIIIPPPPV(__functionAddress, program, index, bufSize, length, size, type, name);
    }

    public static void glGetActiveUniform(int program, int index, int bufSize, ByteBuffer length, ByteBuffer size, ByteBuffer type, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)name, bufSize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
            Checks.checkBuffer((Buffer)size, 4);
            Checks.checkBuffer((Buffer)type, 4);
        }
        GLES20.nglGetActiveUniform(program, index, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
    }

    public static void glGetActiveUniform(int program, int index, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        if (Checks.CHECKS) {
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 1);
            }
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        GLES20.nglGetActiveUniform(program, index, name.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
    }

    public static String glGetActiveUniform(int program, int index, int bufSize, IntBuffer size, IntBuffer type) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int name = __buffer.bufferParam(bufSize);
        GLES20.nglGetActiveUniform(program, index, bufSize, __buffer.address(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), __buffer.address(name));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), name);
    }

    public static String glGetActiveUniform(int program, int index, IntBuffer size, IntBuffer type) {
        int bufSize = GLES20.glGetProgrami(program, 35719);
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int name = __buffer.bufferParam(bufSize);
        GLES20.nglGetActiveUniform(program, index, bufSize, __buffer.address(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), __buffer.address(name));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), name);
    }

    public static void nglGetAttachedShaders(int program, int maxCount, long count, long shaders) {
        long __functionAddress = GLES20.getInstance().GetAttachedShaders;
        JNI.callIIPPV(__functionAddress, program, maxCount, count, shaders);
    }

    public static void glGetAttachedShaders(int program, int maxCount, ByteBuffer count, ByteBuffer shaders) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)shaders, maxCount << 2);
            if (count != null) {
                Checks.checkBuffer((Buffer)count, 4);
            }
        }
        GLES20.nglGetAttachedShaders(program, maxCount, MemoryUtil.memAddressSafe(count), MemoryUtil.memAddress(shaders));
    }

    public static void glGetAttachedShaders(int program, IntBuffer count, IntBuffer shaders) {
        if (Checks.CHECKS && count != null) {
            Checks.checkBuffer((Buffer)count, 1);
        }
        GLES20.nglGetAttachedShaders(program, shaders.remaining(), MemoryUtil.memAddressSafe(count), MemoryUtil.memAddress(shaders));
    }

    public static IntBuffer glGetAttachedShaders(int program, int maxCount) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int count = __buffer.intParam();
        IntBuffer shaders = BufferUtils.createIntBuffer(maxCount);
        GLES20.nglGetAttachedShaders(program, maxCount, __buffer.address(count), MemoryUtil.memAddress(shaders));
        shaders.limit(__buffer.intValue(count));
        return shaders.slice();
    }

    public static IntBuffer glGetAttachedShaders(int program) {
        int maxCount = GLES20.glGetProgrami(program, 35717);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int count = __buffer.intParam();
        IntBuffer shaders = BufferUtils.createIntBuffer(maxCount);
        GLES20.nglGetAttachedShaders(program, maxCount, __buffer.address(count), MemoryUtil.memAddress(shaders));
        shaders.limit(__buffer.intValue(count));
        return shaders.slice();
    }

    public static int nglGetAttribLocation(int program, long name) {
        long __functionAddress = GLES20.getInstance().GetAttribLocation;
        return JNI.callIPI(__functionAddress, program, name);
    }

    public static int glGetAttribLocation(int program, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return GLES20.nglGetAttribLocation(program, MemoryUtil.memAddress(name));
    }

    public static int glGetAttribLocation(int program, CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, true);
        return GLES20.nglGetAttribLocation(program, __buffer.address(nameEncoded));
    }

    public static void nglGetBooleanv(int pname, long data) {
        long __functionAddress = GLES20.getInstance().GetBooleanv;
        JNI.callIPV(__functionAddress, pname, data);
    }

    public static void glGetBooleanv(int pname, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 1);
        }
        GLES20.nglGetBooleanv(pname, MemoryUtil.memAddress(data));
    }

    public static boolean glGetBoolean(int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int data = __buffer.booleanParam();
        GLES20.nglGetBooleanv(pname, __buffer.address(data));
        return __buffer.booleanValue(data);
    }

    public static void nglGetBufferParameteriv(int target, int pname, long params) {
        long __functionAddress = GLES20.getInstance().GetBufferParameteriv;
        JNI.callIIPV(__functionAddress, target, pname, params);
    }

    public static void glGetBufferParameteriv(int target, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GLES20.nglGetBufferParameteriv(target, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetBufferParameteriv(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES20.nglGetBufferParameteriv(target, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetBufferParameteri(int target, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GLES20.nglGetBufferParameteriv(target, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static int glGetError() {
        long __functionAddress = GLES20.getInstance().GetError;
        return JNI.callI(__functionAddress);
    }

    public static void nglGetFloatv(int pname, long data) {
        long __functionAddress = GLES20.getInstance().GetFloatv;
        JNI.callIPV(__functionAddress, pname, data);
    }

    public static void glGetFloatv(int pname, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 4);
        }
        GLES20.nglGetFloatv(pname, MemoryUtil.memAddress(data));
    }

    public static void glGetFloatv(int pname, FloatBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 1);
        }
        GLES20.nglGetFloatv(pname, MemoryUtil.memAddress(data));
    }

    public static float glGetFloat(int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int data = __buffer.floatParam();
        GLES20.nglGetFloatv(pname, __buffer.address(data));
        return __buffer.floatValue(data);
    }

    public static void nglGetFramebufferAttachmentParameteriv(int target, int attachment, int pname, long params) {
        long __functionAddress = GLES20.getInstance().GetFramebufferAttachmentParameteriv;
        JNI.callIIIPV(__functionAddress, target, attachment, pname, params);
    }

    public static void glGetFramebufferAttachmentParameteriv(int target, int attachment, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GLES20.nglGetFramebufferAttachmentParameteriv(target, attachment, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetFramebufferAttachmentParameteriv(int target, int attachment, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES20.nglGetFramebufferAttachmentParameteriv(target, attachment, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetFramebufferAttachmentParameteri(int target, int attachment, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GLES20.nglGetFramebufferAttachmentParameteriv(target, attachment, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetIntegerv(int pname, long data) {
        long __functionAddress = GLES20.getInstance().GetIntegerv;
        JNI.callIPV(__functionAddress, pname, data);
    }

    public static void glGetIntegerv(int pname, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 4);
        }
        GLES20.nglGetIntegerv(pname, MemoryUtil.memAddress(data));
    }

    public static void glGetIntegerv(int pname, IntBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 1);
        }
        GLES20.nglGetIntegerv(pname, MemoryUtil.memAddress(data));
    }

    public static int glGetInteger(int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int data = __buffer.intParam();
        GLES20.nglGetIntegerv(pname, __buffer.address(data));
        return __buffer.intValue(data);
    }

    public static void nglGetProgramiv(int program, int pname, long params) {
        long __functionAddress = GLES20.getInstance().GetProgramiv;
        JNI.callIIPV(__functionAddress, program, pname, params);
    }

    public static void glGetProgramiv(int program, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GLES20.nglGetProgramiv(program, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetProgramiv(int program, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES20.nglGetProgramiv(program, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetProgrami(int program, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GLES20.nglGetProgramiv(program, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetProgramInfoLog(int program, int bufSize, long length, long infoLog) {
        long __functionAddress = GLES20.getInstance().GetProgramInfoLog;
        JNI.callIIPPV(__functionAddress, program, bufSize, length, infoLog);
    }

    public static void glGetProgramInfoLog(int program, int bufSize, ByteBuffer length, ByteBuffer infoLog) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)infoLog, bufSize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        GLES20.nglGetProgramInfoLog(program, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(infoLog));
    }

    public static void glGetProgramInfoLog(int program, IntBuffer length, ByteBuffer infoLog) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        GLES20.nglGetProgramInfoLog(program, infoLog.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(infoLog));
    }

    public static String glGetProgramInfoLog(int program, int bufSize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int infoLog = __buffer.bufferParam(bufSize);
        GLES20.nglGetProgramInfoLog(program, bufSize, __buffer.address(length), __buffer.address(infoLog));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), infoLog);
    }

    public static String glGetProgramInfoLog(int program) {
        int bufSize = GLES20.glGetProgrami(program, 35716);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int infoLog = __buffer.bufferParam(bufSize);
        GLES20.nglGetProgramInfoLog(program, bufSize, __buffer.address(length), __buffer.address(infoLog));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), infoLog);
    }

    public static void nglGetRenderbufferParameteriv(int target, int pname, long params) {
        long __functionAddress = GLES20.getInstance().GetRenderbufferParameteriv;
        JNI.callIIPV(__functionAddress, target, pname, params);
    }

    public static void glGetRenderbufferParameteriv(int target, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GLES20.nglGetRenderbufferParameteriv(target, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetRenderbufferParameteriv(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES20.nglGetRenderbufferParameteriv(target, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetRenderbufferParameteri(int target, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GLES20.nglGetRenderbufferParameteriv(target, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetShaderiv(int shader, int pname, long params) {
        long __functionAddress = GLES20.getInstance().GetShaderiv;
        JNI.callIIPV(__functionAddress, shader, pname, params);
    }

    public static void glGetShaderiv(int shader, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GLES20.nglGetShaderiv(shader, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetShaderiv(int shader, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES20.nglGetShaderiv(shader, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetShaderi(int shader, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GLES20.nglGetShaderiv(shader, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetShaderInfoLog(int shader, int bufSize, long length, long infoLog) {
        long __functionAddress = GLES20.getInstance().GetShaderInfoLog;
        JNI.callIIPPV(__functionAddress, shader, bufSize, length, infoLog);
    }

    public static void glGetShaderInfoLog(int shader, int bufSize, ByteBuffer length, ByteBuffer infoLog) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)infoLog, bufSize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        GLES20.nglGetShaderInfoLog(shader, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(infoLog));
    }

    public static void glGetShaderInfoLog(int shader, IntBuffer length, ByteBuffer infoLog) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        GLES20.nglGetShaderInfoLog(shader, infoLog.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(infoLog));
    }

    public static String glGetShaderInfoLog(int shader, int bufSize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int infoLog = __buffer.bufferParam(bufSize);
        GLES20.nglGetShaderInfoLog(shader, bufSize, __buffer.address(length), __buffer.address(infoLog));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), infoLog);
    }

    public static String glGetShaderInfoLog(int shader) {
        int bufSize = GLES20.glGetShaderi(shader, 35716);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int infoLog = __buffer.bufferParam(bufSize);
        GLES20.nglGetShaderInfoLog(shader, bufSize, __buffer.address(length), __buffer.address(infoLog));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), infoLog);
    }

    public static void nglGetShaderPrecisionFormat(int shadertype, int precisiontype, long range, long precision) {
        long __functionAddress = GLES20.getInstance().GetShaderPrecisionFormat;
        JNI.callIIPPV(__functionAddress, shadertype, precisiontype, range, precision);
    }

    public static void glGetShaderPrecisionFormat(int shadertype, int precisiontype, ByteBuffer range, ByteBuffer precision) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)range, 8);
            Checks.checkBuffer((Buffer)precision, 8);
        }
        GLES20.nglGetShaderPrecisionFormat(shadertype, precisiontype, MemoryUtil.memAddress(range), MemoryUtil.memAddress(precision));
    }

    public static void glGetShaderPrecisionFormat(int shadertype, int precisiontype, IntBuffer range, IntBuffer precision) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)range, 2);
            Checks.checkBuffer((Buffer)precision, 2);
        }
        GLES20.nglGetShaderPrecisionFormat(shadertype, precisiontype, MemoryUtil.memAddress(range), MemoryUtil.memAddress(precision));
    }

    public static void nglGetShaderSource(int shader, int bufSize, long length, long source) {
        long __functionAddress = GLES20.getInstance().GetShaderSource;
        JNI.callIIPPV(__functionAddress, shader, bufSize, length, source);
    }

    public static void glGetShaderSource(int shader, int bufSize, ByteBuffer length, ByteBuffer source) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)source, bufSize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        GLES20.nglGetShaderSource(shader, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(source));
    }

    public static void glGetShaderSource(int shader, IntBuffer length, ByteBuffer source) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        GLES20.nglGetShaderSource(shader, source.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(source));
    }

    public static String glGetShaderSource(int shader, int bufSize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int source = __buffer.bufferParam(bufSize);
        GLES20.nglGetShaderSource(shader, bufSize, __buffer.address(length), __buffer.address(source));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), source);
    }

    public static String glGetShaderSource(int shader) {
        int bufSize = GLES20.glGetShaderi(shader, 35720);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int source = __buffer.bufferParam(bufSize);
        GLES20.nglGetShaderSource(shader, bufSize, __buffer.address(length), __buffer.address(source));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), source);
    }

    public static long nglGetString(int name) {
        long __functionAddress = GLES20.getInstance().GetString;
        return JNI.callIP(__functionAddress, name);
    }

    public static String glGetString(int name) {
        long __result = GLES20.nglGetString(name);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static void nglGetTexParameterfv(int target, int pname, long params) {
        long __functionAddress = GLES20.getInstance().GetTexParameterfv;
        JNI.callIIPV(__functionAddress, target, pname, params);
    }

    public static void glGetTexParameterfv(int target, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GLES20.nglGetTexParameterfv(target, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetTexParameterfv(int target, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES20.nglGetTexParameterfv(target, pname, MemoryUtil.memAddress(params));
    }

    public static float glGetTexParameterf(int target, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.floatParam();
        GLES20.nglGetTexParameterfv(target, pname, __buffer.address(params));
        return __buffer.floatValue(params);
    }

    public static void nglGetTexParameteriv(int target, int pname, long params) {
        long __functionAddress = GLES20.getInstance().GetTexParameteriv;
        JNI.callIIPV(__functionAddress, target, pname, params);
    }

    public static void glGetTexParameteriv(int target, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GLES20.nglGetTexParameteriv(target, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetTexParameteriv(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES20.nglGetTexParameteriv(target, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetTexParameteri(int target, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GLES20.nglGetTexParameteriv(target, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetUniformfv(int program, int location, long params) {
        long __functionAddress = GLES20.getInstance().GetUniformfv;
        JNI.callIIPV(__functionAddress, program, location, params);
    }

    public static void glGetUniformfv(int program, int location, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GLES20.nglGetUniformfv(program, location, MemoryUtil.memAddress(params));
    }

    public static void glGetUniformfv(int program, int location, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES20.nglGetUniformfv(program, location, MemoryUtil.memAddress(params));
    }

    public static float glGetUniformf(int program, int location) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.floatParam();
        GLES20.nglGetUniformfv(program, location, __buffer.address(params));
        return __buffer.floatValue(params);
    }

    public static void nglGetUniformiv(int program, int location, long params) {
        long __functionAddress = GLES20.getInstance().GetUniformiv;
        JNI.callIIPV(__functionAddress, program, location, params);
    }

    public static void glGetUniformiv(int program, int location, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GLES20.nglGetUniformiv(program, location, MemoryUtil.memAddress(params));
    }

    public static void glGetUniformiv(int program, int location, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES20.nglGetUniformiv(program, location, MemoryUtil.memAddress(params));
    }

    public static int glGetUniformi(int program, int location) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GLES20.nglGetUniformiv(program, location, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static int nglGetUniformLocation(int program, long name) {
        long __functionAddress = GLES20.getInstance().GetUniformLocation;
        return JNI.callIPI(__functionAddress, program, name);
    }

    public static int glGetUniformLocation(int program, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return GLES20.nglGetUniformLocation(program, MemoryUtil.memAddress(name));
    }

    public static int glGetUniformLocation(int program, CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, true);
        return GLES20.nglGetUniformLocation(program, __buffer.address(nameEncoded));
    }

    public static void nglGetVertexAttribfv(int index, int pname, long params) {
        long __functionAddress = GLES20.getInstance().GetVertexAttribfv;
        JNI.callIIPV(__functionAddress, index, pname, params);
    }

    public static void glGetVertexAttribfv(int index, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 16);
        }
        GLES20.nglGetVertexAttribfv(index, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetVertexAttribfv(int index, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GLES20.nglGetVertexAttribfv(index, pname, MemoryUtil.memAddress(params));
    }

    public static void nglGetVertexAttribiv(int index, int pname, long params) {
        long __functionAddress = GLES20.getInstance().GetVertexAttribiv;
        JNI.callIIPV(__functionAddress, index, pname, params);
    }

    public static void glGetVertexAttribiv(int index, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 16);
        }
        GLES20.nglGetVertexAttribiv(index, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetVertexAttribiv(int index, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GLES20.nglGetVertexAttribiv(index, pname, MemoryUtil.memAddress(params));
    }

    public static void nglGetVertexAttribPointerv(int index, int pname, long pointer) {
        long __functionAddress = GLES20.getInstance().GetVertexAttribPointerv;
        JNI.callIIPV(__functionAddress, index, pname, pointer);
    }

    public static void glGetVertexAttribPointerv(int index, int pname, ByteBuffer pointer) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)pointer, 1 << Pointer.POINTER_SHIFT);
        }
        GLES20.nglGetVertexAttribPointerv(index, pname, MemoryUtil.memAddress(pointer));
    }

    public static void glGetVertexAttribPointerv(int index, int pname, PointerBuffer pointer) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(pointer, 1);
        }
        GLES20.nglGetVertexAttribPointerv(index, pname, MemoryUtil.memAddress(pointer));
    }

    public static long glGetVertexAttribPointer(int index, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int pointer = __buffer.pointerParam();
        GLES20.nglGetVertexAttribPointerv(index, pname, __buffer.address(pointer));
        return __buffer.pointerValue(pointer);
    }

    public static void glHint(int target, int mode) {
        long __functionAddress = GLES20.getInstance().Hint;
        JNI.callIIV(__functionAddress, target, mode);
    }

    public static boolean glIsBuffer(int buffer) {
        long __functionAddress = GLES20.getInstance().IsBuffer;
        return JNI.callIZ(__functionAddress, buffer);
    }

    public static boolean glIsEnabled(int cap) {
        long __functionAddress = GLES20.getInstance().IsEnabled;
        return JNI.callIZ(__functionAddress, cap);
    }

    public static boolean glIsFramebuffer(int framebuffer) {
        long __functionAddress = GLES20.getInstance().IsFramebuffer;
        return JNI.callIZ(__functionAddress, framebuffer);
    }

    public static boolean glIsProgram(int program) {
        long __functionAddress = GLES20.getInstance().IsProgram;
        return JNI.callIZ(__functionAddress, program);
    }

    public static boolean glIsRenderbuffer(int renderbuffer) {
        long __functionAddress = GLES20.getInstance().IsRenderbuffer;
        return JNI.callIZ(__functionAddress, renderbuffer);
    }

    public static boolean glIsShader(int shader) {
        long __functionAddress = GLES20.getInstance().IsShader;
        return JNI.callIZ(__functionAddress, shader);
    }

    public static boolean glIsTexture(int texture) {
        long __functionAddress = GLES20.getInstance().IsTexture;
        return JNI.callIZ(__functionAddress, texture);
    }

    public static void glLineWidth(float width) {
        long __functionAddress = GLES20.getInstance().LineWidth;
        JNI.callFV(__functionAddress, width);
    }

    public static void glLinkProgram(int program) {
        long __functionAddress = GLES20.getInstance().LinkProgram;
        JNI.callIV(__functionAddress, program);
    }

    public static void glPixelStorei(int pname, int param) {
        long __functionAddress = GLES20.getInstance().PixelStorei;
        JNI.callIIV(__functionAddress, pname, param);
    }

    public static void glPolygonOffset(float factor, float units) {
        long __functionAddress = GLES20.getInstance().PolygonOffset;
        JNI.callFFV(__functionAddress, factor, units);
    }

    public static void nglReadPixels(int x, int y, int width, int height, int format, int type, long pixels) {
        long __functionAddress = GLES20.getInstance().ReadPixels;
        JNI.callIIIIIIPV(__functionAddress, x, y, width, height, format, type, pixels);
    }

    public static void glReadPixels(int x, int y, int width, int height, int format, int type, ByteBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35053, false);
        }
        GLES20.nglReadPixels(x, y, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glReadPixels(int x, int y, int width, int height, int format, int type, long pixelsOffset) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35053, true);
        }
        GLES20.nglReadPixels(x, y, width, height, format, type, pixelsOffset);
    }

    public static void glReadPixels(int x, int y, int width, int height, int format, int type, ShortBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35053, false);
        }
        GLES20.nglReadPixels(x, y, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glReadPixels(int x, int y, int width, int height, int format, int type, IntBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35053, false);
        }
        GLES20.nglReadPixels(x, y, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glReadPixels(int x, int y, int width, int height, int format, int type, FloatBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35053, false);
        }
        GLES20.nglReadPixels(x, y, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glReleaseShaderCompiler() {
        long __functionAddress = GLES20.getInstance().ReleaseShaderCompiler;
        JNI.callV(__functionAddress);
    }

    public static void glRenderbufferStorage(int target, int internalformat, int width, int height) {
        long __functionAddress = GLES20.getInstance().RenderbufferStorage;
        JNI.callIIIIV(__functionAddress, target, internalformat, width, height);
    }

    public static void glSampleCoverage(float value, boolean invert) {
        long __functionAddress = GLES20.getInstance().SampleCoverage;
        JNI.callFZV(__functionAddress, value, invert);
    }

    public static void glScissor(int x, int y, int width, int height) {
        long __functionAddress = GLES20.getInstance().Scissor;
        JNI.callIIIIV(__functionAddress, x, y, width, height);
    }

    public static void nglShaderBinary(int count, long shaders, int binaryformat, long binary, int length) {
        long __functionAddress = GLES20.getInstance().ShaderBinary;
        JNI.callIPIPIV(__functionAddress, count, shaders, binaryformat, binary, length);
    }

    public static void glShaderBinary(int count, ByteBuffer shaders, int binaryformat, ByteBuffer binary, int length) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)shaders, count << 2);
            Checks.checkBuffer((Buffer)binary, length);
        }
        GLES20.nglShaderBinary(count, MemoryUtil.memAddress(shaders), binaryformat, MemoryUtil.memAddress(binary), length);
    }

    public static void glShaderBinary(IntBuffer shaders, int binaryformat, ByteBuffer binary) {
        GLES20.nglShaderBinary(shaders.remaining(), MemoryUtil.memAddress(shaders), binaryformat, MemoryUtil.memAddress(binary), binary.remaining());
    }

    public static void nglShaderSource(int shader, int count, long string, long length) {
        long __functionAddress = GLES20.getInstance().ShaderSource;
        JNI.callIIPPV(__functionAddress, shader, count, string, length);
    }

    public static void glShaderSource(int shader, int count, ByteBuffer string, ByteBuffer length) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)string, count << Pointer.POINTER_SHIFT);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, count << 2);
            }
        }
        GLES20.nglShaderSource(shader, count, MemoryUtil.memAddress(string), MemoryUtil.memAddressSafe(length));
    }

    public static void glShaderSource(int shader, PointerBuffer string, IntBuffer length) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, string.remaining());
        }
        GLES20.nglShaderSource(shader, string.remaining(), MemoryUtil.memAddress(string), MemoryUtil.memAddressSafe(length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glShaderSource(int shader, CharSequence ... string) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int stringAddress = __buffer.pointerArrayParamUTF8i(string);
        try {
            GLES20.nglShaderSource(shader, string.length, __buffer.address(stringAddress), __buffer.address(stringAddress + (string.length << Pointer.POINTER_SHIFT)));
        }
        finally {
            __buffer.pointerArrayFree(stringAddress, string.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glShaderSource(int shader, CharSequence string) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int stringAddress = __buffer.pointerArrayParamUTF8i(string);
        try {
            GLES20.nglShaderSource(shader, 1, __buffer.address(stringAddress), __buffer.address(stringAddress + Pointer.POINTER_SIZE));
        }
        finally {
            __buffer.pointerArrayFree(stringAddress, 1);
        }
    }

    public static void glStencilFunc(int func, int ref, int mask) {
        long __functionAddress = GLES20.getInstance().StencilFunc;
        JNI.callIIIV(__functionAddress, func, ref, mask);
    }

    public static void glStencilFuncSeparate(int face, int func, int ref, int mask) {
        long __functionAddress = GLES20.getInstance().StencilFuncSeparate;
        JNI.callIIIIV(__functionAddress, face, func, ref, mask);
    }

    public static void glStencilMask(int mask) {
        long __functionAddress = GLES20.getInstance().StencilMask;
        JNI.callIV(__functionAddress, mask);
    }

    public static void glStencilMaskSeparate(int face, int mask) {
        long __functionAddress = GLES20.getInstance().StencilMaskSeparate;
        JNI.callIIV(__functionAddress, face, mask);
    }

    public static void glStencilOp(int fail, int zfail, int zpass) {
        long __functionAddress = GLES20.getInstance().StencilOp;
        JNI.callIIIV(__functionAddress, fail, zfail, zpass);
    }

    public static void glStencilOpSeparate(int face, int sfail, int dpfail, int dppass) {
        long __functionAddress = GLES20.getInstance().StencilOpSeparate;
        JNI.callIIIIV(__functionAddress, face, sfail, dpfail, dppass);
    }

    public static void nglTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, long pixels) {
        long __functionAddress = GLES20.getInstance().TexImage2D;
        JNI.callIIIIIIIIPV(__functionAddress, target, level, internalformat, width, height, border, format, type, pixels);
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, ByteBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        GLES20.nglTexImage2D(target, level, internalformat, width, height, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, long pixelsOffset) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, true);
        }
        GLES20.nglTexImage2D(target, level, internalformat, width, height, border, format, type, pixelsOffset);
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, ShortBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        GLES20.nglTexImage2D(target, level, internalformat, width, height, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, IntBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        GLES20.nglTexImage2D(target, level, internalformat, width, height, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, FloatBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        GLES20.nglTexImage2D(target, level, internalformat, width, height, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTexParameterf(int target, int pname, float param) {
        long __functionAddress = GLES20.getInstance().TexParameterf;
        JNI.callIIFV(__functionAddress, target, pname, param);
    }

    public static void nglTexParameterfv(int target, int pname, long params) {
        long __functionAddress = GLES20.getInstance().TexParameterfv;
        JNI.callIIPV(__functionAddress, target, pname, params);
    }

    public static void glTexParameterfv(int target, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GLES20.nglTexParameterfv(target, pname, MemoryUtil.memAddress(params));
    }

    public static void glTexParameterfv(int target, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES20.nglTexParameterfv(target, pname, MemoryUtil.memAddress(params));
    }

    public static void glTexParameteri(int target, int pname, int param) {
        long __functionAddress = GLES20.getInstance().TexParameteri;
        JNI.callIIIV(__functionAddress, target, pname, param);
    }

    public static void nglTexParameteriv(int target, int pname, long params) {
        long __functionAddress = GLES20.getInstance().TexParameteriv;
        JNI.callIIPV(__functionAddress, target, pname, params);
    }

    public static void glTexParameteriv(int target, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GLES20.nglTexParameteriv(target, pname, MemoryUtil.memAddress(params));
    }

    public static void glTexParameteriv(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES20.nglTexParameteriv(target, pname, MemoryUtil.memAddress(params));
    }

    public static void nglTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, long pixels) {
        long __functionAddress = GLES20.getInstance().TexSubImage2D;
        JNI.callIIIIIIIIPV(__functionAddress, target, level, xoffset, yoffset, width, height, format, type, pixels);
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, ByteBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        GLES20.nglTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, long pixelsOffset) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, true);
        }
        GLES20.nglTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixelsOffset);
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, ShortBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        GLES20.nglTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, IntBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        GLES20.nglTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, FloatBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        GLES20.nglTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glUniform1f(int location, float v0) {
        long __functionAddress = GLES20.getInstance().Uniform1f;
        JNI.callIFV(__functionAddress, location, v0);
    }

    public static void nglUniform1fv(int location, int count, long value) {
        long __functionAddress = GLES20.getInstance().Uniform1fv;
        JNI.callIIPV(__functionAddress, location, count, value);
    }

    public static void glUniform1fv(int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2);
        }
        GLES20.nglUniform1fv(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform1fv(int location, FloatBuffer value) {
        GLES20.nglUniform1fv(location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void glUniform1i(int location, int v0) {
        long __functionAddress = GLES20.getInstance().Uniform1i;
        JNI.callIIV(__functionAddress, location, v0);
    }

    public static void nglUniform1iv(int location, int count, long value) {
        long __functionAddress = GLES20.getInstance().Uniform1iv;
        JNI.callIIPV(__functionAddress, location, count, value);
    }

    public static void glUniform1iv(int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2);
        }
        GLES20.nglUniform1iv(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform1iv(int location, IntBuffer value) {
        GLES20.nglUniform1iv(location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void glUniform2f(int location, float v0, float v1) {
        long __functionAddress = GLES20.getInstance().Uniform2f;
        JNI.callIFFV(__functionAddress, location, v0, v1);
    }

    public static void nglUniform2fv(int location, int count, long value) {
        long __functionAddress = GLES20.getInstance().Uniform2fv;
        JNI.callIIPV(__functionAddress, location, count, value);
    }

    public static void glUniform2fv(int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 1 << 2);
        }
        GLES20.nglUniform2fv(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform2fv(int location, FloatBuffer value) {
        GLES20.nglUniform2fv(location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static void glUniform2i(int location, int v0, int v1) {
        long __functionAddress = GLES20.getInstance().Uniform2i;
        JNI.callIIIV(__functionAddress, location, v0, v1);
    }

    public static void nglUniform2iv(int location, int count, long value) {
        long __functionAddress = GLES20.getInstance().Uniform2iv;
        JNI.callIIPV(__functionAddress, location, count, value);
    }

    public static void glUniform2iv(int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 1 << 2);
        }
        GLES20.nglUniform2iv(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform2iv(int location, IntBuffer value) {
        GLES20.nglUniform2iv(location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static void glUniform3f(int location, float v0, float v1, float v2) {
        long __functionAddress = GLES20.getInstance().Uniform3f;
        JNI.callIFFFV(__functionAddress, location, v0, v1, v2);
    }

    public static void nglUniform3fv(int location, int count, long value) {
        long __functionAddress = GLES20.getInstance().Uniform3fv;
        JNI.callIIPV(__functionAddress, location, count, value);
    }

    public static void glUniform3fv(int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 3 << 2);
        }
        GLES20.nglUniform3fv(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform3fv(int location, FloatBuffer value) {
        GLES20.nglUniform3fv(location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static void glUniform3i(int location, int v0, int v1, int v2) {
        long __functionAddress = GLES20.getInstance().Uniform3i;
        JNI.callIIIIV(__functionAddress, location, v0, v1, v2);
    }

    public static void nglUniform3iv(int location, int count, long value) {
        long __functionAddress = GLES20.getInstance().Uniform3iv;
        JNI.callIIPV(__functionAddress, location, count, value);
    }

    public static void glUniform3iv(int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 3 << 2);
        }
        GLES20.nglUniform3iv(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform3iv(int location, IntBuffer value) {
        GLES20.nglUniform3iv(location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static void glUniform4f(int location, float v0, float v1, float v2, float v3) {
        long __functionAddress = GLES20.getInstance().Uniform4f;
        JNI.callIFFFFV(__functionAddress, location, v0, v1, v2, v3);
    }

    public static void nglUniform4fv(int location, int count, long value) {
        long __functionAddress = GLES20.getInstance().Uniform4fv;
        JNI.callIIPV(__functionAddress, location, count, value);
    }

    public static void glUniform4fv(int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 2);
        }
        GLES20.nglUniform4fv(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform4fv(int location, FloatBuffer value) {
        GLES20.nglUniform4fv(location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static void glUniform4i(int location, int v0, int v1, int v2, int v3) {
        long __functionAddress = GLES20.getInstance().Uniform4i;
        JNI.callIIIIIV(__functionAddress, location, v0, v1, v2, v3);
    }

    public static void nglUniform4iv(int location, int count, long value) {
        long __functionAddress = GLES20.getInstance().Uniform4iv;
        JNI.callIIPV(__functionAddress, location, count, value);
    }

    public static void glUniform4iv(int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 2);
        }
        GLES20.nglUniform4iv(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform4iv(int location, IntBuffer value) {
        GLES20.nglUniform4iv(location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix2fv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GLES20.getInstance().UniformMatrix2fv;
        JNI.callIIZPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix2fv(int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 2);
        }
        GLES20.nglUniformMatrix2fv(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix2fv(int location, boolean transpose, FloatBuffer value) {
        GLES20.nglUniformMatrix2fv(location, value.remaining() >> 2, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix3fv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GLES20.getInstance().UniformMatrix3fv;
        JNI.callIIZPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix3fv(int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 9 << 2);
        }
        GLES20.nglUniformMatrix3fv(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix3fv(int location, boolean transpose, FloatBuffer value) {
        GLES20.nglUniformMatrix3fv(location, value.remaining() / 9, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix4fv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GLES20.getInstance().UniformMatrix4fv;
        JNI.callIIZPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix4fv(int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 4 << 2);
        }
        GLES20.nglUniformMatrix4fv(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix4fv(int location, boolean transpose, FloatBuffer value) {
        GLES20.nglUniformMatrix4fv(location, value.remaining() >> 4, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUseProgram(int program) {
        long __functionAddress = GLES20.getInstance().UseProgram;
        JNI.callIV(__functionAddress, program);
    }

    public static void glValidateProgram(int program) {
        long __functionAddress = GLES20.getInstance().ValidateProgram;
        JNI.callIV(__functionAddress, program);
    }

    public static void glVertexAttrib1f(int index, float x) {
        long __functionAddress = GLES20.getInstance().VertexAttrib1f;
        JNI.callIFV(__functionAddress, index, x);
    }

    public static void nglVertexAttrib1fv(int index, long v) {
        long __functionAddress = GLES20.getInstance().VertexAttrib1fv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib1fv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GLES20.nglVertexAttrib1fv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib1fv(int index, FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 1);
        }
        GLES20.nglVertexAttrib1fv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib2f(int index, float x, float y) {
        long __functionAddress = GLES20.getInstance().VertexAttrib2f;
        JNI.callIFFV(__functionAddress, index, x, y);
    }

    public static void nglVertexAttrib2fv(int index, long v) {
        long __functionAddress = GLES20.getInstance().VertexAttrib2fv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib2fv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 8);
        }
        GLES20.nglVertexAttrib2fv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib2fv(int index, FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 2);
        }
        GLES20.nglVertexAttrib2fv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib3f(int index, float x, float y, float z) {
        long __functionAddress = GLES20.getInstance().VertexAttrib3f;
        JNI.callIFFFV(__functionAddress, index, x, y, z);
    }

    public static void nglVertexAttrib3fv(int index, long v) {
        long __functionAddress = GLES20.getInstance().VertexAttrib3fv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib3fv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 12);
        }
        GLES20.nglVertexAttrib3fv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib3fv(int index, FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 3);
        }
        GLES20.nglVertexAttrib3fv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib4f(int index, float x, float y, float z, float w) {
        long __functionAddress = GLES20.getInstance().VertexAttrib4f;
        JNI.callIFFFFV(__functionAddress, index, x, y, z, w);
    }

    public static void nglVertexAttrib4fv(int index, long v) {
        long __functionAddress = GLES20.getInstance().VertexAttrib4fv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4fv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 16);
        }
        GLES20.nglVertexAttrib4fv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib4fv(int index, FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GLES20.nglVertexAttrib4fv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, long pointer) {
        long __functionAddress = GLES20.getInstance().VertexAttribPointer;
        JNI.callIIIZIPV(__functionAddress, index, size, type, normalized, stride, pointer);
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, ByteBuffer pointer) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34964, false);
        }
        GLES20.nglVertexAttribPointer(index, size, type, normalized, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, long pointerOffset) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34964, true);
        }
        GLES20.nglVertexAttribPointer(index, size, type, normalized, stride, pointerOffset);
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, ShortBuffer pointer) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34964, false);
        }
        GLES20.nglVertexAttribPointer(index, size, type, normalized, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, IntBuffer pointer) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34964, false);
        }
        GLES20.nglVertexAttribPointer(index, size, type, normalized, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, FloatBuffer pointer) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34964, false);
        }
        GLES20.nglVertexAttribPointer(index, size, type, normalized, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glViewport(int x, int y, int width, int height) {
        long __functionAddress = GLES20.getInstance().Viewport;
        JNI.callIIIIV(__functionAddress, x, y, width, height);
    }
}

