/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.opengles.GLESChecks;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class GLES31 {
    public static final int GL_COMPUTE_SHADER = 37305;
    public static final int GL_MAX_COMPUTE_UNIFORM_BLOCKS = 37307;
    public static final int GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS = 37308;
    public static final int GL_MAX_COMPUTE_IMAGE_UNIFORMS = 37309;
    public static final int GL_MAX_COMPUTE_SHARED_MEMORY_SIZE = 33378;
    public static final int GL_MAX_COMPUTE_UNIFORM_COMPONENTS = 33379;
    public static final int GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS = 33380;
    public static final int GL_MAX_COMPUTE_ATOMIC_COUNTERS = 33381;
    public static final int GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS = 33382;
    public static final int GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS = 37099;
    public static final int GL_MAX_COMPUTE_WORK_GROUP_COUNT = 37310;
    public static final int GL_MAX_COMPUTE_WORK_GROUP_SIZE = 37311;
    public static final int GL_COMPUTE_WORK_GROUP_SIZE = 33383;
    public static final int GL_DISPATCH_INDIRECT_BUFFER = 37102;
    public static final int GL_DISPATCH_INDIRECT_BUFFER_BINDING = 37103;
    public static final int GL_COMPUTE_SHADER_BIT = 32;
    public static final int GL_DRAW_INDIRECT_BUFFER = 36671;
    public static final int GL_DRAW_INDIRECT_BUFFER_BINDING = 36675;
    public static final int GL_MAX_UNIFORM_LOCATIONS = 33390;
    public static final int GL_FRAMEBUFFER_DEFAULT_WIDTH = 37648;
    public static final int GL_FRAMEBUFFER_DEFAULT_HEIGHT = 37649;
    public static final int GL_FRAMEBUFFER_DEFAULT_SAMPLES = 37651;
    public static final int GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS = 37652;
    public static final int GL_MAX_FRAMEBUFFER_WIDTH = 37653;
    public static final int GL_MAX_FRAMEBUFFER_HEIGHT = 37654;
    public static final int GL_MAX_FRAMEBUFFER_SAMPLES = 37656;
    public static final int GL_UNIFORM = 37601;
    public static final int GL_UNIFORM_BLOCK = 37602;
    public static final int GL_PROGRAM_INPUT = 37603;
    public static final int GL_PROGRAM_OUTPUT = 37604;
    public static final int GL_BUFFER_VARIABLE = 37605;
    public static final int GL_SHADER_STORAGE_BLOCK = 37606;
    public static final int GL_ATOMIC_COUNTER_BUFFER = 37568;
    public static final int GL_TRANSFORM_FEEDBACK_VARYING = 37620;
    public static final int GL_ACTIVE_RESOURCES = 37621;
    public static final int GL_MAX_NAME_LENGTH = 37622;
    public static final int GL_MAX_NUM_ACTIVE_VARIABLES = 37623;
    public static final int GL_NAME_LENGTH = 37625;
    public static final int GL_TYPE = 37626;
    public static final int GL_ARRAY_SIZE = 37627;
    public static final int GL_OFFSET = 37628;
    public static final int GL_BLOCK_INDEX = 37629;
    public static final int GL_ARRAY_STRIDE = 37630;
    public static final int GL_MATRIX_STRIDE = 37631;
    public static final int GL_IS_ROW_MAJOR = 37632;
    public static final int GL_ATOMIC_COUNTER_BUFFER_INDEX = 37633;
    public static final int GL_BUFFER_BINDING = 37634;
    public static final int GL_BUFFER_DATA_SIZE = 37635;
    public static final int GL_NUM_ACTIVE_VARIABLES = 37636;
    public static final int GL_ACTIVE_VARIABLES = 37637;
    public static final int GL_REFERENCED_BY_VERTEX_SHADER = 37638;
    public static final int GL_REFERENCED_BY_FRAGMENT_SHADER = 37642;
    public static final int GL_REFERENCED_BY_COMPUTE_SHADER = 37643;
    public static final int GL_TOP_LEVEL_ARRAY_SIZE = 37644;
    public static final int GL_TOP_LEVEL_ARRAY_STRIDE = 37645;
    public static final int GL_LOCATION = 37646;
    public static final int GL_VERTEX_SHADER_BIT = 1;
    public static final int GL_FRAGMENT_SHADER_BIT = 2;
    public static final int GL_ALL_SHADER_BITS = -1;
    public static final int GL_PROGRAM_SEPARABLE = 33368;
    public static final int GL_ACTIVE_PROGRAM = 33369;
    public static final int GL_PROGRAM_PIPELINE_BINDING = 33370;
    public static final int GL_ATOMIC_COUNTER_BUFFER_BINDING = 37569;
    public static final int GL_ATOMIC_COUNTER_BUFFER_START = 37570;
    public static final int GL_ATOMIC_COUNTER_BUFFER_SIZE = 37571;
    public static final int GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS = 37580;
    public static final int GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS = 37584;
    public static final int GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS = 37585;
    public static final int GL_MAX_VERTEX_ATOMIC_COUNTERS = 37586;
    public static final int GL_MAX_FRAGMENT_ATOMIC_COUNTERS = 37590;
    public static final int GL_MAX_COMBINED_ATOMIC_COUNTERS = 37591;
    public static final int GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE = 37592;
    public static final int GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS = 37596;
    public static final int GL_ACTIVE_ATOMIC_COUNTER_BUFFERS = 37593;
    public static final int GL_UNSIGNED_INT_ATOMIC_COUNTER = 37595;
    public static final int GL_MAX_IMAGE_UNITS = 36664;
    public static final int GL_MAX_VERTEX_IMAGE_UNIFORMS = 37066;
    public static final int GL_MAX_FRAGMENT_IMAGE_UNIFORMS = 37070;
    public static final int GL_MAX_COMBINED_IMAGE_UNIFORMS = 37071;
    public static final int GL_IMAGE_BINDING_NAME = 36666;
    public static final int GL_IMAGE_BINDING_LEVEL = 36667;
    public static final int GL_IMAGE_BINDING_LAYERED = 36668;
    public static final int GL_IMAGE_BINDING_LAYER = 36669;
    public static final int GL_IMAGE_BINDING_ACCESS = 36670;
    public static final int GL_IMAGE_BINDING_FORMAT = 36974;
    public static final int GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT = 1;
    public static final int GL_ELEMENT_ARRAY_BARRIER_BIT = 2;
    public static final int GL_UNIFORM_BARRIER_BIT = 4;
    public static final int GL_TEXTURE_FETCH_BARRIER_BIT = 8;
    public static final int GL_SHADER_IMAGE_ACCESS_BARRIER_BIT = 32;
    public static final int GL_COMMAND_BARRIER_BIT = 64;
    public static final int GL_PIXEL_BUFFER_BARRIER_BIT = 128;
    public static final int GL_TEXTURE_UPDATE_BARRIER_BIT = 256;
    public static final int GL_BUFFER_UPDATE_BARRIER_BIT = 512;
    public static final int GL_FRAMEBUFFER_BARRIER_BIT = 1024;
    public static final int GL_TRANSFORM_FEEDBACK_BARRIER_BIT = 2048;
    public static final int GL_ATOMIC_COUNTER_BARRIER_BIT = 4096;
    public static final int GL_ALL_BARRIER_BITS = -1;
    public static final int GL_IMAGE_2D = 36941;
    public static final int GL_IMAGE_3D = 36942;
    public static final int GL_IMAGE_CUBE = 36944;
    public static final int GL_IMAGE_2D_ARRAY = 36947;
    public static final int GL_INT_IMAGE_2D = 36952;
    public static final int GL_INT_IMAGE_3D = 36953;
    public static final int GL_INT_IMAGE_CUBE = 36955;
    public static final int GL_INT_IMAGE_2D_ARRAY = 36958;
    public static final int GL_UNSIGNED_INT_IMAGE_2D = 36963;
    public static final int GL_UNSIGNED_INT_IMAGE_3D = 36964;
    public static final int GL_UNSIGNED_INT_IMAGE_CUBE = 36966;
    public static final int GL_UNSIGNED_INT_IMAGE_2D_ARRAY = 36969;
    public static final int GL_IMAGE_FORMAT_COMPATIBILITY_TYPE = 37063;
    public static final int GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE = 37064;
    public static final int GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS = 37065;
    public static final int GL_READ_ONLY = 35000;
    public static final int GL_WRITE_ONLY = 35001;
    public static final int GL_READ_WRITE = 35002;
    public static final int GL_SHADER_STORAGE_BUFFER = 37074;
    public static final int GL_SHADER_STORAGE_BUFFER_BINDING = 37075;
    public static final int GL_SHADER_STORAGE_BUFFER_START = 37076;
    public static final int GL_SHADER_STORAGE_BUFFER_SIZE = 37077;
    public static final int GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS = 37078;
    public static final int GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS = 37082;
    public static final int GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS = 37083;
    public static final int GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS = 37084;
    public static final int GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS = 37085;
    public static final int GL_MAX_SHADER_STORAGE_BLOCK_SIZE = 37086;
    public static final int GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT = 37087;
    public static final int GL_SHADER_STORAGE_BARRIER_BIT = 8192;
    public static final int GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES = 36665;
    public static final int GL_DEPTH_STENCIL_TEXTURE_MODE = 37098;
    public static final int GL_STENCIL_INDEX = 6401;
    public static final int GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET = 36446;
    public static final int GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET = 36447;
    public static final int GL_SAMPLE_POSITION = 36432;
    public static final int GL_SAMPLE_MASK = 36433;
    public static final int GL_SAMPLE_MASK_VALUE = 36434;
    public static final int GL_TEXTURE_2D_MULTISAMPLE = 37120;
    public static final int GL_MAX_SAMPLE_MASK_WORDS = 36441;
    public static final int GL_MAX_COLOR_TEXTURE_SAMPLES = 37134;
    public static final int GL_MAX_DEPTH_TEXTURE_SAMPLES = 37135;
    public static final int GL_MAX_INTEGER_SAMPLES = 37136;
    public static final int GL_TEXTURE_BINDING_2D_MULTISAMPLE = 37124;
    public static final int GL_TEXTURE_SAMPLES = 37126;
    public static final int GL_TEXTURE_FIXED_SAMPLE_LOCATIONS = 37127;
    public static final int GL_TEXTURE_WIDTH = 4096;
    public static final int GL_TEXTURE_HEIGHT = 4097;
    public static final int GL_TEXTURE_DEPTH = 32881;
    public static final int GL_TEXTURE_INTERNAL_FORMAT = 4099;
    public static final int GL_TEXTURE_RED_SIZE = 32860;
    public static final int GL_TEXTURE_GREEN_SIZE = 32861;
    public static final int GL_TEXTURE_BLUE_SIZE = 32862;
    public static final int GL_TEXTURE_ALPHA_SIZE = 32863;
    public static final int GL_TEXTURE_DEPTH_SIZE = 34890;
    public static final int GL_TEXTURE_STENCIL_SIZE = 35057;
    public static final int GL_TEXTURE_SHARED_SIZE = 35903;
    public static final int GL_TEXTURE_RED_TYPE = 35856;
    public static final int GL_TEXTURE_GREEN_TYPE = 35857;
    public static final int GL_TEXTURE_BLUE_TYPE = 35858;
    public static final int GL_TEXTURE_ALPHA_TYPE = 35859;
    public static final int GL_TEXTURE_DEPTH_TYPE = 35862;
    public static final int GL_TEXTURE_COMPRESSED = 34465;
    public static final int GL_SAMPLER_2D_MULTISAMPLE = 37128;
    public static final int GL_INT_SAMPLER_2D_MULTISAMPLE = 37129;
    public static final int GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE = 37130;
    public static final int GL_VERTEX_ATTRIB_BINDING = 33492;
    public static final int GL_VERTEX_ATTRIB_RELATIVE_OFFSET = 33493;
    public static final int GL_VERTEX_BINDING_DIVISOR = 33494;
    public static final int GL_VERTEX_BINDING_OFFSET = 33495;
    public static final int GL_VERTEX_BINDING_STRIDE = 33496;
    public static final int GL_VERTEX_BINDING_BUFFER = 36687;
    public static final int GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET = 33497;
    public static final int GL_MAX_VERTEX_ATTRIB_BINDINGS = 33498;
    public static final int GL_MAX_VERTEX_ATTRIB_STRIDE = 33509;
    public final long DispatchCompute;
    public final long DispatchComputeIndirect;
    public final long DrawArraysIndirect;
    public final long DrawElementsIndirect;
    public final long FramebufferParameteri;
    public final long GetFramebufferParameteriv;
    public final long GetProgramInterfaceiv;
    public final long GetProgramResourceIndex;
    public final long GetProgramResourceName;
    public final long GetProgramResourceiv;
    public final long GetProgramResourceLocation;
    public final long UseProgramStages;
    public final long ActiveShaderProgram;
    public final long CreateShaderProgramv;
    public final long BindProgramPipeline;
    public final long DeleteProgramPipelines;
    public final long GenProgramPipelines;
    public final long IsProgramPipeline;
    public final long GetProgramPipelineiv;
    public final long ProgramUniform1i;
    public final long ProgramUniform2i;
    public final long ProgramUniform3i;
    public final long ProgramUniform4i;
    public final long ProgramUniform1ui;
    public final long ProgramUniform2ui;
    public final long ProgramUniform3ui;
    public final long ProgramUniform4ui;
    public final long ProgramUniform1f;
    public final long ProgramUniform2f;
    public final long ProgramUniform3f;
    public final long ProgramUniform4f;
    public final long ProgramUniform1iv;
    public final long ProgramUniform2iv;
    public final long ProgramUniform3iv;
    public final long ProgramUniform4iv;
    public final long ProgramUniform1uiv;
    public final long ProgramUniform2uiv;
    public final long ProgramUniform3uiv;
    public final long ProgramUniform4uiv;
    public final long ProgramUniform1fv;
    public final long ProgramUniform2fv;
    public final long ProgramUniform3fv;
    public final long ProgramUniform4fv;
    public final long ProgramUniformMatrix2fv;
    public final long ProgramUniformMatrix3fv;
    public final long ProgramUniformMatrix4fv;
    public final long ProgramUniformMatrix2x3fv;
    public final long ProgramUniformMatrix3x2fv;
    public final long ProgramUniformMatrix2x4fv;
    public final long ProgramUniformMatrix4x2fv;
    public final long ProgramUniformMatrix3x4fv;
    public final long ProgramUniformMatrix4x3fv;
    public final long ValidateProgramPipeline;
    public final long GetProgramPipelineInfoLog;
    public final long BindImageTexture;
    public final long GetBooleani_v;
    public final long MemoryBarrier;
    public final long MemoryBarrierByRegion;
    public final long TexStorage2DMultisample;
    public final long GetMultisamplefv;
    public final long SampleMaski;
    public final long GetTexLevelParameteriv;
    public final long GetTexLevelParameterfv;
    public final long BindVertexBuffer;
    public final long VertexAttribFormat;
    public final long VertexAttribIFormat;
    public final long VertexAttribBinding;
    public final long VertexBindingDivisor;

    protected GLES31() {
        throw new UnsupportedOperationException();
    }

    public GLES31(FunctionProvider provider) {
        this.DispatchCompute = provider.getFunctionAddress("glDispatchCompute");
        this.DispatchComputeIndirect = provider.getFunctionAddress("glDispatchComputeIndirect");
        this.DrawArraysIndirect = provider.getFunctionAddress("glDrawArraysIndirect");
        this.DrawElementsIndirect = provider.getFunctionAddress("glDrawElementsIndirect");
        this.FramebufferParameteri = provider.getFunctionAddress("glFramebufferParameteri");
        this.GetFramebufferParameteriv = provider.getFunctionAddress("glGetFramebufferParameteriv");
        this.GetProgramInterfaceiv = provider.getFunctionAddress("glGetProgramInterfaceiv");
        this.GetProgramResourceIndex = provider.getFunctionAddress("glGetProgramResourceIndex");
        this.GetProgramResourceName = provider.getFunctionAddress("glGetProgramResourceName");
        this.GetProgramResourceiv = provider.getFunctionAddress("glGetProgramResourceiv");
        this.GetProgramResourceLocation = provider.getFunctionAddress("glGetProgramResourceLocation");
        this.UseProgramStages = provider.getFunctionAddress("glUseProgramStages");
        this.ActiveShaderProgram = provider.getFunctionAddress("glActiveShaderProgram");
        this.CreateShaderProgramv = provider.getFunctionAddress("glCreateShaderProgramv");
        this.BindProgramPipeline = provider.getFunctionAddress("glBindProgramPipeline");
        this.DeleteProgramPipelines = provider.getFunctionAddress("glDeleteProgramPipelines");
        this.GenProgramPipelines = provider.getFunctionAddress("glGenProgramPipelines");
        this.IsProgramPipeline = provider.getFunctionAddress("glIsProgramPipeline");
        this.GetProgramPipelineiv = provider.getFunctionAddress("glGetProgramPipelineiv");
        this.ProgramUniform1i = provider.getFunctionAddress("glProgramUniform1i");
        this.ProgramUniform2i = provider.getFunctionAddress("glProgramUniform2i");
        this.ProgramUniform3i = provider.getFunctionAddress("glProgramUniform3i");
        this.ProgramUniform4i = provider.getFunctionAddress("glProgramUniform4i");
        this.ProgramUniform1ui = provider.getFunctionAddress("glProgramUniform1ui");
        this.ProgramUniform2ui = provider.getFunctionAddress("glProgramUniform2ui");
        this.ProgramUniform3ui = provider.getFunctionAddress("glProgramUniform3ui");
        this.ProgramUniform4ui = provider.getFunctionAddress("glProgramUniform4ui");
        this.ProgramUniform1f = provider.getFunctionAddress("glProgramUniform1f");
        this.ProgramUniform2f = provider.getFunctionAddress("glProgramUniform2f");
        this.ProgramUniform3f = provider.getFunctionAddress("glProgramUniform3f");
        this.ProgramUniform4f = provider.getFunctionAddress("glProgramUniform4f");
        this.ProgramUniform1iv = provider.getFunctionAddress("glProgramUniform1iv");
        this.ProgramUniform2iv = provider.getFunctionAddress("glProgramUniform2iv");
        this.ProgramUniform3iv = provider.getFunctionAddress("glProgramUniform3iv");
        this.ProgramUniform4iv = provider.getFunctionAddress("glProgramUniform4iv");
        this.ProgramUniform1uiv = provider.getFunctionAddress("glProgramUniform1uiv");
        this.ProgramUniform2uiv = provider.getFunctionAddress("glProgramUniform2uiv");
        this.ProgramUniform3uiv = provider.getFunctionAddress("glProgramUniform3uiv");
        this.ProgramUniform4uiv = provider.getFunctionAddress("glProgramUniform4uiv");
        this.ProgramUniform1fv = provider.getFunctionAddress("glProgramUniform1fv");
        this.ProgramUniform2fv = provider.getFunctionAddress("glProgramUniform2fv");
        this.ProgramUniform3fv = provider.getFunctionAddress("glProgramUniform3fv");
        this.ProgramUniform4fv = provider.getFunctionAddress("glProgramUniform4fv");
        this.ProgramUniformMatrix2fv = provider.getFunctionAddress("glProgramUniformMatrix2fv");
        this.ProgramUniformMatrix3fv = provider.getFunctionAddress("glProgramUniformMatrix3fv");
        this.ProgramUniformMatrix4fv = provider.getFunctionAddress("glProgramUniformMatrix4fv");
        this.ProgramUniformMatrix2x3fv = provider.getFunctionAddress("glProgramUniformMatrix2x3fv");
        this.ProgramUniformMatrix3x2fv = provider.getFunctionAddress("glProgramUniformMatrix3x2fv");
        this.ProgramUniformMatrix2x4fv = provider.getFunctionAddress("glProgramUniformMatrix2x4fv");
        this.ProgramUniformMatrix4x2fv = provider.getFunctionAddress("glProgramUniformMatrix4x2fv");
        this.ProgramUniformMatrix3x4fv = provider.getFunctionAddress("glProgramUniformMatrix3x4fv");
        this.ProgramUniformMatrix4x3fv = provider.getFunctionAddress("glProgramUniformMatrix4x3fv");
        this.ValidateProgramPipeline = provider.getFunctionAddress("glValidateProgramPipeline");
        this.GetProgramPipelineInfoLog = provider.getFunctionAddress("glGetProgramPipelineInfoLog");
        this.BindImageTexture = provider.getFunctionAddress("glBindImageTexture");
        this.GetBooleani_v = provider.getFunctionAddress("glGetBooleani_v");
        this.MemoryBarrier = provider.getFunctionAddress("glMemoryBarrier");
        this.MemoryBarrierByRegion = provider.getFunctionAddress("glMemoryBarrierByRegion");
        this.TexStorage2DMultisample = provider.getFunctionAddress("glTexStorage2DMultisample");
        this.GetMultisamplefv = provider.getFunctionAddress("glGetMultisamplefv");
        this.SampleMaski = provider.getFunctionAddress("glSampleMaski");
        this.GetTexLevelParameteriv = provider.getFunctionAddress("glGetTexLevelParameteriv");
        this.GetTexLevelParameterfv = provider.getFunctionAddress("glGetTexLevelParameterfv");
        this.BindVertexBuffer = provider.getFunctionAddress("glBindVertexBuffer");
        this.VertexAttribFormat = provider.getFunctionAddress("glVertexAttribFormat");
        this.VertexAttribIFormat = provider.getFunctionAddress("glVertexAttribIFormat");
        this.VertexAttribBinding = provider.getFunctionAddress("glVertexAttribBinding");
        this.VertexBindingDivisor = provider.getFunctionAddress("glVertexBindingDivisor");
    }

    public static GLES31 getInstance() {
        return GLES31.getInstance(GLES.getCapabilities());
    }

    public static GLES31 getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__GLES31);
    }

    static GLES31 create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GLES31")) {
            return null;
        }
        GLES31 funcs = new GLES31(provider);
        boolean supported = Checks.checkFunctions(funcs.DispatchCompute, funcs.DispatchComputeIndirect, funcs.DrawArraysIndirect, funcs.DrawElementsIndirect, funcs.FramebufferParameteri, funcs.GetFramebufferParameteriv, funcs.GetProgramInterfaceiv, funcs.GetProgramResourceIndex, funcs.GetProgramResourceName, funcs.GetProgramResourceiv, funcs.GetProgramResourceLocation, funcs.UseProgramStages, funcs.ActiveShaderProgram, funcs.CreateShaderProgramv, funcs.BindProgramPipeline, funcs.DeleteProgramPipelines, funcs.GenProgramPipelines, funcs.IsProgramPipeline, funcs.GetProgramPipelineiv, funcs.ProgramUniform1i, funcs.ProgramUniform2i, funcs.ProgramUniform3i, funcs.ProgramUniform4i, funcs.ProgramUniform1ui, funcs.ProgramUniform2ui, funcs.ProgramUniform3ui, funcs.ProgramUniform4ui, funcs.ProgramUniform1f, funcs.ProgramUniform2f, funcs.ProgramUniform3f, funcs.ProgramUniform4f, funcs.ProgramUniform1iv, funcs.ProgramUniform2iv, funcs.ProgramUniform3iv, funcs.ProgramUniform4iv, funcs.ProgramUniform1uiv, funcs.ProgramUniform2uiv, funcs.ProgramUniform3uiv, funcs.ProgramUniform4uiv, funcs.ProgramUniform1fv, funcs.ProgramUniform2fv, funcs.ProgramUniform3fv, funcs.ProgramUniform4fv, funcs.ProgramUniformMatrix2fv, funcs.ProgramUniformMatrix3fv, funcs.ProgramUniformMatrix4fv, funcs.ProgramUniformMatrix2x3fv, funcs.ProgramUniformMatrix3x2fv, funcs.ProgramUniformMatrix2x4fv, funcs.ProgramUniformMatrix4x2fv, funcs.ProgramUniformMatrix3x4fv, funcs.ProgramUniformMatrix4x3fv, funcs.ValidateProgramPipeline, funcs.GetProgramPipelineInfoLog, funcs.BindImageTexture, funcs.GetBooleani_v, funcs.MemoryBarrier, funcs.MemoryBarrierByRegion, funcs.TexStorage2DMultisample, funcs.GetMultisamplefv, funcs.SampleMaski, funcs.GetTexLevelParameteriv, funcs.GetTexLevelParameterfv, funcs.BindVertexBuffer, funcs.VertexAttribFormat, funcs.VertexAttribIFormat, funcs.VertexAttribBinding, funcs.VertexBindingDivisor);
        return GLES.checkExtension("GLES31", funcs, supported);
    }

    public static void glDispatchCompute(int num_groups_x, int num_groups_y, int num_groups_z) {
        long __functionAddress = GLES31.getInstance().DispatchCompute;
        JNI.callIIIV(__functionAddress, num_groups_x, num_groups_y, num_groups_z);
    }

    public static void glDispatchComputeIndirect(long indirect) {
        long __functionAddress = GLES31.getInstance().DispatchComputeIndirect;
        JNI.callPV(__functionAddress, indirect);
    }

    public static void nglDrawArraysIndirect(int mode, long indirect) {
        long __functionAddress = GLES31.getInstance().DrawArraysIndirect;
        JNI.callIPV(__functionAddress, mode, indirect);
    }

    public static void glDrawArraysIndirect(int mode, ByteBuffer indirect) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, 16);
            GLESChecks.ensureBufferObject(36675, false);
        }
        GLES31.nglDrawArraysIndirect(mode, MemoryUtil.memAddress(indirect));
    }

    public static void glDrawArraysIndirect(int mode, long indirectOffset) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(36675, true);
        }
        GLES31.nglDrawArraysIndirect(mode, indirectOffset);
    }

    public static void glDrawArraysIndirect(int mode, IntBuffer indirect) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, 4);
            GLESChecks.ensureBufferObject(36675, false);
        }
        GLES31.nglDrawArraysIndirect(mode, MemoryUtil.memAddress(indirect));
    }

    public static void nglDrawElementsIndirect(int mode, int type, long indirect) {
        long __functionAddress = GLES31.getInstance().DrawElementsIndirect;
        JNI.callIIPV(__functionAddress, mode, type, indirect);
    }

    public static void glDrawElementsIndirect(int mode, int type, ByteBuffer indirect) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, 20);
            GLESChecks.ensureBufferObject(36675, false);
        }
        GLES31.nglDrawElementsIndirect(mode, type, MemoryUtil.memAddress(indirect));
    }

    public static void glDrawElementsIndirect(int mode, int type, long indirectOffset) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(36675, true);
        }
        GLES31.nglDrawElementsIndirect(mode, type, indirectOffset);
    }

    public static void glDrawElementsIndirect(int mode, int type, IntBuffer indirect) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, 5);
            GLESChecks.ensureBufferObject(36675, false);
        }
        GLES31.nglDrawElementsIndirect(mode, type, MemoryUtil.memAddress(indirect));
    }

    public static void glFramebufferParameteri(int target, int pname, int param) {
        long __functionAddress = GLES31.getInstance().FramebufferParameteri;
        JNI.callIIIV(__functionAddress, target, pname, param);
    }

    public static void nglGetFramebufferParameteriv(int target, int pname, long params) {
        long __functionAddress = GLES31.getInstance().GetFramebufferParameteriv;
        JNI.callIIPV(__functionAddress, target, pname, params);
    }

    public static void glGetFramebufferParameteriv(int target, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GLES31.nglGetFramebufferParameteriv(target, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetFramebufferParameteriv(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES31.nglGetFramebufferParameteriv(target, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetFramebufferParameteri(int target, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GLES31.nglGetFramebufferParameteriv(target, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetProgramInterfaceiv(int program, int programInterface, int pname, long params) {
        long __functionAddress = GLES31.getInstance().GetProgramInterfaceiv;
        JNI.callIIIPV(__functionAddress, program, programInterface, pname, params);
    }

    public static void glGetProgramInterfaceiv(int program, int programInterface, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GLES31.nglGetProgramInterfaceiv(program, programInterface, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetProgramInterfaceiv(int program, int programInterface, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES31.nglGetProgramInterfaceiv(program, programInterface, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetProgramInterfacei(int program, int programInterface, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GLES31.nglGetProgramInterfaceiv(program, programInterface, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static int nglGetProgramResourceIndex(int program, int programInterface, long name) {
        long __functionAddress = GLES31.getInstance().GetProgramResourceIndex;
        return JNI.callIIPI(__functionAddress, program, programInterface, name);
    }

    public static int glGetProgramResourceIndex(int program, int programInterface, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return GLES31.nglGetProgramResourceIndex(program, programInterface, MemoryUtil.memAddress(name));
    }

    public static int glGetProgramResourceIndex(int program, int programInterface, CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, true);
        return GLES31.nglGetProgramResourceIndex(program, programInterface, __buffer.address(nameEncoded));
    }

    public static void nglGetProgramResourceName(int program, int programInterface, int index, int bufSize, long length, long name) {
        long __functionAddress = GLES31.getInstance().GetProgramResourceName;
        JNI.callIIIIPPV(__functionAddress, program, programInterface, index, bufSize, length, name);
    }

    public static void glGetProgramResourceName(int program, int programInterface, int index, int bufSize, ByteBuffer length, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)name, bufSize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        GLES31.nglGetProgramResourceName(program, programInterface, index, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(name));
    }

    public static void glGetProgramResourceName(int program, int programInterface, int index, IntBuffer length, ByteBuffer name) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        GLES31.nglGetProgramResourceName(program, programInterface, index, name.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(name));
    }

    public static String glGetProgramResourceName(int program, int programInterface, int index, int bufSize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int name = __buffer.bufferParam(bufSize);
        GLES31.nglGetProgramResourceName(program, programInterface, index, bufSize, __buffer.address(length), __buffer.address(name));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), name);
    }

    public static String glGetProgramResourceName(int program, int programInterface, int index) {
        int bufSize = GLES31.glGetProgramInterfacei(program, programInterface, 37622);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int name = __buffer.bufferParam(bufSize);
        GLES31.nglGetProgramResourceName(program, programInterface, index, bufSize, __buffer.address(length), __buffer.address(name));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), name);
    }

    public static void nglGetProgramResourceiv(int program, int programInterface, int index, int propCount, long props, int bufSize, long length, long params) {
        long __functionAddress = GLES31.getInstance().GetProgramResourceiv;
        JNI.callIIIIPIPPV(__functionAddress, program, programInterface, index, propCount, props, bufSize, length, params);
    }

    public static void glGetProgramResourceiv(int program, int programInterface, int index, int propCount, ByteBuffer props, int bufSize, ByteBuffer length, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)props, propCount << 2);
            Checks.checkBuffer((Buffer)params, bufSize << 2);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        GLES31.nglGetProgramResourceiv(program, programInterface, index, propCount, MemoryUtil.memAddress(props), bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(params));
    }

    public static void glGetProgramResourceiv(int program, int programInterface, int index, IntBuffer props, IntBuffer length, IntBuffer params) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        GLES31.nglGetProgramResourceiv(program, programInterface, index, props.remaining(), MemoryUtil.memAddress(props), params.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(params));
    }

    public static IntBuffer glGetProgramResourceiv(int program, int programInterface, int index, IntBuffer props, int bufSize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        IntBuffer params = BufferUtils.createIntBuffer(bufSize);
        GLES31.nglGetProgramResourceiv(program, programInterface, index, props.remaining(), MemoryUtil.memAddress(props), bufSize, __buffer.address(length), MemoryUtil.memAddress(params));
        params.limit(__buffer.intValue(length));
        return params.slice();
    }

    public static int nglGetProgramResourceLocation(int program, int programInterface, long name) {
        long __functionAddress = GLES31.getInstance().GetProgramResourceLocation;
        return JNI.callIIPI(__functionAddress, program, programInterface, name);
    }

    public static int glGetProgramResourceLocation(int program, int programInterface, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return GLES31.nglGetProgramResourceLocation(program, programInterface, MemoryUtil.memAddress(name));
    }

    public static int glGetProgramResourceLocation(int program, int programInterface, CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, true);
        return GLES31.nglGetProgramResourceLocation(program, programInterface, __buffer.address(nameEncoded));
    }

    public static void glUseProgramStages(int pipeline, int stages, int program) {
        long __functionAddress = GLES31.getInstance().UseProgramStages;
        JNI.callIIIV(__functionAddress, pipeline, stages, program);
    }

    public static void glActiveShaderProgram(int pipeline, int program) {
        long __functionAddress = GLES31.getInstance().ActiveShaderProgram;
        JNI.callIIV(__functionAddress, pipeline, program);
    }

    public static int nglCreateShaderProgramv(int type, int count, long strings) {
        long __functionAddress = GLES31.getInstance().CreateShaderProgramv;
        return JNI.callIIPI(__functionAddress, type, count, strings);
    }

    public static int glCreateShaderProgramv(int type, int count, ByteBuffer strings) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)strings, count << Pointer.POINTER_SHIFT);
        }
        return GLES31.nglCreateShaderProgramv(type, count, MemoryUtil.memAddress(strings));
    }

    public static int glCreateShaderProgramv(int type, PointerBuffer strings) {
        return GLES31.nglCreateShaderProgramv(type, strings.remaining(), MemoryUtil.memAddress(strings));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glCreateShaderProgramv(int type, CharSequence ... strings) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int stringsAddress = __buffer.pointerArrayParamUTF8(strings);
        try {
            int n = GLES31.nglCreateShaderProgramv(type, strings.length, __buffer.address(stringsAddress));
            return n;
        }
        finally {
            __buffer.pointerArrayFree(stringsAddress, strings.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glCreateShaderProgramv(int type, CharSequence string) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int stringsAddress = __buffer.pointerArrayParamUTF8(string);
        try {
            int n = GLES31.nglCreateShaderProgramv(type, 1, __buffer.address(stringsAddress));
            return n;
        }
        finally {
            __buffer.pointerArrayFree(stringsAddress, 1);
        }
    }

    public static void glBindProgramPipeline(int pipeline) {
        long __functionAddress = GLES31.getInstance().BindProgramPipeline;
        JNI.callIV(__functionAddress, pipeline);
    }

    public static void nglDeleteProgramPipelines(int n, long pipelines) {
        long __functionAddress = GLES31.getInstance().DeleteProgramPipelines;
        JNI.callIPV(__functionAddress, n, pipelines);
    }

    public static void glDeleteProgramPipelines(int n, ByteBuffer pipelines) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)pipelines, n << 2);
        }
        GLES31.nglDeleteProgramPipelines(n, MemoryUtil.memAddress(pipelines));
    }

    public static void glDeleteProgramPipelines(IntBuffer pipelines) {
        GLES31.nglDeleteProgramPipelines(pipelines.remaining(), MemoryUtil.memAddress(pipelines));
    }

    public static void glDeleteProgramPipelines(int pipeline) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int pipelines = __buffer.intParam(pipeline);
        GLES31.nglDeleteProgramPipelines(1, __buffer.address(pipelines));
    }

    public static void nglGenProgramPipelines(int n, long pipelines) {
        long __functionAddress = GLES31.getInstance().GenProgramPipelines;
        JNI.callIPV(__functionAddress, n, pipelines);
    }

    public static void glGenProgramPipelines(int n, ByteBuffer pipelines) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)pipelines, n << 2);
        }
        GLES31.nglGenProgramPipelines(n, MemoryUtil.memAddress(pipelines));
    }

    public static void glGenProgramPipelines(IntBuffer pipelines) {
        GLES31.nglGenProgramPipelines(pipelines.remaining(), MemoryUtil.memAddress(pipelines));
    }

    public static int glGenProgramPipelines() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int pipelines = __buffer.intParam();
        GLES31.nglGenProgramPipelines(1, __buffer.address(pipelines));
        return __buffer.intValue(pipelines);
    }

    public static boolean glIsProgramPipeline(int pipeline) {
        long __functionAddress = GLES31.getInstance().IsProgramPipeline;
        return JNI.callIZ(__functionAddress, pipeline);
    }

    public static void nglGetProgramPipelineiv(int pipeline, int pname, long params) {
        long __functionAddress = GLES31.getInstance().GetProgramPipelineiv;
        JNI.callIIPV(__functionAddress, pipeline, pname, params);
    }

    public static void glGetProgramPipelineiv(int pipeline, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GLES31.nglGetProgramPipelineiv(pipeline, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetProgramPipelineiv(int pipeline, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES31.nglGetProgramPipelineiv(pipeline, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetProgramPipelinei(int pipeline, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GLES31.nglGetProgramPipelineiv(pipeline, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void glProgramUniform1i(int program, int location, int v0) {
        long __functionAddress = GLES31.getInstance().ProgramUniform1i;
        JNI.callIIIV(__functionAddress, program, location, v0);
    }

    public static void glProgramUniform2i(int program, int location, int v0, int v1) {
        long __functionAddress = GLES31.getInstance().ProgramUniform2i;
        JNI.callIIIIV(__functionAddress, program, location, v0, v1);
    }

    public static void glProgramUniform3i(int program, int location, int v0, int v1, int v2) {
        long __functionAddress = GLES31.getInstance().ProgramUniform3i;
        JNI.callIIIIIV(__functionAddress, program, location, v0, v1, v2);
    }

    public static void glProgramUniform4i(int program, int location, int v0, int v1, int v2, int v3) {
        long __functionAddress = GLES31.getInstance().ProgramUniform4i;
        JNI.callIIIIIIV(__functionAddress, program, location, v0, v1, v2, v3);
    }

    public static void glProgramUniform1ui(int program, int location, int v0) {
        long __functionAddress = GLES31.getInstance().ProgramUniform1ui;
        JNI.callIIIV(__functionAddress, program, location, v0);
    }

    public static void glProgramUniform2ui(int program, int location, int v0, int v1) {
        long __functionAddress = GLES31.getInstance().ProgramUniform2ui;
        JNI.callIIIIV(__functionAddress, program, location, v0, v1);
    }

    public static void glProgramUniform3ui(int program, int location, int v0, int v1, int v2) {
        long __functionAddress = GLES31.getInstance().ProgramUniform3ui;
        JNI.callIIIIIV(__functionAddress, program, location, v0, v1, v2);
    }

    public static void glProgramUniform4ui(int program, int location, int v0, int v1, int v2, int v3) {
        long __functionAddress = GLES31.getInstance().ProgramUniform4ui;
        JNI.callIIIIIIV(__functionAddress, program, location, v0, v1, v2, v3);
    }

    public static void glProgramUniform1f(int program, int location, float v0) {
        long __functionAddress = GLES31.getInstance().ProgramUniform1f;
        JNI.callIIFV(__functionAddress, program, location, v0);
    }

    public static void glProgramUniform2f(int program, int location, float v0, float v1) {
        long __functionAddress = GLES31.getInstance().ProgramUniform2f;
        JNI.callIIFFV(__functionAddress, program, location, v0, v1);
    }

    public static void glProgramUniform3f(int program, int location, float v0, float v1, float v2) {
        long __functionAddress = GLES31.getInstance().ProgramUniform3f;
        JNI.callIIFFFV(__functionAddress, program, location, v0, v1, v2);
    }

    public static void glProgramUniform4f(int program, int location, float v0, float v1, float v2, float v3) {
        long __functionAddress = GLES31.getInstance().ProgramUniform4f;
        JNI.callIIFFFFV(__functionAddress, program, location, v0, v1, v2, v3);
    }

    public static void nglProgramUniform1iv(int program, int location, int count, long value) {
        long __functionAddress = GLES31.getInstance().ProgramUniform1iv;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform1iv(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2);
        }
        GLES31.nglProgramUniform1iv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform1iv(int program, int location, IntBuffer value) {
        GLES31.nglProgramUniform1iv(program, location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform2iv(int program, int location, int count, long value) {
        long __functionAddress = GLES31.getInstance().ProgramUniform2iv;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform2iv(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 1 << 2);
        }
        GLES31.nglProgramUniform2iv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform2iv(int program, int location, IntBuffer value) {
        GLES31.nglProgramUniform2iv(program, location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform3iv(int program, int location, int count, long value) {
        long __functionAddress = GLES31.getInstance().ProgramUniform3iv;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform3iv(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 3 << 2);
        }
        GLES31.nglProgramUniform3iv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform3iv(int program, int location, IntBuffer value) {
        GLES31.nglProgramUniform3iv(program, location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform4iv(int program, int location, int count, long value) {
        long __functionAddress = GLES31.getInstance().ProgramUniform4iv;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform4iv(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 2);
        }
        GLES31.nglProgramUniform4iv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform4iv(int program, int location, IntBuffer value) {
        GLES31.nglProgramUniform4iv(program, location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform1uiv(int program, int location, int count, long value) {
        long __functionAddress = GLES31.getInstance().ProgramUniform1uiv;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform1uiv(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2);
        }
        GLES31.nglProgramUniform1uiv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform1uiv(int program, int location, IntBuffer value) {
        GLES31.nglProgramUniform1uiv(program, location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform2uiv(int program, int location, int count, long value) {
        long __functionAddress = GLES31.getInstance().ProgramUniform2uiv;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform2uiv(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 1 << 2);
        }
        GLES31.nglProgramUniform2uiv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform2uiv(int program, int location, IntBuffer value) {
        GLES31.nglProgramUniform2uiv(program, location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform3uiv(int program, int location, int count, long value) {
        long __functionAddress = GLES31.getInstance().ProgramUniform3uiv;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform3uiv(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 3 << 2);
        }
        GLES31.nglProgramUniform3uiv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform3uiv(int program, int location, IntBuffer value) {
        GLES31.nglProgramUniform3uiv(program, location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform4uiv(int program, int location, int count, long value) {
        long __functionAddress = GLES31.getInstance().ProgramUniform4uiv;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform4uiv(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 2);
        }
        GLES31.nglProgramUniform4uiv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform4uiv(int program, int location, IntBuffer value) {
        GLES31.nglProgramUniform4uiv(program, location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform1fv(int program, int location, int count, long value) {
        long __functionAddress = GLES31.getInstance().ProgramUniform1fv;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform1fv(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2);
        }
        GLES31.nglProgramUniform1fv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform1fv(int program, int location, FloatBuffer value) {
        GLES31.nglProgramUniform1fv(program, location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform2fv(int program, int location, int count, long value) {
        long __functionAddress = GLES31.getInstance().ProgramUniform2fv;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform2fv(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 1 << 2);
        }
        GLES31.nglProgramUniform2fv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform2fv(int program, int location, FloatBuffer value) {
        GLES31.nglProgramUniform2fv(program, location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform3fv(int program, int location, int count, long value) {
        long __functionAddress = GLES31.getInstance().ProgramUniform3fv;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform3fv(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 3 << 2);
        }
        GLES31.nglProgramUniform3fv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform3fv(int program, int location, FloatBuffer value) {
        GLES31.nglProgramUniform3fv(program, location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform4fv(int program, int location, int count, long value) {
        long __functionAddress = GLES31.getInstance().ProgramUniform4fv;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform4fv(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 2);
        }
        GLES31.nglProgramUniform4fv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform4fv(int program, int location, FloatBuffer value) {
        GLES31.nglProgramUniform4fv(program, location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix2fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GLES31.getInstance().ProgramUniformMatrix2fv;
        JNI.callIIIZPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix2fv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 2);
        }
        GLES31.nglProgramUniformMatrix2fv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix2fv(int program, int location, boolean transpose, FloatBuffer value) {
        GLES31.nglProgramUniformMatrix2fv(program, location, value.remaining() >> 2, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix3fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GLES31.getInstance().ProgramUniformMatrix3fv;
        JNI.callIIIZPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix3fv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 9 << 2);
        }
        GLES31.nglProgramUniformMatrix3fv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix3fv(int program, int location, boolean transpose, FloatBuffer value) {
        GLES31.nglProgramUniformMatrix3fv(program, location, value.remaining() / 9, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix4fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GLES31.getInstance().ProgramUniformMatrix4fv;
        JNI.callIIIZPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix4fv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 4 << 2);
        }
        GLES31.nglProgramUniformMatrix4fv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix4fv(int program, int location, boolean transpose, FloatBuffer value) {
        GLES31.nglProgramUniformMatrix4fv(program, location, value.remaining() >> 4, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix2x3fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GLES31.getInstance().ProgramUniformMatrix2x3fv;
        JNI.callIIIZPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix2x3fv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 6 << 2);
        }
        GLES31.nglProgramUniformMatrix2x3fv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix2x3fv(int program, int location, boolean transpose, FloatBuffer value) {
        GLES31.nglProgramUniformMatrix2x3fv(program, location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix3x2fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GLES31.getInstance().ProgramUniformMatrix3x2fv;
        JNI.callIIIZPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix3x2fv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 6 << 2);
        }
        GLES31.nglProgramUniformMatrix3x2fv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix3x2fv(int program, int location, boolean transpose, FloatBuffer value) {
        GLES31.nglProgramUniformMatrix3x2fv(program, location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix2x4fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GLES31.getInstance().ProgramUniformMatrix2x4fv;
        JNI.callIIIZPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix2x4fv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 3 << 2);
        }
        GLES31.nglProgramUniformMatrix2x4fv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix2x4fv(int program, int location, boolean transpose, FloatBuffer value) {
        GLES31.nglProgramUniformMatrix2x4fv(program, location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix4x2fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GLES31.getInstance().ProgramUniformMatrix4x2fv;
        JNI.callIIIZPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix4x2fv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 3 << 2);
        }
        GLES31.nglProgramUniformMatrix4x2fv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix4x2fv(int program, int location, boolean transpose, FloatBuffer value) {
        GLES31.nglProgramUniformMatrix4x2fv(program, location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix3x4fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GLES31.getInstance().ProgramUniformMatrix3x4fv;
        JNI.callIIIZPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix3x4fv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 12 << 2);
        }
        GLES31.nglProgramUniformMatrix3x4fv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix3x4fv(int program, int location, boolean transpose, FloatBuffer value) {
        GLES31.nglProgramUniformMatrix3x4fv(program, location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix4x3fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GLES31.getInstance().ProgramUniformMatrix4x3fv;
        JNI.callIIIZPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix4x3fv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 12 << 2);
        }
        GLES31.nglProgramUniformMatrix4x3fv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix4x3fv(int program, int location, boolean transpose, FloatBuffer value) {
        GLES31.nglProgramUniformMatrix4x3fv(program, location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static void glValidateProgramPipeline(int pipeline) {
        long __functionAddress = GLES31.getInstance().ValidateProgramPipeline;
        JNI.callIV(__functionAddress, pipeline);
    }

    public static void nglGetProgramPipelineInfoLog(int pipeline, int bufSize, long length, long infoLog) {
        long __functionAddress = GLES31.getInstance().GetProgramPipelineInfoLog;
        JNI.callIIPPV(__functionAddress, pipeline, bufSize, length, infoLog);
    }

    public static void glGetProgramPipelineInfoLog(int pipeline, int bufSize, ByteBuffer length, ByteBuffer infoLog) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)infoLog, bufSize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        GLES31.nglGetProgramPipelineInfoLog(pipeline, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(infoLog));
    }

    public static void glGetProgramPipelineInfoLog(int pipeline, IntBuffer length, ByteBuffer infoLog) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        GLES31.nglGetProgramPipelineInfoLog(pipeline, infoLog.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(infoLog));
    }

    public static String glGetProgramPipelineInfoLog(int pipeline, int bufSize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int infoLog = __buffer.bufferParam(bufSize);
        GLES31.nglGetProgramPipelineInfoLog(pipeline, bufSize, __buffer.address(length), __buffer.address(infoLog));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), infoLog);
    }

    public static String glGetProgramPipelineInfoLog(int pipeline) {
        int bufSize = GLES31.glGetProgramPipelinei(pipeline, 35716);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int infoLog = __buffer.bufferParam(bufSize);
        GLES31.nglGetProgramPipelineInfoLog(pipeline, bufSize, __buffer.address(length), __buffer.address(infoLog));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), infoLog);
    }

    public static void glBindImageTexture(int unit, int texture, int level, boolean layered, int layer, int access, int format) {
        long __functionAddress = GLES31.getInstance().BindImageTexture;
        JNI.callIIIZIIIV(__functionAddress, unit, texture, level, layered, layer, access, format);
    }

    public static void nglGetBooleani_v(int target, int index, long data) {
        long __functionAddress = GLES31.getInstance().GetBooleani_v;
        JNI.callIIPV(__functionAddress, target, index, data);
    }

    public static void glGetBooleani_v(int target, int index, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 1);
        }
        GLES31.nglGetBooleani_v(target, index, MemoryUtil.memAddress(data));
    }

    public static boolean glGetBooleani(int target, int index) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int data = __buffer.booleanParam();
        GLES31.nglGetBooleani_v(target, index, __buffer.address(data));
        return __buffer.booleanValue(data);
    }

    public static void glMemoryBarrier(int barriers) {
        long __functionAddress = GLES31.getInstance().MemoryBarrier;
        JNI.callIV(__functionAddress, barriers);
    }

    public static void glMemoryBarrierByRegion(int barriers) {
        long __functionAddress = GLES31.getInstance().MemoryBarrierByRegion;
        JNI.callIV(__functionAddress, barriers);
    }

    public static void glTexStorage2DMultisample(int target, int samples, int internalformat, int width, int height, boolean fixedsamplelocations) {
        long __functionAddress = GLES31.getInstance().TexStorage2DMultisample;
        JNI.callIIIIIZV(__functionAddress, target, samples, internalformat, width, height, fixedsamplelocations);
    }

    public static void nglGetMultisamplefv(int pname, int index, long val) {
        long __functionAddress = GLES31.getInstance().GetMultisamplefv;
        JNI.callIIPV(__functionAddress, pname, index, val);
    }

    public static void glGetMultisamplefv(int pname, int index, ByteBuffer val) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)val, 4);
        }
        GLES31.nglGetMultisamplefv(pname, index, MemoryUtil.memAddress(val));
    }

    public static void glGetMultisamplefv(int pname, int index, FloatBuffer val) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)val, 1);
        }
        GLES31.nglGetMultisamplefv(pname, index, MemoryUtil.memAddress(val));
    }

    public static float glGetMultisamplef(int pname, int index) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int val = __buffer.floatParam();
        GLES31.nglGetMultisamplefv(pname, index, __buffer.address(val));
        return __buffer.floatValue(val);
    }

    public static void glSampleMaski(int maskNumber, int mask) {
        long __functionAddress = GLES31.getInstance().SampleMaski;
        JNI.callIIV(__functionAddress, maskNumber, mask);
    }

    public static void nglGetTexLevelParameteriv(int target, int level, int pname, long params) {
        long __functionAddress = GLES31.getInstance().GetTexLevelParameteriv;
        JNI.callIIIPV(__functionAddress, target, level, pname, params);
    }

    public static void glGetTexLevelParameteriv(int target, int level, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GLES31.nglGetTexLevelParameteriv(target, level, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetTexLevelParameteriv(int target, int level, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES31.nglGetTexLevelParameteriv(target, level, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetTexLevelParameteri(int target, int level, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GLES31.nglGetTexLevelParameteriv(target, level, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetTexLevelParameterfv(int target, int level, int pname, long params) {
        long __functionAddress = GLES31.getInstance().GetTexLevelParameterfv;
        JNI.callIIIPV(__functionAddress, target, level, pname, params);
    }

    public static void glGetTexLevelParameterfv(int target, int level, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GLES31.nglGetTexLevelParameterfv(target, level, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetTexLevelParameterfv(int target, int level, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES31.nglGetTexLevelParameterfv(target, level, pname, MemoryUtil.memAddress(params));
    }

    public static float glGetTexLevelParameterf(int target, int level, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.floatParam();
        GLES31.nglGetTexLevelParameterfv(target, level, pname, __buffer.address(params));
        return __buffer.floatValue(params);
    }

    public static void glBindVertexBuffer(int bindingindex, int buffer, long offset, int stride) {
        long __functionAddress = GLES31.getInstance().BindVertexBuffer;
        JNI.callIIPIV(__functionAddress, bindingindex, buffer, offset, stride);
    }

    public static void glVertexAttribFormat(int attribindex, int size, int type, boolean normalized, int relativeoffset) {
        long __functionAddress = GLES31.getInstance().VertexAttribFormat;
        JNI.callIIIZIV(__functionAddress, attribindex, size, type, normalized, relativeoffset);
    }

    public static void glVertexAttribIFormat(int attribindex, int size, int type, int relativeoffset) {
        long __functionAddress = GLES31.getInstance().VertexAttribIFormat;
        JNI.callIIIIV(__functionAddress, attribindex, size, type, relativeoffset);
    }

    public static void glVertexAttribBinding(int attribindex, int bindingindex) {
        long __functionAddress = GLES31.getInstance().VertexAttribBinding;
        JNI.callIIV(__functionAddress, attribindex, bindingindex);
    }

    public static void glVertexBindingDivisor(int bindingindex, int divisor) {
        long __functionAddress = GLES31.getInstance().VertexBindingDivisor;
        JNI.callIIV(__functionAddress, bindingindex, divisor);
    }
}

