/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLDebugMessageCallback;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLES20;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.opengles.GLESChecks;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class GLES32 {
    public static final int GL_MULTISAMPLE_LINE_WIDTH_RANGE_ARB = 37761;
    public static final int GL_MULTISAMPLE_LINE_WIDTH_GRANULARITY_ARB = 37762;
    public static final int GL_MULTIPLY = 37524;
    public static final int GL_SCREEN = 37525;
    public static final int GL_OVERLAY = 37526;
    public static final int GL_DARKEN = 37527;
    public static final int GL_LIGHTEN = 37528;
    public static final int GL_COLORDODGE = 37529;
    public static final int GL_COLORBURN = 37530;
    public static final int GL_HARDLIGHT = 37531;
    public static final int GL_SOFTLIGHT = 37532;
    public static final int GL_DIFFERENCE = 37534;
    public static final int GL_EXCLUSION = 37536;
    public static final int GL_HSL_HUE = 37549;
    public static final int GL_HSL_SATURATION = 37550;
    public static final int GL_HSL_COLOR = 37551;
    public static final int GL_HSL_LUMINOSITY = 37552;
    public static final int GL_DEBUG_OUTPUT = 37600;
    public static final int GL_DEBUG_OUTPUT_SYNCHRONOUS = 33346;
    public static final int GL_CONTEXT_FLAG_DEBUG_BIT = 2;
    public static final int GL_MAX_DEBUG_MESSAGE_LENGTH = 37187;
    public static final int GL_MAX_DEBUG_LOGGED_MESSAGES = 37188;
    public static final int GL_DEBUG_LOGGED_MESSAGES = 37189;
    public static final int GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH = 33347;
    public static final int GL_MAX_DEBUG_GROUP_STACK_DEPTH = 33388;
    public static final int GL_DEBUG_GROUP_STACK_DEPTH = 33389;
    public static final int GL_MAX_LABEL_LENGTH = 33512;
    public static final int GL_DEBUG_CALLBACK_FUNCTION = 33348;
    public static final int GL_DEBUG_CALLBACK_USER_PARAM = 33349;
    public static final int GL_DEBUG_SOURCE_API = 33350;
    public static final int GL_DEBUG_SOURCE_WINDOW_SYSTEM = 33351;
    public static final int GL_DEBUG_SOURCE_SHADER_COMPILER = 33352;
    public static final int GL_DEBUG_SOURCE_THIRD_PARTY = 33353;
    public static final int GL_DEBUG_SOURCE_APPLICATION = 33354;
    public static final int GL_DEBUG_SOURCE_OTHER = 33355;
    public static final int GL_DEBUG_TYPE_ERROR = 33356;
    public static final int GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR = 33357;
    public static final int GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR = 33358;
    public static final int GL_DEBUG_TYPE_PORTABILITY = 33359;
    public static final int GL_DEBUG_TYPE_PERFORMANCE = 33360;
    public static final int GL_DEBUG_TYPE_OTHER = 33361;
    public static final int GL_DEBUG_TYPE_MARKER = 33384;
    public static final int GL_DEBUG_TYPE_PUSH_GROUP = 33385;
    public static final int GL_DEBUG_TYPE_POP_GROUP = 33386;
    public static final int GL_DEBUG_SEVERITY_HIGH = 37190;
    public static final int GL_DEBUG_SEVERITY_MEDIUM = 37191;
    public static final int GL_DEBUG_SEVERITY_LOW = 37192;
    public static final int GL_DEBUG_SEVERITY_NOTIFICATION = 33387;
    public static final int GL_STACK_UNDERFLOW = 1284;
    public static final int GL_STACK_OVERFLOW = 1283;
    public static final int GL_BUFFER = 33504;
    public static final int GL_SHADER = 33505;
    public static final int GL_PROGRAM = 33506;
    public static final int GL_QUERY = 33507;
    public static final int GL_PROGRAM_PIPELINE = 33508;
    public static final int GL_SAMPLER = 33510;
    public static final int GL_GEOMETRY_SHADER = 36313;
    public static final int GL_GEOMETRY_SHADER_BIT = 4;
    public static final int GL_GEOMETRY_LINKED_VERTICES_OUT = 35094;
    public static final int GL_GEOMETRY_LINKED_INPUT_TYPE = 35095;
    public static final int GL_GEOMETRY_LINKED_OUTPUT_TYPE = 35096;
    public static final int GL_GEOMETRY_SHADER_INVOCATIONS = 34943;
    public static final int GL_LAYER_PROVOKING_VERTEX = 33374;
    public static final int GL_MAX_GEOMETRY_UNIFORM_COMPONENTS = 36319;
    public static final int GL_MAX_GEOMETRY_UNIFORM_BLOCKS = 35372;
    public static final int GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS = 35378;
    public static final int GL_MAX_GEOMETRY_INPUT_COMPONENTS = 37155;
    public static final int GL_MAX_GEOMETRY_OUTPUT_COMPONENTS = 37156;
    public static final int GL_MAX_GEOMETRY_OUTPUT_VERTICES = 36320;
    public static final int GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS = 36321;
    public static final int GL_MAX_GEOMETRY_SHADER_INVOCATIONS = 36442;
    public static final int GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS = 35881;
    public static final int GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS = 37583;
    public static final int GL_MAX_GEOMETRY_ATOMIC_COUNTERS = 37589;
    public static final int GL_MAX_GEOMETRY_IMAGE_UNIFORMS = 37069;
    public static final int GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS = 37079;
    public static final int GL_FIRST_VERTEX_CONVENTION = 36429;
    public static final int GL_LAST_VERTEX_CONVENTION = 36430;
    public static final int GL_UNDEFINED_VERTEX = 33376;
    public static final int GL_PRIMITIVES_GENERATED = 35975;
    public static final int GL_LINES_ADJACENCY = 10;
    public static final int GL_LINE_STRIP_ADJACENCY = 11;
    public static final int GL_TRIANGLES_ADJACENCY = 12;
    public static final int GL_TRIANGLE_STRIP_ADJACENCY = 13;
    public static final int GL_FRAMEBUFFER_DEFAULT_LAYERS = 37650;
    public static final int GL_MAX_FRAMEBUFFER_LAYERS = 37655;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS = 36264;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_LAYERED = 36263;
    public static final int GL_REFERENCED_BY_GEOMETRY_SHADER = 37641;
    public static final int GL_PRIMITIVE_BOUNDING_BOX_ARB = 37566;
    public static final int GL_NO_ERROR = 0;
    public static final int GL_GUILTY_CONTEXT_RESET = 33363;
    public static final int GL_INNOCENT_CONTEXT_RESET = 33364;
    public static final int GL_UNKNOWN_CONTEXT_RESET = 33365;
    public static final int GL_CONTEXT_ROBUST_ACCESS = 37107;
    public static final int GL_RESET_NOTIFICATION_STRATEGY = 33366;
    public static final int GL_LOSE_CONTEXT_ON_RESET = 33362;
    public static final int GL_NO_RESET_NOTIFICATION = 33377;
    public static final int GL_CONTEXT_LOST = 1287;
    public static final int GL_SAMPLE_SHADING = 35894;
    public static final int GL_MIN_SAMPLE_SHADING_VALUE = 35895;
    public static final int GL_MIN_FRAGMENT_INTERPOLATION_OFFSET = 36443;
    public static final int GL_MAX_FRAGMENT_INTERPOLATION_OFFSET = 36444;
    public static final int GL_FRAGMENT_INTERPOLATION_OFFSET_BITS = 36445;
    public static final int GL_PATCHES = 14;
    public static final int GL_PATCH_VERTICES = 36466;
    public static final int GL_TESS_CONTROL_OUTPUT_VERTICES = 36469;
    public static final int GL_TESS_GEN_MODE = 36470;
    public static final int GL_TESS_GEN_SPACING = 36471;
    public static final int GL_TESS_GEN_VERTEX_ORDER = 36472;
    public static final int GL_TESS_GEN_POINT_MODE = 36473;
    public static final int GL_ISOLINES = 36474;
    public static final int GL_QUADS = 7;
    public static final int GL_FRACTIONAL_ODD = 36475;
    public static final int GL_FRACTIONAL_EVEN = 36476;
    public static final int GL_MAX_PATCH_VERTICES = 36477;
    public static final int GL_MAX_TESS_GEN_LEVEL = 36478;
    public static final int GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS = 36479;
    public static final int GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS = 36480;
    public static final int GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS = 36481;
    public static final int GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS = 36482;
    public static final int GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS = 36483;
    public static final int GL_MAX_TESS_PATCH_COMPONENTS = 36484;
    public static final int GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS = 36485;
    public static final int GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS = 36486;
    public static final int GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS = 36489;
    public static final int GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS = 36490;
    public static final int GL_MAX_TESS_CONTROL_INPUT_COMPONENTS = 34924;
    public static final int GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS = 34925;
    public static final int GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS = 36382;
    public static final int GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS = 36383;
    public static final int GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS = 37581;
    public static final int GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS = 37582;
    public static final int GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS = 37587;
    public static final int GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS = 37588;
    public static final int GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS = 37067;
    public static final int GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS = 37068;
    public static final int GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS = 37080;
    public static final int GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS = 37081;
    public static final int GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED = 33313;
    public static final int GL_IS_PER_PATCH = 37607;
    public static final int GL_REFERENCED_BY_TESS_CONTROL_SHADER = 37639;
    public static final int GL_REFERENCED_BY_TESS_EVALUATION_SHADER = 37640;
    public static final int GL_TESS_EVALUATION_SHADER = 36487;
    public static final int GL_TESS_CONTROL_SHADER = 36488;
    public static final int GL_TESS_CONTROL_SHADER_BIT = 8;
    public static final int GL_TESS_EVALUATION_SHADER_BIT = 16;
    public static final int GL_TEXTURE_BORDER_COLOR = 4100;
    public static final int GL_CLAMP_TO_BORDER = 33069;
    public static final int GL_TEXTURE_BUFFER = 35882;
    public static final int GL_TEXTURE_BUFFER_BINDING = 35882;
    public static final int GL_SAMPLER_BUFFER = 36290;
    public static final int GL_INT_SAMPLER_BUFFER = 36304;
    public static final int GL_UNSIGNED_INT_SAMPLER_BUFFER = 36312;
    public static final int GL_IMAGE_BUFFER = 36945;
    public static final int GL_INT_IMAGE_BUFFER = 36956;
    public static final int GL_UNSIGNED_INT_IMAGE_BUFFER = 36967;
    public static final int GL_TEXTURE_BUFFER_DATA_STORE_BINDING = 35885;
    public static final int GL_TEXTURE_BUFFER_OFFSET = 37277;
    public static final int GL_TEXTURE_BUFFER_SIZE = 37278;
    public static final int GL_COMPRESSED_RGBA_ASTC_4x4 = 37808;
    public static final int GL_COMPRESSED_RGBA_ASTC_5x4 = 37809;
    public static final int GL_COMPRESSED_RGBA_ASTC_5x5 = 37810;
    public static final int GL_COMPRESSED_RGBA_ASTC_6x5 = 37811;
    public static final int GL_COMPRESSED_RGBA_ASTC_6x6 = 37812;
    public static final int GL_COMPRESSED_RGBA_ASTC_8x5 = 37813;
    public static final int GL_COMPRESSED_RGBA_ASTC_8x6 = 37814;
    public static final int GL_COMPRESSED_RGBA_ASTC_8x8 = 37815;
    public static final int GL_COMPRESSED_RGBA_ASTC_10x5 = 37816;
    public static final int GL_COMPRESSED_RGBA_ASTC_10x6 = 37817;
    public static final int GL_COMPRESSED_RGBA_ASTC_10x8 = 37818;
    public static final int GL_COMPRESSED_RGBA_ASTC_10x10 = 37819;
    public static final int GL_COMPRESSED_RGBA_ASTC_12x10 = 37820;
    public static final int GL_COMPRESSED_RGBA_ASTC_12x12 = 37821;
    public static final int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4 = 37840;
    public static final int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4 = 37841;
    public static final int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5 = 37842;
    public static final int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5 = 37843;
    public static final int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6 = 37844;
    public static final int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5 = 37845;
    public static final int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6 = 37846;
    public static final int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8 = 37847;
    public static final int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5 = 37848;
    public static final int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6 = 37849;
    public static final int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8 = 37850;
    public static final int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10 = 37851;
    public static final int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10 = 37852;
    public static final int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12 = 37853;
    public static final int GL_TEXTURE_CUBE_MAP_ARRAY = 36873;
    public static final int GL_TEXTURE_BINDING_CUBE_MAP_ARRAY = 36874;
    public static final int GL_SAMPLER_CUBE_MAP_ARRAY = 36876;
    public static final int GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW = 36877;
    public static final int GL_INT_SAMPLER_CUBE_MAP_ARRAY = 36878;
    public static final int GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY = 36879;
    public static final int GL_IMAGE_CUBE_MAP_ARRAY = 36948;
    public static final int GL_INT_IMAGE_CUBE_MAP_ARRAY = 36959;
    public static final int GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY = 36970;
    public static final int GL_TEXTURE_2D_MULTISAMPLE_ARRAY = 37122;
    public static final int GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY = 37125;
    public static final int GL_SAMPLER_2D_MULTISAMPLE_ARRAY = 37131;
    public static final int GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = 37132;
    public static final int GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = 37133;
    public final long BlendBarrier;
    public final long CopyImageSubData;
    public final long DebugMessageControl;
    public final long DebugMessageInsert;
    public final long DebugMessageCallback;
    public final long GetDebugMessageLog;
    public final long GetPointerv;
    public final long PushDebugGroup;
    public final long PopDebugGroup;
    public final long ObjectLabel;
    public final long GetObjectLabel;
    public final long ObjectPtrLabel;
    public final long GetObjectPtrLabel;
    public final long Enablei;
    public final long Disablei;
    public final long BlendEquationi;
    public final long BlendEquationSeparatei;
    public final long BlendFunci;
    public final long BlendFuncSeparatei;
    public final long ColorMaski;
    public final long IsEnabledi;
    public final long DrawElementsBaseVertex;
    public final long DrawRangeElementsBaseVertex;
    public final long DrawElementsInstancedBaseVertex;
    public final long FramebufferTexture;
    public final long PrimitiveBoundingBox;
    public final long GetGraphicsResetStatus;
    public final long ReadnPixels;
    public final long GetnUniformfv;
    public final long GetnUniformiv;
    public final long GetnUniformuiv;
    public final long MinSampleShading;
    public final long PatchParameteri;
    public final long TexParameterIiv;
    public final long TexParameterIuiv;
    public final long GetTexParameterIiv;
    public final long GetTexParameterIuiv;
    public final long SamplerParameterIiv;
    public final long SamplerParameterIuiv;
    public final long GetSamplerParameterIiv;
    public final long GetSamplerParameterIuiv;
    public final long TexBuffer;
    public final long TexBufferRange;
    public final long TexStorage3DMultisample;

    protected GLES32() {
        throw new UnsupportedOperationException();
    }

    public GLES32(FunctionProvider provider) {
        this.BlendBarrier = provider.getFunctionAddress("glBlendBarrier");
        this.CopyImageSubData = provider.getFunctionAddress("glCopyImageSubData");
        this.DebugMessageControl = provider.getFunctionAddress("glDebugMessageControl");
        this.DebugMessageInsert = provider.getFunctionAddress("glDebugMessageInsert");
        this.DebugMessageCallback = provider.getFunctionAddress("glDebugMessageCallback");
        this.GetDebugMessageLog = provider.getFunctionAddress("glGetDebugMessageLog");
        this.GetPointerv = provider.getFunctionAddress("glGetPointerv");
        this.PushDebugGroup = provider.getFunctionAddress("glPushDebugGroup");
        this.PopDebugGroup = provider.getFunctionAddress("glPopDebugGroup");
        this.ObjectLabel = provider.getFunctionAddress("glObjectLabel");
        this.GetObjectLabel = provider.getFunctionAddress("glGetObjectLabel");
        this.ObjectPtrLabel = provider.getFunctionAddress("glObjectPtrLabel");
        this.GetObjectPtrLabel = provider.getFunctionAddress("glGetObjectPtrLabel");
        this.Enablei = provider.getFunctionAddress("glEnablei");
        this.Disablei = provider.getFunctionAddress("glDisablei");
        this.BlendEquationi = provider.getFunctionAddress("glBlendEquationi");
        this.BlendEquationSeparatei = provider.getFunctionAddress("glBlendEquationSeparatei");
        this.BlendFunci = provider.getFunctionAddress("glBlendFunci");
        this.BlendFuncSeparatei = provider.getFunctionAddress("glBlendFuncSeparatei");
        this.ColorMaski = provider.getFunctionAddress("glColorMaski");
        this.IsEnabledi = provider.getFunctionAddress("glIsEnabledi");
        this.DrawElementsBaseVertex = provider.getFunctionAddress("glDrawElementsBaseVertex");
        this.DrawRangeElementsBaseVertex = provider.getFunctionAddress("glDrawRangeElementsBaseVertex");
        this.DrawElementsInstancedBaseVertex = provider.getFunctionAddress("glDrawElementsInstancedBaseVertex");
        this.FramebufferTexture = provider.getFunctionAddress("glFramebufferTexture");
        this.PrimitiveBoundingBox = provider.getFunctionAddress("glPrimitiveBoundingBox");
        this.GetGraphicsResetStatus = provider.getFunctionAddress("glGetGraphicsResetStatus");
        this.ReadnPixels = provider.getFunctionAddress("glReadnPixels");
        this.GetnUniformfv = provider.getFunctionAddress("glGetnUniformfv");
        this.GetnUniformiv = provider.getFunctionAddress("glGetnUniformiv");
        this.GetnUniformuiv = provider.getFunctionAddress("glGetnUniformuiv");
        this.MinSampleShading = provider.getFunctionAddress("glMinSampleShading");
        this.PatchParameteri = provider.getFunctionAddress("glPatchParameteri");
        this.TexParameterIiv = provider.getFunctionAddress("glTexParameterIiv");
        this.TexParameterIuiv = provider.getFunctionAddress("glTexParameterIuiv");
        this.GetTexParameterIiv = provider.getFunctionAddress("glGetTexParameterIiv");
        this.GetTexParameterIuiv = provider.getFunctionAddress("glGetTexParameterIuiv");
        this.SamplerParameterIiv = provider.getFunctionAddress("glSamplerParameterIiv");
        this.SamplerParameterIuiv = provider.getFunctionAddress("glSamplerParameterIuiv");
        this.GetSamplerParameterIiv = provider.getFunctionAddress("glGetSamplerParameterIiv");
        this.GetSamplerParameterIuiv = provider.getFunctionAddress("glGetSamplerParameterIuiv");
        this.TexBuffer = provider.getFunctionAddress("glTexBuffer");
        this.TexBufferRange = provider.getFunctionAddress("glTexBufferRange");
        this.TexStorage3DMultisample = provider.getFunctionAddress("glTexStorage3DMultisample");
    }

    public static GLES32 getInstance() {
        return GLES32.getInstance(GLES.getCapabilities());
    }

    public static GLES32 getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__GLES32);
    }

    static GLES32 create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GLES32")) {
            return null;
        }
        GLES32 funcs = new GLES32(provider);
        boolean supported = Checks.checkFunctions(funcs.BlendBarrier, funcs.CopyImageSubData, funcs.DebugMessageControl, funcs.DebugMessageInsert, funcs.DebugMessageCallback, funcs.GetDebugMessageLog, funcs.GetPointerv, funcs.PushDebugGroup, funcs.PopDebugGroup, funcs.ObjectLabel, funcs.GetObjectLabel, funcs.ObjectPtrLabel, funcs.GetObjectPtrLabel, funcs.Enablei, funcs.Disablei, funcs.BlendEquationi, funcs.BlendEquationSeparatei, funcs.BlendFunci, funcs.BlendFuncSeparatei, funcs.ColorMaski, funcs.IsEnabledi, funcs.DrawElementsBaseVertex, funcs.DrawRangeElementsBaseVertex, funcs.DrawElementsInstancedBaseVertex, funcs.FramebufferTexture, funcs.PrimitiveBoundingBox, funcs.GetGraphicsResetStatus, funcs.ReadnPixels, funcs.GetnUniformfv, funcs.GetnUniformiv, funcs.GetnUniformuiv, funcs.MinSampleShading, funcs.PatchParameteri, funcs.TexParameterIiv, funcs.TexParameterIuiv, funcs.GetTexParameterIiv, funcs.GetTexParameterIuiv, funcs.SamplerParameterIiv, funcs.SamplerParameterIuiv, funcs.GetSamplerParameterIiv, funcs.GetSamplerParameterIuiv, funcs.TexBuffer, funcs.TexBufferRange, funcs.TexStorage3DMultisample);
        return GLES.checkExtension("GLES32", funcs, supported);
    }

    public static void glBlendBarrier() {
        long __functionAddress = GLES32.getInstance().BlendBarrier;
        JNI.callV(__functionAddress);
    }

    public static void glCopyImageSubData(int srcName, int srcTarget, int srcLevel, int srcX, int srcY, int srcZ, int dstName, int dstTarget, int dstLevel, int dstX, int dstY, int dstZ, int srcWidth, int srcHeight, int srcDepth) {
        long __functionAddress = GLES32.getInstance().CopyImageSubData;
        JNI.callIIIIIIIIIIIIIIIV(__functionAddress, srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight, srcDepth);
    }

    public static void nglDebugMessageControl(int source, int type, int severity, int count, long ids, boolean enabled) {
        long __functionAddress = GLES32.getInstance().DebugMessageControl;
        JNI.callIIIIPZV(__functionAddress, source, type, severity, count, ids, enabled);
    }

    public static void glDebugMessageControl(int source, int type, int severity, int count, ByteBuffer ids, boolean enabled) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)ids, count << 2);
        }
        GLES32.nglDebugMessageControl(source, type, severity, count, MemoryUtil.memAddress(ids), enabled);
    }

    public static void glDebugMessageControl(int source, int type, int severity, IntBuffer ids, boolean enabled) {
        GLES32.nglDebugMessageControl(source, type, severity, ids.remaining(), MemoryUtil.memAddress(ids), enabled);
    }

    public static void glDebugMessageControl(int source, int type, int severity, int id, boolean enabled) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int ids = __buffer.intParam(id);
        GLES32.nglDebugMessageControl(source, type, severity, 1, __buffer.address(ids), enabled);
    }

    public static void nglDebugMessageInsert(int source, int type, int id, int severity, int length, long message) {
        long __functionAddress = GLES32.getInstance().DebugMessageInsert;
        JNI.callIIIIIPV(__functionAddress, source, type, id, severity, length, message);
    }

    public static void glDebugMessageInsert(int source, int type, int id, int severity, int length, ByteBuffer message) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)message, length);
        }
        GLES32.nglDebugMessageInsert(source, type, id, severity, length, MemoryUtil.memAddress(message));
    }

    public static void glDebugMessageInsert(int source, int type, int id, int severity, ByteBuffer message) {
        GLES32.nglDebugMessageInsert(source, type, id, severity, message.remaining(), MemoryUtil.memAddress(message));
    }

    public static void glDebugMessageInsert(int source, int type, int id, int severity, CharSequence message) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int messageEncoded = __buffer.stringParamUTF8(message, false);
        int messageEncodedLen = __buffer.getOffset() - messageEncoded;
        GLES32.nglDebugMessageInsert(source, type, id, severity, messageEncodedLen, __buffer.address(messageEncoded));
    }

    public static void glDebugMessageCallback(GLDebugMessageCallback callback, long userParam) {
        long __functionAddress = GLES32.getInstance().DebugMessageCallback;
        JNI.callPPV(__functionAddress, callback == null ? 0L : callback.address(), userParam);
    }

    public static int nglGetDebugMessageLog(int count, int bufsize, long sources, long types, long ids, long severities, long lengths, long messageLog) {
        long __functionAddress = GLES32.getInstance().GetDebugMessageLog;
        return JNI.callIIPPPPPPI(__functionAddress, count, bufsize, sources, types, ids, severities, lengths, messageLog);
    }

    public static int glGetDebugMessageLog(int count, int bufsize, ByteBuffer sources, ByteBuffer types, ByteBuffer ids, ByteBuffer severities, ByteBuffer lengths, ByteBuffer messageLog) {
        if (Checks.CHECKS) {
            if (messageLog != null) {
                Checks.checkBuffer((Buffer)messageLog, bufsize);
            }
            if (sources != null) {
                Checks.checkBuffer((Buffer)sources, count << 2);
            }
            if (types != null) {
                Checks.checkBuffer((Buffer)types, count << 2);
            }
            if (ids != null) {
                Checks.checkBuffer((Buffer)ids, count << 2);
            }
            if (severities != null) {
                Checks.checkBuffer((Buffer)severities, count << 2);
            }
            if (lengths != null) {
                Checks.checkBuffer((Buffer)lengths, count << 2);
            }
        }
        return GLES32.nglGetDebugMessageLog(count, bufsize, MemoryUtil.memAddressSafe(sources), MemoryUtil.memAddressSafe(types), MemoryUtil.memAddressSafe(ids), MemoryUtil.memAddressSafe(severities), MemoryUtil.memAddressSafe(lengths), MemoryUtil.memAddressSafe(messageLog));
    }

    public static int glGetDebugMessageLog(int count, IntBuffer sources, IntBuffer types, IntBuffer ids, IntBuffer severities, IntBuffer lengths, ByteBuffer messageLog) {
        if (Checks.CHECKS) {
            if (sources != null) {
                Checks.checkBuffer((Buffer)sources, count);
            }
            if (types != null) {
                Checks.checkBuffer((Buffer)types, count);
            }
            if (ids != null) {
                Checks.checkBuffer((Buffer)ids, count);
            }
            if (severities != null) {
                Checks.checkBuffer((Buffer)severities, count);
            }
            if (lengths != null) {
                Checks.checkBuffer((Buffer)lengths, count);
            }
        }
        return GLES32.nglGetDebugMessageLog(count, messageLog == null ? 0 : messageLog.remaining(), MemoryUtil.memAddressSafe(sources), MemoryUtil.memAddressSafe(types), MemoryUtil.memAddressSafe(ids), MemoryUtil.memAddressSafe(severities), MemoryUtil.memAddressSafe(lengths), MemoryUtil.memAddressSafe(messageLog));
    }

    public static void nglGetPointerv(int pname, long params) {
        long __functionAddress = GLES32.getInstance().GetPointerv;
        JNI.callIPV(__functionAddress, pname, params);
    }

    public static void glGetPointerv(int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1 << Pointer.POINTER_SHIFT);
        }
        GLES32.nglGetPointerv(pname, MemoryUtil.memAddress(params));
    }

    public static void glGetPointerv(int pname, PointerBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(params, 1);
        }
        GLES32.nglGetPointerv(pname, MemoryUtil.memAddress(params));
    }

    public static long glGetPointer(int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.pointerParam();
        GLES32.nglGetPointerv(pname, __buffer.address(params));
        return __buffer.pointerValue(params);
    }

    public static void nglPushDebugGroup(int source, int id, int length, long message) {
        long __functionAddress = GLES32.getInstance().PushDebugGroup;
        JNI.callIIIPV(__functionAddress, source, id, length, message);
    }

    public static void glPushDebugGroup(int source, int id, int length, ByteBuffer message) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)message, length);
        }
        GLES32.nglPushDebugGroup(source, id, length, MemoryUtil.memAddress(message));
    }

    public static void glPushDebugGroup(int source, int id, ByteBuffer message) {
        GLES32.nglPushDebugGroup(source, id, message.remaining(), MemoryUtil.memAddress(message));
    }

    public static void glPushDebugGroup(int source, int id, CharSequence message) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int messageEncoded = __buffer.stringParamUTF8(message, false);
        int messageEncodedLen = __buffer.getOffset() - messageEncoded;
        GLES32.nglPushDebugGroup(source, id, messageEncodedLen, __buffer.address(messageEncoded));
    }

    public static void glPopDebugGroup() {
        long __functionAddress = GLES32.getInstance().PopDebugGroup;
        JNI.callV(__functionAddress);
    }

    public static void nglObjectLabel(int identifier, int name, int length, long label) {
        long __functionAddress = GLES32.getInstance().ObjectLabel;
        JNI.callIIIPV(__functionAddress, identifier, name, length, label);
    }

    public static void glObjectLabel(int identifier, int name, int length, ByteBuffer label) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)label, length);
        }
        GLES32.nglObjectLabel(identifier, name, length, MemoryUtil.memAddress(label));
    }

    public static void glObjectLabel(int identifier, int name, ByteBuffer label) {
        GLES32.nglObjectLabel(identifier, name, label.remaining(), MemoryUtil.memAddress(label));
    }

    public static void glObjectLabel(int identifier, int name, CharSequence label) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int labelEncoded = __buffer.stringParamUTF8(label, false);
        int labelEncodedLen = __buffer.getOffset() - labelEncoded;
        GLES32.nglObjectLabel(identifier, name, labelEncodedLen, __buffer.address(labelEncoded));
    }

    public static void nglGetObjectLabel(int identifier, int name, int bufSize, long length, long label) {
        long __functionAddress = GLES32.getInstance().GetObjectLabel;
        JNI.callIIIPPV(__functionAddress, identifier, name, bufSize, length, label);
    }

    public static void glGetObjectLabel(int identifier, int name, int bufSize, ByteBuffer length, ByteBuffer label) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)label, bufSize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        GLES32.nglGetObjectLabel(identifier, name, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(label));
    }

    public static void glGetObjectLabel(int identifier, int name, IntBuffer length, ByteBuffer label) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        GLES32.nglGetObjectLabel(identifier, name, label.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(label));
    }

    public static String glGetObjectLabel(int identifier, int name, int bufSize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int label = __buffer.bufferParam(bufSize);
        GLES32.nglGetObjectLabel(identifier, name, bufSize, __buffer.address(length), __buffer.address(label));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), label);
    }

    public static String glGetObjectLabel(int identifier, int name) {
        int bufSize = GLES20.glGetInteger(33512);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int label = __buffer.bufferParam(bufSize);
        GLES32.nglGetObjectLabel(identifier, name, bufSize, __buffer.address(length), __buffer.address(label));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), label);
    }

    public static void nglObjectPtrLabel(long ptr, int length, long label) {
        long __functionAddress = GLES32.getInstance().ObjectPtrLabel;
        if (Checks.CHECKS) {
            Checks.checkPointer(ptr);
        }
        JNI.callPIPV(__functionAddress, ptr, length, label);
    }

    public static void glObjectPtrLabel(long ptr, int length, ByteBuffer label) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)label, length);
        }
        GLES32.nglObjectPtrLabel(ptr, length, MemoryUtil.memAddress(label));
    }

    public static void glObjectPtrLabel(long ptr, ByteBuffer label) {
        GLES32.nglObjectPtrLabel(ptr, label.remaining(), MemoryUtil.memAddress(label));
    }

    public static void glObjectPtrLabel(long ptr, CharSequence label) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int labelEncoded = __buffer.stringParamUTF8(label, false);
        int labelEncodedLen = __buffer.getOffset() - labelEncoded;
        GLES32.nglObjectPtrLabel(ptr, labelEncodedLen, __buffer.address(labelEncoded));
    }

    public static void nglGetObjectPtrLabel(long ptr, int bufSize, long length, long label) {
        long __functionAddress = GLES32.getInstance().GetObjectPtrLabel;
        if (Checks.CHECKS) {
            Checks.checkPointer(ptr);
        }
        JNI.callPIPPV(__functionAddress, ptr, bufSize, length, label);
    }

    public static void glGetObjectPtrLabel(long ptr, int bufSize, ByteBuffer length, ByteBuffer label) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)label, bufSize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        GLES32.nglGetObjectPtrLabel(ptr, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(label));
    }

    public static void glGetObjectPtrLabel(long ptr, IntBuffer length, ByteBuffer label) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        GLES32.nglGetObjectPtrLabel(ptr, label.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(label));
    }

    public static String glGetObjectPtrLabel(long ptr, int bufSize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int label = __buffer.bufferParam(bufSize);
        GLES32.nglGetObjectPtrLabel(ptr, bufSize, __buffer.address(length), __buffer.address(label));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), label);
    }

    public static String glGetObjectPtrLabel(long ptr) {
        int bufSize = GLES20.glGetInteger(33512);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int label = __buffer.bufferParam(bufSize);
        GLES32.nglGetObjectPtrLabel(ptr, bufSize, __buffer.address(length), __buffer.address(label));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), label);
    }

    public static void glEnablei(int target, int index) {
        long __functionAddress = GLES32.getInstance().Enablei;
        JNI.callIIV(__functionAddress, target, index);
    }

    public static void glDisablei(int target, int index) {
        long __functionAddress = GLES32.getInstance().Disablei;
        JNI.callIIV(__functionAddress, target, index);
    }

    public static void glBlendEquationi(int buf, int mode) {
        long __functionAddress = GLES32.getInstance().BlendEquationi;
        JNI.callIIV(__functionAddress, buf, mode);
    }

    public static void glBlendEquationSeparatei(int buf, int modeRGB, int modeAlpha) {
        long __functionAddress = GLES32.getInstance().BlendEquationSeparatei;
        JNI.callIIIV(__functionAddress, buf, modeRGB, modeAlpha);
    }

    public static void glBlendFunci(int buf, int src, int dst) {
        long __functionAddress = GLES32.getInstance().BlendFunci;
        JNI.callIIIV(__functionAddress, buf, src, dst);
    }

    public static void glBlendFuncSeparatei(int buf, int srcRGB, int dstRGB, int srcAlpha, int dstAlpha) {
        long __functionAddress = GLES32.getInstance().BlendFuncSeparatei;
        JNI.callIIIIIV(__functionAddress, buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
    }

    public static void glColorMaski(int index, boolean r, boolean g, boolean b, boolean a) {
        long __functionAddress = GLES32.getInstance().ColorMaski;
        JNI.callIZZZZV(__functionAddress, index, r, g, b, a);
    }

    public static boolean glIsEnabledi(int target, int index) {
        long __functionAddress = GLES32.getInstance().IsEnabledi;
        return JNI.callIIZ(__functionAddress, target, index);
    }

    public static void nglDrawElementsBaseVertex(int mode, int count, int type, long indices, int basevertex) {
        long __functionAddress = GLES32.getInstance().DrawElementsBaseVertex;
        JNI.callIIIPIV(__functionAddress, mode, count, type, indices, basevertex);
    }

    public static void glDrawElementsBaseVertex(int mode, int count, int type, ByteBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indices, count << GLESChecks.typeToByteShift(type));
            GLESChecks.ensureBufferObject(34965, false);
        }
        GLES32.nglDrawElementsBaseVertex(mode, count, type, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawElementsBaseVertex(int mode, int count, int type, long indicesOffset, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, true);
        }
        GLES32.nglDrawElementsBaseVertex(mode, count, type, indicesOffset, basevertex);
    }

    public static void glDrawElementsBaseVertex(int mode, int type, ByteBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        GLES32.nglDrawElementsBaseVertex(mode, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawElementsBaseVertex(int mode, ByteBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        GLES32.nglDrawElementsBaseVertex(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawElementsBaseVertex(int mode, ShortBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        GLES32.nglDrawElementsBaseVertex(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawElementsBaseVertex(int mode, IntBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        GLES32.nglDrawElementsBaseVertex(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void nglDrawRangeElementsBaseVertex(int mode, int start, int end, int count, int type, long indices, int basevertex) {
        long __functionAddress = GLES32.getInstance().DrawRangeElementsBaseVertex;
        JNI.callIIIIIPIV(__functionAddress, mode, start, end, count, type, indices, basevertex);
    }

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, int count, int type, ByteBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indices, count << GLESChecks.typeToByteShift(type));
            GLESChecks.ensureBufferObject(34965, false);
        }
        GLES32.nglDrawRangeElementsBaseVertex(mode, start, end, count, type, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, int count, int type, long indicesOffset, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, true);
        }
        GLES32.nglDrawRangeElementsBaseVertex(mode, start, end, count, type, indicesOffset, basevertex);
    }

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, int type, ByteBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        GLES32.nglDrawRangeElementsBaseVertex(mode, start, end, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, ByteBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        GLES32.nglDrawRangeElementsBaseVertex(mode, start, end, indices.remaining(), 5121, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, ShortBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        GLES32.nglDrawRangeElementsBaseVertex(mode, start, end, indices.remaining(), 5123, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, IntBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        GLES32.nglDrawRangeElementsBaseVertex(mode, start, end, indices.remaining(), 5125, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void nglDrawElementsInstancedBaseVertex(int mode, int count, int type, long indices, int instancecount, int basevertex) {
        long __functionAddress = GLES32.getInstance().DrawElementsInstancedBaseVertex;
        JNI.callIIIPIIV(__functionAddress, mode, count, type, indices, instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertex(int mode, int count, int type, ByteBuffer indices, int instancecount, int basevertex) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indices, count << GLESChecks.typeToByteShift(type));
            GLESChecks.ensureBufferObject(34965, false);
        }
        GLES32.nglDrawElementsInstancedBaseVertex(mode, count, type, MemoryUtil.memAddress(indices), instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertex(int mode, int count, int type, long indicesOffset, int instancecount, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, true);
        }
        GLES32.nglDrawElementsInstancedBaseVertex(mode, count, type, indicesOffset, instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertex(int mode, int type, ByteBuffer indices, int instancecount, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        GLES32.nglDrawElementsInstancedBaseVertex(mode, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertex(int mode, ByteBuffer indices, int instancecount, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        GLES32.nglDrawElementsInstancedBaseVertex(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertex(int mode, ShortBuffer indices, int instancecount, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        GLES32.nglDrawElementsInstancedBaseVertex(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertex(int mode, IntBuffer indices, int instancecount, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        GLES32.nglDrawElementsInstancedBaseVertex(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), instancecount, basevertex);
    }

    public static void glFramebufferTexture(int target, int attachment, int texture, int level) {
        long __functionAddress = GLES32.getInstance().FramebufferTexture;
        JNI.callIIIIV(__functionAddress, target, attachment, texture, level);
    }

    public static void glPrimitiveBoundingBox(float minX, float minY, float minZ, float minW, float maxX, float maxY, float maxZ, float maxW) {
        long __functionAddress = GLES32.getInstance().PrimitiveBoundingBox;
        JNI.callFFFFFFFFV(__functionAddress, minX, minY, minZ, minW, maxX, maxY, maxZ, maxW);
    }

    public static int glGetGraphicsResetStatus() {
        long __functionAddress = GLES32.getInstance().GetGraphicsResetStatus;
        return JNI.callI(__functionAddress);
    }

    public static void nglReadnPixels(int x, int y, int width, int height, int format, int type, int bufSize, long pixels) {
        long __functionAddress = GLES32.getInstance().ReadnPixels;
        JNI.callIIIIIIIPV(__functionAddress, x, y, width, height, format, type, bufSize, pixels);
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, int bufSize, ByteBuffer pixels) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)pixels, bufSize);
            GLESChecks.ensureBufferObject(35053, false);
        }
        GLES32.nglReadnPixels(x, y, width, height, format, type, bufSize, MemoryUtil.memAddress(pixels));
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, int bufSize, long pixelsOffset) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35053, true);
        }
        GLES32.nglReadnPixels(x, y, width, height, format, type, bufSize, pixelsOffset);
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, ByteBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35053, false);
        }
        GLES32.nglReadnPixels(x, y, width, height, format, type, pixels.remaining(), MemoryUtil.memAddress(pixels));
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, ShortBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35053, false);
        }
        GLES32.nglReadnPixels(x, y, width, height, format, type, pixels.remaining() << 1, MemoryUtil.memAddress(pixels));
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, IntBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35053, false);
        }
        GLES32.nglReadnPixels(x, y, width, height, format, type, pixels.remaining() << 2, MemoryUtil.memAddress(pixels));
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, FloatBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35053, false);
        }
        GLES32.nglReadnPixels(x, y, width, height, format, type, pixels.remaining() << 2, MemoryUtil.memAddress(pixels));
    }

    public static void nglGetnUniformfv(int program, int location, int bufSize, long params) {
        long __functionAddress = GLES32.getInstance().GetnUniformfv;
        JNI.callIIIPV(__functionAddress, program, location, bufSize, params);
    }

    public static void glGetnUniformfv(int program, int location, int bufSize, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, bufSize << 2);
        }
        GLES32.nglGetnUniformfv(program, location, bufSize, MemoryUtil.memAddress(params));
    }

    public static void glGetnUniformfv(int program, int location, FloatBuffer params) {
        GLES32.nglGetnUniformfv(program, location, params.remaining(), MemoryUtil.memAddress(params));
    }

    public static float glGetnUniformf(int program, int location) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.floatParam();
        GLES32.nglGetnUniformfv(program, location, 1, __buffer.address(params));
        return __buffer.floatValue(params);
    }

    public static void nglGetnUniformiv(int program, int location, int bufSize, long params) {
        long __functionAddress = GLES32.getInstance().GetnUniformiv;
        JNI.callIIIPV(__functionAddress, program, location, bufSize, params);
    }

    public static void glGetnUniformiv(int program, int location, int bufSize, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, bufSize << 2);
        }
        GLES32.nglGetnUniformiv(program, location, bufSize, MemoryUtil.memAddress(params));
    }

    public static void glGetnUniformiv(int program, int location, FloatBuffer params) {
        GLES32.nglGetnUniformiv(program, location, params.remaining(), MemoryUtil.memAddress(params));
    }

    public static float glGetnUniformi(int program, int location) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.floatParam();
        GLES32.nglGetnUniformiv(program, location, 1, __buffer.address(params));
        return __buffer.floatValue(params);
    }

    public static void nglGetnUniformuiv(int program, int location, int bufSize, long params) {
        long __functionAddress = GLES32.getInstance().GetnUniformuiv;
        JNI.callIIIPV(__functionAddress, program, location, bufSize, params);
    }

    public static void glGetnUniformuiv(int program, int location, int bufSize, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, bufSize << 2);
        }
        GLES32.nglGetnUniformuiv(program, location, bufSize, MemoryUtil.memAddress(params));
    }

    public static void glGetnUniformuiv(int program, int location, FloatBuffer params) {
        GLES32.nglGetnUniformuiv(program, location, params.remaining(), MemoryUtil.memAddress(params));
    }

    public static float glGetnUniformui(int program, int location) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.floatParam();
        GLES32.nglGetnUniformuiv(program, location, 1, __buffer.address(params));
        return __buffer.floatValue(params);
    }

    public static void glMinSampleShading(float value) {
        long __functionAddress = GLES32.getInstance().MinSampleShading;
        JNI.callFV(__functionAddress, value);
    }

    public static void glPatchParameteri(int pname, int value) {
        long __functionAddress = GLES32.getInstance().PatchParameteri;
        JNI.callIIV(__functionAddress, pname, value);
    }

    public static void nglTexParameterIiv(int target, int pname, long params) {
        long __functionAddress = GLES32.getInstance().TexParameterIiv;
        JNI.callIIPV(__functionAddress, target, pname, params);
    }

    public static void glTexParameterIiv(int target, int pname, ByteBuffer params) {
        GLES32.nglTexParameterIiv(target, pname, MemoryUtil.memAddress(params));
    }

    public static void glTexParameterIiv(int target, int pname, IntBuffer params) {
        GLES32.nglTexParameterIiv(target, pname, MemoryUtil.memAddress(params));
    }

    public static void glTexParameterIi(int target, int pname, int param) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam(param);
        GLES32.nglTexParameterIiv(target, pname, __buffer.address(params));
    }

    public static void nglTexParameterIuiv(int target, int pname, long params) {
        long __functionAddress = GLES32.getInstance().TexParameterIuiv;
        JNI.callIIPV(__functionAddress, target, pname, params);
    }

    public static void glTexParameterIuiv(int target, int pname, ByteBuffer params) {
        GLES32.nglTexParameterIuiv(target, pname, MemoryUtil.memAddress(params));
    }

    public static void glTexParameterIuiv(int target, int pname, IntBuffer params) {
        GLES32.nglTexParameterIuiv(target, pname, MemoryUtil.memAddress(params));
    }

    public static void glTexParameterIui(int target, int pname, int param) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam(param);
        GLES32.nglTexParameterIuiv(target, pname, __buffer.address(params));
    }

    public static void nglGetTexParameterIiv(int target, int pname, long params) {
        long __functionAddress = GLES32.getInstance().GetTexParameterIiv;
        JNI.callIIPV(__functionAddress, target, pname, params);
    }

    public static void glGetTexParameterIiv(int target, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GLES32.nglGetTexParameterIiv(target, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetTexParameterIiv(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES32.nglGetTexParameterIiv(target, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetTexParameterIi(int target, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GLES32.nglGetTexParameterIiv(target, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetTexParameterIuiv(int target, int pname, long params) {
        long __functionAddress = GLES32.getInstance().GetTexParameterIuiv;
        JNI.callIIPV(__functionAddress, target, pname, params);
    }

    public static void glGetTexParameterIuiv(int target, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GLES32.nglGetTexParameterIuiv(target, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetTexParameterIuiv(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES32.nglGetTexParameterIuiv(target, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetTexParameterIui(int target, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GLES32.nglGetTexParameterIuiv(target, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglSamplerParameterIiv(int sampler, int pname, long params) {
        long __functionAddress = GLES32.getInstance().SamplerParameterIiv;
        JNI.callIIPV(__functionAddress, sampler, pname, params);
    }

    public static void glSamplerParameterIiv(int sampler, int pname, ByteBuffer params) {
        GLES32.nglSamplerParameterIiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void glSamplerParameterIiv(int sampler, int pname, IntBuffer params) {
        GLES32.nglSamplerParameterIiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void glSamplerParameterIi(int sampler, int pname, int param) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam(param);
        GLES32.nglSamplerParameterIiv(sampler, pname, __buffer.address(params));
    }

    public static void nglSamplerParameterIuiv(int sampler, int pname, long params) {
        long __functionAddress = GLES32.getInstance().SamplerParameterIuiv;
        JNI.callIIPV(__functionAddress, sampler, pname, params);
    }

    public static void glSamplerParameterIuiv(int sampler, int pname, ByteBuffer params) {
        GLES32.nglSamplerParameterIuiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void glSamplerParameterIuiv(int sampler, int pname, IntBuffer params) {
        GLES32.nglSamplerParameterIuiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void glSamplerParameterIui(int sampler, int pname, int param) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam(param);
        GLES32.nglSamplerParameterIuiv(sampler, pname, __buffer.address(params));
    }

    public static void nglGetSamplerParameterIiv(int sampler, int pname, long params) {
        long __functionAddress = GLES32.getInstance().GetSamplerParameterIiv;
        JNI.callIIPV(__functionAddress, sampler, pname, params);
    }

    public static void glGetSamplerParameterIiv(int sampler, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GLES32.nglGetSamplerParameterIiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetSamplerParameterIiv(int sampler, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES32.nglGetSamplerParameterIiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetSamplerParameterIi(int sampler, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GLES32.nglGetSamplerParameterIiv(sampler, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetSamplerParameterIuiv(int sampler, int pname, long params) {
        long __functionAddress = GLES32.getInstance().GetSamplerParameterIuiv;
        JNI.callIIPV(__functionAddress, sampler, pname, params);
    }

    public static void glGetSamplerParameterIuiv(int sampler, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GLES32.nglGetSamplerParameterIuiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetSamplerParameterIuiv(int sampler, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES32.nglGetSamplerParameterIuiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetSamplerParameterIui(int sampler, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GLES32.nglGetSamplerParameterIuiv(sampler, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void glTexBuffer(int target, int internalformat, int buffer) {
        long __functionAddress = GLES32.getInstance().TexBuffer;
        JNI.callIIIV(__functionAddress, target, internalformat, buffer);
    }

    public static void glTexBufferRange(int target, int internalformat, int buffer, long offset, long size) {
        long __functionAddress = GLES32.getInstance().TexBufferRange;
        JNI.callIIIPPV(__functionAddress, target, internalformat, buffer, offset, size);
    }

    public static void glTexStorage3DMultisample(int target, int samples, int internalformat, int width, int height, int depth, boolean fixedsamplelocations) {
        long __functionAddress = GLES32.getInstance().TexStorage3DMultisample;
        JNI.callIIIIIIZV(__functionAddress, target, samples, internalformat, width, height, depth, fixedsamplelocations);
    }
}

