/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.util.Set;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;

public class NVConditionalRender {
    public static final int GL_QUERY_WAIT_NV = 36371;
    public static final int GL_QUERY_NO_WAIT_NV = 36372;
    public static final int GL_QUERY_BY_REGION_WAIT_NV = 36373;
    public static final int GL_QUERY_BY_REGION_NO_WAIT_NV = 36374;
    public final long BeginConditionalRenderNV;
    public final long EndConditionalRenderNV;

    protected NVConditionalRender() {
        throw new UnsupportedOperationException();
    }

    public NVConditionalRender(FunctionProvider provider) {
        this.BeginConditionalRenderNV = provider.getFunctionAddress("glBeginConditionalRenderNV");
        this.EndConditionalRenderNV = provider.getFunctionAddress("glEndConditionalRenderNV");
    }

    public static NVConditionalRender getInstance() {
        return NVConditionalRender.getInstance(GLES.getCapabilities());
    }

    public static NVConditionalRender getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__NVConditionalRender);
    }

    static NVConditionalRender create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_NV_conditional_render")) {
            return null;
        }
        NVConditionalRender funcs = new NVConditionalRender(provider);
        boolean supported = Checks.checkFunctions(funcs.BeginConditionalRenderNV, funcs.EndConditionalRenderNV);
        return GLES.checkExtension("GL_NV_conditional_render", funcs, supported);
    }

    public static void glBeginConditionalRenderNV(int id, int mode) {
        long __functionAddress = NVConditionalRender.getInstance().BeginConditionalRenderNV;
        JNI.callIIV(__functionAddress, id, mode);
    }

    public static void glEndConditionalRenderNV() {
        long __functionAddress = NVConditionalRender.getInstance().EndConditionalRenderNV;
        JNI.callV(__functionAddress);
    }
}

