/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.util.Set;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;

public class NVCoverageSample {
    public static final int GL_COVERAGE_COMPONENT_NV = 36560;
    public static final int GL_COVERAGE_COMPONENT4_NV = 36561;
    public static final int GL_COVERAGE_ALL_FRAGMENTS_NV = 36565;
    public static final int GL_COVERAGE_EDGE_FRAGMENTS_NV = 36566;
    public static final int GL_COVERAGE_AUTOMATIC_NV = 36567;
    public static final int GL_COVERAGE_ATTACHMENT_NV = 36562;
    public static final int GL_COVERAGE_BUFFER_BIT_NV = 32768;
    public static final int GL_COVERAGE_BUFFERS_NV = 36563;
    public static final int GL_COVERAGE_SAMPLES_NV = 36564;
    public final long CoverageMaskNV;
    public final long CoverageOperationNV;

    protected NVCoverageSample() {
        throw new UnsupportedOperationException();
    }

    public NVCoverageSample(FunctionProvider provider) {
        this.CoverageMaskNV = provider.getFunctionAddress("glCoverageMaskNV");
        this.CoverageOperationNV = provider.getFunctionAddress("glCoverageOperationNV");
    }

    public static NVCoverageSample getInstance() {
        return NVCoverageSample.getInstance(GLES.getCapabilities());
    }

    public static NVCoverageSample getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__NVCoverageSample);
    }

    static NVCoverageSample create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_NV_coverage_sample")) {
            return null;
        }
        NVCoverageSample funcs = new NVCoverageSample(provider);
        boolean supported = Checks.checkFunctions(funcs.CoverageMaskNV, funcs.CoverageOperationNV);
        return GLES.checkExtension("GL_NV_coverage_sample", funcs, supported);
    }

    public static void glCoverageMaskNV(boolean mask) {
        long __functionAddress = NVCoverageSample.getInstance().CoverageMaskNV;
        JNI.callZV(__functionAddress, mask);
    }

    public static void glCoverageOperationNV(int operation) {
        long __functionAddress = NVCoverageSample.getInstance().CoverageOperationNV;
        JNI.callIV(__functionAddress, operation);
    }
}

