/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Set;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class NVNonSquareMatrices {
    public static final int GL_FLOAT_MAT2x3_NV = 35685;
    public static final int GL_FLOAT_MAT2x4_NV = 35686;
    public static final int GL_FLOAT_MAT3x2_NV = 35687;
    public static final int GL_FLOAT_MAT3x4_NV = 35688;
    public static final int GL_FLOAT_MAT4x2_NV = 35689;
    public static final int GL_FLOAT_MAT4x3_NV = 35690;
    public final long UniformMatrix2x3fvNV;
    public final long UniformMatrix3x2fvNV;
    public final long UniformMatrix2x4fvNV;
    public final long UniformMatrix4x2fvNV;
    public final long UniformMatrix3x4fvNV;
    public final long UniformMatrix4x3fvNV;

    protected NVNonSquareMatrices() {
        throw new UnsupportedOperationException();
    }

    public NVNonSquareMatrices(FunctionProvider provider) {
        this.UniformMatrix2x3fvNV = provider.getFunctionAddress("glUniformMatrix2x3fvNV");
        this.UniformMatrix3x2fvNV = provider.getFunctionAddress("glUniformMatrix3x2fvNV");
        this.UniformMatrix2x4fvNV = provider.getFunctionAddress("glUniformMatrix2x4fvNV");
        this.UniformMatrix4x2fvNV = provider.getFunctionAddress("glUniformMatrix4x2fvNV");
        this.UniformMatrix3x4fvNV = provider.getFunctionAddress("glUniformMatrix3x4fvNV");
        this.UniformMatrix4x3fvNV = provider.getFunctionAddress("glUniformMatrix4x3fvNV");
    }

    public static NVNonSquareMatrices getInstance() {
        return NVNonSquareMatrices.getInstance(GLES.getCapabilities());
    }

    public static NVNonSquareMatrices getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__NVNonSquareMatrices);
    }

    static NVNonSquareMatrices create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_NV_non_square_matrices")) {
            return null;
        }
        NVNonSquareMatrices funcs = new NVNonSquareMatrices(provider);
        boolean supported = Checks.checkFunctions(funcs.UniformMatrix2x3fvNV, funcs.UniformMatrix3x2fvNV, funcs.UniformMatrix2x4fvNV, funcs.UniformMatrix4x2fvNV, funcs.UniformMatrix3x4fvNV, funcs.UniformMatrix4x3fvNV);
        return GLES.checkExtension("GL_NV_non_square_matrices", funcs, supported);
    }

    public static void nglUniformMatrix2x3fvNV(int location, int count, boolean transpose, long value) {
        long __functionAddress = NVNonSquareMatrices.getInstance().UniformMatrix2x3fvNV;
        JNI.callIIZPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix2x3fvNV(int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 6 << 2);
        }
        NVNonSquareMatrices.nglUniformMatrix2x3fvNV(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix2x3fvNV(int location, boolean transpose, FloatBuffer value) {
        NVNonSquareMatrices.nglUniformMatrix2x3fvNV(location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix3x2fvNV(int location, int count, boolean transpose, long value) {
        long __functionAddress = NVNonSquareMatrices.getInstance().UniformMatrix3x2fvNV;
        JNI.callIIZPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix3x2fvNV(int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 6 << 2);
        }
        NVNonSquareMatrices.nglUniformMatrix3x2fvNV(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix3x2fvNV(int location, boolean transpose, FloatBuffer value) {
        NVNonSquareMatrices.nglUniformMatrix3x2fvNV(location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix2x4fvNV(int location, int count, boolean transpose, long value) {
        long __functionAddress = NVNonSquareMatrices.getInstance().UniformMatrix2x4fvNV;
        JNI.callIIZPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix2x4fvNV(int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 3 << 2);
        }
        NVNonSquareMatrices.nglUniformMatrix2x4fvNV(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix2x4fvNV(int location, boolean transpose, FloatBuffer value) {
        NVNonSquareMatrices.nglUniformMatrix2x4fvNV(location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix4x2fvNV(int location, int count, boolean transpose, long value) {
        long __functionAddress = NVNonSquareMatrices.getInstance().UniformMatrix4x2fvNV;
        JNI.callIIZPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix4x2fvNV(int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 3 << 2);
        }
        NVNonSquareMatrices.nglUniformMatrix4x2fvNV(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix4x2fvNV(int location, boolean transpose, FloatBuffer value) {
        NVNonSquareMatrices.nglUniformMatrix4x2fvNV(location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix3x4fvNV(int location, int count, boolean transpose, long value) {
        long __functionAddress = NVNonSquareMatrices.getInstance().UniformMatrix3x4fvNV;
        JNI.callIIZPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix3x4fvNV(int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 12 << 2);
        }
        NVNonSquareMatrices.nglUniformMatrix3x4fvNV(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix3x4fvNV(int location, boolean transpose, FloatBuffer value) {
        NVNonSquareMatrices.nglUniformMatrix3x4fvNV(location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix4x3fvNV(int location, int count, boolean transpose, long value) {
        long __functionAddress = NVNonSquareMatrices.getInstance().UniformMatrix4x3fvNV;
        JNI.callIIZPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix4x3fvNV(int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 12 << 2);
        }
        NVNonSquareMatrices.nglUniformMatrix4x3fvNV(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix4x3fvNV(int location, boolean transpose, FloatBuffer value) {
        NVNonSquareMatrices.nglUniformMatrix4x3fvNV(location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }
}

