/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.opengles.GLESChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class NVTextureArray {
    public static final int GL_TEXTURE_2D_ARRAY_NV = 35866;
    public static final int GL_TEXTURE_BINDING_2D_ARRAY_NV = 35869;
    public static final int GL_MAX_ARRAY_TEXTURE_LAYERS_NV = 35071;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER_NV = 36052;
    public static final int GL_SAMPLER_2D_ARRAY_NV = 36289;
    public static final int GL_UNPACK_SKIP_IMAGES_NV = 32877;
    public static final int GL_UNPACK_IMAGE_HEIGHT_NV = 32878;
    public final long TexImage3DNV;
    public final long TexSubImage3DNV;
    public final long CopyTexSubImage3DNV;
    public final long CompressedTexImage3DNV;
    public final long CompressedTexSubImage3DNV;
    public final long FramebufferTextureLayerNV;

    protected NVTextureArray() {
        throw new UnsupportedOperationException();
    }

    public NVTextureArray(FunctionProvider provider) {
        this.TexImage3DNV = provider.getFunctionAddress("glTexImage3DNV");
        this.TexSubImage3DNV = provider.getFunctionAddress("glTexSubImage3DNV");
        this.CopyTexSubImage3DNV = provider.getFunctionAddress("glCopyTexSubImage3DNV");
        this.CompressedTexImage3DNV = provider.getFunctionAddress("glCompressedTexImage3DNV");
        this.CompressedTexSubImage3DNV = provider.getFunctionAddress("glCompressedTexSubImage3DNV");
        this.FramebufferTextureLayerNV = provider.getFunctionAddress("glFramebufferTextureLayerNV");
    }

    public static NVTextureArray getInstance() {
        return NVTextureArray.getInstance(GLES.getCapabilities());
    }

    public static NVTextureArray getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__NVTextureArray);
    }

    static NVTextureArray create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_NV_texture_array")) {
            return null;
        }
        NVTextureArray funcs = new NVTextureArray(provider);
        boolean supported = Checks.checkFunctions(funcs.TexImage3DNV, funcs.TexSubImage3DNV, funcs.CopyTexSubImage3DNV, funcs.CompressedTexImage3DNV, funcs.CompressedTexSubImage3DNV, funcs.FramebufferTextureLayerNV);
        return GLES.checkExtension("GL_NV_texture_array", funcs, supported);
    }

    public static void nglTexImage3DNV(int target, int level, int internalFormat, int width, int height, int depth, int border, int format, int type, long pixels) {
        long __functionAddress = NVTextureArray.getInstance().TexImage3DNV;
        JNI.callIIIIIIIIIPV(__functionAddress, target, level, internalFormat, width, height, depth, border, format, type, pixels);
    }

    public static void glTexImage3DNV(int target, int level, int internalFormat, int width, int height, int depth, int border, int format, int type, ByteBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        NVTextureArray.nglTexImage3DNV(target, level, internalFormat, width, height, depth, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTexImage3DNV(int target, int level, int internalFormat, int width, int height, int depth, int border, int format, int type, long pixelsOffset) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, true);
        }
        NVTextureArray.nglTexImage3DNV(target, level, internalFormat, width, height, depth, border, format, type, pixelsOffset);
    }

    public static void glTexImage3DNV(int target, int level, int internalFormat, int width, int height, int depth, int border, int format, int type, ShortBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        NVTextureArray.nglTexImage3DNV(target, level, internalFormat, width, height, depth, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTexImage3DNV(int target, int level, int internalFormat, int width, int height, int depth, int border, int format, int type, IntBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        NVTextureArray.nglTexImage3DNV(target, level, internalFormat, width, height, depth, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTexImage3DNV(int target, int level, int internalFormat, int width, int height, int depth, int border, int format, int type, FloatBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        NVTextureArray.nglTexImage3DNV(target, level, internalFormat, width, height, depth, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void nglTexSubImage3DNV(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, long pixels) {
        long __functionAddress = NVTextureArray.getInstance().TexSubImage3DNV;
        JNI.callIIIIIIIIIIPV(__functionAddress, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    }

    public static void glTexSubImage3DNV(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ByteBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        NVTextureArray.nglTexSubImage3DNV(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTexSubImage3DNV(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, long pixelsOffset) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, true);
        }
        NVTextureArray.nglTexSubImage3DNV(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixelsOffset);
    }

    public static void glTexSubImage3DNV(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ShortBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        NVTextureArray.nglTexSubImage3DNV(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTexSubImage3DNV(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, IntBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        NVTextureArray.nglTexSubImage3DNV(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTexSubImage3DNV(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, FloatBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        NVTextureArray.nglTexSubImage3DNV(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glCopyTexSubImage3DNV(int target, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height) {
        long __functionAddress = NVTextureArray.getInstance().CopyTexSubImage3DNV;
        JNI.callIIIIIIIIIV(__functionAddress, target, level, xoffset, yoffset, zoffset, x, y, width, height);
    }

    public static void nglCompressedTexImage3DNV(int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, long data) {
        long __functionAddress = NVTextureArray.getInstance().CompressedTexImage3DNV;
        JNI.callIIIIIIIIPV(__functionAddress, target, level, internalformat, width, height, depth, border, imageSize, data);
    }

    public static void glCompressedTexImage3DNV(int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, ByteBuffer data) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        NVTextureArray.nglCompressedTexImage3DNV(target, level, internalformat, width, height, depth, border, imageSize, MemoryUtil.memAddressSafe(data));
    }

    public static void glCompressedTexImage3DNV(int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, long dataOffset) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, true);
        }
        NVTextureArray.nglCompressedTexImage3DNV(target, level, internalformat, width, height, depth, border, imageSize, dataOffset);
    }

    public static void nglCompressedTexSubImage3DNV(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, long data) {
        long __functionAddress = NVTextureArray.getInstance().CompressedTexSubImage3DNV;
        JNI.callIIIIIIIIIIPV(__functionAddress, target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
    }

    public static void glCompressedTexSubImage3DNV(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, ByteBuffer data) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        NVTextureArray.nglCompressedTexSubImage3DNV(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, MemoryUtil.memAddress(data));
    }

    public static void glCompressedTexSubImage3DNV(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, long dataOffset) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, true);
        }
        NVTextureArray.nglCompressedTexSubImage3DNV(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, dataOffset);
    }

    public static void glFramebufferTextureLayerNV(int target, int attachment, int texture, int level, int layer) {
        long __functionAddress = NVTextureArray.getInstance().FramebufferTextureLayerNV;
        JNI.callIIIIIV(__functionAddress, target, attachment, texture, level, layer);
    }
}

