/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class OESVertexArrayObject {
    public static final int GL_VERTEX_ARRAY_BINDING_OES = 34229;
    public final long BindVertexArrayOES;
    public final long DeleteVertexArraysOES;
    public final long GenVertexArraysOES;
    public final long IsVertexArrayOES;

    protected OESVertexArrayObject() {
        throw new UnsupportedOperationException();
    }

    public OESVertexArrayObject(FunctionProvider provider) {
        this.BindVertexArrayOES = provider.getFunctionAddress("glBindVertexArrayOES");
        this.DeleteVertexArraysOES = provider.getFunctionAddress("glDeleteVertexArraysOES");
        this.GenVertexArraysOES = provider.getFunctionAddress("glGenVertexArraysOES");
        this.IsVertexArrayOES = provider.getFunctionAddress("glIsVertexArrayOES");
    }

    public static OESVertexArrayObject getInstance() {
        return OESVertexArrayObject.getInstance(GLES.getCapabilities());
    }

    public static OESVertexArrayObject getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__OESVertexArrayObject);
    }

    static OESVertexArrayObject create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_OES_vertex_array_object")) {
            return null;
        }
        OESVertexArrayObject funcs = new OESVertexArrayObject(provider);
        boolean supported = Checks.checkFunctions(funcs.BindVertexArrayOES, funcs.DeleteVertexArraysOES, funcs.GenVertexArraysOES, funcs.IsVertexArrayOES);
        return GLES.checkExtension("GL_OES_vertex_array_object", funcs, supported);
    }

    public static void glBindVertexArrayOES(int array) {
        long __functionAddress = OESVertexArrayObject.getInstance().BindVertexArrayOES;
        JNI.callIV(__functionAddress, array);
    }

    public static void nglDeleteVertexArraysOES(int n, long arrays) {
        long __functionAddress = OESVertexArrayObject.getInstance().DeleteVertexArraysOES;
        JNI.callIPV(__functionAddress, n, arrays);
    }

    public static void glDeleteVertexArraysOES(int n, ByteBuffer arrays) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)arrays, n << 2);
        }
        OESVertexArrayObject.nglDeleteVertexArraysOES(n, MemoryUtil.memAddress(arrays));
    }

    public static void glDeleteVertexArraysOES(IntBuffer arrays) {
        OESVertexArrayObject.nglDeleteVertexArraysOES(arrays.remaining(), MemoryUtil.memAddress(arrays));
    }

    public static void glDeleteVertexArraysOES(int array) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arrays = __buffer.intParam(array);
        OESVertexArrayObject.nglDeleteVertexArraysOES(1, __buffer.address(arrays));
    }

    public static void nglGenVertexArraysOES(int n, long arrays) {
        long __functionAddress = OESVertexArrayObject.getInstance().GenVertexArraysOES;
        JNI.callIPV(__functionAddress, n, arrays);
    }

    public static void glGenVertexArraysOES(int n, ByteBuffer arrays) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)arrays, n << 2);
            Checks.checkBuffer((Buffer)arrays, 4);
        }
        OESVertexArrayObject.nglGenVertexArraysOES(n, MemoryUtil.memAddress(arrays));
    }

    public static void glGenVertexArraysOES(IntBuffer arrays) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)arrays, 1);
        }
        OESVertexArrayObject.nglGenVertexArraysOES(arrays.remaining(), MemoryUtil.memAddress(arrays));
    }

    public static int glGenVertexArraysOES() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arrays = __buffer.intParam();
        OESVertexArrayObject.nglGenVertexArraysOES(1, __buffer.address(arrays));
        return __buffer.intValue(arrays);
    }

    public static boolean glIsVertexArrayOES(int array) {
        long __functionAddress = OESVertexArrayObject.getInstance().IsVertexArrayOES;
        return JNI.callIZ(__functionAddress, array);
    }
}

