/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class QCOMExtendedGet {
    public static final int GL_TEXTURE_WIDTH_QCOM = 35794;
    public static final int GL_TEXTURE_HEIGHT_QCOM = 35795;
    public static final int GL_TEXTURE_DEPTH_QCOM = 35796;
    public static final int GL_TEXTURE_INTERNAL_FORMAT_QCOM = 35797;
    public static final int GL_TEXTURE_FORMAT_QCOM = 35798;
    public static final int GL_TEXTURE_TYPE_QCOM = 35799;
    public static final int GL_TEXTURE_IMAGE_VALID_QCOM = 35800;
    public static final int GL_TEXTURE_NUM_LEVELS_QCOM = 35801;
    public static final int GL_TEXTURE_TARGET_QCOM = 35802;
    public static final int GL_TEXTURE_OBJECT_VALID_QCOM = 35803;
    public static final int GL_STATE_RESTORE = 35804;
    public final long ExtGetTexturesQCOM;
    public final long ExtGetBuffersQCOM;
    public final long ExtGetRenderbuffersQCOM;
    public final long ExtGetFramebuffersQCOM;
    public final long ExtGetTexLevelParameterivQCOM;
    public final long ExtTexObjectStateOverrideiQCOM;
    public final long ExtGetTexSubImageQCOM;
    public final long ExtGetBufferPointervQCOM;

    protected QCOMExtendedGet() {
        throw new UnsupportedOperationException();
    }

    public QCOMExtendedGet(FunctionProvider provider) {
        this.ExtGetTexturesQCOM = provider.getFunctionAddress("glExtGetTexturesQCOM");
        this.ExtGetBuffersQCOM = provider.getFunctionAddress("glExtGetBuffersQCOM");
        this.ExtGetRenderbuffersQCOM = provider.getFunctionAddress("glExtGetRenderbuffersQCOM");
        this.ExtGetFramebuffersQCOM = provider.getFunctionAddress("glExtGetFramebuffersQCOM");
        this.ExtGetTexLevelParameterivQCOM = provider.getFunctionAddress("glExtGetTexLevelParameterivQCOM");
        this.ExtTexObjectStateOverrideiQCOM = provider.getFunctionAddress("glExtTexObjectStateOverrideiQCOM");
        this.ExtGetTexSubImageQCOM = provider.getFunctionAddress("glExtGetTexSubImageQCOM");
        this.ExtGetBufferPointervQCOM = provider.getFunctionAddress("glExtGetBufferPointervQCOM");
    }

    public static QCOMExtendedGet getInstance() {
        return QCOMExtendedGet.getInstance(GLES.getCapabilities());
    }

    public static QCOMExtendedGet getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__QCOMExtendedGet);
    }

    static QCOMExtendedGet create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_QCOM_extended_get")) {
            return null;
        }
        QCOMExtendedGet funcs = new QCOMExtendedGet(provider);
        boolean supported = Checks.checkFunctions(funcs.ExtGetTexturesQCOM, funcs.ExtGetBuffersQCOM, funcs.ExtGetRenderbuffersQCOM, funcs.ExtGetFramebuffersQCOM, funcs.ExtGetTexLevelParameterivQCOM, funcs.ExtTexObjectStateOverrideiQCOM, funcs.ExtGetTexSubImageQCOM, funcs.ExtGetBufferPointervQCOM);
        return GLES.checkExtension("GL_QCOM_extended_get", funcs, supported);
    }

    public static void nglExtGetTexturesQCOM(long textures, int maxTextures, long numTextures) {
        long __functionAddress = QCOMExtendedGet.getInstance().ExtGetTexturesQCOM;
        JNI.callPIPV(__functionAddress, textures, maxTextures, numTextures);
    }

    public static void glExtGetTexturesQCOM(ByteBuffer textures, int maxTextures, ByteBuffer numTextures) {
        if (Checks.CHECKS) {
            if (textures != null) {
                Checks.checkBuffer((Buffer)textures, maxTextures << 2);
            }
            if (numTextures != null) {
                Checks.checkBuffer((Buffer)numTextures, 4);
            }
        }
        QCOMExtendedGet.nglExtGetTexturesQCOM(MemoryUtil.memAddressSafe(textures), maxTextures, MemoryUtil.memAddressSafe(numTextures));
    }

    public static void glExtGetTexturesQCOM(IntBuffer textures, IntBuffer numTextures) {
        if (Checks.CHECKS && numTextures != null) {
            Checks.checkBuffer((Buffer)numTextures, 1);
        }
        QCOMExtendedGet.nglExtGetTexturesQCOM(MemoryUtil.memAddressSafe(textures), textures == null ? 0 : textures.remaining(), MemoryUtil.memAddressSafe(numTextures));
    }

    public static void nglExtGetBuffersQCOM(long buffers, int maxBuffers, long numBuffers) {
        long __functionAddress = QCOMExtendedGet.getInstance().ExtGetBuffersQCOM;
        JNI.callPIPV(__functionAddress, buffers, maxBuffers, numBuffers);
    }

    public static void glExtGetBuffersQCOM(ByteBuffer buffers, int maxBuffers, ByteBuffer numBuffers) {
        if (Checks.CHECKS) {
            if (buffers != null) {
                Checks.checkBuffer((Buffer)buffers, maxBuffers << 2);
            }
            if (numBuffers != null) {
                Checks.checkBuffer((Buffer)numBuffers, 4);
            }
        }
        QCOMExtendedGet.nglExtGetBuffersQCOM(MemoryUtil.memAddressSafe(buffers), maxBuffers, MemoryUtil.memAddressSafe(numBuffers));
    }

    public static void glExtGetBuffersQCOM(IntBuffer buffers, IntBuffer numBuffers) {
        if (Checks.CHECKS && numBuffers != null) {
            Checks.checkBuffer((Buffer)numBuffers, 1);
        }
        QCOMExtendedGet.nglExtGetBuffersQCOM(MemoryUtil.memAddressSafe(buffers), buffers == null ? 0 : buffers.remaining(), MemoryUtil.memAddressSafe(numBuffers));
    }

    public static void nglExtGetRenderbuffersQCOM(long renderbuffers, int maxRenderbuffers, long numRenderbuffers) {
        long __functionAddress = QCOMExtendedGet.getInstance().ExtGetRenderbuffersQCOM;
        JNI.callPIPV(__functionAddress, renderbuffers, maxRenderbuffers, numRenderbuffers);
    }

    public static void glExtGetRenderbuffersQCOM(ByteBuffer renderbuffers, int maxRenderbuffers, ByteBuffer numRenderbuffers) {
        if (Checks.CHECKS) {
            if (renderbuffers != null) {
                Checks.checkBuffer((Buffer)renderbuffers, maxRenderbuffers << 2);
            }
            if (numRenderbuffers != null) {
                Checks.checkBuffer((Buffer)numRenderbuffers, 4);
            }
        }
        QCOMExtendedGet.nglExtGetRenderbuffersQCOM(MemoryUtil.memAddressSafe(renderbuffers), maxRenderbuffers, MemoryUtil.memAddressSafe(numRenderbuffers));
    }

    public static void glExtGetRenderbuffersQCOM(IntBuffer renderbuffers, IntBuffer numRenderbuffers) {
        if (Checks.CHECKS && numRenderbuffers != null) {
            Checks.checkBuffer((Buffer)numRenderbuffers, 1);
        }
        QCOMExtendedGet.nglExtGetRenderbuffersQCOM(MemoryUtil.memAddressSafe(renderbuffers), renderbuffers == null ? 0 : renderbuffers.remaining(), MemoryUtil.memAddressSafe(numRenderbuffers));
    }

    public static void nglExtGetFramebuffersQCOM(long framebuffers, int maxFramebuffers, long numFramebuffers) {
        long __functionAddress = QCOMExtendedGet.getInstance().ExtGetFramebuffersQCOM;
        JNI.callPIPV(__functionAddress, framebuffers, maxFramebuffers, numFramebuffers);
    }

    public static void glExtGetFramebuffersQCOM(ByteBuffer framebuffers, int maxFramebuffers, ByteBuffer numFramebuffers) {
        if (Checks.CHECKS) {
            if (framebuffers != null) {
                Checks.checkBuffer((Buffer)framebuffers, maxFramebuffers << 2);
            }
            if (numFramebuffers != null) {
                Checks.checkBuffer((Buffer)numFramebuffers, 4);
            }
        }
        QCOMExtendedGet.nglExtGetFramebuffersQCOM(MemoryUtil.memAddressSafe(framebuffers), maxFramebuffers, MemoryUtil.memAddressSafe(numFramebuffers));
    }

    public static void glExtGetFramebuffersQCOM(IntBuffer framebuffers, IntBuffer numFramebuffers) {
        if (Checks.CHECKS && numFramebuffers != null) {
            Checks.checkBuffer((Buffer)numFramebuffers, 1);
        }
        QCOMExtendedGet.nglExtGetFramebuffersQCOM(MemoryUtil.memAddressSafe(framebuffers), framebuffers == null ? 0 : framebuffers.remaining(), MemoryUtil.memAddressSafe(numFramebuffers));
    }

    public static void nglExtGetTexLevelParameterivQCOM(int texture, int face, int level, int pname, long params) {
        long __functionAddress = QCOMExtendedGet.getInstance().ExtGetTexLevelParameterivQCOM;
        JNI.callIIIIPV(__functionAddress, texture, face, level, pname, params);
    }

    public static void glExtGetTexLevelParameterivQCOM(int texture, int face, int level, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        QCOMExtendedGet.nglExtGetTexLevelParameterivQCOM(texture, face, level, pname, MemoryUtil.memAddress(params));
    }

    public static void glExtGetTexLevelParameterivQCOM(int texture, int face, int level, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        QCOMExtendedGet.nglExtGetTexLevelParameterivQCOM(texture, face, level, pname, MemoryUtil.memAddress(params));
    }

    public static int glExtGetTexLevelParameteriQCOM(int texture, int face, int level, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        QCOMExtendedGet.nglExtGetTexLevelParameterivQCOM(texture, face, level, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void glExtTexObjectStateOverrideiQCOM(int target, int pname, int param) {
        long __functionAddress = QCOMExtendedGet.getInstance().ExtTexObjectStateOverrideiQCOM;
        JNI.callIIIV(__functionAddress, target, pname, param);
    }

    public static void nglExtGetTexSubImageQCOM(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, long texels) {
        long __functionAddress = QCOMExtendedGet.getInstance().ExtGetTexSubImageQCOM;
        JNI.callIIIIIIIIIIPV(__functionAddress, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, texels);
    }

    public static void glExtGetTexSubImageQCOM(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ByteBuffer texels) {
        QCOMExtendedGet.nglExtGetTexSubImageQCOM(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(texels));
    }

    public static void nglExtGetBufferPointervQCOM(int target, long params) {
        long __functionAddress = QCOMExtendedGet.getInstance().ExtGetBufferPointervQCOM;
        JNI.callIPV(__functionAddress, target, params);
    }

    public static void glExtGetBufferPointervQCOM(int target, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1 << Pointer.POINTER_SHIFT);
        }
        QCOMExtendedGet.nglExtGetBufferPointervQCOM(target, MemoryUtil.memAddress(params));
    }

    public static void glExtGetBufferPointervQCOM(int target, PointerBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(params, 1);
        }
        QCOMExtendedGet.nglExtGetBufferPointervQCOM(target, MemoryUtil.memAddress(params));
    }

    public static long glExtGetBufferPointerQCOM(int target) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.pointerParam();
        QCOMExtendedGet.nglExtGetBufferPointervQCOM(target, __buffer.address(params));
        return __buffer.pointerValue(params);
    }
}

