/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.ovr.OVRErrorInfo;
import org.lwjgl.ovr.OVREyeRenderDesc;
import org.lwjgl.ovr.OVRFovPort;
import org.lwjgl.ovr.OVRGraphicsLuid;
import org.lwjgl.ovr.OVRHmdDesc;
import org.lwjgl.ovr.OVRInitParams;
import org.lwjgl.ovr.OVRInputState;
import org.lwjgl.ovr.OVRSessionStatus;
import org.lwjgl.ovr.OVRSizei;
import org.lwjgl.ovr.OVRSwapTextureSet;
import org.lwjgl.ovr.OVRTexture;
import org.lwjgl.ovr.OVRTrackingState;
import org.lwjgl.ovr.OVRViewScaleDesc;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class OVR {
    public static final int ovrFalse = 0;
    public static final int ovrTrue = 1;
    public static final int ovrInit_Debug = 1;
    public static final int ovrInit_RequestVersion = 4;
    public static final int ovrInit_WritableBits = 0xFFFFFF;
    public static final int ovrLogLevel_Debug = 0;
    public static final int ovrLogLevel_Info = 1;
    public static final int ovrLogLevel_Error = 2;
    public static final int ovrHmd_None = 0;
    public static final int ovrHmd_DK1 = 3;
    public static final int ovrHmd_DKHD = 4;
    public static final int ovrHmd_DK2 = 6;
    public static final int ovrHmd_CB = 8;
    public static final int ovrHmd_Other = 9;
    public static final int ovrHmd_E3_2015 = 10;
    public static final int ovrHmd_ES06 = 11;
    public static final int ovrHmd_ES09 = 12;
    public static final int ovrHmdCap_DebugDevice = 16;
    public static final int ovrHmdCap_Writable_Mask = 0;
    public static final int ovrHmdCap_Service_Mask = 0;
    public static final int ovrTrackingCap_Orientation = 16;
    public static final int ovrTrackingCap_MagYawCorrection = 32;
    public static final int ovrTrackingCap_Position = 64;
    public static final int ovrEye_Left = 0;
    public static final int ovrEye_Right = 1;
    public static final int ovrEye_Count = 2;
    public static final int ovrStatus_OrientationTracked = 1;
    public static final int ovrStatus_PositionTracked = 2;
    public static final int ovrStatus_CameraPoseTracked = 4;
    public static final int ovrStatus_PositionConnected = 32;
    public static final int ovrStatus_HmdConnected = 128;
    public static final int ovrRenderAPI_None = 0;
    public static final int ovrRenderAPI_OpenGL = 1;
    public static final int ovrRenderAPI_Android_GLES = 2;
    public static final int ovrRenderAPI_D3D11 = 5;
    public static final int ovrButton_A = 1;
    public static final int ovrButton_B = 2;
    public static final int ovrButton_RThumb = 4;
    public static final int ovrButton_RShoulder = 8;
    public static final int ovrButton_X = 256;
    public static final int ovrButton_Y = 512;
    public static final int ovrButton_LThumb = 1024;
    public static final int ovrButton_LShoulder = 2048;
    public static final int ovrButton_Up = 65536;
    public static final int ovrButton_Down = 131072;
    public static final int ovrButton_Left = 262144;
    public static final int ovrButton_Right = 524288;
    public static final int ovrButton_Enter = 0x100000;
    public static final int ovrButton_Back = 0x200000;
    public static final int ovrButton_Private = 0x1C00000;
    public static final int ovrTouch_A = 1;
    public static final int ovrTouch_B = 2;
    public static final int ovrTouch_RThumb = 4;
    public static final int ovrTouch_RIndexTrigger = 16;
    public static final int ovrTouch_X = 256;
    public static final int ovrTouch_Y = 512;
    public static final int ovrTouch_LThumb = 1024;
    public static final int ovrTouch_LIndexTrigger = 4096;
    public static final int ovrTouch_RIndexPointing = 32;
    public static final int ovrTouch_RThumbUp = 64;
    public static final int ovrTouch_LIndexPointing = 8192;
    public static final int ovrTouch_LThumbUp = 16384;
    public static final int ovrControllerType_None = 0;
    public static final int ovrControllerType_LTouch = 1;
    public static final int ovrControllerType_RTouch = 2;
    public static final int ovrControllerType_Touch = 3;
    public static final int ovrControllerType_XBox = 16;
    public static final int ovrControllerType_All = 255;
    public static final int ovrHand_Left = 0;
    public static final int ovrHand_Right = 1;
    public static final int ovrMaxLayerCount = 32;
    public static final int ovrLayerType_Disabled = 0;
    public static final int ovrLayerType_EyeFov = 1;
    public static final int ovrLayerType_EyeFovDepth = 2;
    public static final int ovrLayerType_Quad = 3;
    public static final int ovrLayerType_EyeMatrix = 5;
    public static final int ovrLayerType_Direct = 6;
    public static final int ovrLayerFlag_HighQuality = 1;
    public static final int ovrLayerFlag_TextureOriginAtBottomLeft = 2;
    public static final int ovrLayerFlag_HeadLocked = 4;
    public static final int ovrPerfHud_Off = 0;
    public static final int ovrPerfHud_LatencyTiming = 1;
    public static final int ovrPerfHud_RenderTiming = 2;
    public static final int ovrPerfHud_PerfHeadroom = 3;
    public static final int ovrPerfHud_VersionInfo = 4;
    public static final int ovrLayerHud_Off = 0;
    public static final int ovrLayerHud_Info = 1;
    public static final int ovrDebugHudStereo_Off = 0;
    public static final int ovrDebugHudStereo_Quad = 1;
    public static final int ovrDebugHudStereo_QuadWithCrosshair = 2;
    public static final int ovrDebugHudStereo_CrosshairAtInfinity = 3;

    protected OVR() {
        throw new UnsupportedOperationException();
    }

    public static native int novr_Initialize(long var0);

    public static int ovr_Initialize(OVRInitParams params) {
        return OVR.novr_Initialize(params == null ? 0L : params.address());
    }

    public static native void ovr_Shutdown();

    public static native void novr_GetLastErrorInfo(long var0);

    public static void ovr_GetLastErrorInfo(OVRErrorInfo errorInfo) {
        OVR.novr_GetLastErrorInfo(errorInfo.address());
    }

    public static native long novr_GetVersionString();

    public static String ovr_GetVersionString() {
        long __result = OVR.novr_GetVersionString();
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static native long novr_TraceMessage(int var0, long var1);

    public static String ovr_TraceMessage(int level, ByteBuffer message) {
        long __result = OVR.novr_TraceMessage(level, MemoryUtil.memAddress(message));
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static String ovr_TraceMessage(int level, CharSequence message) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int messageEncoded = __buffer.stringParamUTF8(message, true);
        long __result = OVR.novr_TraceMessage(level, __buffer.address(messageEncoded));
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static native void novr_GetHmdDesc(long var0, long var2);

    public static void ovr_GetHmdDesc(long session, OVRHmdDesc __result) {
        OVR.novr_GetHmdDesc(session, __result.address());
    }

    public static native int novr_Create(long var0, long var2);

    public static int ovr_Create(ByteBuffer pSession, OVRGraphicsLuid luid) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)pSession, 1 << Pointer.POINTER_SHIFT);
        }
        return OVR.novr_Create(MemoryUtil.memAddress(pSession), luid.address());
    }

    public static int ovr_Create(PointerBuffer pSession, OVRGraphicsLuid luid) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(pSession, 1);
        }
        return OVR.novr_Create(MemoryUtil.memAddress(pSession), luid.address());
    }

    public static native void novr_Destroy(long var0);

    public static void ovr_Destroy(long session) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        OVR.novr_Destroy(session);
    }

    public static native int novr_GetSessionStatus(long var0, long var2);

    public static int ovr_GetSessionStatus(long session, OVRSessionStatus sessionStatus) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        return OVR.novr_GetSessionStatus(session, sessionStatus.address());
    }

    public static native int novr_GetEnabledCaps(long var0);

    public static int ovr_GetEnabledCaps(long session) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        return OVR.novr_GetEnabledCaps(session);
    }

    public static native void novr_SetEnabledCaps(long var0, int var2);

    public static void ovr_SetEnabledCaps(long session, int hmdCaps) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        OVR.novr_SetEnabledCaps(session, hmdCaps);
    }

    public static native int novr_GetTrackingCaps(long var0);

    public static int ovr_GetTrackingCaps(long session) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        return OVR.novr_GetTrackingCaps(session);
    }

    public static native int novr_ConfigureTracking(long var0, int var2, int var3);

    public static int ovr_ConfigureTracking(long session, int requestedTrackingCaps, int requiredTrackingCaps) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        return OVR.novr_ConfigureTracking(session, requestedTrackingCaps, requiredTrackingCaps);
    }

    public static native void novr_RecenterPose(long var0);

    public static void ovr_RecenterPose(long session) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        OVR.novr_RecenterPose(session);
    }

    public static native void novr_GetTrackingState(long var0, double var2, boolean var4, long var5);

    public static void ovr_GetTrackingState(long session, double absTime, boolean latencyMarker, OVRTrackingState __result) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        OVR.novr_GetTrackingState(session, absTime, latencyMarker, __result.address());
    }

    public static native int novr_GetInputState(long var0, int var2, long var3);

    public static int ovr_GetInputState(long session, int controllerTypeMask, OVRInputState inputState) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        return OVR.novr_GetInputState(session, controllerTypeMask, inputState.address());
    }

    public static native int novr_SetControllerVibration(long var0, int var2, float var3, float var4);

    public static int ovr_SetControllerVibration(long session, int controllerTypeMask, float frequency, float amplitude) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        return OVR.novr_SetControllerVibration(session, controllerTypeMask, frequency, amplitude);
    }

    public static native void novr_DestroySwapTextureSet(long var0, long var2);

    public static void ovr_DestroySwapTextureSet(long session, OVRSwapTextureSet textureSet) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        OVR.novr_DestroySwapTextureSet(session, textureSet == null ? 0L : textureSet.address());
    }

    public static native void novr_DestroyMirrorTexture(long var0, long var2);

    public static void ovr_DestroyMirrorTexture(long session, OVRTexture mirrorTexture) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        OVR.novr_DestroyMirrorTexture(session, mirrorTexture == null ? 0L : mirrorTexture.address());
    }

    public static native void novr_GetFovTextureSize(long var0, int var2, long var3, float var5, long var6);

    public static void ovr_GetFovTextureSize(long session, int eye, OVRFovPort fov, float pixelsPerDisplayPixel, OVRSizei __result) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        OVR.novr_GetFovTextureSize(session, eye, fov.address(), pixelsPerDisplayPixel, __result.address());
    }

    public static native void novr_GetRenderDesc(long var0, int var2, long var3, long var5);

    public static void ovr_GetRenderDesc(long session, int eyeType, OVRFovPort fov, OVREyeRenderDesc __result) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        OVR.novr_GetRenderDesc(session, eyeType, fov.address(), __result.address());
    }

    public static native int novr_SubmitFrame(long var0, long var2, long var4, long var6, int var8);

    public static int ovr_SubmitFrame(long session, long frameIndex, OVRViewScaleDesc viewScaleDesc, ByteBuffer layerPtrList, int layerCount) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
            Checks.checkBuffer((Buffer)layerPtrList, layerCount << Pointer.POINTER_SHIFT);
        }
        return OVR.novr_SubmitFrame(session, frameIndex, viewScaleDesc == null ? 0L : viewScaleDesc.address(), MemoryUtil.memAddress(layerPtrList), layerCount);
    }

    public static int ovr_SubmitFrame(long session, long frameIndex, OVRViewScaleDesc viewScaleDesc, PointerBuffer layerPtrList) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        return OVR.novr_SubmitFrame(session, frameIndex, viewScaleDesc == null ? 0L : viewScaleDesc.address(), MemoryUtil.memAddress(layerPtrList), layerPtrList.remaining());
    }

    public static native double novr_GetPredictedDisplayTime(long var0, long var2);

    public static double ovr_GetPredictedDisplayTime(long session, long frameIndex) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        return OVR.novr_GetPredictedDisplayTime(session, frameIndex);
    }

    public static native double ovr_GetTimeInSeconds();

    public static native void novr_ResetBackOfHeadTracking(long var0);

    public static void ovr_ResetBackOfHeadTracking(long session) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        OVR.novr_ResetBackOfHeadTracking(session);
    }

    public static native void novr_ResetMulticameraTracking(long var0);

    public static void ovr_ResetMulticameraTracking(long session) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        OVR.novr_ResetMulticameraTracking(session);
    }

    public static native boolean novr_GetBool(long var0, long var2, boolean var4);

    public static boolean ovr_GetBool(long session, ByteBuffer propertyName, boolean defaultVal) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
            Checks.checkNT1(propertyName);
        }
        return OVR.novr_GetBool(session, MemoryUtil.memAddress(propertyName), defaultVal);
    }

    public static boolean ovr_GetBool(long session, CharSequence propertyName, boolean defaultVal) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int propertyNameEncoded = __buffer.stringParamASCII(propertyName, true);
        return OVR.novr_GetBool(session, __buffer.address(propertyNameEncoded), defaultVal);
    }

    public static native boolean novr_SetBool(long var0, long var2, boolean var4);

    public static boolean ovr_SetBool(long session, ByteBuffer propertyName, boolean value) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
            Checks.checkNT1(propertyName);
        }
        return OVR.novr_SetBool(session, MemoryUtil.memAddress(propertyName), value);
    }

    public static boolean ovr_SetBool(long session, CharSequence propertyName, boolean value) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int propertyNameEncoded = __buffer.stringParamASCII(propertyName, true);
        return OVR.novr_SetBool(session, __buffer.address(propertyNameEncoded), value);
    }

    public static native int novr_GetInt(long var0, long var2, int var4);

    public static int ovr_GetInt(long session, ByteBuffer propertyName, int defaultVal) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
            Checks.checkNT1(propertyName);
        }
        return OVR.novr_GetInt(session, MemoryUtil.memAddress(propertyName), defaultVal);
    }

    public static int ovr_GetInt(long session, CharSequence propertyName, int defaultVal) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int propertyNameEncoded = __buffer.stringParamASCII(propertyName, true);
        return OVR.novr_GetInt(session, __buffer.address(propertyNameEncoded), defaultVal);
    }

    public static native boolean novr_SetInt(long var0, long var2, int var4);

    public static boolean ovr_SetInt(long session, ByteBuffer propertyName, int value) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
            Checks.checkNT1(propertyName);
        }
        return OVR.novr_SetInt(session, MemoryUtil.memAddress(propertyName), value);
    }

    public static boolean ovr_SetInt(long session, CharSequence propertyName, int value) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int propertyNameEncoded = __buffer.stringParamASCII(propertyName, true);
        return OVR.novr_SetInt(session, __buffer.address(propertyNameEncoded), value);
    }

    public static native float novr_GetFloat(long var0, long var2, float var4);

    public static float ovr_GetFloat(long session, ByteBuffer propertyName, float defaultVal) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
            Checks.checkNT1(propertyName);
        }
        return OVR.novr_GetFloat(session, MemoryUtil.memAddress(propertyName), defaultVal);
    }

    public static float ovr_GetFloat(long session, CharSequence propertyName, float defaultVal) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int propertyNameEncoded = __buffer.stringParamASCII(propertyName, true);
        return OVR.novr_GetFloat(session, __buffer.address(propertyNameEncoded), defaultVal);
    }

    public static native boolean novr_SetFloat(long var0, long var2, float var4);

    public static boolean ovr_SetFloat(long session, ByteBuffer propertyName, float value) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
            Checks.checkNT1(propertyName);
        }
        return OVR.novr_SetFloat(session, MemoryUtil.memAddress(propertyName), value);
    }

    public static boolean ovr_SetFloat(long session, CharSequence propertyName, float value) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int propertyNameEncoded = __buffer.stringParamASCII(propertyName, true);
        return OVR.novr_SetFloat(session, __buffer.address(propertyNameEncoded), value);
    }

    public static native int novr_GetFloatArray(long var0, long var2, long var4, int var6);

    public static int ovr_GetFloatArray(long session, ByteBuffer propertyName, ByteBuffer values, int valuesCapacity) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
            Checks.checkNT1(propertyName);
            Checks.checkBuffer((Buffer)values, valuesCapacity << 2);
        }
        return OVR.novr_GetFloatArray(session, MemoryUtil.memAddress(propertyName), MemoryUtil.memAddress(values), valuesCapacity);
    }

    public static int ovr_GetFloatArray(long session, ByteBuffer propertyName, FloatBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        return OVR.novr_GetFloatArray(session, MemoryUtil.memAddress(propertyName), MemoryUtil.memAddress(values), values.remaining());
    }

    public static int ovr_GetFloatArray(long session, CharSequence propertyName, FloatBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int propertyNameEncoded = __buffer.stringParamASCII(propertyName, true);
        return OVR.novr_GetFloatArray(session, __buffer.address(propertyNameEncoded), MemoryUtil.memAddress(values), values.remaining());
    }

    public static native boolean novr_SetFloatArray(long var0, long var2, long var4, int var6);

    public static boolean ovr_SetFloatArray(long session, ByteBuffer propertyName, ByteBuffer values, int valuesSize) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
            Checks.checkNT1(propertyName);
            Checks.checkBuffer((Buffer)values, valuesSize << 2);
        }
        return OVR.novr_SetFloatArray(session, MemoryUtil.memAddress(propertyName), MemoryUtil.memAddress(values), valuesSize);
    }

    public static boolean ovr_SetFloatArray(long session, ByteBuffer propertyName, FloatBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        return OVR.novr_SetFloatArray(session, MemoryUtil.memAddress(propertyName), MemoryUtil.memAddress(values), values.remaining());
    }

    public static boolean ovr_SetFloatArray(long session, CharSequence propertyName, FloatBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int propertyNameEncoded = __buffer.stringParamASCII(propertyName, true);
        return OVR.novr_SetFloatArray(session, __buffer.address(propertyNameEncoded), MemoryUtil.memAddress(values), values.remaining());
    }

    public static native long novr_GetString(long var0, long var2, long var4);

    public static String ovr_GetString(long session, ByteBuffer propertyName, ByteBuffer defaultVal) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        long __result = OVR.novr_GetString(session, MemoryUtil.memAddress(propertyName), MemoryUtil.memAddressSafe(defaultVal));
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static String ovr_GetString(long session, CharSequence propertyName, CharSequence defaultVal) {
        if (Checks.CHECKS) {
            Checks.checkPointer(session);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int propertyNameEncoded = __buffer.stringParamASCII(propertyName, true);
        int defaultValEncoded = __buffer.stringParamUTF8(defaultVal, true);
        long __result = OVR.novr_GetString(session, __buffer.address(propertyNameEncoded), __buffer.addressSafe(defaultVal, defaultValEncoded));
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static native boolean novr_SetString(long var0, long var2, long var4);

    public static boolean ovr_SetString(long hmddesc, ByteBuffer propertyName, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkPointer(hmddesc);
            Checks.checkNT1(propertyName);
            Checks.checkNT1(value);
        }
        return OVR.novr_SetString(hmddesc, MemoryUtil.memAddress(propertyName), MemoryUtil.memAddress(value));
    }

    public static boolean ovr_SetString(long hmddesc, CharSequence propertyName, CharSequence value) {
        if (Checks.CHECKS) {
            Checks.checkPointer(hmddesc);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int propertyNameEncoded = __buffer.stringParamASCII(propertyName, true);
        int valueEncoded = __buffer.stringParamASCII(value, true);
        return OVR.novr_SetString(hmddesc, __buffer.address(propertyNameEncoded), __buffer.address(valueEncoded));
    }

    static {
        Library.initialize();
    }
}

