/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRErrorInfo
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int RESULT;
    public static final int ERRORSTRING;

    OVRErrorInfo(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public OVRErrorInfo(long struct) {
        this(struct, null);
    }

    public OVRErrorInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int Result() {
        return OVRErrorInfo.nResult(this.address());
    }

    public ByteBuffer ErrorString() {
        return OVRErrorInfo.nErrorString(this.address());
    }

    public byte ErrorString(int index) {
        return OVRErrorInfo.nErrorString(this.address(), index);
    }

    public static OVRErrorInfo malloc() {
        return new OVRErrorInfo(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRErrorInfo calloc() {
        return new OVRErrorInfo(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRErrorInfo create() {
        return new OVRErrorInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static int nResult(long struct) {
        return MemoryUtil.memGetInt(struct + (long)RESULT);
    }

    public static ByteBuffer nErrorString(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)ERRORSTRING, 512);
    }

    public static byte nErrorString(long struct, int index) {
        return MemoryUtil.memGetByte(struct + (long)ERRORSTRING + (long)(index * 1));
    }

    static {
        Struct.Layout layout = OVRErrorInfo.__struct(OVRErrorInfo.__member(4), OVRErrorInfo.__array(1, 512));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        RESULT = layout.offsetof(0);
        ERRORSTRING = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<OVRErrorInfo, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected OVRErrorInfo newInstance(long address) {
            return new OVRErrorInfo(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int Result() {
            return OVRErrorInfo.nResult(this.address());
        }

        public ByteBuffer ErrorString() {
            return OVRErrorInfo.nErrorString(this.address());
        }

        public byte ErrorString(int index) {
            return OVRErrorInfo.nErrorString(this.address(), index);
        }
    }
}

