/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRFovPort;
import org.lwjgl.ovr.OVRRecti;
import org.lwjgl.ovr.OVRVector2f;
import org.lwjgl.ovr.OVRVector3f;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVREyeRenderDesc
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int EYE;
    public static final int FOV;
    public static final int DISTORTEDVIEWPORT;
    public static final int PIXELSPERTANANGLEATCENTER;
    public static final int HMDTOEYEVIEWOFFSET;

    OVREyeRenderDesc(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public OVREyeRenderDesc(long struct) {
        this(struct, null);
    }

    public OVREyeRenderDesc(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int Eye() {
        return OVREyeRenderDesc.nEye(this.address());
    }

    public OVRFovPort Fov() {
        return OVREyeRenderDesc.nFov(this.address());
    }

    public OVRRecti DistortedViewport() {
        return OVREyeRenderDesc.nDistortedViewport(this.address());
    }

    public OVRVector2f PixelsPerTanAngleAtCenter() {
        return OVREyeRenderDesc.nPixelsPerTanAngleAtCenter(this.address());
    }

    public OVRVector3f HmdToEyeViewOffset() {
        return OVREyeRenderDesc.nHmdToEyeViewOffset(this.address());
    }

    public static OVREyeRenderDesc malloc() {
        return new OVREyeRenderDesc(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVREyeRenderDesc calloc() {
        return new OVREyeRenderDesc(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVREyeRenderDesc create() {
        return new OVREyeRenderDesc(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static int nEye(long struct) {
        return MemoryUtil.memGetInt(struct + (long)EYE);
    }

    public static OVRFovPort nFov(long struct) {
        return new OVRFovPort(struct + (long)FOV);
    }

    public static OVRRecti nDistortedViewport(long struct) {
        return new OVRRecti(struct + (long)DISTORTEDVIEWPORT);
    }

    public static OVRVector2f nPixelsPerTanAngleAtCenter(long struct) {
        return new OVRVector2f(struct + (long)PIXELSPERTANANGLEATCENTER);
    }

    public static OVRVector3f nHmdToEyeViewOffset(long struct) {
        return new OVRVector3f(struct + (long)HMDTOEYEVIEWOFFSET);
    }

    static {
        Struct.Layout layout = OVREyeRenderDesc.__struct(OVREyeRenderDesc.__member(4), OVREyeRenderDesc.__member(OVRFovPort.SIZEOF, OVRFovPort.__ALIGNMENT), OVREyeRenderDesc.__member(OVRRecti.SIZEOF, OVRRecti.__ALIGNMENT), OVREyeRenderDesc.__member(OVRVector2f.SIZEOF, OVRVector2f.__ALIGNMENT), OVREyeRenderDesc.__member(OVRVector3f.SIZEOF, OVRVector3f.__ALIGNMENT));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        EYE = layout.offsetof(0);
        FOV = layout.offsetof(1);
        DISTORTEDVIEWPORT = layout.offsetof(2);
        PIXELSPERTANANGLEATCENTER = layout.offsetof(3);
        HMDTOEYEVIEWOFFSET = layout.offsetof(4);
    }

    public static final class Buffer
    extends StructBuffer<OVREyeRenderDesc, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected OVREyeRenderDesc newInstance(long address) {
            return new OVREyeRenderDesc(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int Eye() {
            return OVREyeRenderDesc.nEye(this.address());
        }

        public OVRFovPort Fov() {
            return OVREyeRenderDesc.nFov(this.address());
        }

        public OVRRecti DistortedViewport() {
            return OVREyeRenderDesc.nDistortedViewport(this.address());
        }

        public OVRVector2f PixelsPerTanAngleAtCenter() {
            return OVREyeRenderDesc.nPixelsPerTanAngleAtCenter(this.address());
        }

        public OVRVector3f HmdToEyeViewOffset() {
            return OVREyeRenderDesc.nHmdToEyeViewOffset(this.address());
        }
    }
}

