/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRGLTextureData;
import org.lwjgl.ovr.OVRTexture;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRGLTexture
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int TEXTURE;
    public static final int OGL;

    OVRGLTexture(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public OVRGLTexture(long struct) {
        this(struct, null);
    }

    public OVRGLTexture(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public OVRTexture Texture() {
        return OVRGLTexture.nTexture(this.address());
    }

    public OVRGLTextureData OGL() {
        return OVRGLTexture.nOGL(this.address());
    }

    public OVRGLTexture Texture(OVRTexture value) {
        OVRGLTexture.nTexture(this.address(), value);
        return this;
    }

    public OVRGLTexture OGL(OVRGLTextureData value) {
        OVRGLTexture.nOGL(this.address(), value);
        return this;
    }

    public OVRGLTexture set(OVRTexture Texture, OVRGLTextureData OGL) {
        this.Texture(Texture);
        this.OGL(OGL);
        return this;
    }

    public OVRGLTexture nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public OVRGLTexture set(OVRGLTexture src) {
        return this.nset(src.address());
    }

    public OVRGLTexture set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static OVRGLTexture malloc() {
        return new OVRGLTexture(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRGLTexture calloc() {
        return new OVRGLTexture(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRGLTexture create() {
        return new OVRGLTexture(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static OVRTexture nTexture(long struct) {
        return new OVRTexture(struct + (long)TEXTURE);
    }

    public static OVRGLTextureData nOGL(long struct) {
        return new OVRGLTextureData(struct + (long)OGL);
    }

    public static void nTexture(long struct, OVRTexture value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TEXTURE, OVRTexture.SIZEOF);
    }

    public static void nOGL(long struct, OVRGLTextureData value) {
        MemoryUtil.memCopy(value.address(), struct + (long)OGL, OVRGLTextureData.SIZEOF);
    }

    static {
        Struct.Layout layout = OVRGLTexture.__union(OVRGLTexture.__member(OVRTexture.SIZEOF, OVRTexture.__ALIGNMENT), OVRGLTexture.__member(OVRGLTextureData.SIZEOF, OVRGLTextureData.__ALIGNMENT));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        TEXTURE = layout.offsetof(0);
        OGL = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<OVRGLTexture, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected OVRGLTexture newInstance(long address) {
            return new OVRGLTexture(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public OVRTexture Texture() {
            return OVRGLTexture.nTexture(this.address());
        }

        public OVRGLTextureData OGL() {
            return OVRGLTexture.nOGL(this.address());
        }

        public Buffer Texture(OVRTexture value) {
            OVRGLTexture.nTexture(this.address(), value);
            return this;
        }

        public Buffer OGL(OVRGLTextureData value) {
            OVRGLTexture.nOGL(this.address(), value);
            return this;
        }
    }
}

