/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.ovr.OVRLayerHeader;
import org.lwjgl.ovr.OVRRecti;
import org.lwjgl.ovr.OVRSwapTextureSet;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRLayerDirect
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int HEADER;
    public static final int COLORTEXTURE;
    public static final int VIEWPORT;

    OVRLayerDirect(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public OVRLayerDirect(long struct) {
        this(struct, null);
    }

    public OVRLayerDirect(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public OVRLayerHeader Header() {
        return OVRLayerDirect.nHeader(this.address());
    }

    public PointerBuffer ColorTexture() {
        return OVRLayerDirect.nColorTexture(this.address());
    }

    public OVRSwapTextureSet ColorTexture(int index) {
        return OVRLayerDirect.nColorTexture(this.address(), index);
    }

    public OVRRecti.Buffer Viewport() {
        return OVRLayerDirect.nViewport(this.address());
    }

    public OVRRecti Viewport(int index) {
        return OVRLayerDirect.nViewport(this.address(), index);
    }

    public OVRLayerDirect Header(OVRLayerHeader value) {
        OVRLayerDirect.nHeader(this.address(), value);
        return this;
    }

    public OVRLayerDirect ColorTexture(PointerBuffer value) {
        OVRLayerDirect.nColorTexture(this.address(), value);
        return this;
    }

    public OVRLayerDirect ColorTexture(int index, OVRSwapTextureSet value) {
        OVRLayerDirect.nColorTexture(this.address(), index, value);
        return this;
    }

    public OVRLayerDirect Viewport(OVRRecti.Buffer value) {
        OVRLayerDirect.nViewport(this.address(), value);
        return this;
    }

    public OVRLayerDirect Viewport(int index, OVRRecti value) {
        OVRLayerDirect.nViewport(this.address(), index, value);
        return this;
    }

    public OVRLayerDirect set(OVRLayerHeader Header, PointerBuffer ColorTexture, OVRRecti.Buffer Viewport) {
        this.Header(Header);
        this.ColorTexture(ColorTexture);
        this.Viewport(Viewport);
        return this;
    }

    public OVRLayerDirect nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public OVRLayerDirect set(OVRLayerDirect src) {
        return this.nset(src.address());
    }

    public OVRLayerDirect set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static OVRLayerDirect malloc() {
        return new OVRLayerDirect(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRLayerDirect calloc() {
        return new OVRLayerDirect(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRLayerDirect create() {
        return new OVRLayerDirect(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static OVRLayerHeader nHeader(long struct) {
        return new OVRLayerHeader(struct + (long)HEADER);
    }

    public static PointerBuffer nColorTexture(long struct) {
        return MemoryUtil.memPointerBuffer(struct + (long)COLORTEXTURE, 2);
    }

    public static OVRSwapTextureSet nColorTexture(long struct, int index) {
        return new OVRSwapTextureSet(MemoryUtil.memGetAddress(struct + (long)COLORTEXTURE + (long)(index * POINTER_SIZE)));
    }

    public static OVRRecti.Buffer nViewport(long struct) {
        return OVRRecti.createBuffer(struct + (long)VIEWPORT, 2);
    }

    public static OVRRecti nViewport(long struct, int index) {
        return new OVRRecti(struct + (long)VIEWPORT + (long)(index * OVRRecti.SIZEOF));
    }

    public static void nHeader(long struct, OVRLayerHeader value) {
        MemoryUtil.memCopy(value.address(), struct + (long)HEADER, OVRLayerHeader.SIZEOF);
    }

    public static void nColorTexture(long struct, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBufferGT(value, 2);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)COLORTEXTURE, value.remaining() * POINTER_SIZE);
    }

    public static void nColorTexture(long struct, int index, OVRSwapTextureSet value) {
        MemoryUtil.memPutAddress(struct + (long)COLORTEXTURE + (long)(index * POINTER_SIZE), value.address());
    }

    public static void nViewport(long struct, OVRRecti.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkBufferGT(value, 2);
        }
        MemoryUtil.memCopy(value.address(), struct + (long)VIEWPORT, value.remaining() * OVRRecti.SIZEOF);
    }

    public static void nViewport(long struct, int index, OVRRecti value) {
        MemoryUtil.memCopy(value.address(), struct + (long)VIEWPORT + (long)(index * OVRRecti.SIZEOF), OVRRecti.SIZEOF);
    }

    static {
        Struct.Layout layout = OVRLayerDirect.__struct(OVRLayerDirect.__member(OVRLayerHeader.SIZEOF, OVRLayerHeader.__ALIGNMENT), OVRLayerDirect.__array(Pointer.POINTER_SIZE, 2), OVRLayerDirect.__array(OVRRecti.SIZEOF, OVRRecti.__ALIGNMENT, 2));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        HEADER = layout.offsetof(0);
        COLORTEXTURE = layout.offsetof(1);
        VIEWPORT = layout.offsetof(2);
    }

    public static final class Buffer
    extends StructBuffer<OVRLayerDirect, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected OVRLayerDirect newInstance(long address) {
            return new OVRLayerDirect(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public OVRLayerHeader Header() {
            return OVRLayerDirect.nHeader(this.address());
        }

        public PointerBuffer ColorTexture() {
            return OVRLayerDirect.nColorTexture(this.address());
        }

        public OVRSwapTextureSet ColorTexture(int index) {
            return OVRLayerDirect.nColorTexture(this.address(), index);
        }

        public OVRRecti.Buffer Viewport() {
            return OVRLayerDirect.nViewport(this.address());
        }

        public OVRRecti Viewport(int index) {
            return OVRLayerDirect.nViewport(this.address(), index);
        }

        public Buffer Header(OVRLayerHeader value) {
            OVRLayerDirect.nHeader(this.address(), value);
            return this;
        }

        public Buffer ColorTexture(PointerBuffer value) {
            OVRLayerDirect.nColorTexture(this.address(), value);
            return this;
        }

        public Buffer ColorTexture(int index, OVRSwapTextureSet value) {
            OVRLayerDirect.nColorTexture(this.address(), index, value);
            return this;
        }

        public Buffer Viewport(OVRRecti.Buffer value) {
            OVRLayerDirect.nViewport(this.address(), value);
            return this;
        }

        public Buffer Viewport(int index, OVRRecti value) {
            OVRLayerDirect.nViewport(this.address(), index, value);
            return this;
        }
    }
}

