/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.ovr.OVRLayerHeader;
import org.lwjgl.ovr.OVRMatrix4f;
import org.lwjgl.ovr.OVRPosef;
import org.lwjgl.ovr.OVRRecti;
import org.lwjgl.ovr.OVRSwapTextureSet;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRLayerEyeMatrix
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int HEADER;
    public static final int COLORTEXTURE;
    public static final int VIEWPORT;
    public static final int RENDERPOSE;
    public static final int MATRIX;
    public static final int SENSORSAMPLETIME;

    OVRLayerEyeMatrix(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public OVRLayerEyeMatrix(long struct) {
        this(struct, null);
    }

    public OVRLayerEyeMatrix(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public OVRLayerHeader Header() {
        return OVRLayerEyeMatrix.nHeader(this.address());
    }

    public PointerBuffer ColorTexture() {
        return OVRLayerEyeMatrix.nColorTexture(this.address());
    }

    public OVRSwapTextureSet ColorTexture(int index) {
        return OVRLayerEyeMatrix.nColorTexture(this.address(), index);
    }

    public OVRRecti.Buffer Viewport() {
        return OVRLayerEyeMatrix.nViewport(this.address());
    }

    public OVRRecti Viewport(int index) {
        return OVRLayerEyeMatrix.nViewport(this.address(), index);
    }

    public OVRPosef.Buffer RenderPose() {
        return OVRLayerEyeMatrix.nRenderPose(this.address());
    }

    public OVRPosef RenderPose(int index) {
        return OVRLayerEyeMatrix.nRenderPose(this.address(), index);
    }

    public OVRMatrix4f.Buffer Matrix() {
        return OVRLayerEyeMatrix.nMatrix(this.address());
    }

    public OVRMatrix4f Matrix(int index) {
        return OVRLayerEyeMatrix.nMatrix(this.address(), index);
    }

    public double SensorSampleTime() {
        return OVRLayerEyeMatrix.nSensorSampleTime(this.address());
    }

    public OVRLayerEyeMatrix Header(OVRLayerHeader value) {
        OVRLayerEyeMatrix.nHeader(this.address(), value);
        return this;
    }

    public OVRLayerEyeMatrix ColorTexture(PointerBuffer value) {
        OVRLayerEyeMatrix.nColorTexture(this.address(), value);
        return this;
    }

    public OVRLayerEyeMatrix ColorTexture(int index, OVRSwapTextureSet value) {
        OVRLayerEyeMatrix.nColorTexture(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeMatrix Viewport(OVRRecti.Buffer value) {
        OVRLayerEyeMatrix.nViewport(this.address(), value);
        return this;
    }

    public OVRLayerEyeMatrix Viewport(int index, OVRRecti value) {
        OVRLayerEyeMatrix.nViewport(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeMatrix RenderPose(OVRPosef.Buffer value) {
        OVRLayerEyeMatrix.nRenderPose(this.address(), value);
        return this;
    }

    public OVRLayerEyeMatrix RenderPose(int index, OVRPosef value) {
        OVRLayerEyeMatrix.nRenderPose(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeMatrix Matrix(OVRMatrix4f.Buffer value) {
        OVRLayerEyeMatrix.nMatrix(this.address(), value);
        return this;
    }

    public OVRLayerEyeMatrix Matrix(int index, OVRMatrix4f value) {
        OVRLayerEyeMatrix.nMatrix(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeMatrix SensorSampleTime(double value) {
        OVRLayerEyeMatrix.nSensorSampleTime(this.address(), value);
        return this;
    }

    public OVRLayerEyeMatrix set(OVRLayerHeader Header, PointerBuffer ColorTexture, OVRRecti.Buffer Viewport, OVRPosef.Buffer RenderPose, OVRMatrix4f.Buffer Matrix, double SensorSampleTime) {
        this.Header(Header);
        this.ColorTexture(ColorTexture);
        this.Viewport(Viewport);
        this.RenderPose(RenderPose);
        this.Matrix(Matrix);
        this.SensorSampleTime(SensorSampleTime);
        return this;
    }

    public OVRLayerEyeMatrix nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public OVRLayerEyeMatrix set(OVRLayerEyeMatrix src) {
        return this.nset(src.address());
    }

    public OVRLayerEyeMatrix set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static OVRLayerEyeMatrix malloc() {
        return new OVRLayerEyeMatrix(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRLayerEyeMatrix calloc() {
        return new OVRLayerEyeMatrix(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRLayerEyeMatrix create() {
        return new OVRLayerEyeMatrix(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static OVRLayerHeader nHeader(long struct) {
        return new OVRLayerHeader(struct + (long)HEADER);
    }

    public static PointerBuffer nColorTexture(long struct) {
        return MemoryUtil.memPointerBuffer(struct + (long)COLORTEXTURE, 2);
    }

    public static OVRSwapTextureSet nColorTexture(long struct, int index) {
        return new OVRSwapTextureSet(MemoryUtil.memGetAddress(struct + (long)COLORTEXTURE + (long)(index * POINTER_SIZE)));
    }

    public static OVRRecti.Buffer nViewport(long struct) {
        return OVRRecti.createBuffer(struct + (long)VIEWPORT, 2);
    }

    public static OVRRecti nViewport(long struct, int index) {
        return new OVRRecti(struct + (long)VIEWPORT + (long)(index * OVRRecti.SIZEOF));
    }

    public static OVRPosef.Buffer nRenderPose(long struct) {
        return OVRPosef.createBuffer(struct + (long)RENDERPOSE, 2);
    }

    public static OVRPosef nRenderPose(long struct, int index) {
        return new OVRPosef(struct + (long)RENDERPOSE + (long)(index * OVRPosef.SIZEOF));
    }

    public static OVRMatrix4f.Buffer nMatrix(long struct) {
        return OVRMatrix4f.createBuffer(struct + (long)MATRIX, 2);
    }

    public static OVRMatrix4f nMatrix(long struct, int index) {
        return new OVRMatrix4f(struct + (long)MATRIX + (long)(index * OVRMatrix4f.SIZEOF));
    }

    public static double nSensorSampleTime(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)SENSORSAMPLETIME);
    }

    public static void nHeader(long struct, OVRLayerHeader value) {
        MemoryUtil.memCopy(value.address(), struct + (long)HEADER, OVRLayerHeader.SIZEOF);
    }

    public static void nColorTexture(long struct, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBufferGT(value, 2);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)COLORTEXTURE, value.remaining() * POINTER_SIZE);
    }

    public static void nColorTexture(long struct, int index, OVRSwapTextureSet value) {
        MemoryUtil.memPutAddress(struct + (long)COLORTEXTURE + (long)(index * POINTER_SIZE), value.address());
    }

    public static void nViewport(long struct, OVRRecti.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkBufferGT(value, 2);
        }
        MemoryUtil.memCopy(value.address(), struct + (long)VIEWPORT, value.remaining() * OVRRecti.SIZEOF);
    }

    public static void nViewport(long struct, int index, OVRRecti value) {
        MemoryUtil.memCopy(value.address(), struct + (long)VIEWPORT + (long)(index * OVRRecti.SIZEOF), OVRRecti.SIZEOF);
    }

    public static void nRenderPose(long struct, OVRPosef.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkBufferGT(value, 2);
        }
        MemoryUtil.memCopy(value.address(), struct + (long)RENDERPOSE, value.remaining() * OVRPosef.SIZEOF);
    }

    public static void nRenderPose(long struct, int index, OVRPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)RENDERPOSE + (long)(index * OVRPosef.SIZEOF), OVRPosef.SIZEOF);
    }

    public static void nMatrix(long struct, OVRMatrix4f.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkBufferGT(value, 2);
        }
        MemoryUtil.memCopy(value.address(), struct + (long)MATRIX, value.remaining() * OVRMatrix4f.SIZEOF);
    }

    public static void nMatrix(long struct, int index, OVRMatrix4f value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MATRIX + (long)(index * OVRMatrix4f.SIZEOF), OVRMatrix4f.SIZEOF);
    }

    public static void nSensorSampleTime(long struct, double value) {
        MemoryUtil.memPutDouble(struct + (long)SENSORSAMPLETIME, value);
    }

    static {
        Struct.Layout layout = OVRLayerEyeMatrix.__struct(OVRLayerEyeMatrix.__member(OVRLayerHeader.SIZEOF, OVRLayerHeader.__ALIGNMENT), OVRLayerEyeMatrix.__array(Pointer.POINTER_SIZE, 2), OVRLayerEyeMatrix.__array(OVRRecti.SIZEOF, OVRRecti.__ALIGNMENT, 2), OVRLayerEyeMatrix.__array(OVRPosef.SIZEOF, OVRPosef.__ALIGNMENT, 2), OVRLayerEyeMatrix.__array(OVRMatrix4f.SIZEOF, OVRMatrix4f.__ALIGNMENT, 2), OVRLayerEyeMatrix.__member(8));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        HEADER = layout.offsetof(0);
        COLORTEXTURE = layout.offsetof(1);
        VIEWPORT = layout.offsetof(2);
        RENDERPOSE = layout.offsetof(3);
        MATRIX = layout.offsetof(4);
        SENSORSAMPLETIME = layout.offsetof(5);
    }

    public static final class Buffer
    extends StructBuffer<OVRLayerEyeMatrix, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected OVRLayerEyeMatrix newInstance(long address) {
            return new OVRLayerEyeMatrix(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public OVRLayerHeader Header() {
            return OVRLayerEyeMatrix.nHeader(this.address());
        }

        public PointerBuffer ColorTexture() {
            return OVRLayerEyeMatrix.nColorTexture(this.address());
        }

        public OVRSwapTextureSet ColorTexture(int index) {
            return OVRLayerEyeMatrix.nColorTexture(this.address(), index);
        }

        public OVRRecti.Buffer Viewport() {
            return OVRLayerEyeMatrix.nViewport(this.address());
        }

        public OVRRecti Viewport(int index) {
            return OVRLayerEyeMatrix.nViewport(this.address(), index);
        }

        public OVRPosef.Buffer RenderPose() {
            return OVRLayerEyeMatrix.nRenderPose(this.address());
        }

        public OVRPosef RenderPose(int index) {
            return OVRLayerEyeMatrix.nRenderPose(this.address(), index);
        }

        public OVRMatrix4f.Buffer Matrix() {
            return OVRLayerEyeMatrix.nMatrix(this.address());
        }

        public OVRMatrix4f Matrix(int index) {
            return OVRLayerEyeMatrix.nMatrix(this.address(), index);
        }

        public double SensorSampleTime() {
            return OVRLayerEyeMatrix.nSensorSampleTime(this.address());
        }

        public Buffer Header(OVRLayerHeader value) {
            OVRLayerEyeMatrix.nHeader(this.address(), value);
            return this;
        }

        public Buffer ColorTexture(PointerBuffer value) {
            OVRLayerEyeMatrix.nColorTexture(this.address(), value);
            return this;
        }

        public Buffer ColorTexture(int index, OVRSwapTextureSet value) {
            OVRLayerEyeMatrix.nColorTexture(this.address(), index, value);
            return this;
        }

        public Buffer Viewport(OVRRecti.Buffer value) {
            OVRLayerEyeMatrix.nViewport(this.address(), value);
            return this;
        }

        public Buffer Viewport(int index, OVRRecti value) {
            OVRLayerEyeMatrix.nViewport(this.address(), index, value);
            return this;
        }

        public Buffer RenderPose(OVRPosef.Buffer value) {
            OVRLayerEyeMatrix.nRenderPose(this.address(), value);
            return this;
        }

        public Buffer RenderPose(int index, OVRPosef value) {
            OVRLayerEyeMatrix.nRenderPose(this.address(), index, value);
            return this;
        }

        public Buffer Matrix(OVRMatrix4f.Buffer value) {
            OVRLayerEyeMatrix.nMatrix(this.address(), value);
            return this;
        }

        public Buffer Matrix(int index, OVRMatrix4f value) {
            OVRLayerEyeMatrix.nMatrix(this.address(), index, value);
            return this;
        }

        public Buffer SensorSampleTime(double value) {
            OVRLayerEyeMatrix.nSensorSampleTime(this.address(), value);
            return this;
        }
    }
}

