/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRLayerHeader
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int TYPE;
    public static final int FLAGS;

    OVRLayerHeader(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public OVRLayerHeader(long struct) {
        this(struct, null);
    }

    public OVRLayerHeader(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int Type() {
        return OVRLayerHeader.nType(this.address());
    }

    public int Flags() {
        return OVRLayerHeader.nFlags(this.address());
    }

    public OVRLayerHeader Type(int value) {
        OVRLayerHeader.nType(this.address(), value);
        return this;
    }

    public OVRLayerHeader Flags(int value) {
        OVRLayerHeader.nFlags(this.address(), value);
        return this;
    }

    public OVRLayerHeader set(int Type2, int Flags) {
        this.Type(Type2);
        this.Flags(Flags);
        return this;
    }

    public OVRLayerHeader nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public OVRLayerHeader set(OVRLayerHeader src) {
        return this.nset(src.address());
    }

    public OVRLayerHeader set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static OVRLayerHeader malloc() {
        return new OVRLayerHeader(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRLayerHeader calloc() {
        return new OVRLayerHeader(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRLayerHeader create() {
        return new OVRLayerHeader(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static int nType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static int nFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static void nType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nFlags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    static {
        Struct.Layout layout = OVRLayerHeader.__struct(OVRLayerHeader.__member(4), OVRLayerHeader.__member(4));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        TYPE = layout.offsetof(0);
        FLAGS = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<OVRLayerHeader, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected OVRLayerHeader newInstance(long address) {
            return new OVRLayerHeader(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int Type() {
            return OVRLayerHeader.nType(this.address());
        }

        public int Flags() {
            return OVRLayerHeader.nFlags(this.address());
        }

        public Buffer Type(int value) {
            OVRLayerHeader.nType(this.address(), value);
            return this;
        }

        public Buffer Flags(int value) {
            OVRLayerHeader.nFlags(this.address(), value);
            return this;
        }
    }
}

