/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRPosef;
import org.lwjgl.ovr.OVRVector3f;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRPoseStatef
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int THEPOSE;
    public static final int ANGULARVELOCITY;
    public static final int LINEARVELOCITY;
    public static final int ANGULARACCELERATION;
    public static final int LINEARACCELERATION;
    public static final int TIMEINSECONDS;

    OVRPoseStatef(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public OVRPoseStatef(long struct) {
        this(struct, null);
    }

    public OVRPoseStatef(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public OVRPosef ThePose() {
        return OVRPoseStatef.nThePose(this.address());
    }

    public OVRVector3f AngularVelocity() {
        return OVRPoseStatef.nAngularVelocity(this.address());
    }

    public OVRVector3f LinearVelocity() {
        return OVRPoseStatef.nLinearVelocity(this.address());
    }

    public OVRVector3f AngularAcceleration() {
        return OVRPoseStatef.nAngularAcceleration(this.address());
    }

    public OVRVector3f LinearAcceleration() {
        return OVRPoseStatef.nLinearAcceleration(this.address());
    }

    public double TimeInSeconds() {
        return OVRPoseStatef.nTimeInSeconds(this.address());
    }

    public static OVRPoseStatef malloc() {
        return new OVRPoseStatef(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRPoseStatef calloc() {
        return new OVRPoseStatef(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRPoseStatef create() {
        return new OVRPoseStatef(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static OVRPosef nThePose(long struct) {
        return new OVRPosef(struct + (long)THEPOSE);
    }

    public static OVRVector3f nAngularVelocity(long struct) {
        return new OVRVector3f(struct + (long)ANGULARVELOCITY);
    }

    public static OVRVector3f nLinearVelocity(long struct) {
        return new OVRVector3f(struct + (long)LINEARVELOCITY);
    }

    public static OVRVector3f nAngularAcceleration(long struct) {
        return new OVRVector3f(struct + (long)ANGULARACCELERATION);
    }

    public static OVRVector3f nLinearAcceleration(long struct) {
        return new OVRVector3f(struct + (long)LINEARACCELERATION);
    }

    public static double nTimeInSeconds(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)TIMEINSECONDS);
    }

    static {
        Struct.Layout layout = OVRPoseStatef.__struct(OVRPoseStatef.__member(OVRPosef.SIZEOF, OVRPosef.__ALIGNMENT), OVRPoseStatef.__member(OVRVector3f.SIZEOF, OVRVector3f.__ALIGNMENT), OVRPoseStatef.__member(OVRVector3f.SIZEOF, OVRVector3f.__ALIGNMENT), OVRPoseStatef.__member(OVRVector3f.SIZEOF, OVRVector3f.__ALIGNMENT), OVRPoseStatef.__member(OVRVector3f.SIZEOF, OVRVector3f.__ALIGNMENT), OVRPoseStatef.__member(8));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        THEPOSE = layout.offsetof(0);
        ANGULARVELOCITY = layout.offsetof(1);
        LINEARVELOCITY = layout.offsetof(2);
        ANGULARACCELERATION = layout.offsetof(3);
        LINEARACCELERATION = layout.offsetof(4);
        TIMEINSECONDS = layout.offsetof(5);
    }

    public static final class Buffer
    extends StructBuffer<OVRPoseStatef, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected OVRPoseStatef newInstance(long address) {
            return new OVRPoseStatef(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public OVRPosef ThePose() {
            return OVRPoseStatef.nThePose(this.address());
        }

        public OVRVector3f AngularVelocity() {
            return OVRPoseStatef.nAngularVelocity(this.address());
        }

        public OVRVector3f LinearVelocity() {
            return OVRPoseStatef.nLinearVelocity(this.address());
        }

        public OVRVector3f AngularAcceleration() {
            return OVRPoseStatef.nAngularAcceleration(this.address());
        }

        public OVRVector3f LinearAcceleration() {
            return OVRPoseStatef.nLinearAcceleration(this.address());
        }

        public double TimeInSeconds() {
            return OVRPoseStatef.nTimeInSeconds(this.address());
        }
    }
}

