/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRVector3f;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRSensorData
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int ACCELEROMETER;
    public static final int GYRO;
    public static final int MAGNETOMETER;
    public static final int TEMPERATURE;
    public static final int TIMEINSECONDS;

    OVRSensorData(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public OVRSensorData(long struct) {
        this(struct, null);
    }

    public OVRSensorData(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public OVRVector3f Accelerometer() {
        return OVRSensorData.nAccelerometer(this.address());
    }

    public OVRVector3f Gyro() {
        return OVRSensorData.nGyro(this.address());
    }

    public OVRVector3f Magnetometer() {
        return OVRSensorData.nMagnetometer(this.address());
    }

    public float Temperature() {
        return OVRSensorData.nTemperature(this.address());
    }

    public float TimeInSeconds() {
        return OVRSensorData.nTimeInSeconds(this.address());
    }

    public static OVRSensorData malloc() {
        return new OVRSensorData(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRSensorData calloc() {
        return new OVRSensorData(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRSensorData create() {
        return new OVRSensorData(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static OVRVector3f nAccelerometer(long struct) {
        return new OVRVector3f(struct + (long)ACCELEROMETER);
    }

    public static OVRVector3f nGyro(long struct) {
        return new OVRVector3f(struct + (long)GYRO);
    }

    public static OVRVector3f nMagnetometer(long struct) {
        return new OVRVector3f(struct + (long)MAGNETOMETER);
    }

    public static float nTemperature(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)TEMPERATURE);
    }

    public static float nTimeInSeconds(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)TIMEINSECONDS);
    }

    static {
        Struct.Layout layout = OVRSensorData.__struct(OVRSensorData.__member(OVRVector3f.SIZEOF, OVRVector3f.__ALIGNMENT), OVRSensorData.__member(OVRVector3f.SIZEOF, OVRVector3f.__ALIGNMENT), OVRSensorData.__member(OVRVector3f.SIZEOF, OVRVector3f.__ALIGNMENT), OVRSensorData.__member(4), OVRSensorData.__member(4));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        ACCELEROMETER = layout.offsetof(0);
        GYRO = layout.offsetof(1);
        MAGNETOMETER = layout.offsetof(2);
        TEMPERATURE = layout.offsetof(3);
        TIMEINSECONDS = layout.offsetof(4);
    }

    public static final class Buffer
    extends StructBuffer<OVRSensorData, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected OVRSensorData newInstance(long address) {
            return new OVRSensorData(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public OVRVector3f Accelerometer() {
            return OVRSensorData.nAccelerometer(this.address());
        }

        public OVRVector3f Gyro() {
            return OVRSensorData.nGyro(this.address());
        }

        public OVRVector3f Magnetometer() {
            return OVRSensorData.nMagnetometer(this.address());
        }

        public float Temperature() {
            return OVRSensorData.nTemperature(this.address());
        }

        public float TimeInSeconds() {
            return OVRSensorData.nTimeInSeconds(this.address());
        }
    }
}

