/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRTexture;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRSwapTextureSet
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int TEXTURES;
    public static final int TEXTURECOUNT;
    public static final int CURRENTINDEX;

    OVRSwapTextureSet(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public OVRSwapTextureSet(long struct) {
        this(struct, null);
    }

    public OVRSwapTextureSet(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public OVRTexture Textures() {
        return OVRSwapTextureSet.nTexturesStruct(this.address());
    }

    public int TextureCount() {
        return OVRSwapTextureSet.nTextureCount(this.address());
    }

    public int CurrentIndex() {
        return OVRSwapTextureSet.nCurrentIndex(this.address());
    }

    public OVRSwapTextureSet Textures(OVRTexture value) {
        OVRSwapTextureSet.nTextures(this.address(), value);
        return this;
    }

    public OVRSwapTextureSet TextureCount(int value) {
        OVRSwapTextureSet.nTextureCount(this.address(), value);
        return this;
    }

    public OVRSwapTextureSet CurrentIndex(int value) {
        OVRSwapTextureSet.nCurrentIndex(this.address(), value);
        return this;
    }

    public OVRSwapTextureSet set(OVRTexture Textures, int TextureCount, int CurrentIndex) {
        this.Textures(Textures);
        this.TextureCount(TextureCount);
        this.CurrentIndex(CurrentIndex);
        return this;
    }

    public OVRSwapTextureSet nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public OVRSwapTextureSet set(OVRSwapTextureSet src) {
        return this.nset(src.address());
    }

    public OVRSwapTextureSet set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static OVRSwapTextureSet malloc() {
        return new OVRSwapTextureSet(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRSwapTextureSet calloc() {
        return new OVRSwapTextureSet(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRSwapTextureSet create() {
        return new OVRSwapTextureSet(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static OVRTexture nTexturesStruct(long struct) {
        return new OVRTexture(MemoryUtil.memGetAddress(struct + (long)TEXTURES));
    }

    public static int nTextureCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TEXTURECOUNT);
    }

    public static int nCurrentIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CURRENTINDEX);
    }

    public static void nTextures(long struct, OVRTexture value) {
        MemoryUtil.memPutAddress(struct + (long)TEXTURES, value.address());
    }

    public static void nTextureCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TEXTURECOUNT, value);
    }

    public static void nCurrentIndex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CURRENTINDEX, value);
    }

    static {
        Struct.Layout layout = OVRSwapTextureSet.__struct(OVRSwapTextureSet.__member(Pointer.POINTER_SIZE), OVRSwapTextureSet.__member(4), OVRSwapTextureSet.__member(4));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        TEXTURES = layout.offsetof(0);
        TEXTURECOUNT = layout.offsetof(1);
        CURRENTINDEX = layout.offsetof(2);
    }

    public static final class Buffer
    extends StructBuffer<OVRSwapTextureSet, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected OVRSwapTextureSet newInstance(long address) {
            return new OVRSwapTextureSet(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public OVRTexture Textures() {
            return OVRSwapTextureSet.nTexturesStruct(this.address());
        }

        public int TextureCount() {
            return OVRSwapTextureSet.nTextureCount(this.address());
        }

        public int CurrentIndex() {
            return OVRSwapTextureSet.nCurrentIndex(this.address());
        }

        public Buffer Textures(OVRTexture value) {
            OVRSwapTextureSet.nTextures(this.address(), value);
            return this;
        }

        public Buffer TextureCount(int value) {
            OVRSwapTextureSet.nTextureCount(this.address(), value);
            return this;
        }

        public Buffer CurrentIndex(int value) {
            OVRSwapTextureSet.nCurrentIndex(this.address(), value);
            return this;
        }
    }
}

