/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRSizei;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRTextureHeader
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int API;
    public static final int TEXTURESIZE;

    OVRTextureHeader(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public OVRTextureHeader(long struct) {
        this(struct, null);
    }

    public OVRTextureHeader(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int API() {
        return OVRTextureHeader.nAPI(this.address());
    }

    public OVRSizei TextureSize() {
        return OVRTextureHeader.nTextureSize(this.address());
    }

    public OVRTextureHeader API(int value) {
        OVRTextureHeader.nAPI(this.address(), value);
        return this;
    }

    public OVRTextureHeader TextureSize(OVRSizei value) {
        OVRTextureHeader.nTextureSize(this.address(), value);
        return this;
    }

    public OVRTextureHeader set(int API, OVRSizei TextureSize) {
        this.API(API);
        this.TextureSize(TextureSize);
        return this;
    }

    public OVRTextureHeader nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public OVRTextureHeader set(OVRTextureHeader src) {
        return this.nset(src.address());
    }

    public OVRTextureHeader set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static OVRTextureHeader malloc() {
        return new OVRTextureHeader(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRTextureHeader calloc() {
        return new OVRTextureHeader(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRTextureHeader create() {
        return new OVRTextureHeader(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static int nAPI(long struct) {
        return MemoryUtil.memGetInt(struct + (long)API);
    }

    public static OVRSizei nTextureSize(long struct) {
        return new OVRSizei(struct + (long)TEXTURESIZE);
    }

    public static void nAPI(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)API, value);
    }

    public static void nTextureSize(long struct, OVRSizei value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TEXTURESIZE, OVRSizei.SIZEOF);
    }

    static {
        Struct.Layout layout = OVRTextureHeader.__struct(OVRTextureHeader.__member(4), OVRTextureHeader.__member(OVRSizei.SIZEOF, OVRSizei.__ALIGNMENT));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        API = layout.offsetof(0);
        TEXTURESIZE = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<OVRTextureHeader, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected OVRTextureHeader newInstance(long address) {
            return new OVRTextureHeader(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int API() {
            return OVRTextureHeader.nAPI(this.address());
        }

        public OVRSizei TextureSize() {
            return OVRTextureHeader.nTextureSize(this.address());
        }

        public Buffer API(int value) {
            OVRTextureHeader.nAPI(this.address(), value);
            return this;
        }

        public Buffer TextureSize(OVRSizei value) {
            OVRTextureHeader.nTextureSize(this.address(), value);
            return this;
        }
    }
}

