/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class STBRPNode
extends Struct {
    public static final int SIZEOF = STBRPNode.offsets();

    private static native int offsets();

    STBRPNode(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public STBRPNode(long struct) {
        this(struct, null);
    }

    public STBRPNode(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public static STBRPNode malloc() {
        return new STBRPNode(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static STBRPNode calloc() {
        return new STBRPNode(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static STBRPNode create() {
        return new STBRPNode(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static final class Buffer
    extends StructBuffer<STBRPNode, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected STBRPNode newInstance(long address) {
            return new STBRPNode(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }
    }
}

