/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class STBTTVertex
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int X;
    public static final int Y;
    public static final int CX;
    public static final int CY;
    public static final int TYPE;

    STBTTVertex(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public STBTTVertex(long struct) {
        this(struct, null);
    }

    public STBTTVertex(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public short x() {
        return STBTTVertex.nx(this.address());
    }

    public short y() {
        return STBTTVertex.ny(this.address());
    }

    public short cx() {
        return STBTTVertex.ncx(this.address());
    }

    public short cy() {
        return STBTTVertex.ncy(this.address());
    }

    public byte type() {
        return STBTTVertex.ntype(this.address());
    }

    public static STBTTVertex malloc() {
        return new STBTTVertex(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static STBTTVertex calloc() {
        return new STBTTVertex(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static STBTTVertex create() {
        return new STBTTVertex(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static short nx(long struct) {
        return MemoryUtil.memGetShort(struct + (long)X);
    }

    public static short ny(long struct) {
        return MemoryUtil.memGetShort(struct + (long)Y);
    }

    public static short ncx(long struct) {
        return MemoryUtil.memGetShort(struct + (long)CX);
    }

    public static short ncy(long struct) {
        return MemoryUtil.memGetShort(struct + (long)CY);
    }

    public static byte ntype(long struct) {
        return MemoryUtil.memGetByte(struct + (long)TYPE);
    }

    static {
        Struct.Layout layout = STBTTVertex.__struct(STBTTVertex.__member(2), STBTTVertex.__member(2), STBTTVertex.__member(2), STBTTVertex.__member(2), STBTTVertex.__member(1));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        CX = layout.offsetof(2);
        CY = layout.offsetof(3);
        TYPE = layout.offsetof(4);
    }

    public static final class Buffer
    extends StructBuffer<STBTTVertex, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected STBTTVertex newInstance(long address) {
            return new STBTTVertex(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public short x() {
            return STBTTVertex.nx(this.address());
        }

        public short y() {
            return STBTTVertex.ny(this.address());
        }

        public short cx() {
            return STBTTVertex.ncx(this.address());
        }

        public short cy() {
            return STBTTVertex.ncy(this.address());
        }

        public byte type() {
            return STBTTVertex.ntype(this.address());
        }
    }
}

