/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class STBVorbisAlloc
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int ALLOC_BUFFER;
    public static final int ALLOC_BUFFER_LENGTH_IN_BYTES;

    STBVorbisAlloc(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public STBVorbisAlloc(long struct) {
        this(struct, null);
    }

    public STBVorbisAlloc(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public ByteBuffer alloc_buffer(int capacity) {
        return STBVorbisAlloc.nalloc_buffer(this.address(), capacity);
    }

    public int alloc_buffer_length_in_bytes() {
        return STBVorbisAlloc.nalloc_buffer_length_in_bytes(this.address());
    }

    public STBVorbisAlloc alloc_buffer(ByteBuffer value) {
        STBVorbisAlloc.nalloc_buffer(this.address(), value);
        return this;
    }

    public STBVorbisAlloc alloc_buffer_length_in_bytes(int value) {
        STBVorbisAlloc.nalloc_buffer_length_in_bytes(this.address(), value);
        return this;
    }

    public STBVorbisAlloc set(ByteBuffer alloc_buffer, int alloc_buffer_length_in_bytes) {
        this.alloc_buffer(alloc_buffer);
        this.alloc_buffer_length_in_bytes(alloc_buffer_length_in_bytes);
        return this;
    }

    public STBVorbisAlloc nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public STBVorbisAlloc set(STBVorbisAlloc src) {
        return this.nset(src.address());
    }

    public STBVorbisAlloc set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static STBVorbisAlloc malloc() {
        return new STBVorbisAlloc(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static STBVorbisAlloc calloc() {
        return new STBVorbisAlloc(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static STBVorbisAlloc create() {
        return new STBVorbisAlloc(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static ByteBuffer nalloc_buffer(long struct, int capacity) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)ALLOC_BUFFER), capacity);
    }

    public static int nalloc_buffer_length_in_bytes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ALLOC_BUFFER_LENGTH_IN_BYTES);
    }

    public static void nalloc_buffer(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)ALLOC_BUFFER, MemoryUtil.memAddressSafe(value));
    }

    public static void nalloc_buffer_length_in_bytes(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ALLOC_BUFFER_LENGTH_IN_BYTES, value);
    }

    static {
        Struct.Layout layout = STBVorbisAlloc.__struct(STBVorbisAlloc.__member(Pointer.POINTER_SIZE), STBVorbisAlloc.__member(4));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        ALLOC_BUFFER = layout.offsetof(0);
        ALLOC_BUFFER_LENGTH_IN_BYTES = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<STBVorbisAlloc, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected STBVorbisAlloc newInstance(long address) {
            return new STBVorbisAlloc(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public ByteBuffer alloc_buffer(int capacity) {
            return STBVorbisAlloc.nalloc_buffer(this.address(), capacity);
        }

        public int alloc_buffer_length_in_bytes() {
            return STBVorbisAlloc.nalloc_buffer_length_in_bytes(this.address());
        }

        public Buffer alloc_buffer(ByteBuffer value) {
            STBVorbisAlloc.nalloc_buffer(this.address(), value);
            return this;
        }

        public Buffer alloc_buffer_length_in_bytes(int value) {
            STBVorbisAlloc.nalloc_buffer_length_in_bytes(this.address(), value);
            return this;
        }
    }
}

