/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.Library;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.linux.LinuxLibrary;
import org.lwjgl.system.macosx.MacOSXLibrary;
import org.lwjgl.system.windows.WindowsLibrary;

public final class APIUtil {
    public static final PrintStream DEBUG_STREAM = Configuration.createDebugStream();
    private static final ThreadLocal<APIBuffer> API_BUFFERS = new ThreadLocal<APIBuffer>(){

        @Override
        protected APIBuffer initialValue() {
            return new APIBuffer();
        }
    };

    private APIUtil() {
    }

    public static void apiLog(CharSequence msg) {
        if (Checks.DEBUG) {
            DEBUG_STREAM.print("[LWJGL] ");
            DEBUG_STREAM.println(msg);
        }
    }

    public static APIBuffer apiBuffer() {
        return API_BUFFERS.get().reset();
    }

    public static APIBuffer apiStack() {
        return API_BUFFERS.get().push();
    }

    public static SharedLibrary apiCreateLibrary(String name) {
        switch (Platform.get()) {
            case WINDOWS: {
                return new WindowsLibrary(name);
            }
            case LINUX: {
                return new LinuxLibrary(name);
            }
            case MACOSX: {
                return MacOSXLibrary.create(name);
            }
        }
        throw new IllegalStateException();
    }

    public static APIVersion apiParseVersion(String version) {
        return APIUtil.apiParseVersion(version, null);
    }

    public static APIVersion apiParseVersion(String version, String prefix) {
        Matcher matcher;
        String pattern = "([0-9]+)[.]([0-9]+)([.]\\S+)?\\s*(.+)?";
        if (prefix != null) {
            pattern = prefix + "\\s+" + pattern;
        }
        if (!(matcher = Pattern.compile(pattern).matcher(version)).matches()) {
            throw new IllegalArgumentException(String.format("Malformed API version string [%s]", version));
        }
        return new APIVersion(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), matcher.group(3), matcher.group(4));
    }

    public static String apiUnknownToken(int token) {
        return APIUtil.apiUnknownToken("Unknown", token);
    }

    public static String apiUnknownToken(String description, int token) {
        return String.format("%s [0x%X]", description, token);
    }

    public static Map<Integer, String> apiClassTokens(TokenFilter filter, Map<Integer, String> target, Class<?> ... tokenClasses) {
        if (target == null) {
            target = new HashMap<Integer, String>(64);
        }
        int TOKEN_MODIFIERS = 25;
        for (Class<?> tokenClass : tokenClasses) {
            if (tokenClass == null) continue;
            for (Field field : tokenClass.getDeclaredFields()) {
                if ((field.getModifiers() & TOKEN_MODIFIERS) != TOKEN_MODIFIERS || field.getType() != Integer.TYPE) continue;
                try {
                    int value = field.getInt(null);
                    if (filter != null && !filter.accept(field, value)) continue;
                    String name = target.get(value);
                    target.put(value, name == null ? field.getName() : name + "|" + field.getName());
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        return target;
    }

    public static Class<?> apiOptionalClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    static {
        Library.initialize();
    }

    public static interface TokenFilter {
        public boolean accept(Field var1, int var2);
    }

    public static class APIVersion {
        public final int major;
        public final int minor;
        public final String revision;
        public final String implementation;

        public APIVersion(int major, int minor) {
            this(major, minor, null, null);
        }

        public APIVersion(int major, int minor, String revision, String implementation) {
            this.major = major;
            this.minor = minor;
            this.revision = revision;
            this.implementation = implementation;
        }
    }
}

