/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.lwjgl.system.APIUtil;

public enum Configuration {
    LIBRARY_PATH("org.lwjgl.librarypath", StateInit.STRING),
    SHARED_LIBRARY_TEMP_DIRECTORY("org.lwjgl.SharedLibraryTempDirectory", StateInit.STRING),
    LIBRARY_NAME_LWJGL("org.lwjgl.libname", StateInit.STRING),
    LIBRARY_NAME_HWLOC("org.lwjgl.system.hwloc.libname", StateInit.STRING),
    LIBRARY_NAME_JEMALLOC("org.lwjgl.system.jemalloc.libname", StateInit.STRING),
    LIBRARY_NAME_GLFW("org.lwjgl.glfw.libname", StateInit.STRING),
    LIBRARY_NAME_EGL("org.lwjgl.egl.libname", StateInit.STRING),
    LIBRARY_NAME_OPENAL("org.lwjgl.openal.libname", StateInit.STRING),
    LIBRARY_NAME_OPENCL("org.lwjgl.opencl.libname", StateInit.STRING),
    LIBRARY_NAME_OPENGL("org.lwjgl.opengl.libname", StateInit.STRING),
    LIBRARY_NAME_OPENGLES("org.lwjgl.opengles.libname", StateInit.STRING),
    MEMORY_DEFAULT_ALIGNMENT("org.lwjgl.util.BufferAlign", StateInit.STRING),
    MEMORY_ALLOCATOR("org.lwjgl.system.allocator", StateInit.STRING),
    DISABLE_CHECKS("org.lwjgl.util.NoChecks", StateInit.BOOLEAN),
    DEBUG("org.lwjgl.util.Debug", StateInit.BOOLEAN),
    DEBUG_STREAM("org.lwjgl.util.DebugStream", StateInit.STRING),
    DEBUG_MEMORY_ALLOCATOR("org.lwjgl.util.DebugAllocator", StateInit.BOOLEAN),
    MAXVERSION_OPENGL("org.lwjgl.opengl.maxVersion", StateInit.STRING),
    MAXVERSION_OPENGLES("org.lwjgl.opengles.maxVersion", StateInit.STRING),
    EXPLICIT_INIT_EGL("org.lwjgl.egl.explicitInit", StateInit.BOOLEAN),
    EXPLICIT_INIT_OPENAL("org.lwjgl.openal.explicitInit", StateInit.BOOLEAN),
    EXPLICIT_INIT_OPENCL("org.lwjgl.opencl.explicitInit", StateInit.BOOLEAN),
    EXPLICIT_INIT_OPENGL("org.lwjgl.opengl.explicitInit", StateInit.BOOLEAN),
    EXPLICIT_INIT_OPENGLES("org.lwjgl.opengles.explicitInit", StateInit.BOOLEAN),
    GLFW_EGL("org.lwjgl.glfw.EGL", StateInit.BOOLEAN);

    private final String property;
    private Object state;

    private Configuration(String property, StateInit init) {
        this.property = property;
        this.state = init.getState(property);
    }

    public String getProperty() {
        return this.property;
    }

    public void set(Object value) {
        this.state = value;
    }

    public <T> T get() {
        return (T)this.state;
    }

    public <T> T get(T defaultValue) {
        Object state = this.state;
        if (state == null) {
            state = defaultValue;
        }
        return (T)state;
    }

    public static APIUtil.APIVersion getAPIVersion(Configuration option) {
        Object state = option.get();
        APIUtil.APIVersion version = state instanceof String ? APIUtil.apiParseVersion((String)state, null) : (state instanceof APIUtil.APIVersion ? (APIUtil.APIVersion)state : null);
        return version;
    }

    public static void setDebugStreamConsumer(DebugStreamConsumer consumer) {
        Configuration.setDebugStreamConsumer(consumer, Charset.forName("UTF-8"));
    }

    public static void setDebugStreamConsumer(final DebugStreamConsumer consumer, final Charset charset) {
        final ByteArrayOutputStream buffer = new ByteArrayOutputStream(128){
            private final CharsetDecoder decoder;
            private byte[] tmp;
            private ByteBuffer in;
            private CharBuffer out;
            {
                super(x0);
                this.decoder = charset.newDecoder();
            }

            @Override
            public void flush() throws IOException {
                if (this.buf != this.tmp) {
                    this.tmp = this.buf;
                    this.out = CharBuffer.allocate(this.tmp.length);
                    this.in = ByteBuffer.wrap(this.tmp);
                } else {
                    this.out.clear();
                    this.in.position(0);
                }
                this.in.limit(this.count);
                this.decoder.reset();
                this.decoder.decode(this.in, this.out, true);
                this.out.flip();
                consumer.accept(this.out.toString());
                this.reset();
            }
        };
        DEBUG_STREAM.set(System.getProperty("line.separator").length() == 2 ? new PrintStream((OutputStream)buffer, false){

            @Override
            public void write(byte[] b, int off, int len) {
                int last = off + len - 1;
                if (b[last] == 10) {
                    buffer.write(b, off, len - (off < last && b[last - 1] == 13 ? 2 : 1));
                    this.flush();
                } else {
                    buffer.write(b, off, len);
                }
            }
        } : new PrintStream((OutputStream)buffer, false){

            @Override
            public void write(byte[] b, int off, int len) {
                if (b[off + len - 1] == 10) {
                    buffer.write(b, off, len - 1);
                    this.flush();
                } else {
                    buffer.write(b, off, len);
                }
            }
        });
    }

    public static PrintStream createDebugStream() {
        PrintStream debugStream = System.err;
        Object state = DEBUG_STREAM.get();
        if (state instanceof String) {
            try {
                DebugStreamFactory factory = (DebugStreamFactory)Class.forName((String)state).newInstance();
                debugStream = factory.create();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (state instanceof DebugStreamFactory) {
            debugStream = ((DebugStreamFactory)state).create();
        } else if (state instanceof PrintStream) {
            debugStream = (PrintStream)state;
        }
        return debugStream;
    }

    public static interface DebugStreamFactory {
        public PrintStream create();
    }

    public static interface DebugStreamConsumer {
        public void accept(String var1);
    }

    private static enum StateInit {
        STRING{

            @Override
            Object getState(String property) {
                return System.getProperty(property);
            }
        }
        ,
        BOOLEAN{

            @Override
            Object getState(String property) {
                return Boolean.getBoolean(property);
            }
        };


        abstract Object getState(String var1);
    }
}

