/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.io.File;
import java.util.regex.Pattern;
import org.lwjgl.Version;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.SharedLibraryLoader;

public final class Library {
    public static final String JNI_LIBRARY_NAME = Configuration.LIBRARY_NAME_LWJGL.get(System.getProperty("os.arch").contains("64") ? "lwjgl" : "lwjgl32");
    private static final String JAVA_LIBRARY_PATH = "java.library.path";
    private static final LibraryLoader<Boolean> LOADER_SYSTEM = new LibraryLoader<Boolean>(){

        @Override
        public Boolean load(File library) {
            System.load(library.getAbsolutePath());
            return true;
        }
    };
    private static final LibraryLoader<SharedLibrary> LOADER_NATIVE = new LibraryLoader<SharedLibrary>(){

        @Override
        public SharedLibrary load(File library) {
            return APIUtil.apiCreateLibrary(library.getPath());
        }
    };

    private Library() {
    }

    public static void initialize() {
    }

    public static void loadSystem(String name) throws UnsatisfiedLinkError {
        if (new File(name).isAbsolute()) {
            System.load(name);
            APIUtil.apiLog("Loaded library: " + name);
            return;
        }
        String override = (String)Configuration.LIBRARY_PATH.get();
        if (override != null && Library.loadLibrary(LOADER_SYSTEM, override, Platform.get().mapLibraryName(name), false).booleanValue()) {
            APIUtil.apiLog("Loaded library from " + Configuration.LIBRARY_PATH.getProperty() + ": " + name);
            return;
        }
        try {
            System.loadLibrary(name);
            APIUtil.apiLog("Loaded library from java.library.path: " + name);
        }
        catch (UnsatisfiedLinkError t) {
            try {
                System.load(new File("./" + Platform.get().mapLibraryName(name)).getAbsolutePath());
                APIUtil.apiLog("Loaded library from the working directory: " + name);
            }
            catch (UnsatisfiedLinkError ignored) {
                throw t;
            }
        }
    }

    public static SharedLibrary loadNative(String name) {
        SharedLibrary lib;
        if (new File(name).isAbsolute()) {
            return APIUtil.apiCreateLibrary(name);
        }
        String libName = Platform.get().mapLibraryName(name);
        String override = (String)Configuration.LIBRARY_PATH.get();
        if (override != null && (lib = (SharedLibrary)Library.loadLibrary(LOADER_NATIVE, override, libName, null)) != null) {
            return lib;
        }
        lib = Library.loadLibrary(LOADER_NATIVE, System.getProperty(JAVA_LIBRARY_PATH), libName, null);
        if (lib != null) {
            return lib;
        }
        try {
            return APIUtil.apiCreateLibrary(libName);
        }
        catch (RuntimeException e) {
            try {
                return APIUtil.apiCreateLibrary("./" + libName);
            }
            catch (Exception ignored) {
                throw e;
            }
        }
    }

    public static SharedLibrary loadNative(Configuration name, String ... defaultNames) {
        SharedLibrary library;
        block7: {
            if (defaultNames.length == 1 || name.get() != null) {
                return Library.loadNative(name.get(defaultNames[0]));
            }
            if (defaultNames.length == 0) {
                throw new RuntimeException("No default names specified.");
            }
            library = null;
            try {
                library = Library.loadNative(defaultNames[0]);
            }
            catch (Exception e) {
                for (int i = 1; i < defaultNames.length; ++i) {
                    try {
                        library = Library.loadNative(defaultNames[i]);
                        break;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                if (library != null) break block7;
                throw new RuntimeException("Failed to load library.", e);
            }
        }
        return library;
    }

    private static <T> T loadLibrary(LibraryLoader<T> loader, String path, String libName, T onFailure) {
        for (String root : Pattern.compile(File.pathSeparator).split(path)) {
            File f = new File(root + File.separator + libName);
            if (!f.exists()) continue;
            return loader.load(f);
        }
        return onFailure;
    }

    static {
        if (Checks.DEBUG) {
            APIUtil.apiLog("Version: " + Version.getVersion());
            APIUtil.apiLog("\t OS: " + System.getProperty("os.name") + " v" + System.getProperty("os.version"));
            APIUtil.apiLog("\tJRE: " + System.getProperty("java.version") + " " + System.getProperty("os.arch"));
            APIUtil.apiLog("\tJVM: " + System.getProperty("java.vm.name") + " v" + System.getProperty("java.vm.version") + " by " + System.getProperty("java.vm.vendor"));
        }
        try {
            Library.loadSystem(JNI_LIBRARY_NAME);
        }
        catch (UnsatisfiedLinkError ule) {
            try {
                SharedLibraryLoader.load();
                Library.loadSystem(JNI_LIBRARY_NAME);
            }
            catch (Throwable t) {
                if (Checks.DEBUG) {
                    t.printStackTrace(APIUtil.DEBUG_STREAM);
                }
                throw ule;
            }
        }
    }

    private static interface LibraryLoader<T> {
        public T load(File var1);
    }
}

