/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.jemalloc;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.system.jemalloc.ChunkAlloc;
import org.lwjgl.system.jemalloc.ChunkCommit;
import org.lwjgl.system.jemalloc.ChunkDalloc;
import org.lwjgl.system.jemalloc.ChunkDecommit;
import org.lwjgl.system.jemalloc.ChunkMerge;
import org.lwjgl.system.jemalloc.ChunkPurge;
import org.lwjgl.system.jemalloc.ChunkSplit;
import org.lwjgl.system.libffi.Closure;

public class ChunkHooks
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int ALLOC;
    public static final int DALLOC;
    public static final int COMMIT;
    public static final int DECOMMIT;
    public static final int PURGE;
    public static final int SPLIT;
    public static final int MERGE;

    ChunkHooks(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public ChunkHooks(long struct) {
        this(struct, null);
    }

    public ChunkHooks(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public ChunkAlloc alloc() {
        return ChunkHooks.nalloc(this.address());
    }

    public ChunkDalloc dalloc() {
        return ChunkHooks.ndalloc(this.address());
    }

    public ChunkCommit commit() {
        return ChunkHooks.ncommit(this.address());
    }

    public ChunkDecommit decommit() {
        return ChunkHooks.ndecommit(this.address());
    }

    public ChunkPurge purge() {
        return ChunkHooks.npurge(this.address());
    }

    public ChunkSplit split() {
        return ChunkHooks.nsplit(this.address());
    }

    public ChunkMerge merge() {
        return ChunkHooks.nmerge(this.address());
    }

    public ChunkHooks alloc(long value) {
        ChunkHooks.nalloc(this.address(), value);
        return this;
    }

    public ChunkHooks dalloc(long value) {
        ChunkHooks.ndalloc(this.address(), value);
        return this;
    }

    public ChunkHooks commit(long value) {
        ChunkHooks.ncommit(this.address(), value);
        return this;
    }

    public ChunkHooks decommit(long value) {
        ChunkHooks.ndecommit(this.address(), value);
        return this;
    }

    public ChunkHooks purge(long value) {
        ChunkHooks.npurge(this.address(), value);
        return this;
    }

    public ChunkHooks split(long value) {
        ChunkHooks.nsplit(this.address(), value);
        return this;
    }

    public ChunkHooks merge(long value) {
        ChunkHooks.nmerge(this.address(), value);
        return this;
    }

    public ChunkHooks set(long alloc, long dalloc, long commit, long decommit, long purge, long split, long merge) {
        this.alloc(alloc);
        this.dalloc(dalloc);
        this.commit(commit);
        this.decommit(decommit);
        this.purge(purge);
        this.split(split);
        this.merge(merge);
        return this;
    }

    public ChunkHooks nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public ChunkHooks set(ChunkHooks src) {
        return this.nset(src.address());
    }

    public ChunkHooks set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static ChunkHooks malloc() {
        return new ChunkHooks(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static ChunkHooks calloc() {
        return new ChunkHooks(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static ChunkHooks create() {
        return new ChunkHooks(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static ChunkAlloc nalloc(long struct) {
        return (ChunkAlloc)Closure.create(MemoryUtil.memGetAddress(struct + (long)ALLOC));
    }

    public static ChunkDalloc ndalloc(long struct) {
        return (ChunkDalloc)Closure.create(MemoryUtil.memGetAddress(struct + (long)DALLOC));
    }

    public static ChunkCommit ncommit(long struct) {
        return (ChunkCommit)Closure.create(MemoryUtil.memGetAddress(struct + (long)COMMIT));
    }

    public static ChunkDecommit ndecommit(long struct) {
        return (ChunkDecommit)Closure.create(MemoryUtil.memGetAddress(struct + (long)DECOMMIT));
    }

    public static ChunkPurge npurge(long struct) {
        return (ChunkPurge)Closure.create(MemoryUtil.memGetAddress(struct + (long)PURGE));
    }

    public static ChunkSplit nsplit(long struct) {
        return (ChunkSplit)Closure.create(MemoryUtil.memGetAddress(struct + (long)SPLIT));
    }

    public static ChunkMerge nmerge(long struct) {
        return (ChunkMerge)Closure.create(MemoryUtil.memGetAddress(struct + (long)MERGE));
    }

    public static void nalloc(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)ALLOC, value);
    }

    public static void ndalloc(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)DALLOC, value);
    }

    public static void ncommit(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)COMMIT, value);
    }

    public static void ndecommit(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)DECOMMIT, value);
    }

    public static void npurge(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PURGE, value);
    }

    public static void nsplit(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SPLIT, value);
    }

    public static void nmerge(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)MERGE, value);
    }

    static {
        Struct.Layout layout = ChunkHooks.__struct(ChunkHooks.__member(Pointer.POINTER_SIZE), ChunkHooks.__member(Pointer.POINTER_SIZE), ChunkHooks.__member(Pointer.POINTER_SIZE), ChunkHooks.__member(Pointer.POINTER_SIZE), ChunkHooks.__member(Pointer.POINTER_SIZE), ChunkHooks.__member(Pointer.POINTER_SIZE), ChunkHooks.__member(Pointer.POINTER_SIZE));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        ALLOC = layout.offsetof(0);
        DALLOC = layout.offsetof(1);
        COMMIT = layout.offsetof(2);
        DECOMMIT = layout.offsetof(3);
        PURGE = layout.offsetof(4);
        SPLIT = layout.offsetof(5);
        MERGE = layout.offsetof(6);
    }

    public static final class Buffer
    extends StructBuffer<ChunkHooks, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected ChunkHooks newInstance(long address) {
            return new ChunkHooks(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public ChunkAlloc alloc() {
            return ChunkHooks.nalloc(this.address());
        }

        public ChunkDalloc dalloc() {
            return ChunkHooks.ndalloc(this.address());
        }

        public ChunkCommit commit() {
            return ChunkHooks.ncommit(this.address());
        }

        public ChunkDecommit decommit() {
            return ChunkHooks.ndecommit(this.address());
        }

        public ChunkPurge purge() {
            return ChunkHooks.npurge(this.address());
        }

        public ChunkSplit split() {
            return ChunkHooks.nsplit(this.address());
        }

        public ChunkMerge merge() {
            return ChunkHooks.nmerge(this.address());
        }

        public Buffer alloc(long value) {
            ChunkHooks.nalloc(this.address(), value);
            return this;
        }

        public Buffer dalloc(long value) {
            ChunkHooks.ndalloc(this.address(), value);
            return this;
        }

        public Buffer commit(long value) {
            ChunkHooks.ncommit(this.address(), value);
            return this;
        }

        public Buffer decommit(long value) {
            ChunkHooks.ndecommit(this.address(), value);
            return this;
        }

        public Buffer purge(long value) {
            ChunkHooks.npurge(this.address(), value);
            return this;
        }

        public Buffer split(long value) {
            ChunkHooks.nsplit(this.address(), value);
            return this;
        }

        public Buffer merge(long value) {
            ChunkHooks.nmerge(this.address(), value);
            return this;
        }
    }
}

