/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.jemalloc;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.jemalloc.MallocMessageCallback;

public class JEmalloc {
    public final long malloc_message;
    public final long malloc;
    public final long calloc;
    public final long posix_memalign;
    public final long aligned_alloc;
    public final long realloc;
    public final long free;
    public final long mallocx;
    public final long rallocx;
    public final long xallocx;
    public final long sallocx;
    public final long dallocx;
    public final long sdallocx;
    public final long nallocx;
    public final long mallctl;
    public final long mallctlnametomib;
    public final long mallctlbymib;
    public final long malloc_stats_print;
    public final long malloc_usable_size;
    private static final SharedLibrary JEMALLOC = Library.loadNative(Configuration.LIBRARY_NAME_JEMALLOC.get(Pointer.BITS64 ? "jemalloc" : "jemalloc32"));
    private static final JEmalloc instance = new JEmalloc(JEMALLOC);

    protected JEmalloc() {
        throw new UnsupportedOperationException();
    }

    public JEmalloc(FunctionProvider provider) {
        this.malloc_message = Checks.checkFunctionAddress(provider.getFunctionAddress("je_malloc_message"));
        this.malloc = Checks.checkFunctionAddress(provider.getFunctionAddress("je_malloc"));
        this.calloc = Checks.checkFunctionAddress(provider.getFunctionAddress("je_calloc"));
        this.posix_memalign = Checks.checkFunctionAddress(provider.getFunctionAddress("je_posix_memalign"));
        this.aligned_alloc = Checks.checkFunctionAddress(provider.getFunctionAddress("je_aligned_alloc"));
        this.realloc = Checks.checkFunctionAddress(provider.getFunctionAddress("je_realloc"));
        this.free = Checks.checkFunctionAddress(provider.getFunctionAddress("je_free"));
        this.mallocx = Checks.checkFunctionAddress(provider.getFunctionAddress("je_mallocx"));
        this.rallocx = Checks.checkFunctionAddress(provider.getFunctionAddress("je_rallocx"));
        this.xallocx = Checks.checkFunctionAddress(provider.getFunctionAddress("je_xallocx"));
        this.sallocx = Checks.checkFunctionAddress(provider.getFunctionAddress("je_sallocx"));
        this.dallocx = Checks.checkFunctionAddress(provider.getFunctionAddress("je_dallocx"));
        this.sdallocx = Checks.checkFunctionAddress(provider.getFunctionAddress("je_sdallocx"));
        this.nallocx = Checks.checkFunctionAddress(provider.getFunctionAddress("je_nallocx"));
        this.mallctl = Checks.checkFunctionAddress(provider.getFunctionAddress("je_mallctl"));
        this.mallctlnametomib = Checks.checkFunctionAddress(provider.getFunctionAddress("je_mallctlnametomib"));
        this.mallctlbymib = Checks.checkFunctionAddress(provider.getFunctionAddress("je_mallctlbymib"));
        this.malloc_stats_print = Checks.checkFunctionAddress(provider.getFunctionAddress("je_malloc_stats_print"));
        this.malloc_usable_size = Checks.checkFunctionAddress(provider.getFunctionAddress("je_malloc_usable_size"));
    }

    public static SharedLibrary getLibrary() {
        return JEMALLOC;
    }

    public static JEmalloc getInstance() {
        return instance;
    }

    public static PointerBuffer je_malloc_message() {
        long __result = JEmalloc.getInstance().malloc_message;
        return MemoryUtil.memPointerBuffer(__result, 1);
    }

    public static long nje_malloc(long size) {
        long __functionAddress = JEmalloc.getInstance().malloc;
        return JNI.invokePP(__functionAddress, size);
    }

    public static ByteBuffer je_malloc(long size) {
        long __result = JEmalloc.nje_malloc(size);
        return MemoryUtil.memByteBuffer(__result, (int)size);
    }

    public static long nje_calloc(long num, long size) {
        long __functionAddress = JEmalloc.getInstance().calloc;
        return JNI.invokePPP(__functionAddress, num, size);
    }

    public static ByteBuffer je_calloc(long num, long size) {
        long __result = JEmalloc.nje_calloc(num, size);
        return MemoryUtil.memByteBuffer(__result, (int)num * (int)size);
    }

    public static int nje_posix_memalign(long memptr, long alignment, long size) {
        long __functionAddress = JEmalloc.getInstance().posix_memalign;
        return JNI.invokePPPI(__functionAddress, memptr, alignment, size);
    }

    public static int je_posix_memalign(ByteBuffer memptr, long alignment, long size) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)memptr, 1 << Pointer.POINTER_SHIFT);
        }
        return JEmalloc.nje_posix_memalign(MemoryUtil.memAddress(memptr), alignment, size);
    }

    public static int je_posix_memalign(PointerBuffer memptr, long alignment, long size) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(memptr, 1);
        }
        return JEmalloc.nje_posix_memalign(MemoryUtil.memAddress(memptr), alignment, size);
    }

    public static long nje_aligned_alloc(long alignment, long size) {
        long __functionAddress = JEmalloc.getInstance().aligned_alloc;
        return JNI.invokePPP(__functionAddress, alignment, size);
    }

    public static ByteBuffer je_aligned_alloc(long alignment, long size) {
        long __result = JEmalloc.nje_aligned_alloc(alignment, size);
        return MemoryUtil.memByteBuffer(__result, (int)size);
    }

    public static long nje_realloc(long ptr, long size) {
        long __functionAddress = JEmalloc.getInstance().realloc;
        return JNI.invokePPP(__functionAddress, ptr, size);
    }

    public static ByteBuffer je_realloc(ByteBuffer ptr, long size) {
        long __result = JEmalloc.nje_realloc(MemoryUtil.memAddressSafe(ptr), size);
        return MemoryUtil.memByteBuffer(__result, (int)size);
    }

    public static void nje_free(long ptr) {
        long __functionAddress = JEmalloc.getInstance().free;
        JNI.invokePV(__functionAddress, ptr);
    }

    public static void je_free(ByteBuffer ptr) {
        JEmalloc.nje_free(MemoryUtil.memAddressSafe(ptr));
    }

    public static void je_free(ShortBuffer ptr) {
        JEmalloc.nje_free(MemoryUtil.memAddressSafe(ptr));
    }

    public static void je_free(IntBuffer ptr) {
        JEmalloc.nje_free(MemoryUtil.memAddressSafe(ptr));
    }

    public static void je_free(LongBuffer ptr) {
        JEmalloc.nje_free(MemoryUtil.memAddressSafe(ptr));
    }

    public static void je_free(FloatBuffer ptr) {
        JEmalloc.nje_free(MemoryUtil.memAddressSafe(ptr));
    }

    public static void je_free(DoubleBuffer ptr) {
        JEmalloc.nje_free(MemoryUtil.memAddressSafe(ptr));
    }

    public static void je_free(PointerBuffer ptr) {
        JEmalloc.nje_free(MemoryUtil.memAddressSafe(ptr));
    }

    public static long nje_mallocx(long size, int flags) {
        long __functionAddress = JEmalloc.getInstance().mallocx;
        return JNI.invokePIP(__functionAddress, size, flags);
    }

    public static ByteBuffer je_mallocx(long size, int flags) {
        long __result = JEmalloc.nje_mallocx(size, flags);
        return MemoryUtil.memByteBuffer(__result, (int)size);
    }

    public static long nje_rallocx(long ptr, long size, int flags) {
        long __functionAddress = JEmalloc.getInstance().rallocx;
        return JNI.invokePPIP(__functionAddress, ptr, size, flags);
    }

    public static ByteBuffer je_rallocx(ByteBuffer ptr, long size, int flags) {
        long __result = JEmalloc.nje_rallocx(MemoryUtil.memAddressSafe(ptr), size, flags);
        return MemoryUtil.memByteBuffer(__result, (int)size);
    }

    public static long nje_xallocx(long ptr, long size, long extra, int flags) {
        long __functionAddress = JEmalloc.getInstance().xallocx;
        return JNI.invokePPPIP(__functionAddress, ptr, size, extra, flags);
    }

    public static long je_xallocx(ByteBuffer ptr, long size, long extra, int flags) {
        return JEmalloc.nje_xallocx(MemoryUtil.memAddressSafe(ptr), size, extra, flags);
    }

    public static long nje_sallocx(long ptr, int flags) {
        long __functionAddress = JEmalloc.getInstance().sallocx;
        return JNI.invokePIP(__functionAddress, ptr, flags);
    }

    public static long je_sallocx(ByteBuffer ptr, int flags) {
        return JEmalloc.nje_sallocx(MemoryUtil.memAddress(ptr), flags);
    }

    public static void nje_dallocx(long ptr, int flags) {
        long __functionAddress = JEmalloc.getInstance().dallocx;
        JNI.invokePIV(__functionAddress, ptr, flags);
    }

    public static void je_dallocx(ByteBuffer ptr, int flags) {
        JEmalloc.nje_dallocx(MemoryUtil.memAddress(ptr), flags);
    }

    public static void je_dallocx(ShortBuffer ptr, int flags) {
        JEmalloc.nje_dallocx(MemoryUtil.memAddress(ptr), flags);
    }

    public static void je_dallocx(IntBuffer ptr, int flags) {
        JEmalloc.nje_dallocx(MemoryUtil.memAddress(ptr), flags);
    }

    public static void je_dallocx(LongBuffer ptr, int flags) {
        JEmalloc.nje_dallocx(MemoryUtil.memAddress(ptr), flags);
    }

    public static void je_dallocx(FloatBuffer ptr, int flags) {
        JEmalloc.nje_dallocx(MemoryUtil.memAddress(ptr), flags);
    }

    public static void je_dallocx(DoubleBuffer ptr, int flags) {
        JEmalloc.nje_dallocx(MemoryUtil.memAddress(ptr), flags);
    }

    public static void je_dallocx(PointerBuffer ptr, int flags) {
        JEmalloc.nje_dallocx(MemoryUtil.memAddress(ptr), flags);
    }

    public static void nje_sdallocx(long ptr, long size, int flags) {
        long __functionAddress = JEmalloc.getInstance().sdallocx;
        JNI.invokePPIV(__functionAddress, ptr, size, flags);
    }

    public static void je_sdallocx(ByteBuffer ptr, long size, int flags) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)ptr, size);
        }
        JEmalloc.nje_sdallocx(MemoryUtil.memAddress(ptr), size, flags);
    }

    public static void je_sdallocx(ByteBuffer ptr, int flags) {
        JEmalloc.nje_sdallocx(MemoryUtil.memAddress(ptr), ptr.remaining(), flags);
    }

    public static void je_sdallocx(ShortBuffer ptr, int flags) {
        JEmalloc.nje_sdallocx(MemoryUtil.memAddress(ptr), ptr.remaining() << 1, flags);
    }

    public static void je_sdallocx(IntBuffer ptr, int flags) {
        JEmalloc.nje_sdallocx(MemoryUtil.memAddress(ptr), ptr.remaining() << 2, flags);
    }

    public static void je_sdallocx(LongBuffer ptr, int flags) {
        JEmalloc.nje_sdallocx(MemoryUtil.memAddress(ptr), ptr.remaining() << 3, flags);
    }

    public static void je_sdallocx(FloatBuffer ptr, int flags) {
        JEmalloc.nje_sdallocx(MemoryUtil.memAddress(ptr), ptr.remaining() << 2, flags);
    }

    public static void je_sdallocx(DoubleBuffer ptr, int flags) {
        JEmalloc.nje_sdallocx(MemoryUtil.memAddress(ptr), ptr.remaining() << 3, flags);
    }

    public static void je_sdallocx(PointerBuffer ptr, int flags) {
        JEmalloc.nje_sdallocx(MemoryUtil.memAddress(ptr), ptr.remaining() << Pointer.POINTER_SHIFT, flags);
    }

    public static long nje_nallocx(long size, int flags) {
        long __functionAddress = JEmalloc.getInstance().nallocx;
        return JNI.invokePIP(__functionAddress, size, flags);
    }

    public static ByteBuffer je_nallocx(long size, int flags) {
        long __result = JEmalloc.nje_nallocx(size, flags);
        return MemoryUtil.memByteBuffer(__result, (int)size);
    }

    public static int nje_mallctl(long name, long oldp, long oldlenp, long newp, long newlen) {
        long __functionAddress = JEmalloc.getInstance().mallctl;
        return JNI.invokePPPPPI(__functionAddress, name, oldp, oldlenp, newp, newlen);
    }

    public static int je_mallctl(ByteBuffer name, ByteBuffer oldp, ByteBuffer oldlenp, ByteBuffer newp, long newlen) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
            if (oldlenp != null) {
                Checks.checkBuffer((Buffer)oldlenp, 1 << Pointer.POINTER_SHIFT);
            }
            if (newp != null) {
                Checks.checkBuffer((Buffer)newp, newlen);
            }
        }
        return JEmalloc.nje_mallctl(MemoryUtil.memAddress(name), MemoryUtil.memAddressSafe(oldp), MemoryUtil.memAddressSafe(oldlenp), MemoryUtil.memAddressSafe(newp), newlen);
    }

    public static int je_mallctl(ByteBuffer name, ByteBuffer oldp, PointerBuffer oldlenp, ByteBuffer newp) {
        if (Checks.CHECKS && oldlenp != null) {
            Checks.checkBuffer(oldlenp, 1);
        }
        return JEmalloc.nje_mallctl(MemoryUtil.memAddress(name), MemoryUtil.memAddressSafe(oldp), MemoryUtil.memAddressSafe(oldlenp), MemoryUtil.memAddressSafe(newp), newp == null ? 0L : (long)newp.remaining());
    }

    public static int je_mallctl(CharSequence name, ByteBuffer oldp, PointerBuffer oldlenp, ByteBuffer newp) {
        if (Checks.CHECKS && oldlenp != null) {
            Checks.checkBuffer(oldlenp, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, true);
        return JEmalloc.nje_mallctl(__buffer.address(nameEncoded), MemoryUtil.memAddressSafe(oldp), MemoryUtil.memAddressSafe(oldlenp), MemoryUtil.memAddressSafe(newp), newp == null ? 0L : (long)newp.remaining());
    }

    public static int nje_mallctlnametomib(long name, long mibp, long miblenp) {
        long __functionAddress = JEmalloc.getInstance().mallctlnametomib;
        return JNI.invokePPPI(__functionAddress, name, mibp, miblenp);
    }

    public static int je_mallctlnametomib(ByteBuffer name, ByteBuffer mibp, ByteBuffer miblenp) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
            Checks.checkBuffer((Buffer)miblenp, 1 << Pointer.POINTER_SHIFT);
            Checks.checkBuffer((Buffer)mibp, PointerBuffer.get(miblenp, miblenp.position()) << Pointer.POINTER_SHIFT);
        }
        return JEmalloc.nje_mallctlnametomib(MemoryUtil.memAddress(name), MemoryUtil.memAddress(mibp), MemoryUtil.memAddress(miblenp));
    }

    public static int je_mallctlnametomib(ByteBuffer name, PointerBuffer mibp, PointerBuffer miblenp) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(miblenp, 1);
            Checks.checkBuffer(mibp, miblenp.get(miblenp.position()));
        }
        return JEmalloc.nje_mallctlnametomib(MemoryUtil.memAddress(name), MemoryUtil.memAddress(mibp), MemoryUtil.memAddress(miblenp));
    }

    public static int je_mallctlnametomib(CharSequence name, PointerBuffer mibp, PointerBuffer miblenp) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(miblenp, 1);
            Checks.checkBuffer(mibp, miblenp.get(miblenp.position()));
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, true);
        return JEmalloc.nje_mallctlnametomib(__buffer.address(nameEncoded), MemoryUtil.memAddress(mibp), MemoryUtil.memAddress(miblenp));
    }

    public static int nje_mallctlbymib(long mib, long miblen, long oldp, long oldlenp, long newp, long newlen) {
        long __functionAddress = JEmalloc.getInstance().mallctlbymib;
        return JNI.invokePPPPPPI(__functionAddress, mib, miblen, oldp, oldlenp, newp, newlen);
    }

    public static int je_mallctlbymib(ByteBuffer mib, long miblen, ByteBuffer oldp, ByteBuffer oldlenp, ByteBuffer newp, long newlen) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)mib, miblen << Pointer.POINTER_SHIFT);
            if (oldlenp != null) {
                Checks.checkBuffer((Buffer)oldlenp, 1 << Pointer.POINTER_SHIFT);
            }
            if (newp != null) {
                Checks.checkBuffer((Buffer)newp, newlen);
            }
        }
        return JEmalloc.nje_mallctlbymib(MemoryUtil.memAddress(mib), miblen, MemoryUtil.memAddressSafe(oldp), MemoryUtil.memAddressSafe(oldlenp), MemoryUtil.memAddressSafe(newp), newlen);
    }

    public static int je_mallctlbymib(PointerBuffer mib, ByteBuffer oldp, PointerBuffer oldlenp, ByteBuffer newp) {
        if (Checks.CHECKS && oldlenp != null) {
            Checks.checkBuffer(oldlenp, 1);
        }
        return JEmalloc.nje_mallctlbymib(MemoryUtil.memAddress(mib), mib.remaining(), MemoryUtil.memAddressSafe(oldp), MemoryUtil.memAddressSafe(oldlenp), MemoryUtil.memAddressSafe(newp), newp == null ? 0L : (long)newp.remaining());
    }

    public static void nje_malloc_stats_print(long write_cb, long je_cbopaque, long opts) {
        long __functionAddress = JEmalloc.getInstance().malloc_stats_print;
        JNI.invokePPPV(__functionAddress, write_cb, je_cbopaque, opts);
    }

    public static void je_malloc_stats_print(MallocMessageCallback write_cb, ByteBuffer je_cbopaque, ByteBuffer opts) {
        if (Checks.CHECKS && opts != null) {
            Checks.checkNT1(opts);
        }
        JEmalloc.nje_malloc_stats_print(write_cb == null ? 0L : write_cb.address(), MemoryUtil.memAddressSafe(je_cbopaque), MemoryUtil.memAddressSafe(opts));
    }

    public static void je_malloc_stats_print(MallocMessageCallback write_cb, ByteBuffer je_cbopaque, CharSequence opts) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int optsEncoded = __buffer.stringParamASCII(opts, true);
        JEmalloc.nje_malloc_stats_print(write_cb == null ? 0L : write_cb.address(), MemoryUtil.memAddressSafe(je_cbopaque), __buffer.addressSafe(opts, optsEncoded));
    }

    public static long nje_malloc_usable_size(long ptr) {
        long __functionAddress = JEmalloc.getInstance().malloc_usable_size;
        return JNI.invokePP(__functionAddress, ptr);
    }

    public static long je_malloc_usable_size(ByteBuffer ptr) {
        return JEmalloc.nje_malloc_usable_size(MemoryUtil.memAddress(ptr));
    }
}

