/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.libffi;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Platform;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Retainable;
import org.lwjgl.system.libffi.ClosureRegistry;
import org.lwjgl.system.libffi.FFICIF;
import org.lwjgl.system.libffi.FFIClosure;
import org.lwjgl.system.libffi.FFIType;
import org.lwjgl.system.libffi.LibFFI;

public abstract class Closure
extends Retainable.Default
implements Pointer {
    protected static final long NATIVE_CALLBACK_VOID;
    protected static final long NATIVE_CALLBACK_BOOLEAN;
    protected static final long NATIVE_CALLBACK_BYTE;
    protected static final long NATIVE_CALLBACK_SHORT;
    protected static final long NATIVE_CALLBACK_INT;
    protected static final long NATIVE_CALLBACK_LONG;
    protected static final long NATIVE_CALLBACK_FLOAT;
    protected static final long NATIVE_CALLBACK_DOUBLE;
    protected static final long NATIVE_CALLBACK_PTR;
    protected static final int CALL_CONVENTION_DEFAULT;
    protected static final int CALL_CONVENTION_SYSTEM;
    private static final ClosureRegistry registry;
    private long user_data;
    private final long closure;
    private final long pointer;

    Closure(FFICIF cif, long classPath, long nativeCallback) {
        APIBuffer __buf = APIUtil.apiStack();
        this.closure = LibFFI.nffi_closure_alloc(FFIClosure.SIZEOF, __buf.address(__buf.getOffset()));
        this.pointer = __buf.pointerValue(__buf.getOffset());
        __buf.pop();
        if (this.closure == 0L) {
            throw new OutOfMemoryError("Failed to allocate libffi closure.");
        }
        this.user_data = MemoryUtil.nmemAlloc(POINTER_SIZE * 2);
        MemoryUtil.memPutAddress(this.user_data, MemoryUtil.memNewWeakGlobalRef(this));
        if (Checks.DEBUG) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            StringBuilder buffer = new StringBuilder(128);
            for (int i = 3; i < stackTrace.length; ++i) {
                buffer.append("\n    at ");
                buffer.append(stackTrace[i].toString());
            }
            MemoryUtil.memPutAddress(this.user_data + (long)POINTER_SIZE, MemoryUtil.memAddress(MemoryUtil.memEncodeASCII((CharSequence)buffer.toString(), true, MemoryUtil.BufferAllocator.MALLOC)));
        } else {
            MemoryUtil.memPutAddress(this.user_data + (long)POINTER_SIZE, classPath);
        }
        int status = LibFFI.nffi_prep_closure_loc(this.closure, cif.address(), nativeCallback, this.user_data, this.pointer);
        if (status != 0) {
            this.destroy();
            throw new IllegalStateException(String.format("Failed to prepare libffi closure. Status: 0x%X", status));
        }
        if (registry != null) {
            registry.register(this);
        }
    }

    @Override
    public long address() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("This closure instance has been destroyed.");
        }
        return this.pointer;
    }

    @Override
    protected void destroy() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("This closure instance has been destroyed.");
        }
        MemoryUtil.memDeleteWeakGlobalRef(MemoryUtil.memGetAddress(this.user_data));
        if (Checks.DEBUG) {
            MemoryUtil.nmemFree(MemoryUtil.memGetAddress(this.user_data + (long)POINTER_SIZE));
        }
        MemoryUtil.nmemFree(this.user_data);
        this.user_data = 0L;
        LibFFI.nffi_closure_free(this.closure);
    }

    public boolean isDestroyed() {
        return this.user_data == 0L;
    }

    public static <T extends Closure> T create(long functionPointer) {
        if (functionPointer == 0L) {
            return null;
        }
        return (T)((Closure)MemoryUtil.memGlobalRefToObject(MemoryUtil.memGetAddress(MemoryUtil.memGetAddress(functionPointer + (long)FFIClosure.USER_DATA))));
    }

    public static void release(long functionPointer) {
        Object clojure = Closure.create(functionPointer);
        if (clojure != null) {
            ((Retainable.Default)clojure).release();
        }
    }

    protected static FFICIF staticAllocCIF() {
        return new FFICIF(MemoryUtil.getAllocator().malloc(FFICIF.SIZEOF));
    }

    protected static PointerBuffer staticAllocPointer(int size) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.getAllocator().malloc(size * POINTER_SIZE), size);
    }

    protected static long staticAllocText(String text) {
        int size = text.length() + 1;
        long address = MemoryUtil.getAllocator().malloc(size);
        MemoryUtil.memEncodeASCII((CharSequence)text, true, MemoryUtil.memByteBuffer(address, size));
        return address;
    }

    protected static void prepareCIF(int ABI, FFICIF CIF, FFIType rtype, PointerBuffer ARGS, FFIType ... atypes) {
        for (int i = 0; i < atypes.length; ++i) {
            ARGS.put(i, atypes[i]);
        }
        int status = LibFFI.ffi_prep_cif(CIF, ABI, rtype, ARGS);
        if (status != 0) {
            throw new IllegalStateException(String.format("Failed to prepare callback interface. Status: 0x%X", status));
        }
    }

    private static native long getNativeCallbacks(Method[] var0, long var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        block8: {
            PointerBuffer callbacks = null;
            try {
                Class[] params = new Class[]{java.lang.Long.TYPE};
                Method[] methods = new Method[]{Void.class.getDeclaredMethod("callback", params), Boolean.class.getDeclaredMethod("callback", params), Byte.class.getDeclaredMethod("callback", params), Short.class.getDeclaredMethod("callback", params), Int.class.getDeclaredMethod("callback", params), Long.class.getDeclaredMethod("callback", params), Float.class.getDeclaredMethod("callback", params), Double.class.getDeclaredMethod("callback", params), Ptr.class.getDeclaredMethod("callback", params)};
                callbacks = MemoryUtil.memAllocPointer(methods.length);
                Closure.getNativeCallbacks(methods, MemoryUtil.memAddress(callbacks));
                NATIVE_CALLBACK_VOID = callbacks.get();
                NATIVE_CALLBACK_BOOLEAN = callbacks.get();
                NATIVE_CALLBACK_BYTE = callbacks.get();
                NATIVE_CALLBACK_SHORT = callbacks.get();
                NATIVE_CALLBACK_INT = callbacks.get();
                NATIVE_CALLBACK_LONG = callbacks.get();
                NATIVE_CALLBACK_FLOAT = callbacks.get();
                NATIVE_CALLBACK_DOUBLE = callbacks.get();
                NATIVE_CALLBACK_PTR = callbacks.get();
                if (callbacks == null) break block8;
            }
            catch (NoSuchMethodException e) {
                try {
                    throw new IllegalStateException("Failed to initialize closure callbacks.", e);
                }
                catch (Throwable throwable) {
                    if (callbacks == null) throw throwable;
                    MemoryUtil.memFree(callbacks);
                    throw throwable;
                }
            }
            MemoryUtil.memFree(callbacks);
        }
        CALL_CONVENTION_DEFAULT = LibFFI.FFI_DEFAULT_ABI;
        CALL_CONVENTION_SYSTEM = Platform.get() == Platform.WINDOWS && Pointer.BITS32 ? LibFFI.FFI_STDCALL : LibFFI.FFI_DEFAULT_ABI;
        String factoryClass = System.getProperty("org.lwjgl.system.libffi.ClosureRegistry");
        if (factoryClass == null) {
            registry = null;
            return;
        }
        try {
            Class<?> factory = Thread.currentThread().getContextClassLoader().loadClass(factoryClass);
            Method create = factory.getMethod("get", new Class[0]);
            if (!Modifier.isStatic(create.getModifiers())) throw new IllegalArgumentException("Invalid ClosureRegistry specified.");
            if (!ClosureRegistry.class.isAssignableFrom(create.getReturnType())) {
                throw new IllegalArgumentException("Invalid ClosureRegistry specified.");
            }
            registry = (ClosureRegistry)create.invoke(null, new Object[0]);
            return;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to initialize the Closure registry.", e);
        }
    }

    public static abstract class Ptr
    extends Closure {
        protected Ptr(FFICIF cif, long classPath) {
            super(cif, classPath, NATIVE_CALLBACK_PTR);
        }

        protected abstract long callback(long var1);
    }

    public static abstract class Double
    extends Closure {
        protected Double(FFICIF cif, long classPath) {
            super(cif, classPath, NATIVE_CALLBACK_DOUBLE);
        }

        protected abstract double callback(long var1);
    }

    public static abstract class Float
    extends Closure {
        protected Float(FFICIF cif, long classPath) {
            super(cif, classPath, NATIVE_CALLBACK_FLOAT);
        }

        protected abstract float callback(long var1);
    }

    public static abstract class Long
    extends Closure {
        protected Long(FFICIF cif, long classPath) {
            super(cif, classPath, NATIVE_CALLBACK_LONG);
        }

        protected abstract long callback(long var1);
    }

    public static abstract class Int
    extends Closure {
        protected Int(FFICIF cif, long classPath) {
            super(cif, classPath, NATIVE_CALLBACK_INT);
        }

        protected abstract int callback(long var1);
    }

    public static abstract class Short
    extends Closure {
        protected Short(FFICIF cif, long classPath) {
            super(cif, classPath, NATIVE_CALLBACK_SHORT);
        }

        protected abstract short callback(long var1);
    }

    public static abstract class Byte
    extends Closure {
        protected Byte(FFICIF cif, long classPath) {
            super(cif, classPath, NATIVE_CALLBACK_BYTE);
        }

        protected abstract byte callback(long var1);
    }

    public static abstract class Boolean
    extends Closure {
        protected Boolean(FFICIF cif, long classPath) {
            super(cif, classPath, NATIVE_CALLBACK_BOOLEAN);
        }

        protected abstract boolean callback(long var1);
    }

    public static abstract class Void
    extends Closure {
        protected Void(FFICIF cif, long classPath) {
            super(cif, classPath, NATIVE_CALLBACK_VOID);
        }

        protected abstract void callback(long var1);
    }
}

