/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.libffi;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.system.libffi.FFICIF;

public class FFIClosure
extends Struct {
    public static final int SIZEOF;
    public static final int CIF;
    public static final int FUN;
    public static final int USER_DATA;

    private static native int offsets(long var0);

    FFIClosure(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public FFIClosure(long struct) {
        this(struct, null);
    }

    public FFIClosure(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public FFICIF cif() {
        return FFIClosure.ncifStruct(this.address());
    }

    public long fun() {
        return FFIClosure.nfun(this.address());
    }

    public long user_data() {
        return FFIClosure.nuser_data(this.address());
    }

    public static FFIClosure malloc() {
        return new FFIClosure(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static FFIClosure calloc() {
        return new FFIClosure(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static FFIClosure create() {
        return new FFIClosure(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static FFICIF ncifStruct(long struct) {
        return new FFICIF(MemoryUtil.memGetAddress(struct + (long)CIF));
    }

    public static long nfun(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)FUN);
    }

    public static long nuser_data(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)USER_DATA);
    }

    static {
        IntBuffer offsets = MemoryUtil.memAllocInt(3);
        SIZEOF = FFIClosure.offsets(MemoryUtil.memAddress(offsets));
        CIF = offsets.get(0);
        FUN = offsets.get(1);
        USER_DATA = offsets.get(2);
        MemoryUtil.memFree(offsets);
    }

    public static final class Buffer
    extends StructBuffer<FFIClosure, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected FFIClosure newInstance(long address) {
            return new FFIClosure(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public FFICIF cif() {
            return FFIClosure.ncifStruct(this.address());
        }

        public long fun() {
            return FFIClosure.nfun(this.address());
        }

        public long user_data() {
            return FFIClosure.nuser_data(this.address());
        }
    }
}

