/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class Visual
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int VISUALID;
    public static final int CLASS;
    public static final int RED_MASK;
    public static final int GREEN_MASK;
    public static final int BLUE_MASK;
    public static final int BITS_PER_RGB;
    public static final int MAP_ENTRIES;

    Visual(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public Visual(long struct) {
        this(struct, null);
    }

    public Visual(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long visualid() {
        return Visual.nvisualid(this.address());
    }

    public int class$() {
        return Visual.nclass$(this.address());
    }

    public long red_mask() {
        return Visual.nred_mask(this.address());
    }

    public long green_mask() {
        return Visual.ngreen_mask(this.address());
    }

    public long blue_mask() {
        return Visual.nblue_mask(this.address());
    }

    public int bits_per_rgb() {
        return Visual.nbits_per_rgb(this.address());
    }

    public int map_entries() {
        return Visual.nmap_entries(this.address());
    }

    public Visual visualid(long value) {
        Visual.nvisualid(this.address(), value);
        return this;
    }

    public Visual class$(int value) {
        Visual.nclass$(this.address(), value);
        return this;
    }

    public Visual red_mask(long value) {
        Visual.nred_mask(this.address(), value);
        return this;
    }

    public Visual green_mask(long value) {
        Visual.ngreen_mask(this.address(), value);
        return this;
    }

    public Visual blue_mask(long value) {
        Visual.nblue_mask(this.address(), value);
        return this;
    }

    public Visual bits_per_rgb(int value) {
        Visual.nbits_per_rgb(this.address(), value);
        return this;
    }

    public Visual map_entries(int value) {
        Visual.nmap_entries(this.address(), value);
        return this;
    }

    public Visual set(long visualid, int class$, long red_mask, long green_mask, long blue_mask, int bits_per_rgb, int map_entries) {
        this.visualid(visualid);
        this.class$(class$);
        this.red_mask(red_mask);
        this.green_mask(green_mask);
        this.blue_mask(blue_mask);
        this.bits_per_rgb(bits_per_rgb);
        this.map_entries(map_entries);
        return this;
    }

    public Visual nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public Visual set(Visual src) {
        return this.nset(src.address());
    }

    public Visual set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static Visual malloc() {
        return new Visual(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static Visual calloc() {
        return new Visual(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static Visual create() {
        return new Visual(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static long nvisualid(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VISUALID);
    }

    public static int nclass$(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CLASS);
    }

    public static long nred_mask(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)RED_MASK);
    }

    public static long ngreen_mask(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)GREEN_MASK);
    }

    public static long nblue_mask(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)BLUE_MASK);
    }

    public static int nbits_per_rgb(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BITS_PER_RGB);
    }

    public static int nmap_entries(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAP_ENTRIES);
    }

    public static void nvisualid(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VISUALID, value);
    }

    public static void nclass$(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CLASS, value);
    }

    public static void nred_mask(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)RED_MASK, value);
    }

    public static void ngreen_mask(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)GREEN_MASK, value);
    }

    public static void nblue_mask(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)BLUE_MASK, value);
    }

    public static void nbits_per_rgb(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BITS_PER_RGB, value);
    }

    public static void nmap_entries(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MAP_ENTRIES, value);
    }

    static {
        Struct.Layout layout = Visual.__struct(Visual.__member(Pointer.POINTER_SIZE), Visual.__member(4), Visual.__member(Pointer.POINTER_SIZE), Visual.__member(Pointer.POINTER_SIZE), Visual.__member(Pointer.POINTER_SIZE), Visual.__member(4), Visual.__member(4));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        VISUALID = layout.offsetof(0);
        CLASS = layout.offsetof(1);
        RED_MASK = layout.offsetof(2);
        GREEN_MASK = layout.offsetof(3);
        BLUE_MASK = layout.offsetof(4);
        BITS_PER_RGB = layout.offsetof(5);
        MAP_ENTRIES = layout.offsetof(6);
    }

    public static final class Buffer
    extends StructBuffer<Visual, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected Visual newInstance(long address) {
            return new Visual(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public long visualid() {
            return Visual.nvisualid(this.address());
        }

        public int class$() {
            return Visual.nclass$(this.address());
        }

        public long red_mask() {
            return Visual.nred_mask(this.address());
        }

        public long green_mask() {
            return Visual.ngreen_mask(this.address());
        }

        public long blue_mask() {
            return Visual.nblue_mask(this.address());
        }

        public int bits_per_rgb() {
            return Visual.nbits_per_rgb(this.address());
        }

        public int map_entries() {
            return Visual.nmap_entries(this.address());
        }

        public Buffer visualid(long value) {
            Visual.nvisualid(this.address(), value);
            return this;
        }

        public Buffer class$(int value) {
            Visual.nclass$(this.address(), value);
            return this;
        }

        public Buffer red_mask(long value) {
            Visual.nred_mask(this.address(), value);
            return this;
        }

        public Buffer green_mask(long value) {
            Visual.ngreen_mask(this.address(), value);
            return this;
        }

        public Buffer blue_mask(long value) {
            Visual.nblue_mask(this.address(), value);
            return this;
        }

        public Buffer bits_per_rgb(int value) {
            Visual.nbits_per_rgb(this.address(), value);
            return this;
        }

        public Buffer map_entries(int value) {
            Visual.nmap_entries(this.address(), value);
            return this;
        }
    }
}

