/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.macosx;

import java.nio.ByteBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;

public class CoreFoundation {
    public static final byte TRUE = 1;
    public static final byte FALSE = 0;
    public static final int kCFStringEncodingMacRoman = 0;
    public static final int kCFStringEncodingWindowsLatin1 = 1280;
    public static final int kCFStringEncodingISOLatin1 = 513;
    public static final int kCFStringEncodingNextStepLatin = 2817;
    public static final int kCFStringEncodingASCII = 1536;
    public static final int kCFStringEncodingUnicode = 256;
    public static final int kCFStringEncodingUTF8 = 0x8000100;
    public static final int kCFStringEncodingNonLossyASCII = 3071;
    public static final int kCFStringEncodingUTF16 = 256;
    public static final int kCFStringEncodingUTF16BE = 0x10000100;
    public static final int kCFStringEncodingUTF16LE = 0x14000100;
    public static final int kCFStringEncodingUTF32 = 0xC000100;
    public static final int kCFStringEncodingUTF32BE = 0x18000100;
    public static final int kCFStringEncodingUTF32LE = 0x1C000100;
    public static final int kCFURLPOSIXPathStyle = 0;
    public static final int kCFURLHFSPathStyle = 1;
    public static final int kCFURLWindowsPathStyle = 2;

    protected CoreFoundation() {
        throw new UnsupportedOperationException();
    }

    public static native long kCFAllocatorDefault();

    public static native long kCFAllocatorSystemDefault();

    public static native long kCFAllocatorMalloc();

    public static native long kCFAllocatorMallocZone();

    public static native long kCFAllocatorNull();

    public static native long kCFAllocatorUseContext();

    public static native long nCFRetain(long var0);

    public static long CFRetain(long cf) {
        if (Checks.CHECKS) {
            Checks.checkPointer(cf);
        }
        return CoreFoundation.nCFRetain(cf);
    }

    public static native void nCFRelease(long var0);

    public static void CFRelease(long cf) {
        if (Checks.CHECKS) {
            Checks.checkPointer(cf);
        }
        CoreFoundation.nCFRelease(cf);
    }

    public static native long nCFBundleCreate(long var0, long var2);

    public static long CFBundleCreate(long allocator, long bundleURL) {
        if (Checks.CHECKS) {
            Checks.checkPointer(bundleURL);
        }
        return CoreFoundation.nCFBundleCreate(allocator, bundleURL);
    }

    public static native long nCFBundleGetFunctionPointerForName(long var0, long var2);

    public static long CFBundleGetFunctionPointerForName(long bundle, long functionName) {
        if (Checks.CHECKS) {
            Checks.checkPointer(bundle);
            Checks.checkPointer(functionName);
        }
        return CoreFoundation.nCFBundleGetFunctionPointerForName(bundle, functionName);
    }

    public static native long nCFStringCreateWithCString(long var0, long var2, int var4);

    public static long CFStringCreateWithCString(long allocator, ByteBuffer cStr, int encoding) {
        return CoreFoundation.nCFStringCreateWithCString(allocator, MemoryUtil.memAddress(cStr), encoding);
    }

    public static native long nCFStringCreateWithCStringNoCopy(long var0, long var2, int var4, long var5);

    public static long CFStringCreateWithCStringNoCopy(long allocator, ByteBuffer cStr, int encoding, long contentsDeallocator) {
        return CoreFoundation.nCFStringCreateWithCStringNoCopy(allocator, MemoryUtil.memAddress(cStr), encoding, contentsDeallocator);
    }

    public static native long nCFURLCreateWithFileSystemPath(long var0, long var2, long var4, byte var6);

    public static long CFURLCreateWithFileSystemPath(long allocator, long filePath, long pathStyle, byte isDirectory) {
        if (Checks.CHECKS) {
            Checks.checkPointer(filePath);
        }
        return CoreFoundation.nCFURLCreateWithFileSystemPath(allocator, filePath, pathStyle, isDirectory);
    }

    static {
        Library.initialize();
    }
}

