/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.macosx;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class ObjCPropertyAttribute
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int NAME;
    public static final int VALUE;

    ObjCPropertyAttribute(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public ObjCPropertyAttribute(long struct) {
        this(struct, null);
    }

    public ObjCPropertyAttribute(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public ByteBuffer name() {
        return ObjCPropertyAttribute.nname(this.address());
    }

    public String nameString() {
        return ObjCPropertyAttribute.nnameString(this.address());
    }

    public ByteBuffer value() {
        return ObjCPropertyAttribute.nvalue(this.address());
    }

    public String valueString() {
        return ObjCPropertyAttribute.nvalueString(this.address());
    }

    public ObjCPropertyAttribute name(ByteBuffer value) {
        ObjCPropertyAttribute.nname(this.address(), value);
        return this;
    }

    public ObjCPropertyAttribute name(CharSequence value) {
        ObjCPropertyAttribute.nname(this.address(), value);
        return this;
    }

    public ObjCPropertyAttribute value(ByteBuffer value) {
        ObjCPropertyAttribute.nvalue(this.address(), value);
        return this;
    }

    public ObjCPropertyAttribute value(CharSequence value) {
        ObjCPropertyAttribute.nvalue(this.address(), value);
        return this;
    }

    public ObjCPropertyAttribute set(ByteBuffer name, ByteBuffer value) {
        this.name(name);
        this.value(value);
        return this;
    }

    public ObjCPropertyAttribute nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public ObjCPropertyAttribute set(ObjCPropertyAttribute src) {
        return this.nset(src.address());
    }

    public ObjCPropertyAttribute set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static ObjCPropertyAttribute malloc() {
        return new ObjCPropertyAttribute(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static ObjCPropertyAttribute calloc() {
        return new ObjCPropertyAttribute(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static ObjCPropertyAttribute create() {
        return new ObjCPropertyAttribute(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memDecodeUTF8(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    public static ByteBuffer nvalue(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)VALUE));
    }

    public static String nvalueString(long struct) {
        return MemoryUtil.memDecodeUTF8(MemoryUtil.memGetAddress(struct + (long)VALUE));
    }

    public static void nname(long struct, ByteBuffer value) {
        if (Checks.CHECKS && value != null) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)NAME, MemoryUtil.memAddressSafe(value));
    }

    public static void nname(long struct, CharSequence value) {
        ObjCPropertyAttribute.nname(struct, MemoryUtil.memEncodeUTF8(value, MemoryUtil.BufferAllocator.MALLOC));
    }

    public static void nvalue(long struct, ByteBuffer value) {
        if (Checks.CHECKS && value != null) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)VALUE, MemoryUtil.memAddressSafe(value));
    }

    public static void nvalue(long struct, CharSequence value) {
        ObjCPropertyAttribute.nvalue(struct, MemoryUtil.memEncodeUTF8(value, MemoryUtil.BufferAllocator.MALLOC));
    }

    static {
        Struct.Layout layout = ObjCPropertyAttribute.__struct(ObjCPropertyAttribute.__member(Pointer.POINTER_SIZE), ObjCPropertyAttribute.__member(Pointer.POINTER_SIZE));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        NAME = layout.offsetof(0);
        VALUE = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<ObjCPropertyAttribute, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected ObjCPropertyAttribute newInstance(long address) {
            return new ObjCPropertyAttribute(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public ByteBuffer name() {
            return ObjCPropertyAttribute.nname(this.address());
        }

        public String nameString() {
            return ObjCPropertyAttribute.nnameString(this.address());
        }

        public ByteBuffer value() {
            return ObjCPropertyAttribute.nvalue(this.address());
        }

        public String valueString() {
            return ObjCPropertyAttribute.nvalueString(this.address());
        }

        public Buffer name(ByteBuffer value) {
            ObjCPropertyAttribute.nname(this.address(), value);
            return this;
        }

        public Buffer name(CharSequence value) {
            ObjCPropertyAttribute.nname(this.address(), value);
            return this;
        }

        public Buffer value(ByteBuffer value) {
            ObjCPropertyAttribute.nvalue(this.address(), value);
            return this;
        }

        public Buffer value(CharSequence value) {
            ObjCPropertyAttribute.nvalue(this.address(), value);
            return this;
        }
    }
}

