/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.macosx;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.macosx.EnumerationMutationHandler;
import org.lwjgl.system.macosx.ObjCMethodDescription;
import org.lwjgl.system.macosx.ObjCPropertyAttribute;

public class ObjCRuntime {
    public static final long nil = 0L;
    public static final byte YES = 1;
    public static final byte NO = 0;
    public static final char _C_ID = '@';
    public static final char _C_CLASS = '#';
    public static final char _C_SEL = ':';
    public static final char _C_CHR = 'c';
    public static final char _C_UCHR = 'C';
    public static final char _C_SHT = 's';
    public static final char _C_USHT = 'S';
    public static final char _C_INT = 'i';
    public static final char _C_UINT = 'I';
    public static final char _C_LNG = 'l';
    public static final char _C_ULNG = 'L';
    public static final char _C_LNG_LNG = 'q';
    public static final char _C_ULNG_LNG = 'Q';
    public static final char _C_FLT = 'f';
    public static final char _C_DBL = 'd';
    public static final char _C_BFLD = 'b';
    public static final char _C_BOOL = 'B';
    public static final char _C_VOID = 'v';
    public static final char _C_UNDEF = '?';
    public static final char _C_PTR = '^';
    public static final char _C_CHARPTR = '*';
    public static final char _C_ATOM = '%';
    public static final char _C_ARY_B = '[';
    public static final char _C_ARY_E = ']';
    public static final char _C_UNION_B = '(';
    public static final char _C_UNION_E = ')';
    public static final char _C_STRUCT_B = '{';
    public static final char _C_STRUCT_E = '}';
    public static final char _C_VECTOR = '!';
    public static final char _C_CONST = 'r';
    public static final int OBJC_ASSOCIATION_ASSIGN = 0;
    public static final int OBJC_ASSOCIATION_RETAIN_NONATOMIC = 1;
    public static final int OBJC_ASSOCIATION_COPY_NONATOMIC = 3;
    public static final int OBJC_ASSOCIATION_RETAIN = 1401;
    public static final int OBJC_ASSOCIATION_COPY = 1403;
    public final long object_copy;
    public final long object_dispose;
    public final long object_getClass;
    public final long object_setClass;
    public final long object_getClassName;
    public final long object_getIndexedIvars;
    public final long object_getIvar;
    public final long object_setIvar;
    public final long object_setInstanceVariable;
    public final long object_getInstanceVariable;
    public final long objc_getClass;
    public final long objc_getMetaClass;
    public final long objc_lookUpClass;
    public final long objc_getRequiredClass;
    public final long objc_getClassList;
    public final long objc_copyClassList;
    public final long class_getName;
    public final long class_isMetaClass;
    public final long class_getSuperclass;
    public final long class_getVersion;
    public final long class_setVersion;
    public final long class_getInstanceSize;
    public final long class_getInstanceVariable;
    public final long class_getClassVariable;
    public final long class_copyIvarList;
    public final long class_getInstanceMethod;
    public final long class_getClassMethod;
    public final long class_getMethodImplementation;
    public final long class_respondsToSelector;
    public final long class_copyMethodList;
    public final long class_conformsToProtocol;
    public final long class_copyProtocolList;
    public final long class_getProperty;
    public final long class_copyPropertyList;
    public final long class_getIvarLayout;
    public final long class_getWeakIvarLayout;
    public final long class_addMethod;
    public final long class_replaceMethod;
    public final long class_addIvar;
    public final long class_addProtocol;
    public final long class_addProperty;
    public final long class_replaceProperty;
    public final long class_setIvarLayout;
    public final long class_setWeakIvarLayout;
    public final long class_createInstance;
    public final long objc_constructInstance;
    public final long objc_destructInstance;
    public final long objc_allocateClassPair;
    public final long objc_registerClassPair;
    public final long objc_disposeClassPair;
    public final long method_getName;
    public final long method_getImplementation;
    public final long method_getTypeEncoding;
    public final long method_getNumberOfArguments;
    public final long method_copyReturnType;
    public final long method_copyArgumentType;
    public final long method_getReturnType;
    public final long method_getArgumentType;
    public final long method_setImplementation;
    public final long method_exchangeImplementations;
    public final long ivar_getName;
    public final long ivar_getTypeEncoding;
    public final long ivar_getOffset;
    public final long property_getName;
    public final long property_getAttributes;
    public final long property_copyAttributeList;
    public final long property_copyAttributeValue;
    public final long objc_getProtocol;
    public final long objc_copyProtocolList;
    public final long protocol_conformsToProtocol;
    public final long protocol_isEqual;
    public final long protocol_getName;
    public final long protocol_getMethodDescription;
    public final long protocol_copyMethodDescriptionList;
    public final long protocol_getProperty;
    public final long protocol_copyPropertyList;
    public final long protocol_copyProtocolList;
    public final long objc_allocateProtocol;
    public final long objc_registerProtocol;
    public final long protocol_addMethodDescription;
    public final long protocol_addProtocol;
    public final long protocol_addProperty;
    public final long objc_copyImageNames;
    public final long class_getImageName;
    public final long objc_copyClassNamesForImage;
    public final long sel_getName;
    public final long sel_getUid;
    public final long sel_registerName;
    public final long sel_isEqual;
    public final long objc_enumerationMutation;
    public final long objc_setEnumerationMutationHandler;
    public final long imp_implementationWithBlock;
    public final long imp_getBlock;
    public final long imp_removeBlock;
    public final long objc_loadWeak;
    public final long objc_storeWeak;
    public final long objc_setAssociatedObject;
    public final long objc_getAssociatedObject;
    public final long objc_removeAssociatedObjects;
    private static final SharedLibrary OBJC;
    private static final ObjCRuntime instance;

    protected ObjCRuntime() {
        throw new UnsupportedOperationException();
    }

    public ObjCRuntime(FunctionProvider provider) {
        this.object_copy = Checks.checkFunctionAddress(provider.getFunctionAddress("object_copy"));
        this.object_dispose = Checks.checkFunctionAddress(provider.getFunctionAddress("object_dispose"));
        this.object_getClass = Checks.checkFunctionAddress(provider.getFunctionAddress("object_getClass"));
        this.object_setClass = Checks.checkFunctionAddress(provider.getFunctionAddress("object_setClass"));
        this.object_getClassName = Checks.checkFunctionAddress(provider.getFunctionAddress("object_getClassName"));
        this.object_getIndexedIvars = Checks.checkFunctionAddress(provider.getFunctionAddress("object_getIndexedIvars"));
        this.object_getIvar = Checks.checkFunctionAddress(provider.getFunctionAddress("object_getIvar"));
        this.object_setIvar = Checks.checkFunctionAddress(provider.getFunctionAddress("object_setIvar"));
        this.object_setInstanceVariable = Checks.checkFunctionAddress(provider.getFunctionAddress("object_setInstanceVariable"));
        this.object_getInstanceVariable = Checks.checkFunctionAddress(provider.getFunctionAddress("object_getInstanceVariable"));
        this.objc_getClass = Checks.checkFunctionAddress(provider.getFunctionAddress("objc_getClass"));
        this.objc_getMetaClass = Checks.checkFunctionAddress(provider.getFunctionAddress("objc_getMetaClass"));
        this.objc_lookUpClass = Checks.checkFunctionAddress(provider.getFunctionAddress("objc_lookUpClass"));
        this.objc_getRequiredClass = Checks.checkFunctionAddress(provider.getFunctionAddress("objc_getRequiredClass"));
        this.objc_getClassList = Checks.checkFunctionAddress(provider.getFunctionAddress("objc_getClassList"));
        this.objc_copyClassList = Checks.checkFunctionAddress(provider.getFunctionAddress("objc_copyClassList"));
        this.class_getName = Checks.checkFunctionAddress(provider.getFunctionAddress("class_getName"));
        this.class_isMetaClass = Checks.checkFunctionAddress(provider.getFunctionAddress("class_isMetaClass"));
        this.class_getSuperclass = Checks.checkFunctionAddress(provider.getFunctionAddress("class_getSuperclass"));
        this.class_getVersion = Checks.checkFunctionAddress(provider.getFunctionAddress("class_getVersion"));
        this.class_setVersion = Checks.checkFunctionAddress(provider.getFunctionAddress("class_setVersion"));
        this.class_getInstanceSize = Checks.checkFunctionAddress(provider.getFunctionAddress("class_getInstanceSize"));
        this.class_getInstanceVariable = Checks.checkFunctionAddress(provider.getFunctionAddress("class_getInstanceVariable"));
        this.class_getClassVariable = Checks.checkFunctionAddress(provider.getFunctionAddress("class_getClassVariable"));
        this.class_copyIvarList = Checks.checkFunctionAddress(provider.getFunctionAddress("class_copyIvarList"));
        this.class_getInstanceMethod = Checks.checkFunctionAddress(provider.getFunctionAddress("class_getInstanceMethod"));
        this.class_getClassMethod = Checks.checkFunctionAddress(provider.getFunctionAddress("class_getClassMethod"));
        this.class_getMethodImplementation = Checks.checkFunctionAddress(provider.getFunctionAddress("class_getMethodImplementation"));
        this.class_respondsToSelector = Checks.checkFunctionAddress(provider.getFunctionAddress("class_respondsToSelector"));
        this.class_copyMethodList = Checks.checkFunctionAddress(provider.getFunctionAddress("class_copyMethodList"));
        this.class_conformsToProtocol = Checks.checkFunctionAddress(provider.getFunctionAddress("class_conformsToProtocol"));
        this.class_copyProtocolList = Checks.checkFunctionAddress(provider.getFunctionAddress("class_copyProtocolList"));
        this.class_getProperty = Checks.checkFunctionAddress(provider.getFunctionAddress("class_getProperty"));
        this.class_copyPropertyList = Checks.checkFunctionAddress(provider.getFunctionAddress("class_copyPropertyList"));
        this.class_getIvarLayout = Checks.checkFunctionAddress(provider.getFunctionAddress("class_getIvarLayout"));
        this.class_getWeakIvarLayout = Checks.checkFunctionAddress(provider.getFunctionAddress("class_getWeakIvarLayout"));
        this.class_addMethod = Checks.checkFunctionAddress(provider.getFunctionAddress("class_addMethod"));
        this.class_replaceMethod = Checks.checkFunctionAddress(provider.getFunctionAddress("class_replaceMethod"));
        this.class_addIvar = Checks.checkFunctionAddress(provider.getFunctionAddress("class_addIvar"));
        this.class_addProtocol = Checks.checkFunctionAddress(provider.getFunctionAddress("class_addProtocol"));
        this.class_addProperty = Checks.checkFunctionAddress(provider.getFunctionAddress("class_addProperty"));
        this.class_replaceProperty = Checks.checkFunctionAddress(provider.getFunctionAddress("class_replaceProperty"));
        this.class_setIvarLayout = Checks.checkFunctionAddress(provider.getFunctionAddress("class_setIvarLayout"));
        this.class_setWeakIvarLayout = Checks.checkFunctionAddress(provider.getFunctionAddress("class_setWeakIvarLayout"));
        this.class_createInstance = Checks.checkFunctionAddress(provider.getFunctionAddress("class_createInstance"));
        this.objc_constructInstance = Checks.checkFunctionAddress(provider.getFunctionAddress("objc_constructInstance"));
        this.objc_destructInstance = Checks.checkFunctionAddress(provider.getFunctionAddress("objc_destructInstance"));
        this.objc_allocateClassPair = Checks.checkFunctionAddress(provider.getFunctionAddress("objc_allocateClassPair"));
        this.objc_registerClassPair = Checks.checkFunctionAddress(provider.getFunctionAddress("objc_registerClassPair"));
        this.objc_disposeClassPair = Checks.checkFunctionAddress(provider.getFunctionAddress("objc_disposeClassPair"));
        this.method_getName = Checks.checkFunctionAddress(provider.getFunctionAddress("method_getName"));
        this.method_getImplementation = Checks.checkFunctionAddress(provider.getFunctionAddress("method_getImplementation"));
        this.method_getTypeEncoding = Checks.checkFunctionAddress(provider.getFunctionAddress("method_getTypeEncoding"));
        this.method_getNumberOfArguments = Checks.checkFunctionAddress(provider.getFunctionAddress("method_getNumberOfArguments"));
        this.method_copyReturnType = Checks.checkFunctionAddress(provider.getFunctionAddress("method_copyReturnType"));
        this.method_copyArgumentType = Checks.checkFunctionAddress(provider.getFunctionAddress("method_copyArgumentType"));
        this.method_getReturnType = Checks.checkFunctionAddress(provider.getFunctionAddress("method_getReturnType"));
        this.method_getArgumentType = Checks.checkFunctionAddress(provider.getFunctionAddress("method_getArgumentType"));
        this.method_setImplementation = Checks.checkFunctionAddress(provider.getFunctionAddress("method_setImplementation"));
        this.method_exchangeImplementations = Checks.checkFunctionAddress(provider.getFunctionAddress("method_exchangeImplementations"));
        this.ivar_getName = Checks.checkFunctionAddress(provider.getFunctionAddress("ivar_getName"));
        this.ivar_getTypeEncoding = Checks.checkFunctionAddress(provider.getFunctionAddress("ivar_getTypeEncoding"));
        this.ivar_getOffset = Checks.checkFunctionAddress(provider.getFunctionAddress("ivar_getOffset"));
        this.property_getName = Checks.checkFunctionAddress(provider.getFunctionAddress("property_getName"));
        this.property_getAttributes = Checks.checkFunctionAddress(provider.getFunctionAddress("property_getAttributes"));
        this.property_copyAttributeList = Checks.checkFunctionAddress(provider.getFunctionAddress("property_copyAttributeList"));
        this.property_copyAttributeValue = Checks.checkFunctionAddress(provider.getFunctionAddress("property_copyAttributeValue"));
        this.objc_getProtocol = Checks.checkFunctionAddress(provider.getFunctionAddress("objc_getProtocol"));
        this.objc_copyProtocolList = Checks.checkFunctionAddress(provider.getFunctionAddress("objc_copyProtocolList"));
        this.protocol_conformsToProtocol = Checks.checkFunctionAddress(provider.getFunctionAddress("protocol_conformsToProtocol"));
        this.protocol_isEqual = Checks.checkFunctionAddress(provider.getFunctionAddress("protocol_isEqual"));
        this.protocol_getName = Checks.checkFunctionAddress(provider.getFunctionAddress("protocol_getName"));
        this.protocol_getMethodDescription = Checks.checkFunctionAddress(provider.getFunctionAddress("protocol_getMethodDescription"));
        this.protocol_copyMethodDescriptionList = Checks.checkFunctionAddress(provider.getFunctionAddress("protocol_copyMethodDescriptionList"));
        this.protocol_getProperty = Checks.checkFunctionAddress(provider.getFunctionAddress("protocol_getProperty"));
        this.protocol_copyPropertyList = Checks.checkFunctionAddress(provider.getFunctionAddress("protocol_copyPropertyList"));
        this.protocol_copyProtocolList = Checks.checkFunctionAddress(provider.getFunctionAddress("protocol_copyProtocolList"));
        this.objc_allocateProtocol = Checks.checkFunctionAddress(provider.getFunctionAddress("objc_allocateProtocol"));
        this.objc_registerProtocol = Checks.checkFunctionAddress(provider.getFunctionAddress("objc_registerProtocol"));
        this.protocol_addMethodDescription = Checks.checkFunctionAddress(provider.getFunctionAddress("protocol_addMethodDescription"));
        this.protocol_addProtocol = Checks.checkFunctionAddress(provider.getFunctionAddress("protocol_addProtocol"));
        this.protocol_addProperty = Checks.checkFunctionAddress(provider.getFunctionAddress("protocol_addProperty"));
        this.objc_copyImageNames = Checks.checkFunctionAddress(provider.getFunctionAddress("objc_copyImageNames"));
        this.class_getImageName = Checks.checkFunctionAddress(provider.getFunctionAddress("class_getImageName"));
        this.objc_copyClassNamesForImage = Checks.checkFunctionAddress(provider.getFunctionAddress("objc_copyClassNamesForImage"));
        this.sel_getName = Checks.checkFunctionAddress(provider.getFunctionAddress("sel_getName"));
        this.sel_getUid = Checks.checkFunctionAddress(provider.getFunctionAddress("sel_getUid"));
        this.sel_registerName = Checks.checkFunctionAddress(provider.getFunctionAddress("sel_registerName"));
        this.sel_isEqual = Checks.checkFunctionAddress(provider.getFunctionAddress("sel_isEqual"));
        this.objc_enumerationMutation = Checks.checkFunctionAddress(provider.getFunctionAddress("objc_enumerationMutation"));
        this.objc_setEnumerationMutationHandler = Checks.checkFunctionAddress(provider.getFunctionAddress("objc_setEnumerationMutationHandler"));
        this.imp_implementationWithBlock = Checks.checkFunctionAddress(provider.getFunctionAddress("imp_implementationWithBlock"));
        this.imp_getBlock = Checks.checkFunctionAddress(provider.getFunctionAddress("imp_getBlock"));
        this.imp_removeBlock = Checks.checkFunctionAddress(provider.getFunctionAddress("imp_removeBlock"));
        this.objc_loadWeak = Checks.checkFunctionAddress(provider.getFunctionAddress("objc_loadWeak"));
        this.objc_storeWeak = Checks.checkFunctionAddress(provider.getFunctionAddress("objc_storeWeak"));
        this.objc_setAssociatedObject = Checks.checkFunctionAddress(provider.getFunctionAddress("objc_setAssociatedObject"));
        this.objc_getAssociatedObject = Checks.checkFunctionAddress(provider.getFunctionAddress("objc_getAssociatedObject"));
        this.objc_removeAssociatedObjects = Checks.checkFunctionAddress(provider.getFunctionAddress("objc_removeAssociatedObjects"));
    }

    public static SharedLibrary getLibrary() {
        return OBJC;
    }

    public static ObjCRuntime getInstance() {
        return instance;
    }

    public static long object_copy(long obj, long size) {
        long __functionAddress = ObjCRuntime.getInstance().object_copy;
        if (Checks.CHECKS) {
            Checks.checkPointer(obj);
        }
        return JNI.invokePPP(__functionAddress, obj, size);
    }

    public static long object_dispose(long obj) {
        long __functionAddress = ObjCRuntime.getInstance().object_dispose;
        if (Checks.CHECKS) {
            Checks.checkPointer(obj);
        }
        return JNI.invokePP(__functionAddress, obj);
    }

    public static long object_getClass(long obj) {
        long __functionAddress = ObjCRuntime.getInstance().object_getClass;
        return JNI.invokePP(__functionAddress, obj);
    }

    public static long object_setClass(long obj, long cls) {
        long __functionAddress = ObjCRuntime.getInstance().object_setClass;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
        }
        return JNI.invokePPP(__functionAddress, obj, cls);
    }

    public static long nobject_getClassName(long obj) {
        long __functionAddress = ObjCRuntime.getInstance().object_getClassName;
        return JNI.invokePP(__functionAddress, obj);
    }

    public static String object_getClassName(long obj) {
        long __result = ObjCRuntime.nobject_getClassName(obj);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static long object_getIndexedIvars(long obj) {
        long __functionAddress = ObjCRuntime.getInstance().object_getIndexedIvars;
        if (Checks.CHECKS) {
            Checks.checkPointer(obj);
        }
        return JNI.invokePP(__functionAddress, obj);
    }

    public static long object_getIvar(long obj, long ivar) {
        long __functionAddress = ObjCRuntime.getInstance().object_getIvar;
        if (Checks.CHECKS) {
            Checks.checkPointer(ivar);
        }
        return JNI.invokePPP(__functionAddress, obj, ivar);
    }

    public static void object_setIvar(long obj, long ivar, long value) {
        long __functionAddress = ObjCRuntime.getInstance().object_setIvar;
        if (Checks.CHECKS) {
            Checks.checkPointer(obj);
            Checks.checkPointer(ivar);
            Checks.checkPointer(value);
        }
        JNI.invokePPPV(__functionAddress, obj, ivar, value);
    }

    public static long nobject_setInstanceVariable(long obj, long name, long value) {
        long __functionAddress = ObjCRuntime.getInstance().object_setInstanceVariable;
        if (Checks.CHECKS) {
            Checks.checkPointer(obj);
        }
        return JNI.invokePPPP(__functionAddress, obj, name, value);
    }

    public static long object_setInstanceVariable(long obj, ByteBuffer name, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nobject_setInstanceVariable(obj, MemoryUtil.memAddress(name), MemoryUtil.memAddress(value));
    }

    public static long object_setInstanceVariable(long obj, CharSequence name, ByteBuffer value) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        return ObjCRuntime.nobject_setInstanceVariable(obj, __buffer.address(nameEncoded), MemoryUtil.memAddress(value));
    }

    public static long nobject_getInstanceVariable(long obj, long name, long outValue) {
        long __functionAddress = ObjCRuntime.getInstance().object_getInstanceVariable;
        if (Checks.CHECKS) {
            Checks.checkPointer(obj);
        }
        return JNI.invokePPPP(__functionAddress, obj, name, outValue);
    }

    public static long object_getInstanceVariable(long obj, ByteBuffer name, ByteBuffer outValue) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nobject_getInstanceVariable(obj, MemoryUtil.memAddress(name), MemoryUtil.memAddress(outValue));
    }

    public static long object_getInstanceVariable(long obj, ByteBuffer name, PointerBuffer outValue) {
        return ObjCRuntime.nobject_getInstanceVariable(obj, MemoryUtil.memAddress(name), MemoryUtil.memAddress(outValue));
    }

    public static long object_getInstanceVariable(long obj, CharSequence name, PointerBuffer outValue) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        return ObjCRuntime.nobject_getInstanceVariable(obj, __buffer.address(nameEncoded), MemoryUtil.memAddress(outValue));
    }

    public static long nobjc_getClass(long name) {
        long __functionAddress = ObjCRuntime.getInstance().objc_getClass;
        return JNI.invokePP(__functionAddress, name);
    }

    public static long objc_getClass(ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nobjc_getClass(MemoryUtil.memAddress(name));
    }

    public static long objc_getClass(CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        return ObjCRuntime.nobjc_getClass(__buffer.address(nameEncoded));
    }

    public static long nobjc_getMetaClass(long name) {
        long __functionAddress = ObjCRuntime.getInstance().objc_getMetaClass;
        return JNI.invokePP(__functionAddress, name);
    }

    public static long objc_getMetaClass(ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nobjc_getMetaClass(MemoryUtil.memAddress(name));
    }

    public static long objc_getMetaClass(CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        return ObjCRuntime.nobjc_getMetaClass(__buffer.address(nameEncoded));
    }

    public static long nobjc_lookUpClass(long name) {
        long __functionAddress = ObjCRuntime.getInstance().objc_lookUpClass;
        return JNI.invokePP(__functionAddress, name);
    }

    public static long objc_lookUpClass(ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nobjc_lookUpClass(MemoryUtil.memAddress(name));
    }

    public static long objc_lookUpClass(CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        return ObjCRuntime.nobjc_lookUpClass(__buffer.address(nameEncoded));
    }

    public static long nobjc_getRequiredClass(long name) {
        long __functionAddress = ObjCRuntime.getInstance().objc_getRequiredClass;
        return JNI.invokePP(__functionAddress, name);
    }

    public static long objc_getRequiredClass(ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nobjc_getRequiredClass(MemoryUtil.memAddress(name));
    }

    public static long objc_getRequiredClass(CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        return ObjCRuntime.nobjc_getRequiredClass(__buffer.address(nameEncoded));
    }

    public static int nobjc_getClassList(long buffer, int bufferCount) {
        long __functionAddress = ObjCRuntime.getInstance().objc_getClassList;
        return JNI.invokePII(__functionAddress, buffer, bufferCount);
    }

    public static int objc_getClassList(ByteBuffer buffer, int bufferCount) {
        if (Checks.CHECKS && buffer != null) {
            Checks.checkBuffer((Buffer)buffer, bufferCount << Pointer.POINTER_SHIFT);
        }
        return ObjCRuntime.nobjc_getClassList(MemoryUtil.memAddressSafe(buffer), bufferCount);
    }

    public static int objc_getClassList(PointerBuffer buffer) {
        return ObjCRuntime.nobjc_getClassList(MemoryUtil.memAddressSafe(buffer), buffer == null ? 0 : buffer.remaining());
    }

    public static long nobjc_copyClassList(long outCount) {
        long __functionAddress = ObjCRuntime.getInstance().objc_copyClassList;
        return JNI.invokePP(__functionAddress, outCount);
    }

    public static PointerBuffer objc_copyClassList() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int outCount = __buffer.intParam();
        long __result = ObjCRuntime.nobjc_copyClassList(__buffer.address(outCount));
        return MemoryUtil.memPointerBuffer(__result, __buffer.intValue(outCount));
    }

    public static long nclass_getName(long cls) {
        long __functionAddress = ObjCRuntime.getInstance().class_getName;
        return JNI.invokePP(__functionAddress, cls);
    }

    public static String class_getName(long cls) {
        long __result = ObjCRuntime.nclass_getName(cls);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static byte class_isMetaClass(long cls) {
        long __functionAddress = ObjCRuntime.getInstance().class_isMetaClass;
        return JNI.invokePB(__functionAddress, cls);
    }

    public static long class_getSuperclass(long cls) {
        long __functionAddress = ObjCRuntime.getInstance().class_getSuperclass;
        return JNI.invokePP(__functionAddress, cls);
    }

    public static int class_getVersion(long cls) {
        long __functionAddress = ObjCRuntime.getInstance().class_getVersion;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
        }
        return JNI.invokePI(__functionAddress, cls);
    }

    public static void class_setVersion(long cls, int version) {
        long __functionAddress = ObjCRuntime.getInstance().class_setVersion;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
        }
        JNI.invokePIV(__functionAddress, cls, version);
    }

    public static long class_getInstanceSize(long cls) {
        long __functionAddress = ObjCRuntime.getInstance().class_getInstanceSize;
        return JNI.invokePP(__functionAddress, cls);
    }

    public static long nclass_getInstanceVariable(long cls, long name) {
        long __functionAddress = ObjCRuntime.getInstance().class_getInstanceVariable;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
        }
        return JNI.invokePPP(__functionAddress, cls, name);
    }

    public static long class_getInstanceVariable(long cls, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nclass_getInstanceVariable(cls, MemoryUtil.memAddress(name));
    }

    public static long class_getInstanceVariable(long cls, CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        return ObjCRuntime.nclass_getInstanceVariable(cls, __buffer.address(nameEncoded));
    }

    public static long nclass_getClassVariable(long cls, long name) {
        long __functionAddress = ObjCRuntime.getInstance().class_getClassVariable;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
        }
        return JNI.invokePPP(__functionAddress, cls, name);
    }

    public static long class_getClassVariable(long cls, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nclass_getClassVariable(cls, MemoryUtil.memAddress(name));
    }

    public static long class_getClassVariable(long cls, CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        return ObjCRuntime.nclass_getClassVariable(cls, __buffer.address(nameEncoded));
    }

    public static long nclass_copyIvarList(long cls, long outCount) {
        long __functionAddress = ObjCRuntime.getInstance().class_copyIvarList;
        return JNI.invokePPP(__functionAddress, cls, outCount);
    }

    public static PointerBuffer class_copyIvarList(long cls) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int outCount = __buffer.intParam();
        long __result = ObjCRuntime.nclass_copyIvarList(cls, __buffer.address(outCount));
        return MemoryUtil.memPointerBuffer(__result, __buffer.intValue(outCount));
    }

    public static long class_getInstanceMethod(long cls, long name) {
        long __functionAddress = ObjCRuntime.getInstance().class_getInstanceMethod;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
            Checks.checkPointer(name);
        }
        return JNI.invokePPP(__functionAddress, cls, name);
    }

    public static long class_getClassMethod(long cls, long name) {
        long __functionAddress = ObjCRuntime.getInstance().class_getClassMethod;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
            Checks.checkPointer(name);
        }
        return JNI.invokePPP(__functionAddress, cls, name);
    }

    public static long class_getMethodImplementation(long cls, long name) {
        long __functionAddress = ObjCRuntime.getInstance().class_getMethodImplementation;
        if (Checks.CHECKS) {
            Checks.checkPointer(name);
        }
        return JNI.invokePPP(__functionAddress, cls, name);
    }

    public static byte class_respondsToSelector(long cls, long name) {
        long __functionAddress = ObjCRuntime.getInstance().class_respondsToSelector;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
            Checks.checkPointer(name);
        }
        return JNI.invokePPB(__functionAddress, cls, name);
    }

    public static long nclass_copyMethodList(long cls, long outCount) {
        long __functionAddress = ObjCRuntime.getInstance().class_copyMethodList;
        return JNI.invokePPP(__functionAddress, cls, outCount);
    }

    public static PointerBuffer class_copyMethodList(long cls) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int outCount = __buffer.intParam();
        long __result = ObjCRuntime.nclass_copyMethodList(cls, __buffer.address(outCount));
        return MemoryUtil.memPointerBuffer(__result, __buffer.intValue(outCount));
    }

    public static byte class_conformsToProtocol(long cls, long protocol) {
        long __functionAddress = ObjCRuntime.getInstance().class_conformsToProtocol;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
            Checks.checkPointer(protocol);
        }
        return JNI.invokePPB(__functionAddress, cls, protocol);
    }

    public static long nclass_copyProtocolList(long cls, long outCount) {
        long __functionAddress = ObjCRuntime.getInstance().class_copyProtocolList;
        return JNI.invokePPP(__functionAddress, cls, outCount);
    }

    public static PointerBuffer class_copyProtocolList(long cls) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int outCount = __buffer.intParam();
        long __result = ObjCRuntime.nclass_copyProtocolList(cls, __buffer.address(outCount));
        return MemoryUtil.memPointerBuffer(__result, __buffer.intValue(outCount));
    }

    public static long nclass_getProperty(long cls, long name) {
        long __functionAddress = ObjCRuntime.getInstance().class_getProperty;
        return JNI.invokePPP(__functionAddress, cls, name);
    }

    public static long class_getProperty(long cls, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nclass_getProperty(cls, MemoryUtil.memAddress(name));
    }

    public static long class_getProperty(long cls, CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        return ObjCRuntime.nclass_getProperty(cls, __buffer.address(nameEncoded));
    }

    public static long nclass_copyPropertyList(long cls, long outCount) {
        long __functionAddress = ObjCRuntime.getInstance().class_copyPropertyList;
        return JNI.invokePPP(__functionAddress, cls, outCount);
    }

    public static PointerBuffer class_copyPropertyList(long cls) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int outCount = __buffer.intParam();
        long __result = ObjCRuntime.nclass_copyPropertyList(cls, __buffer.address(outCount));
        return MemoryUtil.memPointerBuffer(__result, __buffer.intValue(outCount));
    }

    public static long nclass_getIvarLayout(long cls) {
        long __functionAddress = ObjCRuntime.getInstance().class_getIvarLayout;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
        }
        return JNI.invokePP(__functionAddress, cls);
    }

    public static String class_getIvarLayout(long cls) {
        long __result = ObjCRuntime.nclass_getIvarLayout(cls);
        return MemoryUtil.memDecodeASCII(__result);
    }

    public static long nclass_getWeakIvarLayout(long cls) {
        long __functionAddress = ObjCRuntime.getInstance().class_getWeakIvarLayout;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
        }
        return JNI.invokePP(__functionAddress, cls);
    }

    public static String class_getWeakIvarLayout(long cls) {
        long __result = ObjCRuntime.nclass_getWeakIvarLayout(cls);
        return MemoryUtil.memDecodeASCII(__result);
    }

    public static byte nclass_addMethod(long cls, long name, long imp, long types) {
        long __functionAddress = ObjCRuntime.getInstance().class_addMethod;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
            Checks.checkPointer(name);
            Checks.checkPointer(imp);
        }
        return JNI.invokePPPPB(__functionAddress, cls, name, imp, types);
    }

    public static byte class_addMethod(long cls, long name, long imp, ByteBuffer types) {
        if (Checks.CHECKS) {
            Checks.checkNT1(types);
        }
        return ObjCRuntime.nclass_addMethod(cls, name, imp, MemoryUtil.memAddress(types));
    }

    public static byte class_addMethod(long cls, long name, long imp, CharSequence types) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int typesEncoded = __buffer.stringParamUTF8(types, true);
        return ObjCRuntime.nclass_addMethod(cls, name, imp, __buffer.address(typesEncoded));
    }

    public static long nclass_replaceMethod(long cls, long name, long imp, long types) {
        long __functionAddress = ObjCRuntime.getInstance().class_replaceMethod;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
            Checks.checkPointer(name);
            Checks.checkPointer(imp);
        }
        return JNI.invokePPPPP(__functionAddress, cls, name, imp, types);
    }

    public static long class_replaceMethod(long cls, long name, long imp, ByteBuffer types) {
        if (Checks.CHECKS) {
            Checks.checkNT1(types);
        }
        return ObjCRuntime.nclass_replaceMethod(cls, name, imp, MemoryUtil.memAddress(types));
    }

    public static long class_replaceMethod(long cls, long name, long imp, CharSequence types) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int typesEncoded = __buffer.stringParamUTF8(types, true);
        return ObjCRuntime.nclass_replaceMethod(cls, name, imp, __buffer.address(typesEncoded));
    }

    public static byte nclass_addIvar(long cls, long name, long size, byte alignment, long types) {
        long __functionAddress = ObjCRuntime.getInstance().class_addIvar;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
        }
        return JNI.invokePPPBPB(__functionAddress, cls, name, size, alignment, types);
    }

    public static byte class_addIvar(long cls, ByteBuffer name, long size, byte alignment, ByteBuffer types) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
            Checks.checkNT1(types);
        }
        return ObjCRuntime.nclass_addIvar(cls, MemoryUtil.memAddress(name), size, alignment, MemoryUtil.memAddress(types));
    }

    public static byte class_addIvar(long cls, CharSequence name, long size, byte alignment, CharSequence types) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        int typesEncoded = __buffer.stringParamUTF8(types, true);
        return ObjCRuntime.nclass_addIvar(cls, __buffer.address(nameEncoded), size, alignment, __buffer.address(typesEncoded));
    }

    public static byte class_addProtocol(long cls, long protocol) {
        long __functionAddress = ObjCRuntime.getInstance().class_addProtocol;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
            Checks.checkPointer(protocol);
        }
        return JNI.invokePPB(__functionAddress, cls, protocol);
    }

    public static byte nclass_addProperty(long cls, long name, long attributes, int attributeCount) {
        long __functionAddress = ObjCRuntime.getInstance().class_addProperty;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
        }
        return JNI.invokePPPIB(__functionAddress, cls, name, attributes, attributeCount);
    }

    public static byte class_addProperty(long cls, ByteBuffer name, ObjCPropertyAttribute.Buffer attributes, int attributeCount) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
            Checks.checkBuffer(attributes, attributeCount);
        }
        return ObjCRuntime.nclass_addProperty(cls, MemoryUtil.memAddress(name), attributes.address(), attributeCount);
    }

    public static byte class_addProperty(long cls, ByteBuffer name, ObjCPropertyAttribute.Buffer attributes) {
        return ObjCRuntime.nclass_addProperty(cls, MemoryUtil.memAddress(name), attributes.address(), attributes.remaining());
    }

    public static byte class_addProperty(long cls, CharSequence name, ObjCPropertyAttribute.Buffer attributes) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        return ObjCRuntime.nclass_addProperty(cls, __buffer.address(nameEncoded), attributes.address(), attributes.remaining());
    }

    public static void nclass_replaceProperty(long cls, long name, long attributes, int attributeCount) {
        long __functionAddress = ObjCRuntime.getInstance().class_replaceProperty;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
        }
        JNI.invokePPPIV(__functionAddress, cls, name, attributes, attributeCount);
    }

    public static void class_replaceProperty(long cls, ByteBuffer name, ObjCPropertyAttribute.Buffer attributes, int attributeCount) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
            Checks.checkBuffer(attributes, attributeCount);
        }
        ObjCRuntime.nclass_replaceProperty(cls, MemoryUtil.memAddress(name), attributes.address(), attributeCount);
    }

    public static void class_replaceProperty(long cls, ByteBuffer name, ObjCPropertyAttribute.Buffer attributes) {
        ObjCRuntime.nclass_replaceProperty(cls, MemoryUtil.memAddress(name), attributes.address(), attributes.remaining());
    }

    public static void class_replaceProperty(long cls, CharSequence name, ObjCPropertyAttribute.Buffer attributes) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        ObjCRuntime.nclass_replaceProperty(cls, __buffer.address(nameEncoded), attributes.address(), attributes.remaining());
    }

    public static void nclass_setIvarLayout(long cls, long layout) {
        long __functionAddress = ObjCRuntime.getInstance().class_setIvarLayout;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
        }
        JNI.invokePPV(__functionAddress, cls, layout);
    }

    public static void class_setIvarLayout(long cls, ByteBuffer layout) {
        if (Checks.CHECKS) {
            Checks.checkNT1(layout);
        }
        ObjCRuntime.nclass_setIvarLayout(cls, MemoryUtil.memAddress(layout));
    }

    public static void class_setIvarLayout(long cls, CharSequence layout) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int layoutEncoded = __buffer.stringParamASCII(layout, true);
        ObjCRuntime.nclass_setIvarLayout(cls, __buffer.address(layoutEncoded));
    }

    public static void nclass_setWeakIvarLayout(long cls, long layout) {
        long __functionAddress = ObjCRuntime.getInstance().class_setWeakIvarLayout;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
        }
        JNI.invokePPV(__functionAddress, cls, layout);
    }

    public static void class_setWeakIvarLayout(long cls, ByteBuffer layout) {
        if (Checks.CHECKS) {
            Checks.checkNT1(layout);
        }
        ObjCRuntime.nclass_setWeakIvarLayout(cls, MemoryUtil.memAddress(layout));
    }

    public static void class_setWeakIvarLayout(long cls, CharSequence layout) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int layoutEncoded = __buffer.stringParamASCII(layout, true);
        ObjCRuntime.nclass_setWeakIvarLayout(cls, __buffer.address(layoutEncoded));
    }

    public static long class_createInstance(long cls, long extraBytes) {
        long __functionAddress = ObjCRuntime.getInstance().class_createInstance;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
        }
        return JNI.invokePPP(__functionAddress, cls, extraBytes);
    }

    public static long nobjc_constructInstance(long cls, long bytes) {
        long __functionAddress = ObjCRuntime.getInstance().objc_constructInstance;
        return JNI.invokePPP(__functionAddress, cls, bytes);
    }

    public static long objc_constructInstance(long cls, ByteBuffer bytes) {
        return ObjCRuntime.nobjc_constructInstance(cls, MemoryUtil.memAddressSafe(bytes));
    }

    public static long objc_destructInstance(long obj) {
        long __functionAddress = ObjCRuntime.getInstance().objc_destructInstance;
        if (Checks.CHECKS) {
            Checks.checkPointer(obj);
        }
        return JNI.invokePP(__functionAddress, obj);
    }

    public static long nobjc_allocateClassPair(long superclass, long name, long extraBytes) {
        long __functionAddress = ObjCRuntime.getInstance().objc_allocateClassPair;
        return JNI.invokePPPP(__functionAddress, superclass, name, extraBytes);
    }

    public static long objc_allocateClassPair(long superclass, ByteBuffer name, long extraBytes) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nobjc_allocateClassPair(superclass, MemoryUtil.memAddress(name), extraBytes);
    }

    public static long objc_allocateClassPair(long superclass, CharSequence name, long extraBytes) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        return ObjCRuntime.nobjc_allocateClassPair(superclass, __buffer.address(nameEncoded), extraBytes);
    }

    public static void objc_registerClassPair(long cls) {
        long __functionAddress = ObjCRuntime.getInstance().objc_registerClassPair;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
        }
        JNI.invokePV(__functionAddress, cls);
    }

    public static void objc_disposeClassPair(long cls) {
        long __functionAddress = ObjCRuntime.getInstance().objc_disposeClassPair;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
        }
        JNI.invokePV(__functionAddress, cls);
    }

    public static long method_getName(long m) {
        long __functionAddress = ObjCRuntime.getInstance().method_getName;
        if (Checks.CHECKS) {
            Checks.checkPointer(m);
        }
        return JNI.invokePP(__functionAddress, m);
    }

    public static long method_getImplementation(long m) {
        long __functionAddress = ObjCRuntime.getInstance().method_getImplementation;
        if (Checks.CHECKS) {
            Checks.checkPointer(m);
        }
        return JNI.invokePP(__functionAddress, m);
    }

    public static long nmethod_getTypeEncoding(long m) {
        long __functionAddress = ObjCRuntime.getInstance().method_getTypeEncoding;
        if (Checks.CHECKS) {
            Checks.checkPointer(m);
        }
        return JNI.invokePP(__functionAddress, m);
    }

    public static String method_getTypeEncoding(long m) {
        long __result = ObjCRuntime.nmethod_getTypeEncoding(m);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static int method_getNumberOfArguments(long m) {
        long __functionAddress = ObjCRuntime.getInstance().method_getNumberOfArguments;
        if (Checks.CHECKS) {
            Checks.checkPointer(m);
        }
        return JNI.invokePI(__functionAddress, m);
    }

    public static long nmethod_copyReturnType(long m) {
        long __functionAddress = ObjCRuntime.getInstance().method_copyReturnType;
        if (Checks.CHECKS) {
            Checks.checkPointer(m);
        }
        return JNI.invokePP(__functionAddress, m);
    }

    public static String method_copyReturnType(long m) {
        long __result = ObjCRuntime.nmethod_copyReturnType(m);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static long nmethod_copyArgumentType(long m, int index) {
        long __functionAddress = ObjCRuntime.getInstance().method_copyArgumentType;
        if (Checks.CHECKS) {
            Checks.checkPointer(m);
        }
        return JNI.invokePIP(__functionAddress, m, index);
    }

    public static String method_copyArgumentType(long m, int index) {
        long __result = ObjCRuntime.nmethod_copyArgumentType(m, index);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static void nmethod_getReturnType(long m, long dst, long dst_len) {
        long __functionAddress = ObjCRuntime.getInstance().method_getReturnType;
        if (Checks.CHECKS) {
            Checks.checkPointer(m);
        }
        JNI.invokePPPV(__functionAddress, m, dst, dst_len);
    }

    public static void method_getReturnType(long m, ByteBuffer dst, long dst_len) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)dst, dst_len);
        }
        ObjCRuntime.nmethod_getReturnType(m, MemoryUtil.memAddress(dst), dst_len);
    }

    public static void method_getReturnType(long m, ByteBuffer dst) {
        ObjCRuntime.nmethod_getReturnType(m, MemoryUtil.memAddress(dst), dst.remaining());
    }

    public static String method_getReturnType(long m, long dst_len) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int dst = __buffer.bufferParam((int)dst_len);
        ObjCRuntime.nmethod_getReturnType(m, __buffer.address(dst), dst_len);
        return MemoryUtil.memDecodeUTF8(MemoryUtil.memByteBufferNT1(__buffer.address(dst), (int)dst_len));
    }

    public static void nmethod_getArgumentType(long m, int index, long dst, long dst_len) {
        long __functionAddress = ObjCRuntime.getInstance().method_getArgumentType;
        if (Checks.CHECKS) {
            Checks.checkPointer(m);
        }
        JNI.invokePIPPV(__functionAddress, m, index, dst, dst_len);
    }

    public static void method_getArgumentType(long m, int index, ByteBuffer dst, long dst_len) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)dst, dst_len);
        }
        ObjCRuntime.nmethod_getArgumentType(m, index, MemoryUtil.memAddress(dst), dst_len);
    }

    public static void method_getArgumentType(long m, int index, ByteBuffer dst) {
        ObjCRuntime.nmethod_getArgumentType(m, index, MemoryUtil.memAddress(dst), dst.remaining());
    }

    public static String method_getArgumentType(long m, int index, long dst_len) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int dst = __buffer.bufferParam((int)dst_len);
        ObjCRuntime.nmethod_getArgumentType(m, index, __buffer.address(dst), dst_len);
        return MemoryUtil.memDecodeUTF8(MemoryUtil.memByteBufferNT1(__buffer.address(dst), (int)dst_len));
    }

    public static long method_setImplementation(long m, long imp) {
        long __functionAddress = ObjCRuntime.getInstance().method_setImplementation;
        if (Checks.CHECKS) {
            Checks.checkPointer(m);
            Checks.checkPointer(imp);
        }
        return JNI.invokePPP(__functionAddress, m, imp);
    }

    public static void method_exchangeImplementations(long m1, long m2) {
        long __functionAddress = ObjCRuntime.getInstance().method_exchangeImplementations;
        if (Checks.CHECKS) {
            Checks.checkPointer(m1);
            Checks.checkPointer(m2);
        }
        JNI.invokePPV(__functionAddress, m1, m2);
    }

    public static long nivar_getName(long v) {
        long __functionAddress = ObjCRuntime.getInstance().ivar_getName;
        if (Checks.CHECKS) {
            Checks.checkPointer(v);
        }
        return JNI.invokePP(__functionAddress, v);
    }

    public static String ivar_getName(long v) {
        long __result = ObjCRuntime.nivar_getName(v);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static long nivar_getTypeEncoding(long v) {
        long __functionAddress = ObjCRuntime.getInstance().ivar_getTypeEncoding;
        if (Checks.CHECKS) {
            Checks.checkPointer(v);
        }
        return JNI.invokePP(__functionAddress, v);
    }

    public static String ivar_getTypeEncoding(long v) {
        long __result = ObjCRuntime.nivar_getTypeEncoding(v);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static long ivar_getOffset(long v) {
        long __functionAddress = ObjCRuntime.getInstance().ivar_getOffset;
        if (Checks.CHECKS) {
            Checks.checkPointer(v);
        }
        return JNI.invokePP(__functionAddress, v);
    }

    public static long nproperty_getName(long property) {
        long __functionAddress = ObjCRuntime.getInstance().property_getName;
        if (Checks.CHECKS) {
            Checks.checkPointer(property);
        }
        return JNI.invokePP(__functionAddress, property);
    }

    public static String property_getName(long property) {
        long __result = ObjCRuntime.nproperty_getName(property);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static long nproperty_getAttributes(long property) {
        long __functionAddress = ObjCRuntime.getInstance().property_getAttributes;
        if (Checks.CHECKS) {
            Checks.checkPointer(property);
        }
        return JNI.invokePP(__functionAddress, property);
    }

    public static String property_getAttributes(long property) {
        long __result = ObjCRuntime.nproperty_getAttributes(property);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static long nproperty_copyAttributeList(long property, long outCount) {
        long __functionAddress = ObjCRuntime.getInstance().property_copyAttributeList;
        if (Checks.CHECKS) {
            Checks.checkPointer(property);
        }
        return JNI.invokePPP(__functionAddress, property, outCount);
    }

    public static ObjCPropertyAttribute.Buffer property_copyAttributeList(long property) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int outCount = __buffer.intParam();
        long __result = ObjCRuntime.nproperty_copyAttributeList(property, __buffer.address(outCount));
        return new ObjCPropertyAttribute.Buffer(MemoryUtil.memByteBuffer(__result, __buffer.intValue(outCount) * ObjCPropertyAttribute.SIZEOF));
    }

    public static long nproperty_copyAttributeValue(long property, long attributeName) {
        long __functionAddress = ObjCRuntime.getInstance().property_copyAttributeValue;
        if (Checks.CHECKS) {
            Checks.checkPointer(property);
        }
        return JNI.invokePPP(__functionAddress, property, attributeName);
    }

    public static String property_copyAttributeValue(long property, ByteBuffer attributeName) {
        long __result = ObjCRuntime.nproperty_copyAttributeValue(property, MemoryUtil.memAddress(attributeName));
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static String property_copyAttributeValue(long property, CharSequence attributeName) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int attributeNameEncoded = __buffer.stringParamUTF8(attributeName, true);
        long __result = ObjCRuntime.nproperty_copyAttributeValue(property, __buffer.address(attributeNameEncoded));
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static long nobjc_getProtocol(long name) {
        long __functionAddress = ObjCRuntime.getInstance().objc_getProtocol;
        return JNI.invokePP(__functionAddress, name);
    }

    public static long objc_getProtocol(ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nobjc_getProtocol(MemoryUtil.memAddress(name));
    }

    public static long objc_getProtocol(CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        return ObjCRuntime.nobjc_getProtocol(__buffer.address(nameEncoded));
    }

    public static long nobjc_copyProtocolList(long outCount) {
        long __functionAddress = ObjCRuntime.getInstance().objc_copyProtocolList;
        return JNI.invokePP(__functionAddress, outCount);
    }

    public static PointerBuffer objc_copyProtocolList() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int outCount = __buffer.intParam();
        long __result = ObjCRuntime.nobjc_copyProtocolList(__buffer.address(outCount));
        return MemoryUtil.memPointerBuffer(__result, __buffer.intValue(outCount));
    }

    public static byte protocol_conformsToProtocol(long proto, long other) {
        long __functionAddress = ObjCRuntime.getInstance().protocol_conformsToProtocol;
        if (Checks.CHECKS) {
            Checks.checkPointer(proto);
            Checks.checkPointer(other);
        }
        return JNI.invokePPB(__functionAddress, proto, other);
    }

    public static byte protocol_isEqual(long proto, long other) {
        long __functionAddress = ObjCRuntime.getInstance().protocol_isEqual;
        if (Checks.CHECKS) {
            Checks.checkPointer(proto);
            Checks.checkPointer(other);
        }
        return JNI.invokePPB(__functionAddress, proto, other);
    }

    public static long nprotocol_getName(long p) {
        long __functionAddress = ObjCRuntime.getInstance().protocol_getName;
        if (Checks.CHECKS) {
            Checks.checkPointer(p);
        }
        return JNI.invokePP(__functionAddress, p);
    }

    public static String protocol_getName(long p) {
        long __result = ObjCRuntime.nprotocol_getName(p);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static native void nprotocol_getMethodDescription(long var0, long var2, long var4, byte var6, byte var7, long var8);

    public static void nprotocol_getMethodDescription(long p, long aSel, byte isRequiredMethod, byte isInstanceMethod, long __result) {
        long __functionAddress = ObjCRuntime.getInstance().protocol_getMethodDescription;
        if (Checks.CHECKS) {
            Checks.checkPointer(p);
            Checks.checkPointer(aSel);
        }
        ObjCRuntime.nprotocol_getMethodDescription(__functionAddress, p, aSel, isRequiredMethod, isInstanceMethod, __result);
    }

    public static void protocol_getMethodDescription(long p, long aSel, byte isRequiredMethod, byte isInstanceMethod, ObjCMethodDescription __result) {
        ObjCRuntime.nprotocol_getMethodDescription(p, aSel, isRequiredMethod, isInstanceMethod, __result.address());
    }

    public static long nprotocol_copyMethodDescriptionList(long p, byte isRequiredMethod, byte isInstanceMethod, long outCount) {
        long __functionAddress = ObjCRuntime.getInstance().protocol_copyMethodDescriptionList;
        if (Checks.CHECKS) {
            Checks.checkPointer(p);
        }
        return JNI.invokePBBPP(__functionAddress, p, isRequiredMethod, isInstanceMethod, outCount);
    }

    public static ObjCMethodDescription.Buffer protocol_copyMethodDescriptionList(long p, byte isRequiredMethod, byte isInstanceMethod) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int outCount = __buffer.intParam();
        long __result = ObjCRuntime.nprotocol_copyMethodDescriptionList(p, isRequiredMethod, isInstanceMethod, __buffer.address(outCount));
        return new ObjCMethodDescription.Buffer(MemoryUtil.memByteBuffer(__result, __buffer.intValue(outCount) * ObjCMethodDescription.SIZEOF));
    }

    public static long nprotocol_getProperty(long proto, long name, byte isRequiredProperty, byte isInstanceProperty) {
        long __functionAddress = ObjCRuntime.getInstance().protocol_getProperty;
        if (Checks.CHECKS) {
            Checks.checkPointer(proto);
        }
        return JNI.invokePPBBP(__functionAddress, proto, name, isRequiredProperty, isInstanceProperty);
    }

    public static long protocol_getProperty(long proto, ByteBuffer name, byte isRequiredProperty, byte isInstanceProperty) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nprotocol_getProperty(proto, MemoryUtil.memAddress(name), isRequiredProperty, isInstanceProperty);
    }

    public static long protocol_getProperty(long proto, CharSequence name, byte isRequiredProperty, byte isInstanceProperty) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        return ObjCRuntime.nprotocol_getProperty(proto, __buffer.address(nameEncoded), isRequiredProperty, isInstanceProperty);
    }

    public static long nprotocol_copyPropertyList(long proto, long outCount) {
        long __functionAddress = ObjCRuntime.getInstance().protocol_copyPropertyList;
        if (Checks.CHECKS) {
            Checks.checkPointer(proto);
        }
        return JNI.invokePPP(__functionAddress, proto, outCount);
    }

    public static PointerBuffer protocol_copyPropertyList(long proto) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int outCount = __buffer.intParam();
        long __result = ObjCRuntime.nprotocol_copyPropertyList(proto, __buffer.address(outCount));
        return MemoryUtil.memPointerBuffer(__result, __buffer.intValue(outCount));
    }

    public static long nprotocol_copyProtocolList(long proto, long outCount) {
        long __functionAddress = ObjCRuntime.getInstance().protocol_copyProtocolList;
        if (Checks.CHECKS) {
            Checks.checkPointer(proto);
        }
        return JNI.invokePPP(__functionAddress, proto, outCount);
    }

    public static PointerBuffer protocol_copyProtocolList(long proto) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int outCount = __buffer.intParam();
        long __result = ObjCRuntime.nprotocol_copyProtocolList(proto, __buffer.address(outCount));
        return MemoryUtil.memPointerBuffer(__result, __buffer.intValue(outCount));
    }

    public static long nobjc_allocateProtocol(long name) {
        long __functionAddress = ObjCRuntime.getInstance().objc_allocateProtocol;
        return JNI.invokePP(__functionAddress, name);
    }

    public static long objc_allocateProtocol(ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ObjCRuntime.nobjc_allocateProtocol(MemoryUtil.memAddress(name));
    }

    public static long objc_allocateProtocol(CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        return ObjCRuntime.nobjc_allocateProtocol(__buffer.address(nameEncoded));
    }

    public static void objc_registerProtocol(long proto) {
        long __functionAddress = ObjCRuntime.getInstance().objc_registerProtocol;
        if (Checks.CHECKS) {
            Checks.checkPointer(proto);
        }
        JNI.invokePV(__functionAddress, proto);
    }

    public static void nprotocol_addMethodDescription(long proto, long name, long types, byte isRequiredMethod, byte isInstanceMethod) {
        long __functionAddress = ObjCRuntime.getInstance().protocol_addMethodDescription;
        if (Checks.CHECKS) {
            Checks.checkPointer(proto);
            Checks.checkPointer(name);
        }
        JNI.invokePPPBBV(__functionAddress, proto, name, types, isRequiredMethod, isInstanceMethod);
    }

    public static void protocol_addMethodDescription(long proto, long name, ByteBuffer types, byte isRequiredMethod, byte isInstanceMethod) {
        if (Checks.CHECKS) {
            Checks.checkNT1(types);
        }
        ObjCRuntime.nprotocol_addMethodDescription(proto, name, MemoryUtil.memAddress(types), isRequiredMethod, isInstanceMethod);
    }

    public static void protocol_addMethodDescription(long proto, long name, CharSequence types, byte isRequiredMethod, byte isInstanceMethod) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int typesEncoded = __buffer.stringParamUTF8(types, true);
        ObjCRuntime.nprotocol_addMethodDescription(proto, name, __buffer.address(typesEncoded), isRequiredMethod, isInstanceMethod);
    }

    public static void protocol_addProtocol(long proto, long addition) {
        long __functionAddress = ObjCRuntime.getInstance().protocol_addProtocol;
        if (Checks.CHECKS) {
            Checks.checkPointer(proto);
            Checks.checkPointer(addition);
        }
        JNI.invokePPV(__functionAddress, proto, addition);
    }

    public static void nprotocol_addProperty(long proto, long name, long attributes, int attributeCount, byte isRequiredProperty, byte isInstanceProperty) {
        long __functionAddress = ObjCRuntime.getInstance().protocol_addProperty;
        if (Checks.CHECKS) {
            Checks.checkPointer(proto);
        }
        JNI.invokePPPIBBV(__functionAddress, proto, name, attributes, attributeCount, isRequiredProperty, isInstanceProperty);
    }

    public static void protocol_addProperty(long proto, ByteBuffer name, ObjCPropertyAttribute.Buffer attributes, int attributeCount, byte isRequiredProperty, byte isInstanceProperty) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
            Checks.checkBuffer(attributes, attributeCount);
        }
        ObjCRuntime.nprotocol_addProperty(proto, MemoryUtil.memAddress(name), attributes.address(), attributeCount, isRequiredProperty, isInstanceProperty);
    }

    public static void protocol_addProperty(long proto, ByteBuffer name, ObjCPropertyAttribute.Buffer attributes, byte isRequiredProperty, byte isInstanceProperty) {
        ObjCRuntime.nprotocol_addProperty(proto, MemoryUtil.memAddress(name), attributes.address(), attributes.remaining(), isRequiredProperty, isInstanceProperty);
    }

    public static void protocol_addProperty(long proto, CharSequence name, ObjCPropertyAttribute.Buffer attributes, byte isRequiredProperty, byte isInstanceProperty) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        ObjCRuntime.nprotocol_addProperty(proto, __buffer.address(nameEncoded), attributes.address(), attributes.remaining(), isRequiredProperty, isInstanceProperty);
    }

    public static long nobjc_copyImageNames(long outCount) {
        long __functionAddress = ObjCRuntime.getInstance().objc_copyImageNames;
        return JNI.invokePP(__functionAddress, outCount);
    }

    public static PointerBuffer objc_copyImageNames() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int outCount = __buffer.intParam();
        long __result = ObjCRuntime.nobjc_copyImageNames(__buffer.address(outCount));
        return MemoryUtil.memPointerBuffer(__result, __buffer.intValue(outCount));
    }

    public static long nclass_getImageName(long cls) {
        long __functionAddress = ObjCRuntime.getInstance().class_getImageName;
        if (Checks.CHECKS) {
            Checks.checkPointer(cls);
        }
        return JNI.invokePP(__functionAddress, cls);
    }

    public static String class_getImageName(long cls) {
        long __result = ObjCRuntime.nclass_getImageName(cls);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static long nobjc_copyClassNamesForImage(long image, long outCount) {
        long __functionAddress = ObjCRuntime.getInstance().objc_copyClassNamesForImage;
        return JNI.invokePPP(__functionAddress, image, outCount);
    }

    public static PointerBuffer objc_copyClassNamesForImage(ByteBuffer image) {
        if (Checks.CHECKS) {
            Checks.checkNT1(image);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int outCount = __buffer.intParam();
        long __result = ObjCRuntime.nobjc_copyClassNamesForImage(MemoryUtil.memAddress(image), __buffer.address(outCount));
        return MemoryUtil.memPointerBuffer(__result, __buffer.intValue(outCount));
    }

    public static PointerBuffer objc_copyClassNamesForImage(CharSequence image) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int outCount = __buffer.intParam();
        int imageEncoded = __buffer.stringParamUTF8(image, true);
        long __result = ObjCRuntime.nobjc_copyClassNamesForImage(__buffer.address(imageEncoded), __buffer.address(outCount));
        return MemoryUtil.memPointerBuffer(__result, __buffer.intValue(outCount));
    }

    public static long nsel_getName(long sel) {
        long __functionAddress = ObjCRuntime.getInstance().sel_getName;
        if (Checks.CHECKS) {
            Checks.checkPointer(sel);
        }
        return JNI.invokePP(__functionAddress, sel);
    }

    public static String sel_getName(long sel) {
        long __result = ObjCRuntime.nsel_getName(sel);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static long nsel_getUid(long str) {
        long __functionAddress = ObjCRuntime.getInstance().sel_getUid;
        return JNI.invokePP(__functionAddress, str);
    }

    public static long sel_getUid(ByteBuffer str) {
        if (Checks.CHECKS) {
            Checks.checkNT1(str);
        }
        return ObjCRuntime.nsel_getUid(MemoryUtil.memAddress(str));
    }

    public static long sel_getUid(CharSequence str) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int strEncoded = __buffer.stringParamUTF8(str, true);
        return ObjCRuntime.nsel_getUid(__buffer.address(strEncoded));
    }

    public static long nsel_registerName(long str) {
        long __functionAddress = ObjCRuntime.getInstance().sel_registerName;
        return JNI.invokePP(__functionAddress, str);
    }

    public static long sel_registerName(ByteBuffer str) {
        if (Checks.CHECKS) {
            Checks.checkNT1(str);
        }
        return ObjCRuntime.nsel_registerName(MemoryUtil.memAddress(str));
    }

    public static long sel_registerName(CharSequence str) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int strEncoded = __buffer.stringParamUTF8(str, true);
        return ObjCRuntime.nsel_registerName(__buffer.address(strEncoded));
    }

    public static byte sel_isEqual(long lhs, long rhs) {
        long __functionAddress = ObjCRuntime.getInstance().sel_isEqual;
        if (Checks.CHECKS) {
            Checks.checkPointer(lhs);
            Checks.checkPointer(rhs);
        }
        return JNI.invokePPB(__functionAddress, lhs, rhs);
    }

    public static void objc_enumerationMutation(long obj) {
        long __functionAddress = ObjCRuntime.getInstance().objc_enumerationMutation;
        if (Checks.CHECKS) {
            Checks.checkPointer(obj);
        }
        JNI.invokePV(__functionAddress, obj);
    }

    public static void objc_setEnumerationMutationHandler(EnumerationMutationHandler handler) {
        long __functionAddress = ObjCRuntime.getInstance().objc_setEnumerationMutationHandler;
        JNI.invokePV(__functionAddress, handler.address());
    }

    public static long imp_implementationWithBlock(long block) {
        long __functionAddress = ObjCRuntime.getInstance().imp_implementationWithBlock;
        if (Checks.CHECKS) {
            Checks.checkPointer(block);
        }
        return JNI.invokePP(__functionAddress, block);
    }

    public static long imp_getBlock(long anImp) {
        long __functionAddress = ObjCRuntime.getInstance().imp_getBlock;
        if (Checks.CHECKS) {
            Checks.checkPointer(anImp);
        }
        return JNI.invokePP(__functionAddress, anImp);
    }

    public static byte imp_removeBlock(long anImp) {
        long __functionAddress = ObjCRuntime.getInstance().imp_removeBlock;
        if (Checks.CHECKS) {
            Checks.checkPointer(anImp);
        }
        return JNI.invokePB(__functionAddress, anImp);
    }

    public static long nobjc_loadWeak(long location) {
        long __functionAddress = ObjCRuntime.getInstance().objc_loadWeak;
        return JNI.invokePP(__functionAddress, location);
    }

    public static long objc_loadWeak(ByteBuffer location) {
        return ObjCRuntime.nobjc_loadWeak(MemoryUtil.memAddressSafe(location));
    }

    public static long objc_loadWeak(PointerBuffer location) {
        return ObjCRuntime.nobjc_loadWeak(MemoryUtil.memAddressSafe(location));
    }

    public static long nobjc_storeWeak(long location, long obj) {
        long __functionAddress = ObjCRuntime.getInstance().objc_storeWeak;
        if (Checks.CHECKS) {
            Checks.checkPointer(obj);
        }
        return JNI.invokePPP(__functionAddress, location, obj);
    }

    public static long objc_storeWeak(ByteBuffer location, long obj) {
        return ObjCRuntime.nobjc_storeWeak(MemoryUtil.memAddress(location), obj);
    }

    public static long objc_storeWeak(PointerBuffer location, long obj) {
        return ObjCRuntime.nobjc_storeWeak(MemoryUtil.memAddress(location), obj);
    }

    public static void objc_setAssociatedObject(long object, long key, long value, long policy) {
        long __functionAddress = ObjCRuntime.getInstance().objc_setAssociatedObject;
        if (Checks.CHECKS) {
            Checks.checkPointer(object);
            Checks.checkPointer(key);
            Checks.checkPointer(value);
        }
        JNI.invokePPPPV(__functionAddress, object, key, value, policy);
    }

    public static long objc_getAssociatedObject(long object, long key) {
        long __functionAddress = ObjCRuntime.getInstance().objc_getAssociatedObject;
        if (Checks.CHECKS) {
            Checks.checkPointer(object);
            Checks.checkPointer(key);
        }
        return JNI.invokePPP(__functionAddress, object, key);
    }

    public static void objc_removeAssociatedObjects(long object) {
        long __functionAddress = ObjCRuntime.getInstance().objc_removeAssociatedObjects;
        if (Checks.CHECKS) {
            Checks.checkPointer(object);
        }
        JNI.invokePV(__functionAddress, object);
    }

    static {
        Library.initialize();
        OBJC = Library.loadNative("objc");
        instance = new ObjCRuntime(OBJC);
    }
}

