/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.SharedLibrary;

public class User32 {
    public final long GetDC;
    public final long ReleaseDC;
    private static final SharedLibrary USER32 = Library.loadNative("user32");
    private static final User32 instance = new User32(USER32);

    protected User32() {
        throw new UnsupportedOperationException();
    }

    public User32(FunctionProvider provider) {
        this.GetDC = Checks.checkFunctionAddress(provider.getFunctionAddress("GetDC"));
        this.ReleaseDC = Checks.checkFunctionAddress(provider.getFunctionAddress("ReleaseDC"));
    }

    public static SharedLibrary getLibrary() {
        return USER32;
    }

    public static User32 getInstance() {
        return instance;
    }

    public static long GetDC(long hWnd) {
        long __functionAddress = User32.getInstance().GetDC;
        return JNI.callPP(__functionAddress, hWnd);
    }

    public static int ReleaseDC(long hWnd, long hDC) {
        long __functionAddress = User32.getInstance().ReleaseDC;
        if (Checks.CHECKS) {
            Checks.checkPointer(hWnd);
            Checks.checkPointer(hDC);
        }
        return JNI.callPPI(__functionAddress, hWnd, hDC);
    }
}

